/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.diagram.parsers;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.henshin.diagram.edit.helpers.TransformationSystemEditHelper;
import org.eclipse.emf.henshin.diagram.parsers.AbstractParser;
import org.eclipse.emf.henshin.diagram.parsers.NodeTypeParserHelper;
import org.eclipse.emf.henshin.model.Graph;
import org.eclipse.emf.henshin.model.HenshinPackage;
import org.eclipse.emf.henshin.model.Mapping;
import org.eclipse.emf.henshin.model.NestedCondition;
import org.eclipse.emf.henshin.model.Node;
import org.eclipse.emf.henshin.model.Rule;
import org.eclipse.emf.henshin.model.TransformationSystem;
import org.eclipse.emf.henshin.model.util.HenshinRuleAnalysisUtil;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.common.core.command.UnexecutableCommand;
import org.eclipse.gmf.runtime.common.ui.services.parser.IParserEditStatus;
import org.eclipse.gmf.runtime.common.ui.services.parser.ParserEditStatus;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;

public class NodeTypeParser
extends AbstractParser {
    private static final NodeTypeParserHelper PARSER_HELPER = new NodeTypeParserHelper();

    public NodeTypeParser() {
        super(new EAttribute[]{HenshinPackage.eINSTANCE.getNamedElement_Name()});
    }

    public String getPrintString(IAdaptable element, int flags) {
        Node node = (Node)element.getAdapter(EObject.class);
        ArrayList<Node> originNodes = new ArrayList<Node>();
        ArrayList<Node> imageNodes = new ArrayList<Node>();
        String para1 = null;
        NodeTypeParserHelper.ParameterDirection para1Dir = NodeTypeParserHelper.ParameterDirection.IN;
        String para2 = null;
        NodeTypeParserHelper.ParameterDirection para2Dir = NodeTypeParserHelper.ParameterDirection.OUT;
        this.findMappedNodes(node, originNodes, imageNodes);
        for (Node origNode : originNodes) {
            if (origNode.getName() == null || origNode.getName().trim().isEmpty()) continue;
            para1 = origNode.getName().trim();
            break;
        }
        for (Node imgNode : imageNodes) {
            if (imgNode.getName() == null || imgNode.getName().trim().isEmpty()) continue;
            para2 = imgNode.getName().trim();
            break;
        }
        if (para1 == null && para2 != null) {
            para1 = para2;
            para2 = null;
            para1Dir = para2Dir;
            para2Dir = null;
        } else if (para1 != null && para1.equals(para2)) {
            para2 = null;
            para2Dir = null;
            para1Dir = NodeTypeParserHelper.ParameterDirection.INOUT;
        }
        String paraString = PARSER_HELPER.getParameterString(para1, para1Dir, para2, para2Dir);
        if (node.getType() != null) {
            return String.valueOf(paraString) + ":" + node.getType().getName();
        }
        return paraString;
    }

    public String getEditString(IAdaptable element, int flags) {
        return this.getPrintString(element, flags);
    }

    public ICommand getParseCommand(IAdaptable element, final String value, int flags) {
        final Node node = (Node)element.getAdapter(EObject.class);
        TransactionalEditingDomain editingDomain = TransactionUtil.getEditingDomain((EObject)node);
        if (editingDomain == null) {
            return UnexecutableCommand.INSTANCE;
        }
        AbstractTransactionalCommand command = new AbstractTransactionalCommand(editingDomain, "Parse Node Name", null){

            protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                return NodeTypeParser.this.doParsing(value, node);
            }
        };
        return command;
    }

    private CommandResult doParsing(String value, Node node) {
        block20: {
            ArrayList<Node> imageNodes;
            ArrayList<Node> originNodes;
            block19: {
                if (!PARSER_HELPER.parse(value)) {
                    return CommandResult.newErrorCommandResult((String)"Invalid input");
                }
                TransformationSystem ts = node.getGraph().getContainerRule().getTransformationSystem();
                originNodes = new ArrayList<Node>();
                imageNodes = new ArrayList<Node>();
                this.findMappedNodes(node, originNodes, imageNodes);
                if (PARSER_HELPER.getType() != null) {
                    EClass eclass = null;
                    EClassifier[] list = TransformationSystemEditHelper.findEClassifierByName(ts, PARSER_HELPER.getType());
                    if (list.length > 0) {
                        EClassifier[] eClassifierArray = list;
                        int n = list.length;
                        int n2 = 0;
                        while (n2 < n) {
                            EClassifier ec = eClassifierArray[n2];
                            if (ec instanceof EClass) {
                                eclass = (EClass)ec;
                                break;
                            }
                            ++n2;
                        }
                    }
                    if (eclass == null) {
                        return CommandResult.newErrorCommandResult((String)"No such EClass found");
                    }
                    for (Node current : originNodes) {
                        current.setType(eclass);
                    }
                    for (Node current : imageNodes) {
                        current.setType(eclass);
                    }
                }
                if (PARSER_HELPER.getParameter1() == null) break block19;
                String para1 = PARSER_HELPER.getParameter1();
                NodeTypeParserHelper.ParameterDirection dir1 = PARSER_HELPER.getDirection1();
                for (Node current : imageNodes) {
                    current.setName(null);
                }
                for (Node current : originNodes) {
                    current.setName(null);
                }
                if (dir1.equals((Object)NodeTypeParserHelper.ParameterDirection.IN) || dir1.equals((Object)NodeTypeParserHelper.ParameterDirection.INOUT)) {
                    for (Node current : originNodes) {
                        current.setName(para1);
                    }
                }
                if (dir1.equals((Object)NodeTypeParserHelper.ParameterDirection.OUT) || dir1.equals((Object)NodeTypeParserHelper.ParameterDirection.INOUT)) {
                    for (Node current : imageNodes) {
                        current.setName(para1);
                    }
                }
                if (PARSER_HELPER.getParameter2() == null) break block20;
                String para2 = PARSER_HELPER.getParameter2();
                NodeTypeParserHelper.ParameterDirection dir2 = PARSER_HELPER.getDirection2();
                if (dir2.equals((Object)NodeTypeParserHelper.ParameterDirection.IN)) {
                    for (Node current : originNodes) {
                        current.setName(para2);
                    }
                }
                if (!dir2.equals((Object)NodeTypeParserHelper.ParameterDirection.OUT)) break block20;
                for (Node current : imageNodes) {
                    current.setName(para2);
                }
                break block20;
            }
            for (Node current : originNodes) {
                current.setName(null);
            }
            for (Node current : imageNodes) {
                current.setName(null);
            }
        }
        return CommandResult.newOKCommandResult();
    }

    private void findMappedNodes(Node node, List<Node> originNodes, List<Node> imageNodes) {
        block6: {
            EObject container;
            block5: {
                container = node.getGraph().eContainer();
                boolean isLhsPart = HenshinRuleAnalysisUtil.isLHSPart((Graph)node.getGraph());
                if (isLhsPart) {
                    originNodes.add(node);
                } else {
                    imageNodes.add(node);
                }
                if (!(container instanceof Rule)) break block5;
                Rule rule = (Rule)container;
                for (Mapping mapping : rule.getMappings()) {
                    if (mapping.getOrigin() == node) {
                        imageNodes.add(mapping.getImage());
                    }
                    if (mapping.getImage() != node) continue;
                    originNodes.add(mapping.getOrigin());
                }
                break block6;
            }
            if (!(container instanceof NestedCondition)) break block6;
            NestedCondition nc = (NestedCondition)container;
            for (Mapping mapping : nc.getMappings()) {
                if (mapping.getImage() != node) continue;
                originNodes.add(mapping.getOrigin());
            }
        }
    }

    @Override
    protected boolean isAffectingFeature(Object feature) {
        if (feature == HenshinPackage.eINSTANCE.getNamedElement_Name()) {
            return true;
        }
        return feature == HenshinPackage.eINSTANCE.getNode_Type();
    }

    public IParserEditStatus isValidEditString(IAdaptable element, String editString) {
        return ParserEditStatus.EDITABLE_STATUS;
    }
}

