/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.diagram.edit.commands;

import java.util.ArrayList;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.henshin.diagram.providers.HenshinElementTypes;
import org.eclipse.emf.henshin.model.HenshinFactory;
import org.eclipse.emf.henshin.model.HenshinPackage;
import org.eclipse.emf.henshin.model.TransformationSystem;
import org.eclipse.emf.henshin.model.TransformationUnit;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.ui.menus.PopupMenu;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.emf.type.core.commands.EditElementCommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.ConfigureRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateElementRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

public class UnitCreateCommand
extends EditElementCommand {
    private Shell shell;

    public UnitCreateCommand(CreateElementRequest request) {
        super(request.getLabel(), null, (IEditCommandRequest)request);
    }

    public UnitCreateCommand(CreateElementRequest request, Shell shell) {
        this(request);
        this.shell = shell;
    }

    protected EObject getElementToEdit() {
        EObject container = ((CreateElementRequest)this.getRequest()).getContainer();
        if (container instanceof View) {
            container = ((View)container).getElement();
        }
        return container;
    }

    public boolean canExecute() {
        return true;
    }

    protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        EClass unitType = HenshinPackage.eINSTANCE.getSequentialUnit();
        if (this.shell != null) {
            PopupMenu menu = this.getPopupMenu();
            if (!menu.show((Control)this.shell)) {
                monitor.setCanceled(true);
                return CommandResult.newCancelledCommandResult();
            }
            unitType = (EClass)menu.getResult();
        }
        TransformationUnit unit = (TransformationUnit)HenshinFactory.eINSTANCE.create(unitType);
        TransformationSystem system = (TransformationSystem)this.getElementToEdit();
        system.getTransformationUnits().add((Object)unit);
        this.doConfigure(unit, monitor, info);
        ((CreateElementRequest)this.getRequest()).setNewElement((EObject)unit);
        return CommandResult.newOKCommandResult((Object)unit);
    }

    protected PopupMenu getPopupMenu() {
        ArrayList<EClass> unitTypes = new ArrayList<EClass>();
        unitTypes.add(HenshinPackage.eINSTANCE.getIndependentUnit());
        unitTypes.add(HenshinPackage.eINSTANCE.getPriorityUnit());
        unitTypes.add(HenshinPackage.eINSTANCE.getSequentialUnit());
        LabelProvider labelProvider = new LabelProvider(){

            public Image getImage(Object element) {
                return HenshinElementTypes.getImage((ENamedElement)((EClass)element));
            }

            public String getText(Object element) {
                return ((EClass)element).getName();
            }
        };
        return new PopupMenu(unitTypes, (ILabelProvider)labelProvider);
    }

    protected void doConfigure(TransformationUnit newElement, IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        IElementType elementType = ((CreateElementRequest)this.getRequest()).getElementType();
        ConfigureRequest configureRequest = new ConfigureRequest(this.getEditingDomain(), (EObject)newElement, elementType);
        configureRequest.setClientContext(((CreateElementRequest)this.getRequest()).getClientContext());
        configureRequest.addParameters(this.getRequest().getParameters());
        ICommand configureCommand = elementType.getEditCommand((IEditCommandRequest)configureRequest);
        if (configureCommand != null && configureCommand.canExecute()) {
            configureCommand.execute(monitor, info);
        }
    }
}

