/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.editor.filter;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.emf.henshin.presentation.HenshinEditorPlugin;
import org.eclipse.emf.henshin.provider.filter.FilterProvider;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;

public abstract class BaseFilterControlsViewer {
    protected FilterProvider filterProvider;
    protected Collection<Image> images = new ArrayList<Image>();

    public void buildControls(ToolBar tb) {
        this.addControls(tb);
        tb.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                for (Image img : BaseFilterControlsViewer.this.images) {
                    img.dispose();
                }
            }
        });
    }

    protected abstract void addControls(ToolBar var1);

    protected Image getImage(String path) {
        URL imgUrl = (URL)HenshinEditorPlugin.INSTANCE.getImage(path);
        Image img = ImageDescriptor.createFromURL((URL)imgUrl).createImage();
        this.images.add(img);
        return img;
    }

    protected String getString(String key) {
        return HenshinEditorPlugin.getPlugin().getString(key);
    }

    protected static class ButtonController
    extends SelectionAdapter {
        protected ToolItem item;
        protected boolean pressed = false;
        protected ButtonState inactive;
        protected ButtonState active;

        public ButtonController(ButtonState active, ButtonState inactive, boolean pressed) {
            this.active = active;
            this.inactive = inactive;
            this.pressed = pressed;
        }

        ButtonState getState() {
            return this.pressed ? this.active : this.inactive;
        }

        protected void setStateUI(ButtonState state) {
            state.setStateUI(this.item);
            state.initState();
        }

        public void widgetSelected(SelectionEvent e) {
            this.pressed = !this.pressed;
            this.getState().setStateUI(this.item);
            this.getState().initState();
        }

        void init(ToolBar tb) {
            this.item = new ToolItem(tb, 32);
            if (this.pressed) {
                this.item.setSelection(this.pressed);
            }
            this.getState().setStateUI(this.item);
            this.item.addSelectionListener((SelectionListener)this);
        }
    }

    protected static abstract class ButtonState {
        protected String toolTip;
        protected Image image;

        public ButtonState(String tooltip, Image image) {
            this.toolTip = tooltip;
            this.image = image;
        }

        abstract void initState();

        final void setStateUI(ToolItem item) {
            item.setToolTipText(this.toolTip);
            item.setImage(this.image);
        }
    }
}

