/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.statespace.external.prism;

import java.io.File;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Locale;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.henshin.model.Rule;
import org.eclipse.emf.henshin.statespace.StateSpace;
import org.eclipse.emf.henshin.statespace.properties.StateSpacePropertiesManager;

public class RatesPropertiesManager
implements StateSpacePropertiesManager {
    public static final String PRISM_PATH_KEY = "prismPath";
    public static final String PRISM_ARGS_KEY = "prismArgs";
    public static final String PRISM_EXPERIMENT_KEY = "prismExperiment";

    public static Rate getRate(StateSpace stateSpace, Rule rule) throws ParseException {
        String value = (String)stateSpace.getProperties().get((Object)RatesPropertiesManager.getRateKey(rule));
        return value != null && value.trim().length() > 0 ? new Rate(value) : null;
    }

    public static void setRate(StateSpace stateSpace, Rule rule, Rate rate) {
        String value = rate != null ? rate.toString() : "";
        stateSpace.getProperties().put((Object)RatesPropertiesManager.getRateKey(rule), (Object)value);
    }

    public static File getPRISMPath(StateSpace stateSpace) {
        String path = (String)stateSpace.getProperties().get((Object)PRISM_PATH_KEY);
        if (path != null && path.trim().length() > 0) {
            return new File(path.trim());
        }
        return null;
    }

    public static String getPRISMArgs(StateSpace stateSpace) {
        return (String)stateSpace.getProperties().get((Object)PRISM_ARGS_KEY);
    }

    public static String getPRISMExperiment(StateSpace stateSpace) {
        return (String)stateSpace.getProperties().get((Object)PRISM_EXPERIMENT_KEY);
    }

    public void initialize(StateSpace stateSpace) {
        for (Rule rule : stateSpace.getRules()) {
            try {
                if (RatesPropertiesManager.getRate(stateSpace, rule) != null) continue;
                RatesPropertiesManager.setRate(stateSpace, rule, new Rate(1.0));
            }
            catch (ParseException parseException) {}
        }
        if (RatesPropertiesManager.getPRISMArgs(stateSpace) == null) {
            stateSpace.getProperties().put((Object)PRISM_ARGS_KEY, (Object)"-fixdl -gaussseidel");
        }
    }

    public IStatus validate(StateSpace stateSpace) {
        for (Rule rule : stateSpace.getRules()) {
            try {
                RatesPropertiesManager.getRate(stateSpace, rule);
            }
            catch (Throwable throwable) {
                return new Status(4, "org.eclipse.emf.henshin.statespace", "Format error for property \"" + RatesPropertiesManager.getRateKey(rule) + "\"");
            }
        }
        File path = RatesPropertiesManager.getPRISMPath(stateSpace);
        if (path != null && !path.isDirectory()) {
            return new Status(4, "org.eclipse.emf.henshin.statespace", "PRISM path not found");
        }
        return Status.OK_STATUS;
    }

    public static String getRateKey(Rule rule) {
        return "rate" + RatesPropertiesManager.capitalize(RatesPropertiesManager.removeWhiteSpace(rule.getName()));
    }

    private static String capitalize(String string) {
        if (string == null || string.length() == 0) {
            return string;
        }
        String first = string.substring(0, 1).toUpperCase();
        if (string.length() == 0) {
            return first;
        }
        return String.valueOf(first) + string.substring(1);
    }

    private static String removeWhiteSpace(String string) {
        string = string.replaceAll(" ", "_");
        string = string.replaceAll("\t", "_");
        string = string.replaceAll("\n", "_");
        return string;
    }

    public static class Rate {
        public double min = 0.0;
        public double step = 0.0;
        public double max = 0.0;

        public Rate(double min, double step, double max) {
            this.min = min;
            this.step = step;
            this.max = max;
        }

        public Rate(double constant) {
            this(constant, 0.0, constant);
        }

        public Rate(String value) throws ParseException {
            NumberFormat format = NumberFormat.getInstance(Locale.ENGLISH);
            String[] fields = value.split(":");
            if (fields.length == 1) {
                this.min = this.max = format.parse(fields[0]).doubleValue();
            } else if (fields.length == 2) {
                this.min = format.parse(fields[0]).doubleValue();
                this.max = format.parse(fields[1]).doubleValue();
            } else if (fields.length == 3) {
                this.min = format.parse(fields[0]).doubleValue();
                this.step = format.parse(fields[1]).doubleValue();
                this.max = format.parse(fields[2]).doubleValue();
            } else {
                throw new ParseException("Error parsing rate", 0);
            }
        }

        public boolean isConstant() {
            return this.min == this.max;
        }

        public String toString() {
            if (this.isConstant()) {
                return String.valueOf(this.min);
            }
            if (this.step <= 0.0) {
                return String.valueOf(this.min) + ":" + this.max;
            }
            return String.valueOf(this.min) + ":" + this.step + ":" + this.max;
        }
    }
}

