/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.statespace.properties;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.henshin.model.Graph;
import org.eclipse.emf.henshin.model.Node;
import org.eclipse.emf.henshin.model.Rule;
import org.eclipse.emf.henshin.statespace.StateSpace;
import org.eclipse.emf.henshin.statespace.StateSpaceException;
import org.eclipse.emf.henshin.statespace.properties.StateSpacePropertiesManager;

public class ParametersPropertiesManager
implements StateSpacePropertiesManager {
    @Override
    public void initialize(StateSpace stateSpace) {
        for (Rule rule : stateSpace.getRules()) {
            String key = ParametersPropertiesManager.getParametersKey(rule);
            if (stateSpace.getProperties().containsKey((Object)key)) continue;
            stateSpace.getProperties().put((Object)key, (Object)"");
        }
    }

    @Override
    public IStatus validate(StateSpace stateSpace) {
        for (Rule rule : stateSpace.getRules()) {
            try {
                ParametersPropertiesManager.getParameters(stateSpace, rule);
            }
            catch (StateSpaceException e) {
                return new Status(4, "org.eclipse.emf.henshin.statespace", e.getMessage());
            }
        }
        return Status.OK_STATUS;
    }

    static String getParametersKey(Rule rule) {
        String name = String.valueOf(rule.getName());
        name = name.replaceAll(" ", "_");
        name = name.replaceAll("\t", "_");
        if ((name = name.replaceAll("\n", "_")).length() > 0) {
            String first = name.substring(0, 1).toUpperCase();
            name = String.valueOf(first) + name.substring(1);
        }
        return "params" + name;
    }

    public static List<Node> getParameters(StateSpace stateSpace, Rule rule) throws StateSpaceException {
        ArrayList<Node> nodes = new ArrayList<Node>();
        String value = (String)stateSpace.getProperties().get((Object)ParametersPropertiesManager.getParametersKey(rule));
        if (value == null || value.trim().length() == 0) {
            return nodes;
        }
        String[] names = value.split(",");
        int i = 0;
        while (i < names.length) {
            String name = names[i].trim();
            if (name.length() == 0) {
                throw new StateSpaceException("Illegal rule parameters for rule \"" + rule.getName() + "\"");
            }
            Node node = ParametersPropertiesManager.findNodeByName(name, rule.getLhs());
            if (node == null) {
                node = ParametersPropertiesManager.findNodeByName(name, rule.getRhs());
            }
            if (node == null) {
                throw new StateSpaceException("Unknown node \"" + name + "\" for rule \"" + rule.getName() + "\"");
            }
            nodes.add(node);
            ++i;
        }
        return nodes;
    }

    public static void setParameters(StateSpace stateSpace, Rule rule, List<Node> nodes) {
        String value = "";
        int i = 0;
        while (i < nodes.size()) {
            String name = nodes.get(i).getName();
            if (name == null || name.trim().length() == 0) {
                throw new IllegalArgumentException("All parameter nodes must have a unique, non-empty name");
            }
            value = String.valueOf(value) + name;
            if (i < nodes.size() - 1) {
                value = String.valueOf(value) + ",";
            }
            ++i;
        }
        stateSpace.getProperties().put((Object)ParametersPropertiesManager.getParametersKey(rule), (Object)value);
    }

    static Node findNodeByName(String name, Graph graph) {
        for (Node node : graph.getNodes()) {
            if (!name.equals(node.getName())) continue;
            return node;
        }
        return null;
    }
}

