/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.diagram.providers;

import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.henshin.diagram.part.HenshinDiagramEditorPlugin;
import org.eclipse.emf.henshin.model.HenshinPackage;
import org.eclipse.gmf.runtime.emf.type.core.ElementTypeRegistry;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.graphics.Image;

public class HenshinElementTypes {
    private static Map<IElementType, ENamedElement> elements;
    private static ImageRegistry imageRegistry;
    private static Set<IElementType> KNOWN_ELEMENT_TYPES;
    public static final IElementType TransformationSystem_1000;
    public static final IElementType Rule_2001;
    public static final IElementType Node_3001;
    public static final IElementType Attribute_3002;
    public static final IElementType Edge_4001;

    static {
        TransformationSystem_1000 = HenshinElementTypes.getElementType("org.eclipse.emf.henshin.diagram.TransformationSystem_1000");
        Rule_2001 = HenshinElementTypes.getElementType("org.eclipse.emf.henshin.diagram.Rule_2001");
        Node_3001 = HenshinElementTypes.getElementType("org.eclipse.emf.henshin.diagram.Node_3001");
        Attribute_3002 = HenshinElementTypes.getElementType("org.eclipse.emf.henshin.diagram.Attribute_3002");
        Edge_4001 = HenshinElementTypes.getElementType("org.eclipse.emf.henshin.diagram.Edge_4001");
    }

    private HenshinElementTypes() {
    }

    private static ImageRegistry getImageRegistry() {
        if (imageRegistry == null) {
            imageRegistry = new ImageRegistry();
        }
        return imageRegistry;
    }

    private static String getImageRegistryKey(ENamedElement element) {
        return element.getName();
    }

    private static ImageDescriptor getProvidedImageDescriptor(ENamedElement element) {
        EClass eClass;
        if (element instanceof EStructuralFeature) {
            EStructuralFeature feature = (EStructuralFeature)element;
            EClass eContainingClass = feature.getEContainingClass();
            EClassifier eType = feature.getEType();
            if (eContainingClass != null && !eContainingClass.isAbstract()) {
                element = eContainingClass;
            } else if (eType instanceof EClass && !((EClass)eType).isAbstract()) {
                element = eType;
            }
        }
        if (element instanceof EClass && !(eClass = (EClass)element).isAbstract()) {
            return HenshinDiagramEditorPlugin.getInstance().getItemImageDescriptor(eClass.getEPackage().getEFactoryInstance().create(eClass));
        }
        return null;
    }

    public static ImageDescriptor getImageDescriptor(ENamedElement element) {
        String key = HenshinElementTypes.getImageRegistryKey(element);
        ImageDescriptor imageDescriptor = HenshinElementTypes.getImageRegistry().getDescriptor(key);
        if (imageDescriptor == null) {
            imageDescriptor = HenshinElementTypes.getProvidedImageDescriptor(element);
            if (imageDescriptor == null) {
                imageDescriptor = ImageDescriptor.getMissingImageDescriptor();
            }
            HenshinElementTypes.getImageRegistry().put(key, imageDescriptor);
        }
        return imageDescriptor;
    }

    public static Image getImage(ENamedElement element) {
        String key = HenshinElementTypes.getImageRegistryKey(element);
        Image image = HenshinElementTypes.getImageRegistry().get(key);
        if (image == null) {
            ImageDescriptor imageDescriptor = HenshinElementTypes.getProvidedImageDescriptor(element);
            if (imageDescriptor == null) {
                imageDescriptor = ImageDescriptor.getMissingImageDescriptor();
            }
            HenshinElementTypes.getImageRegistry().put(key, imageDescriptor);
            image = HenshinElementTypes.getImageRegistry().get(key);
        }
        return image;
    }

    public static ImageDescriptor getImageDescriptor(IAdaptable hint) {
        ENamedElement element = HenshinElementTypes.getElement(hint);
        if (element == null) {
            return null;
        }
        return HenshinElementTypes.getImageDescriptor(element);
    }

    public static Image getImage(IAdaptable hint) {
        ENamedElement element = HenshinElementTypes.getElement(hint);
        if (element == null) {
            return null;
        }
        return HenshinElementTypes.getImage(element);
    }

    public static ENamedElement getElement(IAdaptable hint) {
        Object type = hint.getAdapter(IElementType.class);
        if (elements == null) {
            elements = new IdentityHashMap<IElementType, ENamedElement>();
            elements.put(TransformationSystem_1000, (ENamedElement)HenshinPackage.eINSTANCE.getTransformationSystem());
            elements.put(Rule_2001, (ENamedElement)HenshinPackage.eINSTANCE.getRule());
            elements.put(Node_3001, (ENamedElement)HenshinPackage.eINSTANCE.getNode());
            elements.put(Attribute_3002, (ENamedElement)HenshinPackage.eINSTANCE.getAttribute());
            elements.put(Edge_4001, (ENamedElement)HenshinPackage.eINSTANCE.getEdge());
        }
        return elements.get(type);
    }

    private static IElementType getElementType(String id) {
        return ElementTypeRegistry.getInstance().getType(id);
    }

    public static boolean isKnownElementType(IElementType elementType) {
        if (KNOWN_ELEMENT_TYPES == null) {
            KNOWN_ELEMENT_TYPES = new HashSet<IElementType>();
            KNOWN_ELEMENT_TYPES.add(TransformationSystem_1000);
            KNOWN_ELEMENT_TYPES.add(Rule_2001);
            KNOWN_ELEMENT_TYPES.add(Node_3001);
            KNOWN_ELEMENT_TYPES.add(Attribute_3002);
            KNOWN_ELEMENT_TYPES.add(Edge_4001);
        }
        return KNOWN_ELEMENT_TYPES.contains(elementType);
    }

    public static IElementType getElementType(int visualID) {
        switch (visualID) {
            case 1000: {
                return TransformationSystem_1000;
            }
            case 2001: {
                return Rule_2001;
            }
            case 3001: {
                return Node_3001;
            }
            case 3002: {
                return Attribute_3002;
            }
            case 4001: {
                return Edge_4001;
            }
        }
        return null;
    }
}

