/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.diagram.parsers;

import java.util.ArrayList;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.henshin.diagram.parsers.AbstractParser;
import org.eclipse.emf.henshin.model.HenshinPackage;
import org.eclipse.emf.henshin.model.Mapping;
import org.eclipse.emf.henshin.model.Node;
import org.eclipse.emf.henshin.model.Rule;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.common.core.command.UnexecutableCommand;
import org.eclipse.gmf.runtime.common.ui.services.parser.IParserEditStatus;
import org.eclipse.gmf.runtime.common.ui.services.parser.ParserEditStatus;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;

public class NodeTypeParser
extends AbstractParser {
    public NodeTypeParser() {
        super(new EAttribute[]{HenshinPackage.eINSTANCE.getNamedElement_Name()});
    }

    public String getPrintString(IAdaptable element, int flags) {
        String name;
        Node node = (Node)element.getAdapter(EObject.class);
        String string = name = node.getName() != null ? node.getName() : "";
        if (node.getType() != null) {
            return String.valueOf(name) + ":" + node.getType().getName();
        }
        return name;
    }

    public String getEditString(IAdaptable element, int flags) {
        return this.getPrintString(element, flags);
    }

    public ICommand getParseCommand(IAdaptable element, final String value, int flags) {
        final Node node = (Node)element.getAdapter(EObject.class);
        TransactionalEditingDomain editingDomain = TransactionUtil.getEditingDomain((EObject)node);
        if (editingDomain == null) {
            return UnexecutableCommand.INSTANCE;
        }
        AbstractTransactionalCommand command = new AbstractTransactionalCommand(editingDomain, "Parse Node Name", null){

            protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                return NodeTypeParser.this.doParsing(value, node);
            }
        };
        return command;
    }

    private CommandResult doParsing(String value, Node node) {
        String type;
        String name;
        Rule rule = (Rule)node.getGraph().eContainer();
        int colon = value.indexOf(58);
        if (colon < 0) {
            name = value;
            type = null;
        } else {
            name = value.substring(0, colon);
            type = value.substring(colon + 1);
        }
        EClass eclass = null;
        if (type != null) {
            for (EPackage epackage : rule.getTransformationSystem().getImports()) {
                EClassifier classifier = epackage.getEClassifier(type);
                if (!(classifier instanceof EClass)) continue;
                eclass = (EClass)classifier;
                break;
            }
        }
        ArrayList<Node> nodes = new ArrayList<Node>();
        nodes.add(node);
        for (Mapping mapping : rule.getMappings()) {
            if (mapping.getOrigin() == node) {
                nodes.add(mapping.getImage());
            }
            if (mapping.getImage() != node) continue;
            nodes.add(mapping.getOrigin());
        }
        for (Node current : nodes) {
            current.setName(name);
            current.setType(eclass);
        }
        return CommandResult.newOKCommandResult();
    }

    @Override
    protected boolean isAffectingFeature(Object feature) {
        if (feature == HenshinPackage.eINSTANCE.getNamedElement_Name()) {
            return true;
        }
        return feature == HenshinPackage.eINSTANCE.getNode_Type();
    }

    public IParserEditStatus isValidEditString(IAdaptable element, String editString) {
        return ParserEditStatus.EDITABLE_STATUS;
    }
}

