/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.statespace.impl;

import java.util.ArrayList;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.impl.EFactoryImpl;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.emf.henshin.interpreter.util.Match;
import org.eclipse.emf.henshin.statespace.Model;
import org.eclipse.emf.henshin.statespace.State;
import org.eclipse.emf.henshin.statespace.StateEqualityHelper;
import org.eclipse.emf.henshin.statespace.StateSpace;
import org.eclipse.emf.henshin.statespace.StateSpaceFactory;
import org.eclipse.emf.henshin.statespace.StateSpacePackage;
import org.eclipse.emf.henshin.statespace.Storage;
import org.eclipse.emf.henshin.statespace.Transition;
import org.eclipse.emf.henshin.statespace.impl.ModelImpl;
import org.eclipse.emf.henshin.statespace.impl.NodeIDImpl;
import org.eclipse.emf.henshin.statespace.impl.StateEqualityHelperImpl;
import org.eclipse.emf.henshin.statespace.impl.StateImpl;
import org.eclipse.emf.henshin.statespace.impl.StateSpaceImpl;
import org.eclipse.emf.henshin.statespace.impl.StorageImpl;
import org.eclipse.emf.henshin.statespace.impl.TransitionImpl;

public class StateSpaceFactoryImpl
extends EFactoryImpl
implements StateSpaceFactory {
    public static StateSpaceFactory init() {
        try {
            StateSpaceFactory theStateSpaceFactory = (StateSpaceFactory)EPackage.Registry.INSTANCE.getEFactory("http://www.eclipse.org/emf/2010/Henshin/StateSpace");
            if (theStateSpaceFactory != null) {
                return theStateSpaceFactory;
            }
        }
        catch (Exception exception) {
            EcorePlugin.INSTANCE.log((Object)exception);
        }
        return new StateSpaceFactoryImpl();
    }

    public EObject create(EClass eClass) {
        switch (eClass.getClassifierID()) {
            case 0: {
                return this.createStateSpace();
            }
            case 1: {
                return this.createState();
            }
            case 2: {
                return this.createModel();
            }
            case 3: {
                return this.createTransition();
            }
            case 4: {
                return this.createStateEqualityHelper();
            }
            case 5: {
                return this.createStorage();
            }
            case 6: {
                return (EObject)this.createNodeID();
            }
        }
        throw new IllegalArgumentException("The class '" + eClass.getName() + "' is not a valid classifier");
    }

    public Object createFromString(EDataType eDataType, String initialValue) {
        switch (eDataType.getClassifierID()) {
            case 7: {
                return this.createIntegerArrayFromString(eDataType, initialValue);
            }
            case 8: {
                return this.createMatchFromString(eDataType, initialValue);
            }
        }
        throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
    }

    public String convertToString(EDataType eDataType, Object instanceValue) {
        switch (eDataType.getClassifierID()) {
            case 7: {
                return this.convertIntegerArrayToString(eDataType, instanceValue);
            }
            case 8: {
                return this.convertMatchToString(eDataType, instanceValue);
            }
        }
        throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
    }

    @Override
    public StateSpace createStateSpace() {
        StateSpaceImpl stateSpace = new StateSpaceImpl();
        return stateSpace;
    }

    @Override
    public State createState() {
        StateImpl state = new StateImpl();
        return state;
    }

    @Override
    public Model createModel() {
        ModelImpl model = new ModelImpl();
        return model;
    }

    @Override
    public Transition createTransition() {
        TransitionImpl transition = new TransitionImpl();
        return transition;
    }

    @Override
    public StateEqualityHelper createStateEqualityHelper() {
        StateEqualityHelperImpl stateEqualityHelper = new StateEqualityHelperImpl();
        return stateEqualityHelper;
    }

    @Override
    public Storage createStorage() {
        StorageImpl storage = new StorageImpl();
        return storage;
    }

    public Map.Entry<EObject, Integer> createNodeID() {
        NodeIDImpl nodeID = new NodeIDImpl();
        return nodeID;
    }

    public int[] createIntegerArrayFromString(EDataType eDataType, String initialValue) {
        StringTokenizer tokenizer = new StringTokenizer(initialValue, ",");
        ArrayList<Integer> values = new ArrayList<Integer>();
        while (tokenizer.hasMoreTokens()) {
            values.add(Integer.valueOf(tokenizer.nextToken().trim()));
        }
        int[] array = new int[values.size()];
        int i = 0;
        while (i < array.length) {
            array[i] = (Integer)values.get(i);
            ++i;
        }
        return array;
    }

    public String convertIntegerArrayToString(EDataType eDataType, Object location) {
        return this.convertIntegerArrayToString(eDataType, (int[])location);
    }

    public Match createMatchFromString(EDataType eDataType, String initialValue) {
        return (Match)super.createFromString(eDataType, initialValue);
    }

    public String convertMatchToString(EDataType eDataType, Object instanceValue) {
        return super.convertToString(eDataType, instanceValue);
    }

    public String convertIntegerArrayToString(EDataType eDataType, int[] location) {
        String result = "";
        int i = 0;
        while (i < location.length) {
            result = String.valueOf(result) + location[i];
            if (i < location.length - 1) {
                result = String.valueOf(result) + ",";
            }
            ++i;
        }
        return result;
    }

    @Override
    public StateSpacePackage getStateSpacePackage() {
        return (StateSpacePackage)this.getEPackage();
    }

    @Deprecated
    public static StateSpacePackage getPackage() {
        return StateSpacePackage.eINSTANCE;
    }
}

