/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.statespace.explorer.parts;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.draw2d.FigureCanvas;
import org.eclipse.draw2d.Viewport;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.henshin.statespace.StateEqualityHelper;
import org.eclipse.emf.henshin.statespace.StateSpace;
import org.eclipse.emf.henshin.statespace.StateSpaceManager;
import org.eclipse.emf.henshin.statespace.StateSpacePlugin;
import org.eclipse.emf.henshin.statespace.Trace;
import org.eclipse.emf.henshin.statespace.explorer.StateSpaceExplorerPlugin;
import org.eclipse.emf.henshin.statespace.explorer.actions.CreateInitialStateAction;
import org.eclipse.emf.henshin.statespace.explorer.actions.EditPropertiesAction;
import org.eclipse.emf.henshin.statespace.explorer.actions.ExportStateSpaceAction;
import org.eclipse.emf.henshin.statespace.explorer.actions.ImportRulesAction;
import org.eclipse.emf.henshin.statespace.explorer.actions.ResetStateSpaceAction;
import org.eclipse.emf.henshin.statespace.explorer.commands.SetGraphEqualityCommand;
import org.eclipse.emf.henshin.statespace.explorer.jobs.LayoutStateSpaceJob;
import org.eclipse.emf.henshin.statespace.explorer.jobs.StateSpaceJobManager;
import org.eclipse.emf.henshin.statespace.explorer.jobs.ValidateStateSpaceJob;
import org.eclipse.emf.henshin.statespace.explorer.parts.StateSpaceExplorer;
import org.eclipse.emf.henshin.statespace.explorer.parts.StateSpaceToolsMenuFactory;
import org.eclipse.emf.henshin.statespace.util.StateSpaceSpringLayouter;
import org.eclipse.emf.henshin.statespace.validation.StateSpaceValidator;
import org.eclipse.emf.henshin.statespace.validation.StateValidator;
import org.eclipse.emf.henshin.statespace.validation.ValidationResult;
import org.eclipse.emf.henshin.statespace.validation.Validator;
import org.eclipse.gef.EditDomain;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editparts.ZoomManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.ExpandBar;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Scale;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class StateSpaceToolsMenu
extends Composite {
    public static double[] ZOOM_LEVELS = new double[]{0.1, 0.15, 0.2, 0.25, 0.3, 0.35, 0.4, 0.45, 0.5, 0.55, 0.6, 0.65, 0.7, 0.75, 0.8, 0.85, 0.9, 0.95, 1.0};
    public static final double REPULSION_FACTOR = 2.0;
    public static final double ATTRACTION_FACTOR = 0.05;
    public static final int NATURAL_LENGTH = 25;
    private EditDomain editDomain;
    private StateSpaceJobManager jobManager;
    private StateSpaceExplorer explorer;
    private Label statesLabel;
    private Label transitionsLabel;
    private Label rulesLabel;
    private ZoomManager zoomManager;
    private Scale zoomScale;
    private FigureCanvas canvas;
    private Scale repulsionScale;
    private Scale attractionScale;
    private Button useNodeIDsCheckbox;
    private Button useAttributesCheckbox;
    private Link layouterLink;
    private Link explorerLink;
    private Link initialStateLink;
    private Link importLink;
    private Link resetLink;
    private Link exportLink;
    private Link propertiesLink;
    private Button ecoreButton;
    private Button graphButton;
    private Button validateButton;
    private Text validationText;
    private Combo validatorCombo;
    private List<Validator> validators;
    private static final String VALIDATOR_KEY = "validator";
    private static final String VALIDATION_PROPERTY_KEY = "validationProperty";
    private Adapter adapter = new AdapterImpl(){

        public void notifyChanged(Notification event) {
            StateSpaceToolsMenu.this.refresh();
        }
    };
    private SelectionListener layouterScaleListener = new SelectionListener(){

        public void widgetDefaultSelected(SelectionEvent e) {
            StateSpaceToolsMenu.this.commitMetadata();
            StateSpaceToolsMenu.this.updateLayouterProperties();
        }

        public void widgetSelected(SelectionEvent e) {
            StateSpaceToolsMenu.this.commitMetadata();
            StateSpaceToolsMenu.this.updateLayouterProperties();
        }
    };
    private SelectionListener scrollBarListener = new SelectionListener(){

        public void widgetDefaultSelected(SelectionEvent e) {
            StateSpaceToolsMenu.this.updateLayouterProperties();
        }

        public void widgetSelected(SelectionEvent e) {
            StateSpaceToolsMenu.this.updateLayouterProperties();
        }
    };
    private Listener canvasListener = new Listener(){

        public void handleEvent(Event event) {
            StateSpaceToolsMenu.this.updateLayouterProperties();
        }
    };
    private SelectionListener equalityTypeListener = new SelectionListener(){

        public void widgetSelected(SelectionEvent e) {
            StateSpaceToolsMenu.this.setEqualityType(StateSpaceToolsMenu.this.graphButton.getSelection(), !StateSpaceToolsMenu.this.useNodeIDsCheckbox.getSelection(), !StateSpaceToolsMenu.this.useAttributesCheckbox.getSelection());
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            this.widgetSelected(e);
        }
    };
    private SelectionListener zoomListener = new SelectionListener(){

        public void widgetSelected(SelectionEvent e) {
            StateSpaceToolsMenu.this.commitMetadata();
            StateSpaceToolsMenu.this.updateLayouterProperties();
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            this.widgetSelected(e);
        }
    };
    private SelectionListener initialStateListener = new SelectionListener(){

        public void widgetSelected(SelectionEvent e) {
            if (StateSpaceToolsMenu.this.explorer != null) {
                CreateInitialStateAction action = new CreateInitialStateAction();
                action.setExplorer(StateSpaceToolsMenu.this.explorer);
                action.run(null);
            }
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            this.widgetSelected(e);
        }
    };
    private SelectionListener importListener = new SelectionListener(){

        public void widgetSelected(SelectionEvent e) {
            if (StateSpaceToolsMenu.this.explorer != null) {
                ImportRulesAction action = new ImportRulesAction();
                action.setExplorer(StateSpaceToolsMenu.this.explorer);
                action.run(null);
            }
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            this.widgetSelected(e);
        }
    };
    private SelectionListener exportListener = new SelectionListener(){

        public void widgetSelected(SelectionEvent e) {
            if (StateSpaceToolsMenu.this.explorer != null) {
                ExportStateSpaceAction action = new ExportStateSpaceAction();
                action.setExplorer(StateSpaceToolsMenu.this.explorer);
                action.run(null);
            }
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            this.widgetSelected(e);
        }
    };
    private SelectionListener resetListener = new SelectionListener(){

        public void widgetSelected(SelectionEvent e) {
            if (StateSpaceToolsMenu.this.explorer != null) {
                ResetStateSpaceAction action = new ResetStateSpaceAction();
                action.setExplorer(StateSpaceToolsMenu.this.explorer);
                action.run(null);
            }
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            this.widgetSelected(e);
        }
    };
    private SelectionListener propertiesListener = new SelectionListener(){

        public void widgetSelected(SelectionEvent e) {
            if (StateSpaceToolsMenu.this.explorer != null) {
                EditPropertiesAction action = new EditPropertiesAction();
                action.setExplorer(StateSpaceToolsMenu.this.explorer);
                action.run(null);
            }
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            this.widgetSelected(e);
        }
    };
    private SelectionListener explorerListener = new SelectionListener(){

        public void widgetSelected(SelectionEvent e) {
            if (StateSpaceToolsMenu.this.jobManager == null) {
                return;
            }
            if (StateSpaceToolsMenu.this.explorerLink.getText().indexOf("Start") >= 0) {
                StateSpaceToolsMenu.this.jobManager.startExploreJob();
                StateSpaceToolsMenu.this.explorerLink.setText(StateSpaceToolsMenu.this.explorerLink.getText().replaceFirst("Start", "Stop"));
            } else {
                StateSpaceToolsMenu.this.jobManager.getExploreJob().cancel();
            }
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            this.widgetSelected(e);
        }
    };
    private SelectionListener layouterListener = new SelectionListener(){

        public void widgetSelected(SelectionEvent e) {
            if (StateSpaceToolsMenu.this.jobManager == null) {
                return;
            }
            if (StateSpaceToolsMenu.this.layouterLink.getText().indexOf("Start") >= 0) {
                StateSpaceToolsMenu.this.updateLayouterProperties();
                StateSpaceToolsMenu.this.jobManager.startLayoutJob();
                StateSpaceToolsMenu.this.layouterLink.setText(StateSpaceToolsMenu.this.layouterLink.getText().replaceFirst("Start", "Stop"));
            } else {
                StateSpaceToolsMenu.this.jobManager.stopLayoutJob();
            }
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            this.widgetSelected(e);
        }
    };
    private SelectionListener validateListener = new SelectionListener(){

        public void widgetSelected(SelectionEvent e) {
            if (StateSpaceToolsMenu.this.jobManager == null) {
                return;
            }
            StateSpaceToolsMenu.this.validateButton.setEnabled(false);
            StateSpaceToolsMenu.this.jobManager.getValidateJob().setProperty(StateSpaceToolsMenu.this.validationText.getText());
            StateSpaceToolsMenu.this.jobManager.getValidateJob().setValidator(StateSpaceToolsMenu.this.getActiveValidator());
            StateSpaceToolsMenu.this.jobManager.startValidateJob();
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }
    };
    private ModifyListener validationTextListener = new ModifyListener(){

        public void modifyText(ModifyEvent e) {
            StateSpaceToolsMenu.this.getPreferenceStore().setValue(StateSpaceToolsMenu.VALIDATION_PROPERTY_KEY, StateSpaceToolsMenu.this.validationText.getText());
            Validator validator = StateSpaceToolsMenu.this.getActiveValidator();
            for (String id : StateSpacePlugin.INSTANCE.getValidators().keySet()) {
                if (StateSpacePlugin.INSTANCE.getValidators().get(id) != validator) continue;
                StateSpaceToolsMenu.this.getPreferenceStore().setValue(StateSpaceToolsMenu.VALIDATOR_KEY, id);
                break;
            }
        }
    };
    private SelectionListener validatorComboListener = new SelectionListener(){

        public void widgetDefaultSelected(SelectionEvent e) {
        }

        public void widgetSelected(SelectionEvent e) {
            Validator validator = StateSpaceToolsMenu.this.getActiveValidator();
            StateSpaceToolsMenu.this.validationText.setEnabled(validator.usesProperty());
            for (String id : StateSpacePlugin.INSTANCE.getValidators().keySet()) {
                if (StateSpacePlugin.INSTANCE.getValidators().get(id) != validator) continue;
                StateSpaceToolsMenu.this.getPreferenceStore().setValue(StateSpaceToolsMenu.VALIDATOR_KEY, id);
                break;
            }
        }
    };

    public StateSpaceToolsMenu(Composite parent, EditDomain editDomain) {
        super(parent, 0);
        this.editDomain = editDomain;
        this.init();
    }

    private void init() {
        this.setLayout((Layout)new FillLayout());
        ExpandBar bar = new ExpandBar((Composite)this, 512);
        Composite details = StateSpaceToolsMenuFactory.newExpandItemComposite((Composite)bar, 2);
        this.statesLabel = StateSpaceToolsMenuFactory.newDoubleLabel(details, "States:", "0");
        this.transitionsLabel = StateSpaceToolsMenuFactory.newDoubleLabel(details, "Transitions:", "0");
        this.rulesLabel = StateSpaceToolsMenuFactory.newDoubleLabel(details, "Rules:", "0");
        StateSpaceToolsMenuFactory.newLabel(details, "Equality:", 128);
        Composite radioButtons = new Composite(details, 0);
        radioButtons.setLayoutData((Object)new GridData(768));
        GridLayout layout = new GridLayout(2, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        radioButtons.setLayout((Layout)layout);
        this.ecoreButton = new Button(radioButtons, 16);
        this.ecoreButton.setText("Ecore");
        this.graphButton = new Button(radioButtons, 16);
        this.graphButton.setText("Graph");
        StateSpaceToolsMenuFactory.newLabel(details, "Options:", 128);
        Composite checkBoxes = new Composite(details, 0);
        checkBoxes.setLayoutData((Object)new GridData(768));
        checkBoxes.setLayout((Layout)layout);
        this.useNodeIDsCheckbox = new Button(checkBoxes, 32);
        this.useNodeIDsCheckbox.setText("Node IDs");
        this.useAttributesCheckbox = new Button(checkBoxes, 32);
        this.useAttributesCheckbox.setText("Attribute values");
        StateSpaceToolsMenuFactory.newExpandItem(bar, details, "Details", 0);
        Composite tasks = StateSpaceToolsMenuFactory.newExpandItemComposite((Composite)bar, 2);
        this.initialStateLink = StateSpaceToolsMenuFactory.newLink(tasks, "<a>New initial state</a>");
        this.layouterLink = StateSpaceToolsMenuFactory.newLink(tasks, "  <a>Start layouter</a>");
        this.importLink = StateSpaceToolsMenuFactory.newLink(tasks, "<a>Import rules</a>");
        this.explorerLink = StateSpaceToolsMenuFactory.newLink(tasks, "  <a>Start explorer</a>");
        this.exportLink = StateSpaceToolsMenuFactory.newLink(tasks, "<a>Export state space</a>");
        this.propertiesLink = StateSpaceToolsMenuFactory.newLink(tasks, "  <a>Edit properties</a>");
        this.resetLink = StateSpaceToolsMenuFactory.newLink(tasks, "<a>Reset state space</a>");
        StateSpaceToolsMenuFactory.newExpandItem(bar, tasks, "Tasks", 1);
        Composite display = StateSpaceToolsMenuFactory.newExpandItemComposite((Composite)bar, 3);
        StateSpaceToolsMenuFactory.newLabel(display, "Zoom: " + (int)(ZOOM_LEVELS[0] * 100.0) + "%", 128);
        this.zoomScale = new Scale(display, 0);
        this.zoomScale.setLayoutData((Object)new GridData(768));
        this.zoomScale.setEnabled(false);
        this.zoomScale.setIncrement(1);
        this.zoomScale.setPageIncrement(2);
        this.zoomScale.setMinimum(0);
        this.zoomScale.setMaximum(ZOOM_LEVELS.length - 1);
        this.zoomScale.setSelection(ZOOM_LEVELS.length - 1);
        StateSpaceToolsMenuFactory.newLabel(display, String.valueOf((int)(ZOOM_LEVELS[ZOOM_LEVELS.length - 1] * 100.0)) + "%", 32);
        this.repulsionScale = StateSpaceToolsMenuFactory.newScale(display, "Repulsion:", 1, 100, 5, 10, false, null);
        this.attractionScale = StateSpaceToolsMenuFactory.newScale(display, "Attraction:", 1, 100, 5, 10, false, null);
        StateSpaceToolsMenuFactory.newExpandItem(bar, display, "Display", 2);
        Composite validation = StateSpaceToolsMenuFactory.newExpandItemComposite((Composite)bar, 2);
        this.validationText = StateSpaceToolsMenuFactory.newMultiText(validation, 2, 80);
        this.validatorCombo = new Combo(validation, 2048);
        this.validatorCombo.setLayoutData((Object)new GridData(768));
        this.validateButton = StateSpaceToolsMenuFactory.newButton(validation, "Run");
        StateSpaceToolsMenuFactory.newExpandItem(bar, validation, "Validation", 3);
        this.initControlsData();
        this.setEnabled(false);
    }

    private void initControlsData() {
        this.validators = new ArrayList<Validator>();
        String lastId = this.getPreferenceStore().getString(VALIDATOR_KEY);
        Validator lastValidator = null;
        for (Validator validator : StateSpacePlugin.INSTANCE.getValidators().values()) {
            if (lastId != null && StateSpacePlugin.INSTANCE.getValidators().get(lastId) == validator) {
                lastValidator = validator;
            }
            try {
                Validator old = validator;
                validator = (Validator)validator.getClass().newInstance();
                if (lastValidator == old) {
                    lastValidator = validator;
                }
            }
            catch (Throwable t) {
                StateSpaceExplorerPlugin.getInstance().logError("Validator cannot be reinstantiated", t);
            }
            this.validators.add(validator);
        }
        Collections.sort(this.validators, new Comparator<Validator>(){

            @Override
            public int compare(Validator v1, Validator v2) {
                String n1 = v1.getName();
                String n2 = v2.getName();
                return n1 != null && n2 != null ? n1.compareTo(n2) : 0;
            }
        });
        for (Validator current : this.validators) {
            String name = current.getName();
            if (!(current instanceof StateSpaceValidator) && current instanceof StateValidator) {
                name = String.valueOf(name) + " (invariant)";
            }
            this.validatorCombo.add(name);
        }
        this.validatorCombo.select(lastValidator != null ? this.validators.indexOf(lastValidator) : 0);
        String property = this.getPreferenceStore().getString(VALIDATION_PROPERTY_KEY);
        this.validationText.setText(property != null ? property : "");
        this.validationText.setEnabled(this.getActiveValidator().usesProperty());
    }

    private void updateLayouterProperties() {
        if (this.jobManager == null) {
            return;
        }
        LayoutStateSpaceJob layoutJob = this.jobManager.getLayoutJob();
        StateSpaceSpringLayouter layouter = layoutJob.getLayouter();
        StateSpace stateSpace = this.explorer.getStateSpaceManager().getStateSpace();
        layouter.setStateRepulsion(((double)stateSpace.getStateRepulsion() + 10.0) * 2.0);
        layouter.setTransitionAttraction(((double)stateSpace.getTransitionAttraction() + 40.0) * 0.05);
        layouter.setNaturalTransitionLength(25);
        double zoom = ZOOM_LEVELS[stateSpace.getZoomLevel() * (ZOOM_LEVELS.length - 1) / 100];
        if (this.zoomManager != null) {
            this.zoomManager.setZoom(zoom);
        }
        if (this.canvas != null) {
            Viewport port = this.canvas.getViewport();
            double x = (double)(port.getHorizontalRangeModel().getValue() + port.getHorizontalRangeModel().getExtent() / 2) / zoom;
            double y = (double)(port.getVerticalRangeModel().getValue() + port.getVerticalRangeModel().getExtent() / 2) / zoom;
            layouter.setCenter(new double[]{x, y});
        } else {
            layouter.setCenter(null);
        }
    }

    private void commitMetadata() {
        StateSpace stateSpace = this.explorer.getStateSpaceManager().getStateSpace();
        stateSpace.setZoomLevel((this.zoomScale.getSelection() + 1) * 100 / ZOOM_LEVELS.length);
        stateSpace.setStateRepulsion(this.repulsionScale.getSelection());
        stateSpace.setTransitionAttraction(this.attractionScale.getSelection());
    }

    public void refresh() {
        if (this.isDisposed()) {
            return;
        }
        if (this.jobManager == null) {
            this.statesLabel.setText("0");
            this.transitionsLabel.setText("0");
            this.rulesLabel.setText("0");
        } else {
            StateSpace stateSpace = this.jobManager.getStateSpaceManager().getStateSpace();
            StateEqualityHelper helper = stateSpace.getEqualityHelper();
            this.statesLabel.setText(String.valueOf(stateSpace.getStates().size()) + " (" + stateSpace.getOpenStates().size() + " open)");
            this.transitionsLabel.setText(String.valueOf(stateSpace.getTransitionCount()));
            this.rulesLabel.setText(String.valueOf(stateSpace.getRules().size()));
            this.graphButton.setSelection(helper.isGraphEquality());
            this.ecoreButton.setSelection(!helper.isGraphEquality());
            this.useNodeIDsCheckbox.setSelection(!helper.isIgnoreNodeIDs());
            this.useAttributesCheckbox.setSelection(!helper.isIgnoreAttributes());
        }
    }

    private void updateScales() {
        StateSpace stateSpace = this.jobManager.getStateSpaceManager().getStateSpace();
        this.zoomScale.setSelection(stateSpace.getZoomLevel() * ZOOM_LEVELS.length / 100);
        this.repulsionScale.setSelection(stateSpace.getStateRepulsion());
        this.attractionScale.setSelection(stateSpace.getTransitionAttraction());
    }

    public void setJobManager(StateSpaceJobManager jobManager) {
        if (this.jobManager != null) {
            this.removeListeners();
        }
        this.jobManager = jobManager;
        this.setEnabled(jobManager != null);
        this.refresh();
        this.updateScales();
        if (jobManager != null) {
            this.addListeners();
        }
    }

    public void setEnabled(boolean enabled) {
        this.initialStateLink.setEnabled(enabled);
        this.importLink.setEnabled(enabled);
        this.resetLink.setEnabled(enabled);
        this.propertiesLink.setEnabled(enabled);
        this.layouterLink.setEnabled(enabled);
        this.explorerLink.setEnabled(enabled);
        this.exportLink.setEnabled(enabled);
        this.repulsionScale.setEnabled(enabled);
        this.attractionScale.setEnabled(enabled);
        this.graphButton.setEnabled(enabled);
        this.ecoreButton.setEnabled(enabled);
        this.validateButton.setEnabled(enabled);
        this.validatorCombo.setEnabled(enabled);
        this.validationText.setEnabled(enabled);
        this.useNodeIDsCheckbox.setEnabled(enabled);
        this.useAttributesCheckbox.setEnabled(enabled);
    }

    public void setZoomManager(ZoomManager zoomManager) {
        this.zoomManager = zoomManager;
        this.zoomScale.setEnabled(zoomManager != null);
        if (zoomManager != null) {
            zoomManager.setZoomLevels(ZOOM_LEVELS);
            zoomManager.setZoomAnimationStyle(1);
        }
    }

    public void setCanvas(FigureCanvas canvas) {
        this.canvas = canvas;
        canvas.getHorizontalBar().addSelectionListener(this.scrollBarListener);
        canvas.getVerticalBar().addSelectionListener(this.scrollBarListener);
        canvas.addListener(11, this.canvasListener);
    }

    public void setExplorer(StateSpaceExplorer explorer) {
        this.explorer = explorer;
    }

    private void setEqualityType(boolean graphEquality, boolean ignoreNodeIDs, boolean ignoreAttributes) {
        StateSpaceManager manager = this.jobManager.getStateSpaceManager();
        StateEqualityHelper helper = manager.getStateSpace().getEqualityHelper();
        if (graphEquality != helper.isGraphEquality() || ignoreAttributes != helper.isIgnoreAttributes() || ignoreNodeIDs != helper.isIgnoreNodeIDs()) {
            boolean confirmed;
            StateSpace stateSpace = manager.getStateSpace();
            boolean bl = confirmed = stateSpace.getStates().size() == stateSpace.getInitialStates().size() || MessageDialog.openConfirm((Shell)this.getShell(), (String)"Reset required", (String)"Changing the equality type requires a reset of the state space. Continue?");
            if (confirmed) {
                SetGraphEqualityCommand command = new SetGraphEqualityCommand(manager, graphEquality, ignoreNodeIDs, ignoreAttributes);
                this.editDomain.getCommandStack().execute((Command)command);
            }
            this.refresh();
        }
    }

    private void validationFinished(ValidationResult result, IStatus status) {
        if (status.isOK() && result != null) {
            if (result.getResult() instanceof Trace && this.explorer != null) {
                this.explorer.selectTrace((Trace)result.getResult());
            }
            if (result.isValid()) {
                MessageDialog.openInformation((Shell)this.getShell(), (String)"Validation", (String)result.getMessage());
            } else {
                MessageDialog.openError((Shell)this.getShell(), (String)"Validation", (String)result.getMessage());
            }
        }
        this.validateButton.setEnabled(true);
    }

    private Validator getActiveValidator() {
        int index = this.validatorCombo.getSelectionIndex();
        return index >= 0 ? this.validators.get(index) : null;
    }

    private IPreferenceStore getPreferenceStore() {
        return StateSpaceExplorerPlugin.getInstance().getPreferenceStore();
    }

    private void addListeners() {
        this.jobManager.getStateSpaceManager().getStateSpace().eAdapters().add((Object)this.adapter);
        this.repulsionScale.addSelectionListener(this.layouterScaleListener);
        this.attractionScale.addSelectionListener(this.layouterScaleListener);
        this.zoomScale.addSelectionListener(this.zoomListener);
        this.explorerLink.addSelectionListener(this.explorerListener);
        this.layouterLink.addSelectionListener(this.layouterListener);
        this.initialStateLink.addSelectionListener(this.initialStateListener);
        this.importLink.addSelectionListener(this.importListener);
        this.exportLink.addSelectionListener(this.exportListener);
        this.resetLink.addSelectionListener(this.resetListener);
        this.propertiesLink.addSelectionListener(this.propertiesListener);
        this.graphButton.addSelectionListener(this.equalityTypeListener);
        this.useNodeIDsCheckbox.addSelectionListener(this.equalityTypeListener);
        this.useAttributesCheckbox.addSelectionListener(this.equalityTypeListener);
        this.validateButton.addSelectionListener(this.validateListener);
        this.validationText.addModifyListener(this.validationTextListener);
        this.validatorCombo.addSelectionListener(this.validatorComboListener);
        this.addLinkJobListener(this.jobManager.getLayoutJob(), this.layouterLink);
        this.addLinkJobListener(this.jobManager.getExploreJob(), this.explorerLink);
        final ValidateStateSpaceJob validateJob = this.jobManager.getValidateJob();
        this.addButtonJobListener(validateJob, this.validateButton);
        validateJob.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(final IJobChangeEvent event) {
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        StateSpaceToolsMenu.this.validationFinished(validateJob.getValidationResult(), event.getResult());
                    }
                });
            }
        });
    }

    private void removeListeners() {
        this.jobManager.getStateSpaceManager().getStateSpace().eAdapters().remove((Object)this.adapter);
        this.repulsionScale.removeSelectionListener(this.layouterScaleListener);
        this.attractionScale.removeSelectionListener(this.layouterScaleListener);
        this.zoomScale.removeSelectionListener(this.zoomListener);
        this.graphButton.removeSelectionListener(this.equalityTypeListener);
        this.useNodeIDsCheckbox.removeSelectionListener(this.equalityTypeListener);
        this.useAttributesCheckbox.removeSelectionListener(this.equalityTypeListener);
        this.initialStateLink.removeSelectionListener(this.initialStateListener);
        this.importLink.removeSelectionListener(this.importListener);
        this.exportLink.removeSelectionListener(this.exportListener);
        this.propertiesLink.removeSelectionListener(this.propertiesListener);
        this.resetLink.removeSelectionListener(this.resetListener);
        this.explorerLink.removeSelectionListener(this.explorerListener);
        this.layouterLink.removeSelectionListener(this.layouterListener);
        this.validateButton.removeSelectionListener(this.validateListener);
        this.validationText.removeModifyListener(this.validationTextListener);
        this.validatorCombo.removeSelectionListener(this.validatorComboListener);
    }

    private void addButtonJobListener(Job job, final Button checkbox) {
        job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (checkbox != null && !checkbox.isDisposed()) {
                            checkbox.setEnabled(true);
                            checkbox.setSelection(false);
                        }
                    }
                });
            }
        });
    }

    private void addLinkJobListener(Job job, final Link link) {
        job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        link.setText(link.getText().replaceFirst("Stop", "Start"));
                    }
                });
            }
        });
    }
}

