/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.provider;

import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.ResourceLocator;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.IEditingDomainItemProvider;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.provider.IStructuredItemContentProvider;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;
import org.eclipse.emf.edit.provider.ItemProviderAdapter;
import org.eclipse.emf.edit.provider.ViewerNotification;
import org.eclipse.emf.henshin.model.Edge;
import org.eclipse.emf.henshin.model.HenshinPackage;
import org.eclipse.emf.henshin.model.util.HenshinRuleAnalysisUtil;
import org.eclipse.emf.henshin.provider.HenshinEditPlugin;
import org.eclipse.emf.henshin.provider.descriptors.EdgeSourcePropertyDescriptor;
import org.eclipse.emf.henshin.provider.descriptors.EdgeTargetPropertyDescriptor;
import org.eclipse.emf.henshin.provider.descriptors.EdgeTypePropertyDescriptor;
import org.eclipse.emf.henshin.provider.util.IconUtil;

public class EdgeItemProvider
extends ItemProviderAdapter
implements IEditingDomainItemProvider,
IStructuredItemContentProvider,
ITreeItemContentProvider,
IItemLabelProvider,
IItemPropertySource {
    public EdgeItemProvider(AdapterFactory adapterFactory) {
        super(adapterFactory);
    }

    public List<IItemPropertyDescriptor> getPropertyDescriptors(Object object) {
        if (this.itemPropertyDescriptors == null) {
            super.getPropertyDescriptors(object);
            this.addSourcePropertyDescriptor(object);
            this.addTypePropertyDescriptor(object);
            this.addTargetPropertyDescriptor(object);
        }
        return this.itemPropertyDescriptors;
    }

    protected void addSourcePropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(new EdgeSourcePropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_Edge_source_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_Edge_source_feature", "_UI_Edge_type"), (EStructuralFeature)HenshinPackage.Literals.EDGE__SOURCE));
    }

    protected void addTargetPropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(new EdgeTargetPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_Edge_target_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_Edge_target_feature", "_UI_Edge_type"), (EStructuralFeature)HenshinPackage.Literals.EDGE__TARGET));
    }

    protected void addTypePropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(new EdgeTypePropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_Edge_type_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_Edge_type_feature", "_UI_Edge_type"), (EStructuralFeature)HenshinPackage.Literals.EDGE__TYPE));
    }

    public Object getImage(Object object) {
        Edge edge = (Edge)object;
        Object edgeImage = null;
        edgeImage = edge.getType() != null && edge.getType().isContainment() ? this.getResourceLocator().getImage("full/obj16/ContainmentEdge.png") : this.getResourceLocator().getImage("full/obj16/Edge");
        if (HenshinRuleAnalysisUtil.isDeletionEdge((Edge)edge)) {
            Object deleteOverlay = this.getResourceLocator().getImage("full/ovr16/Del_ovr.png");
            edgeImage = IconUtil.getCompositeImage(edgeImage, deleteOverlay);
        } else if (HenshinRuleAnalysisUtil.isCreationEdge((Edge)edge)) {
            Object createOverlay = this.getResourceLocator().getImage("full/ovr16/Create_ovr.png");
            edgeImage = IconUtil.getCompositeImage(edgeImage, createOverlay);
        }
        return edgeImage;
    }

    public String getText(Object object) {
        String srcName;
        Edge edge = (Edge)object;
        String result = this.getString("_UI_Edge_type");
        String string = edge.getSource() != null ? (edge.getSource().getName() != null ? edge.getSource().getName() : "_") : (srcName = "?");
        String trgName = edge.getTarget() != null ? (edge.getTarget().getName() != null ? edge.getTarget().getName() : "_") : "?";
        String edgeType = "(" + (edge.getType() != null ? edge.getType().getName() : "?") + ")";
        result = String.valueOf(result) + " " + edgeType + " " + srcName + " -> " + trgName;
        return result;
    }

    public void notifyChanged(Notification notification) {
        if (notification.getEventType() == 1) {
            Edge edge = (Edge)notification.getNotifier();
            ViewerNotification notif = new ViewerNotification(notification, (Object)edge, false, true);
            this.fireNotifyChanged((Notification)notif);
        }
        this.updateChildren(notification);
        super.notifyChanged(notification);
    }

    protected void collectNewChildDescriptors(Collection<Object> newChildDescriptors, Object object) {
        super.collectNewChildDescriptors(newChildDescriptors, object);
    }

    public ResourceLocator getResourceLocator() {
        return HenshinEditPlugin.INSTANCE;
    }
}

