/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.model.util;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.common.util.ResourceLocator;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.impl.EcoreFactoryImpl;
import org.eclipse.emf.ecore.util.EObjectValidator;
import org.eclipse.emf.henshin.HenshinModelPlugin;
import org.eclipse.emf.henshin.model.AmalgamationUnit;
import org.eclipse.emf.henshin.model.And;
import org.eclipse.emf.henshin.model.Attribute;
import org.eclipse.emf.henshin.model.AttributeCondition;
import org.eclipse.emf.henshin.model.BinaryFormula;
import org.eclipse.emf.henshin.model.ConditionalUnit;
import org.eclipse.emf.henshin.model.CountedUnit;
import org.eclipse.emf.henshin.model.DescribedElement;
import org.eclipse.emf.henshin.model.Edge;
import org.eclipse.emf.henshin.model.Formula;
import org.eclipse.emf.henshin.model.Graph;
import org.eclipse.emf.henshin.model.GraphElement;
import org.eclipse.emf.henshin.model.HenshinPackage;
import org.eclipse.emf.henshin.model.IndependentUnit;
import org.eclipse.emf.henshin.model.Mapping;
import org.eclipse.emf.henshin.model.NamedElement;
import org.eclipse.emf.henshin.model.NestedCondition;
import org.eclipse.emf.henshin.model.Node;
import org.eclipse.emf.henshin.model.Not;
import org.eclipse.emf.henshin.model.Or;
import org.eclipse.emf.henshin.model.Parameter;
import org.eclipse.emf.henshin.model.ParameterMapping;
import org.eclipse.emf.henshin.model.PriorityUnit;
import org.eclipse.emf.henshin.model.Rule;
import org.eclipse.emf.henshin.model.SequentialUnit;
import org.eclipse.emf.henshin.model.TransformationSystem;
import org.eclipse.emf.henshin.model.TransformationUnit;
import org.eclipse.emf.henshin.model.UnaryFormula;
import org.eclipse.ocl.ParserException;
import org.eclipse.ocl.ecore.Constraint;
import org.eclipse.ocl.ecore.OCL;

public class HenshinValidator
extends EObjectValidator {
    public static final HenshinValidator INSTANCE = new HenshinValidator();
    public static final String DIAGNOSTIC_SOURCE = "org.eclipse.emf.henshin.model";
    private static final int GENERATED_DIAGNOSTIC_CODE_COUNT = 0;
    protected static final int DIAGNOSTIC_CODE_COUNT = 0;
    private static Constraint namedElement_ValidNameInvOCL;
    private static Constraint edge_EqualParentGraphsInvOCL;
    private static final String OCL_ANNOTATION_SOURCE = "http://www.eclipse.org/emf/2010/Henshin/OCL";
    private static final OCL OCL_ENV;
    private static final Map<String, String> HENSHIN_SEVERITY_2_DIAGNOSTIC_MAP;

    static {
        OCL_ENV = OCL.newInstance();
        HENSHIN_SEVERITY_2_DIAGNOSTIC_MAP = new HashMap<String, String>();
        HENSHIN_SEVERITY_2_DIAGNOSTIC_MAP.put("info", Integer.toString(1));
        HENSHIN_SEVERITY_2_DIAGNOSTIC_MAP.put("warning", Integer.toString(2));
        HENSHIN_SEVERITY_2_DIAGNOSTIC_MAP.put("error", Integer.toString(4));
    }

    protected EPackage getEPackage() {
        return HenshinPackage.eINSTANCE;
    }

    protected boolean validate(int classifierID, Object value, DiagnosticChain diagnostics, Map<Object, Object> context) {
        switch (classifierID) {
            case 0: {
                return this.validateNamedElement((NamedElement)value, diagnostics, context);
            }
            case 1: {
                return this.validateDescribedElement((DescribedElement)value, diagnostics, context);
            }
            case 2: {
                return this.validateTransformationSystem((TransformationSystem)value, diagnostics, context);
            }
            case 3: {
                return this.validateRule((Rule)value, diagnostics, context);
            }
            case 4: {
                return this.validateAttributeCondition((AttributeCondition)value, diagnostics, context);
            }
            case 5: {
                return this.validateParameter((Parameter)value, diagnostics, context);
            }
            case 6: {
                return this.validateGraph((Graph)value, diagnostics, context);
            }
            case 7: {
                return this.validateGraphElement((GraphElement)value, diagnostics, context);
            }
            case 8: {
                return this.validateMapping((Mapping)value, diagnostics, context);
            }
            case 9: {
                return this.validateNode((Node)value, diagnostics, context);
            }
            case 10: {
                return this.validateAttribute((Attribute)value, diagnostics, context);
            }
            case 11: {
                return this.validateEdge((Edge)value, diagnostics, context);
            }
            case 12: {
                return this.validateTransformationUnit((TransformationUnit)value, diagnostics, context);
            }
            case 13: {
                return this.validateIndependentUnit((IndependentUnit)value, diagnostics, context);
            }
            case 14: {
                return this.validateSequentialUnit((SequentialUnit)value, diagnostics, context);
            }
            case 15: {
                return this.validateConditionalUnit((ConditionalUnit)value, diagnostics, context);
            }
            case 16: {
                return this.validatePriorityUnit((PriorityUnit)value, diagnostics, context);
            }
            case 17: {
                return this.validateAmalgamationUnit((AmalgamationUnit)value, diagnostics, context);
            }
            case 18: {
                return this.validateCountedUnit((CountedUnit)value, diagnostics, context);
            }
            case 19: {
                return this.validateNestedCondition((NestedCondition)value, diagnostics, context);
            }
            case 20: {
                return this.validateFormula((Formula)value, diagnostics, context);
            }
            case 21: {
                return this.validateUnaryFormula((UnaryFormula)value, diagnostics, context);
            }
            case 22: {
                return this.validateBinaryFormula((BinaryFormula)value, diagnostics, context);
            }
            case 23: {
                return this.validateAnd((And)value, diagnostics, context);
            }
            case 24: {
                return this.validateOr((Or)value, diagnostics, context);
            }
            case 25: {
                return this.validateNot((Not)value, diagnostics, context);
            }
            case 26: {
                return this.validateParameterMapping((ParameterMapping)value, diagnostics, context);
            }
        }
        return true;
    }

    public boolean validateNamedElement(NamedElement namedElement, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean result = this.validate_NoCircularContainment(namedElement, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryMultiplicityConforms(namedElement, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(namedElement, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(namedElement, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(namedElement, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(namedElement, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(namedElement, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(namedElement, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(namedElement, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateNamedElement_ValidName(namedElement, diagnostics, context);
        }
        return result;
    }

    public boolean validateNamedElement_ValidName(NamedElement namedElement, DiagnosticChain diagnostics, Map<Object, Object> context) {
        OCL.Query query;
        if (namedElement_ValidNameInvOCL == null) {
            String sev;
            OCL.Helper helper = OCL_ENV.createOCLHelper();
            helper.setContext((Object)HenshinPackage.Literals.NAMED_ELEMENT);
            EAnnotation ocl = HenshinPackage.Literals.NAMED_ELEMENT.getEAnnotation(OCL_ANNOTATION_SOURCE);
            String expr = (String)ocl.getDetails().get((Object)"ValidName");
            EAnnotation henshinOclAnnotation = EcoreFactoryImpl.eINSTANCE.createEAnnotation();
            henshinOclAnnotation.setSource(OCL_ANNOTATION_SOURCE);
            try {
                namedElement_ValidNameInvOCL = (Constraint)helper.createInvariant(expr);
            }
            catch (ParserException e) {
                throw new UnsupportedOperationException(e.getLocalizedMessage());
            }
            namedElement_ValidNameInvOCL.getEAnnotations().add((Object)henshinOclAnnotation);
            String msg = (String)ocl.getDetails().get((Object)"ValidName.Msg");
            if (msg != null && msg.length() > 0) {
                henshinOclAnnotation.getDetails().put((Object)"Msg", (Object)msg);
            }
            if ((sev = (String)ocl.getDetails().get((Object)"ValidName.Severity")) != null && sev.length() > 0 && HENSHIN_SEVERITY_2_DIAGNOSTIC_MAP.containsKey(sev = sev.toLowerCase())) {
                henshinOclAnnotation.getDetails().put((Object)"Severity", (Object)HENSHIN_SEVERITY_2_DIAGNOSTIC_MAP.get(sev));
            }
        }
        if (!(query = OCL_ENV.createQuery(namedElement_ValidNameInvOCL)).check((Object)namedElement)) {
            if (diagnostics != null) {
                EAnnotation henshinAnnotation = namedElement_ValidNameInvOCL.getEAnnotation(OCL_ANNOTATION_SOURCE);
                int severity = henshinAnnotation.getDetails().containsKey((Object)"Severity") ? Integer.parseInt((String)henshinAnnotation.getDetails().get((Object)"Severity")) : 4;
                String addMsg = henshinAnnotation.getDetails().containsKey((Object)"Msg") ? (String)henshinAnnotation.getDetails().get((Object)"Msg") : null;
                diagnostics.add((Diagnostic)this.createDiagnostic(severity, DIAGNOSTIC_SOURCE, 0, "_UI_GenericConstraint_diagnostic", new Object[]{"ValidName", HenshinValidator.getObjectLabel((EObject)namedElement, context)}, new Object[]{namedElement}, context, addMsg));
            }
            return false;
        }
        return true;
    }

    public boolean validateDescribedElement(DescribedElement describedElement, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(describedElement, diagnostics, context);
    }

    public boolean validateTransformationSystem(TransformationSystem transformationSystem, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean result = this.validate_NoCircularContainment(transformationSystem, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryMultiplicityConforms(transformationSystem, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(transformationSystem, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(transformationSystem, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(transformationSystem, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(transformationSystem, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(transformationSystem, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(transformationSystem, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(transformationSystem, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateNamedElement_ValidName(transformationSystem, diagnostics, context);
        }
        return result;
    }

    public boolean validateRule(Rule rule, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean result = this.validate_NoCircularContainment(rule, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryMultiplicityConforms(rule, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(rule, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(rule, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(rule, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(rule, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(rule, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(rule, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(rule, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateNamedElement_ValidName(rule, diagnostics, context);
        }
        return result;
    }

    public boolean validateAttributeCondition(AttributeCondition attributeCondition, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean result = this.validate_NoCircularContainment(attributeCondition, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryMultiplicityConforms(attributeCondition, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(attributeCondition, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(attributeCondition, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(attributeCondition, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(attributeCondition, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(attributeCondition, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(attributeCondition, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(attributeCondition, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateNamedElement_ValidName(attributeCondition, diagnostics, context);
        }
        return result;
    }

    public boolean validateParameter(Parameter parameter, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean result = this.validate_NoCircularContainment(parameter, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryMultiplicityConforms(parameter, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(parameter, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(parameter, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(parameter, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(parameter, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(parameter, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(parameter, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(parameter, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateNamedElement_ValidName(parameter, diagnostics, context);
        }
        return result;
    }

    public boolean validateGraph(Graph graph, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean result = this.validate_NoCircularContainment(graph, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryMultiplicityConforms(graph, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(graph, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(graph, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(graph, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(graph, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(graph, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(graph, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(graph, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateNamedElement_ValidName(graph, diagnostics, context);
        }
        return result;
    }

    public boolean validateGraphElement(GraphElement graphElement, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(graphElement, diagnostics, context);
    }

    public boolean validateMapping(Mapping mapping, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(mapping, diagnostics, context);
    }

    public boolean validateNode(Node node, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean result = this.validate_NoCircularContainment(node, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryMultiplicityConforms(node, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(node, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(node, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(node, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(node, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(node, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(node, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(node, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateNamedElement_ValidName(node, diagnostics, context);
        }
        return result;
    }

    public boolean validateAttribute(Attribute attribute, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(attribute, diagnostics, context);
    }

    public boolean validateEdge(Edge edge, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean result = this.validate_NoCircularContainment(edge, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryMultiplicityConforms(edge, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(edge, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(edge, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(edge, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(edge, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(edge, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(edge, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(edge, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateEdge_EqualParentGraphs(edge, diagnostics, context);
        }
        return result;
    }

    public boolean validateEdge_EqualParentGraphs(Edge edge, DiagnosticChain diagnostics, Map<Object, Object> context) {
        OCL.Query query;
        if (edge_EqualParentGraphsInvOCL == null) {
            String sev;
            OCL.Helper helper = OCL_ENV.createOCLHelper();
            helper.setContext((Object)HenshinPackage.Literals.EDGE);
            EAnnotation ocl = HenshinPackage.Literals.EDGE.getEAnnotation(OCL_ANNOTATION_SOURCE);
            String expr = (String)ocl.getDetails().get((Object)"EqualParentGraphs");
            EAnnotation henshinOclAnnotation = EcoreFactoryImpl.eINSTANCE.createEAnnotation();
            henshinOclAnnotation.setSource(OCL_ANNOTATION_SOURCE);
            try {
                edge_EqualParentGraphsInvOCL = (Constraint)helper.createInvariant(expr);
            }
            catch (ParserException e) {
                throw new UnsupportedOperationException(e.getLocalizedMessage());
            }
            edge_EqualParentGraphsInvOCL.getEAnnotations().add((Object)henshinOclAnnotation);
            String msg = (String)ocl.getDetails().get((Object)"EqualParentGraphs.Msg");
            if (msg != null && msg.length() > 0) {
                henshinOclAnnotation.getDetails().put((Object)"Msg", (Object)msg);
            }
            if ((sev = (String)ocl.getDetails().get((Object)"EqualParentGraphs.Severity")) != null && sev.length() > 0 && HENSHIN_SEVERITY_2_DIAGNOSTIC_MAP.containsKey(sev = sev.toLowerCase())) {
                henshinOclAnnotation.getDetails().put((Object)"Severity", (Object)HENSHIN_SEVERITY_2_DIAGNOSTIC_MAP.get(sev));
            }
        }
        if (!(query = OCL_ENV.createQuery(edge_EqualParentGraphsInvOCL)).check((Object)edge)) {
            if (diagnostics != null) {
                EAnnotation henshinAnnotation = edge_EqualParentGraphsInvOCL.getEAnnotation(OCL_ANNOTATION_SOURCE);
                int severity = henshinAnnotation.getDetails().containsKey((Object)"Severity") ? Integer.parseInt((String)henshinAnnotation.getDetails().get((Object)"Severity")) : 4;
                String addMsg = henshinAnnotation.getDetails().containsKey((Object)"Msg") ? (String)henshinAnnotation.getDetails().get((Object)"Msg") : null;
                diagnostics.add((Diagnostic)this.createDiagnostic(severity, DIAGNOSTIC_SOURCE, 0, "_UI_GenericConstraint_diagnostic", new Object[]{"EqualParentGraphs", HenshinValidator.getObjectLabel((EObject)edge, context)}, new Object[]{edge}, context, addMsg));
            }
            return false;
        }
        return true;
    }

    public boolean validateTransformationUnit(TransformationUnit transformationUnit, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean result = this.validate_NoCircularContainment(transformationUnit, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryMultiplicityConforms(transformationUnit, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(transformationUnit, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(transformationUnit, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(transformationUnit, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(transformationUnit, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(transformationUnit, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(transformationUnit, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(transformationUnit, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateNamedElement_ValidName(transformationUnit, diagnostics, context);
        }
        return result;
    }

    public boolean validateIndependentUnit(IndependentUnit independentUnit, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean result = this.validate_NoCircularContainment(independentUnit, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryMultiplicityConforms(independentUnit, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(independentUnit, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(independentUnit, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(independentUnit, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(independentUnit, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(independentUnit, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(independentUnit, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(independentUnit, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateNamedElement_ValidName(independentUnit, diagnostics, context);
        }
        return result;
    }

    public boolean validateSequentialUnit(SequentialUnit sequentialUnit, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean result = this.validate_NoCircularContainment(sequentialUnit, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryMultiplicityConforms(sequentialUnit, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(sequentialUnit, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(sequentialUnit, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(sequentialUnit, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(sequentialUnit, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(sequentialUnit, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(sequentialUnit, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(sequentialUnit, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateNamedElement_ValidName(sequentialUnit, diagnostics, context);
        }
        return result;
    }

    public boolean validateConditionalUnit(ConditionalUnit conditionalUnit, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean result = this.validate_NoCircularContainment(conditionalUnit, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryMultiplicityConforms(conditionalUnit, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(conditionalUnit, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(conditionalUnit, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(conditionalUnit, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(conditionalUnit, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(conditionalUnit, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(conditionalUnit, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(conditionalUnit, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateNamedElement_ValidName(conditionalUnit, diagnostics, context);
        }
        return result;
    }

    public boolean validatePriorityUnit(PriorityUnit priorityUnit, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean result = this.validate_NoCircularContainment(priorityUnit, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryMultiplicityConforms(priorityUnit, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(priorityUnit, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(priorityUnit, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(priorityUnit, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(priorityUnit, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(priorityUnit, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(priorityUnit, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(priorityUnit, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateNamedElement_ValidName(priorityUnit, diagnostics, context);
        }
        return result;
    }

    public boolean validateAmalgamationUnit(AmalgamationUnit amalgamationUnit, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean result = this.validate_NoCircularContainment(amalgamationUnit, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryMultiplicityConforms(amalgamationUnit, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(amalgamationUnit, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(amalgamationUnit, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(amalgamationUnit, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(amalgamationUnit, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(amalgamationUnit, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(amalgamationUnit, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(amalgamationUnit, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateNamedElement_ValidName(amalgamationUnit, diagnostics, context);
        }
        return result;
    }

    public boolean validateCountedUnit(CountedUnit countedUnit, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean result = this.validate_NoCircularContainment(countedUnit, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryMultiplicityConforms(countedUnit, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(countedUnit, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(countedUnit, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(countedUnit, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(countedUnit, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(countedUnit, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(countedUnit, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(countedUnit, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateNamedElement_ValidName(countedUnit, diagnostics, context);
        }
        return result;
    }

    public boolean validateNestedCondition(NestedCondition nestedCondition, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(nestedCondition, diagnostics, context);
    }

    public boolean validateFormula(Formula formula, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(formula, diagnostics, context);
    }

    public boolean validateUnaryFormula(UnaryFormula unaryFormula, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(unaryFormula, diagnostics, context);
    }

    public boolean validateBinaryFormula(BinaryFormula binaryFormula, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(binaryFormula, diagnostics, context);
    }

    public boolean validateAnd(And and, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(and, diagnostics, context);
    }

    public boolean validateOr(Or or, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(or, diagnostics, context);
    }

    public boolean validateNot(Not not, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(not, diagnostics, context);
    }

    public boolean validateParameterMapping(ParameterMapping parameterMapping, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(parameterMapping, diagnostics, context);
    }

    public ResourceLocator getResourceLocator() {
        return HenshinModelPlugin.INSTANCE;
    }

    protected BasicDiagnostic createDiagnostic(int severity, String source, int code, String messageKey, Object[] messageSubstitutions, Object[] data, Map<Object, Object> context, String additionalMessage) {
        String henshinMessage = "";
        if (additionalMessage != null && additionalMessage.length() > 0) {
            henshinMessage = " -- " + (additionalMessage.startsWith("_") ? this.getString(additionalMessage, messageSubstitutions) : additionalMessage);
        }
        String message = this.getString(messageKey, messageSubstitutions);
        return new BasicDiagnostic(severity, source, code, String.valueOf(message) + henshinMessage, data);
    }
}

