/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.interpreter.util;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceFactoryImpl;
import org.eclipse.emf.ecore.xmi.impl.XMLResourceImpl;
import org.eclipse.emf.henshin.model.AmalgamationUnit;
import org.eclipse.emf.henshin.model.Attribute;
import org.eclipse.emf.henshin.model.BinaryFormula;
import org.eclipse.emf.henshin.model.Edge;
import org.eclipse.emf.henshin.model.Formula;
import org.eclipse.emf.henshin.model.Graph;
import org.eclipse.emf.henshin.model.Mapping;
import org.eclipse.emf.henshin.model.NestedCondition;
import org.eclipse.emf.henshin.model.Node;
import org.eclipse.emf.henshin.model.Parameter;
import org.eclipse.emf.henshin.model.Rule;
import org.eclipse.emf.henshin.model.TransformationUnit;
import org.eclipse.emf.henshin.model.UnaryFormula;

public class ModelHelper {
    public static String getUniqueNodeName(EClassifier type) {
        return String.valueOf(type.getEPackage().getNsURI()) + "#" + type.getName();
    }

    public static boolean attributeIsParameter(Rule rule, Attribute attribute) {
        String potentialParameter = attribute.getValue();
        boolean found = false;
        for (Parameter parameter : rule.getParameters()) {
            found = parameter.getName().equals(potentialParameter);
            if (found) break;
        }
        return found;
    }

    public static boolean isNodeMapped(Collection<Mapping> mappings, Node node) {
        return ModelHelper.getRemoteNode(mappings, node) != null;
    }

    public static boolean isEdgeMapped(List<Mapping> mappings, Edge edge) {
        Node sourceNode = edge.getSource();
        Node targetNode = edge.getTarget();
        Node remoteSourceNode = ModelHelper.getRemoteNode(mappings, sourceNode);
        Node remoteTargetNode = ModelHelper.getRemoteNode(mappings, targetNode);
        if (remoteSourceNode != null && remoteTargetNode != null) {
            for (Edge remoteEdge : remoteSourceNode.getOutgoing()) {
                if (remoteEdge.getTarget() != remoteTargetNode || remoteEdge.getType() != edge.getType()) continue;
                return true;
            }
        }
        return false;
    }

    public static Node getRemoteNode(Collection<Mapping> mappings, Node node) {
        for (Mapping mapping : mappings) {
            if (mapping.getOrigin() == node) {
                return mapping.getImage();
            }
            if (mapping.getImage() != node) continue;
            return mapping.getOrigin();
        }
        return null;
    }

    public static Collection<Node> getSourceNodes(Collection<Mapping> mappings, Node node) {
        ArrayList<Node> result = new ArrayList<Node>();
        for (Mapping mapping : mappings) {
            if (mapping.getImage() != node) continue;
            result.add(mapping.getOrigin());
        }
        return result;
    }

    public static Collection<Node> getTargetNodes(Collection<Mapping> mappings, Node node) {
        ArrayList<Node> result = new ArrayList<Node>();
        for (Mapping mapping : mappings) {
            if (mapping.getOrigin() != node) continue;
            result.add(mapping.getImage());
        }
        return result;
    }

    public static NestedCondition getParentCondition(Formula formula, Graph graph) {
        if (formula instanceof NestedCondition) {
            NestedCondition nestedCondition = (NestedCondition)formula;
            if (nestedCondition.getConclusion() == graph) {
                return nestedCondition;
            }
        } else if (formula instanceof BinaryFormula) {
            ModelHelper.getParentCondition(((BinaryFormula)formula).getLeft(), graph);
            ModelHelper.getParentCondition(((BinaryFormula)formula).getRight(), graph);
        } else if (formula instanceof UnaryFormula) {
            ModelHelper.getParentCondition(((UnaryFormula)formula).getChild(), graph);
        }
        return null;
    }

    public static Object castDown(Object complexValue, String type) {
        if (complexValue instanceof Double) {
            if (type.equals("int")) {
                return ((Double)complexValue).intValue();
            }
            if (type.equals("long")) {
                return ((Double)complexValue).longValue();
            }
            if (type.equals("float")) {
                return Float.valueOf(((Double)complexValue).floatValue());
            }
            if (type.equals("short")) {
                return ((Double)complexValue).shortValue();
            }
            if (type.equals("byte")) {
                return ((Double)complexValue).byteValue();
            }
        }
        return complexValue;
    }

    public static void registerFileExtension(String extension) {
        Resource.Factory.Registry.INSTANCE.getExtensionToFactoryMap().put(extension, new XMIResourceFactoryImpl());
    }

    public static void saveFile(String filename, EObject root) {
        XMLResourceImpl resource = new XMLResourceImpl(URI.createFileURI((String)filename));
        resource.getContents().add((Object)root);
        try {
            resource.save(null);
        }
        catch (IOException iOException) {}
    }

    public static EObject loadFile(String filename) {
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        Resource resource = resourceSet.getResource(URI.createFileURI((String)filename), true);
        return (EObject)resource.getContents().get(0);
    }

    public static Map<Node, EObject> createPrematch(TransformationUnit unit, Map<Parameter, Object> parameterValues) {
        HashMap<Node, EObject> prematch = new HashMap<Node, EObject>();
        for (Parameter parameter : unit.getParameters()) {
            Node node;
            Rule rule = null;
            if (unit instanceof Rule) {
                rule = (Rule)unit;
            } else if (unit instanceof AmalgamationUnit) {
                rule = ((AmalgamationUnit)unit).getKernelRule();
            }
            if (rule == null || (node = rule.getNodeByName(parameter.getName(), true)) == null) continue;
            prematch.put(node, (EObject)parameterValues.get(parameter));
        }
        return prematch;
    }

    public static void renameParameterInAttribute(Attribute attribute, String oldName, String newName) {
        if (attribute.getValue().equals(oldName)) {
            attribute.setValue(newName);
        }
    }
}

