/*
 * Decompiled with CFR 0.152.
 */
package com.google.inject;

import com.google.inject.ErrorHandler;
import com.google.inject.Injector;
import com.google.inject.InjectorImpl;
import com.google.inject.InternalFactory;
import com.google.inject.InternalFactoryToProviderAdapter;
import com.google.inject.Key;
import com.google.inject.Provider;
import com.google.inject.ProviderToInternalFactoryAdapter;
import com.google.inject.Scope;
import com.google.inject.ScopeAnnotation;
import com.google.inject.util.StackTraceElements;
import java.lang.annotation.Annotation;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Scopes {
    public static final Scope SINGLETON = new Scope(){

        @Override
        public <T> Provider<T> scope(Key<T> key, final Provider<T> creator) {
            return new Provider<T>(){
                private volatile T instance;

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                @Override
                public T get() {
                    if (this.instance != null) return this.instance;
                    Class<Injector> clazz = Injector.class;
                    synchronized (Injector.class) {
                        if (this.instance != null) return this.instance;
                        this.instance = creator.get();
                        // ** MonitorExit[var1_1] (shouldn't be in output)
                        return this.instance;
                    }
                }

                public String toString() {
                    return creator.toString();
                }
            };
        }

        @Override
        public String toString() {
            return "Scopes.SINGLETON";
        }
    };

    private Scopes() {
    }

    static Scope getScopeForType(Class<?> implementation, Map<Class<? extends Annotation>, Scope> scopes, ErrorHandler errorHandler) {
        Class<? extends Annotation> found = null;
        for (Annotation annotation : implementation.getAnnotations()) {
            if (!Scopes.isScopeAnnotation(annotation)) continue;
            if (found != null) {
                errorHandler.handle(StackTraceElements.forType(implementation), "More than one scope annotation was found: %s and %s", "@" + found.getSimpleName(), "@" + annotation.annotationType().getSimpleName());
                continue;
            }
            found = annotation.annotationType();
        }
        return scopes.get(found);
    }

    static boolean isScopeAnnotation(Annotation annotation) {
        return Scopes.isScopeAnnotation(annotation.annotationType());
    }

    static boolean isScopeAnnotation(Class<? extends Annotation> annotationType) {
        return annotationType.isAnnotationPresent(ScopeAnnotation.class);
    }

    static <T> InternalFactory<? extends T> scope(Key<T> key, InjectorImpl injector, InternalFactory<? extends T> creator, Scope scope) {
        if (scope == null) {
            return creator;
        }
        Provider<? extends T> scoped = scope.scope(key, new ProviderToInternalFactoryAdapter<T>(injector, creator));
        return new InternalFactoryToProviderAdapter<T>(scoped);
    }
}

