/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfindex.ui.dialog;

import com.google.common.collect.Iterators;
import java.util.Iterator;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.emfindex.EObjectDescriptor;
import org.eclipse.emf.emfindex.Index;
import org.eclipse.emf.emfindex.query.EObjectDescriptorQuery;
import org.eclipse.emf.emfindex.query.Query;
import org.eclipse.emf.emfindex.query.QueryCommand;
import org.eclipse.emf.emfindex.query.QueryExecutor;
import org.eclipse.emf.emfindex.query.QueryResult;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ListDialog;

public class FindInstanceByNameDialog
extends ListDialog {
    protected Text searchControl;
    protected Index index;
    private Label messageLabel;
    private EClass eClass;

    public FindInstanceByNameDialog(Shell parent, EClass eClass, Index index) {
        super(parent);
        this.index = index;
        this.eClass = eClass;
        this.setTitle("Find instances of " + eClass.getName());
        this.setMessage("Enter name");
        this.setAddCancelButton(false);
        this.setContentProvider(new EObjectContentProvider());
        this.setLabelProvider(new EObjectDescriptorLabelProvider());
    }

    protected int getTableStyle() {
        return super.getTableStyle() | 0x10000000;
    }

    protected Control createDialogArea(Composite container) {
        Composite parent = (Composite)super.createDialogArea(container);
        this.messageLabel = new Label(parent, 0);
        this.messageLabel.setLayoutData((Object)new GridData(768));
        return parent;
    }

    protected Label createMessageArea(Composite composite) {
        Label label = super.createMessageArea(composite);
        this.searchControl = new Text(composite, 2048);
        GridData layoutData = new GridData(768);
        this.searchControl.setLayoutData((Object)layoutData);
        this.searchControl.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                FindInstanceByNameDialog.this.handleSearchPatternChanged(e);
            }
        });
        return label;
    }

    protected void handleSearchPatternChanged(ModifyEvent e) {
        String searchPattern = this.searchControl.getText();
        final EObjectDescriptorQuery eObjectDescriptorQuery = new EObjectDescriptorQuery();
        eObjectDescriptorQuery.setIsInstanceOf(this.eClass);
        eObjectDescriptorQuery.setNameStartsWith(searchPattern);
        QueryResult matches = (QueryResult)this.index.executeQueryCommand((QueryCommand)new QueryCommand<QueryResult<EObjectDescriptor>>(){

            public QueryResult<EObjectDescriptor> execute(QueryExecutor queryExecutor) {
                return queryExecutor.execute((Query)eObjectDescriptorQuery);
            }
        });
        this.getTableViewer().setInput((Object)matches);
    }

    class EObjectContentProvider
    implements IStructuredContentProvider {
        private Iterator<EObjectDescriptor> iterator;

        EObjectContentProvider() {
        }

        public void dispose() {
            this.iterator = null;
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            this.iterator = null;
            if (newInput instanceof Iterable) {
                this.iterator = ((Iterable)newInput).iterator();
            } else if (newInput instanceof Iterator) {
                this.iterator = (Iterator)newInput;
            }
            System.out.println("Input changed " + this.iterator);
            viewer.refresh();
        }

        public Object[] getElements(Object inputElement) {
            System.out.println("Get elements " + this.iterator);
            if (this.iterator != null) {
                Object[] newArray;
                Object[] objectArray = newArray = Iterators.newArray(this.iterator, Object.class);
                int n = newArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object object = objectArray[n2];
                    System.out.println(object);
                    ++n2;
                }
                return newArray;
            }
            return new Object[0];
        }
    }

    class EObjectDescriptorLabelProvider
    implements ILabelProvider {
        EObjectDescriptorLabelProvider() {
        }

        public Image getImage(Object element) {
            return null;
        }

        public String getText(Object element) {
            String string = element instanceof EObjectDescriptor ? ((EObjectDescriptor)element).getName() : element.toString();
            System.out.println(string);
            return string;
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }
    }
}

