/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfindex.query;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterators;
import java.util.Iterator;
import org.eclipse.emf.emfindex.ContainerDescriptor;
import org.eclipse.emf.emfindex.MemoryIndexImpl;
import org.eclipse.emf.emfindex.query.AbstractBaseQueryExecutorStrategy;
import org.eclipse.emf.emfindex.query.ContainerDescriptorQuery;
import org.eclipse.emf.emfindex.query.LazyQueryResultImpl;
import org.eclipse.emf.emfindex.query.QueryResult;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContainerQueryExecutorStrategyImpl
extends AbstractBaseQueryExecutorStrategy<ContainerDescriptor, ContainerDescriptorQuery, MemoryIndexImpl> {
    @Override
    public boolean canExecute(ContainerDescriptorQuery query, MemoryIndexImpl index) {
        return true;
    }

    @Override
    public QueryResult<ContainerDescriptor> execute(final ContainerDescriptorQuery query, final MemoryIndexImpl index) {
        return new LazyQueryResultImpl<ContainerDescriptor>(new Iterable<ContainerDescriptor>(){

            @Override
            public Iterator<ContainerDescriptor> iterator() {
                return ContainerQueryExecutorStrategyImpl.this.getResult(query, index);
            }
        });
    }

    public Iterator<ContainerDescriptor> getResult(final ContainerDescriptorQuery query, MemoryIndexImpl index) {
        return Iterators.filter(index.allContainerDescriptors(), (Predicate)new Predicate<ContainerDescriptor>(){

            public boolean apply(ContainerDescriptor candidate) {
                return ContainerQueryExecutorStrategyImpl.this.match(query, candidate);
            }
        });
    }

    @Override
    protected boolean internalMatch(ContainerDescriptorQuery query, ContainerDescriptor candidate) {
        return query.getName() == null || query.getName().equals(candidate.getName());
    }
}

