/*******************************************************************************
 * Copyright (c) 2009 itemis AG (http://www.itemis.eu) and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *******************************************************************************/
package org.eclipse.emf.emfindex.store;

import java.util.HashMap;
import java.util.Map;

import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.emfindex.store.ResourceIndexer.Registry;

public class ResourceIndexerRegistryImpl implements Registry {

	private Map<String, ResourceIndexer> fileExtension2ResourceIndexers = new HashMap<String, ResourceIndexer>();

	public ResourceIndexer getResourceIndexer(URI resourceURI) {
		return fileExtension2ResourceIndexers.get(resourceURI.fileExtension());
	}

	public void addResourceIndexer(String fileExtension, ResourceIndexer resourceIndexer) {
		fileExtension2ResourceIndexers.put(fileExtension, resourceIndexer);
	}

	public void removeResourceIndexer(String fileExtension) {
		fileExtension2ResourceIndexers.remove(fileExtension);
	}

}