/*******************************************************************************
 * Copyright (c) 2009 itemis AG (http://www.itemis.eu) and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *******************************************************************************/
package org.eclipse.emf.emfindex.store;

import org.eclipse.emf.common.util.URI;

/**
 * Interface to index a specific resource. Implementing classes should traverse
 * the resource, use the {@link DescriptorFactory} to build a tree of
 * descriptors and commit that to the index using the {@link IndexUpdater}.
 * 
 * @author koehnlein
 */
public interface ResourceIndexer {

	void resourceChanged(URI resourceURI, IndexUpdater updater);

	void resourceDeleted(URI resourceURI, IndexUpdater updater);

	interface Registry {
		ResourceIndexer getResourceIndexer(URI resourceURI);
		
		void addResourceIndexer(String fileExtension, ResourceIndexer resourceIndexer);
		
		void removeResourceIndexer(String fileExtension);
		
		// TODO: contentTypes
	}
}
