/*******************************************************************************
 * Copyright (c) 2009 itemis AG (http://www.itemis.eu) and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *******************************************************************************/
package org.eclipse.emf.emfindex.store;

import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.emfindex.ContainerDescriptor;
import org.eclipse.emf.emfindex.ResourceDescriptor;

/**
 * Updates index data. Formerly known as IndexFeeder.
 * 
 * @author koehnlein
 */
public interface IndexUpdater {

	/** 
	 * Updates a subtree of descriptors in the index representing a resource. 
	 * 
	 * @param rootResourceDescriptor
	 */
	void update(ResourceDescriptor rootResourceDescriptor);

	/** 
	 * Deletes a subtree of descriptors in the index representing a resource. 
	 * 
	 * @param rootResourceDescriptor
	 */
	void deleteResourceDescriptor(URI resourceURI);
	
	/**
	 * Adds a new {@link ContainerDescriptor} to the index.
	 * 
	 * @param containerDescriptor
	 */
	void add(ContainerDescriptor containerContainerDescriptor, ContainerDescriptor newContainerDescriptor);

	/**
	 * Updates an existing {@link ContainerDescriptor} and its direct children.
	 * 
	 * @param containerDescriptor
	 */
	void update(ContainerDescriptor rootContainerDescriptor);

	void deleteContainerDescriptor(String name);
	
	DescriptorFactory getDescriptorFactory();
}
