/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfindex.util;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterators;
import java.util.Comparator;
import java.util.Iterator;
import java.util.SortedSet;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PriorizedList<E> {
    private SortedSet<PriorizedElement> elements = new TreeSet<PriorizedElement>(new Comparator<PriorizedElement>(){

        @Override
        public int compare(PriorizedElement element0, PriorizedElement element1) {
            return element1.getPriority() - element0.getPriority();
        }
    });

    public boolean add(E element, int priority) {
        return this.elements.add(new PriorizedElement(element, priority));
    }

    public void clear() {
        this.elements.clear();
    }

    public Iterator<E> iterator() {
        return Iterators.transform(this.elements.iterator(), (Function)new Function<PriorizedElement, E>(){

            public E apply(PriorizedElement from) {
                return from.getElement();
            }
        });
    }

    public boolean remove(final E element) {
        PriorizedElement match = (PriorizedElement)Iterators.find(this.elements.iterator(), (Predicate)new Predicate<PriorizedElement>(){

            public boolean apply(PriorizedElement input) {
                return input.getElement().equals(element);
            }
        });
        return match != null && this.elements.remove(match);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class PriorizedElement {
        private final E element;
        private final int priority;

        public PriorizedElement(E element, int priority) {
            this.element = element;
            this.priority = priority;
        }

        public E getElement() {
            return this.element;
        }

        public int getPriority() {
            return this.priority;
        }
    }
}

