/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfindex.util;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractPruningIterator<DescriptorType>
implements Iterator<DescriptorType> {
    private List<Iterator<?>> state;
    private DescriptorType next;

    protected AbstractPruningIterator(Iterable<?> initialContents) {
        if (initialContents != null) {
            this.state = new ArrayList(10);
            this.state.add(initialContents.iterator());
            this.next = this.peek();
        } else {
            this.next = null;
        }
    }

    protected AbstractPruningIterator(Object initialElement) {
        Iterator<?> iterator = this.getChildrenIterator(initialElement);
        if (iterator != null) {
            this.state = new Stack();
            this.state.add(iterator);
            this.next = this.peek();
        } else {
            this.next = null;
        }
    }

    private DescriptorType peek() {
        Object next;
        do {
            if (this.state.isEmpty()) {
                return null;
            }
            Iterator<?> lastIterator = this.state.get(this.state.size() - 1);
            while (!lastIterator.hasNext()) {
                this.state.remove(this.state.size() - 1);
                if (this.state.isEmpty()) {
                    return null;
                }
                lastIterator = this.state.get(this.state.size() - 1);
            }
            next = lastIterator.next();
            Iterator<?> nextChildrenIterator = this.getChildrenIterator(next);
            if (nextChildrenIterator == null) continue;
            this.state.add(nextChildrenIterator);
        } while (!this.isReturnType(next));
        return (DescriptorType)next;
    }

    protected abstract boolean isReturnType(Object var1);

    protected abstract Iterator<?> getChildrenIterator(Object var1);

    @Override
    public boolean hasNext() {
        return this.next != null;
    }

    @Override
    public DescriptorType next() {
        DescriptorType returnValue = this.next;
        this.next = this.peek();
        return returnValue;
    }

    @Override
    public void remove() {
        throw new IllegalStateException("Operation not implemented");
    }
}

