/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.eef.ide.ui.internal.widgets.quickfix;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.eef.EEFValidationRuleDescription;
import org.eclipse.eef.core.api.utils.EvalFactory;
import org.eclipse.eef.ide.ui.internal.EEFIdeUiPlugin;
import org.eclipse.eef.ide.ui.internal.Messages;
import org.eclipse.eef.ide.ui.internal.widgets.quickfix.EEFQuickFixPage;
import org.eclipse.eef.ide.ui.internal.widgets.quickfix.EEFValidationMessagesPage;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.forms.IMessage;

public class EEFQuickFixWizard
extends Wizard {
    private static final int SUBMONITOR_TASK_WORK = 10;
    private IMessage[] messages;
    private EEFValidationMessagesPage validationMessagesPage;
    private EEFQuickFixPage quickFixPage;

    public EEFQuickFixWizard(IMessage[] messages) {
        this.messages = messages;
        this.setWindowTitle(Messages.EEFQuickFixWizard_windowTitle);
        this.setDefaultPageImageDescriptor(EEFIdeUiPlugin.getPlugin().getImageDescriptor("icons/full/wizban/quick_fix.png"));
        this.setNeedsProgressMonitor(true);
    }

    public void addPages() {
        super.addPages();
        if (this.messages.length == 1) {
            IMessage message = this.messages[0];
            if (message.getKey() instanceof EEFValidationRuleDescription && message.getData() instanceof EvalFactory.Eval) {
                EEFValidationRuleDescription validationRule = (EEFValidationRuleDescription)message.getKey();
                EvalFactory.Eval eval = (EvalFactory.Eval)message.getData();
                this.quickFixPage = new EEFQuickFixPage(message, validationRule, eval);
                this.addPage((IWizardPage)this.quickFixPage);
            }
        } else {
            this.validationMessagesPage = new EEFValidationMessagesPage(this.messages);
            this.addPage((IWizardPage)this.validationMessagesPage);
        }
    }

    public IWizardPage getNextPage(IWizardPage page) {
        EEFValidationRuleDescription validationRule;
        EEFValidationMessagesPage validationRulesPage;
        IMessage message;
        if (this.messages.length != 1 && page instanceof EEFValidationMessagesPage && (message = (validationRulesPage = (EEFValidationMessagesPage)page).getSelectedMessage()).getKey() instanceof EEFValidationRuleDescription && message.getData() instanceof EvalFactory.Eval && (validationRule = (EEFValidationRuleDescription)message.getKey()).getFixes().size() > 0) {
            EvalFactory.Eval eval = (EvalFactory.Eval)message.getData();
            this.quickFixPage = new EEFQuickFixPage(message, validationRule, eval);
            this.quickFixPage.setWizard((IWizard)this);
            return this.quickFixPage;
        }
        return super.getNextPage(page);
    }

    public IWizardPage getPreviousPage(IWizardPage page) {
        if (this.messages.length != -1 && page == this.quickFixPage) {
            this.validationMessagesPage = new EEFValidationMessagesPage(this.messages, this.quickFixPage.getSelectedMessage());
            this.validationMessagesPage.setWizard((IWizard)this);
            this.quickFixPage = null;
            return this.validationMessagesPage;
        }
        return super.getPreviousPage(page);
    }

    public boolean needsPreviousAndNextButtons() {
        return this.messages.length > 1;
    }

    public boolean canFinish() {
        boolean canFinish = this.getContainer().getCurrentPage() == this.quickFixPage;
        canFinish = canFinish && (this.validationMessagesPage == null || this.validationMessagesPage.isPageComplete());
        canFinish = canFinish && this.quickFixPage != null && this.quickFixPage.isPageComplete();
        return canFinish;
    }

    public boolean performFinish() {
        IRunnableWithProgress runnable = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.EEFQuickFixWizard_applyQuickFix, (int)11);
                subMonitor.worked(1);
                if (EEFQuickFixWizard.this.quickFixPage != null) {
                    EEFQuickFixWizard.this.getShell().getDisplay().readAndDispatch();
                    EEFQuickFixWizard.this.quickFixPage.performFinish((IProgressMonitor)subMonitor.newChild(10));
                }
            }
        };
        boolean finishedProperly = true;
        try {
            this.getContainer().run(false, true, runnable);
        }
        catch (InvocationTargetException e) {
            finishedProperly = false;
            EEFIdeUiPlugin.getPlugin().error(e.getMessage(), e);
        }
        catch (InterruptedException e) {
            finishedProperly = false;
            EEFIdeUiPlugin.getPlugin().error(e.getMessage(), e);
        }
        return finishedProperly;
    }
}

