/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.eef.runtime.api.notify;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EContentAdapter;
import org.eclipse.emf.eef.runtime.api.notify.EClassifierNotificationFilter;
import org.eclipse.emf.eef.runtime.api.notify.EStructuralFeatureNotificationFilter;
import org.eclipse.emf.eef.runtime.api.notify.NotificationFilter;
import org.eclipse.emf.eef.runtime.api.notify.PropertiesEditingSemanticListener;

public class ResourceSetAdapter
extends EContentAdapter {
    private Map<EClassifier, List<PropertiesEditingSemanticListener>> eClassifierListeners;
    private Map<EStructuralFeature, List<PropertiesEditingSemanticListener>> eStructuralFeatureListeners;
    private ResourceSet resourceSet;

    public ResourceSetAdapter(ResourceSet resourceSet) {
        this.resourceSet = resourceSet;
        this.eClassifierListeners = new HashMap<EClassifier, List<PropertiesEditingSemanticListener>>();
        this.eStructuralFeatureListeners = new HashMap<EStructuralFeature, List<PropertiesEditingSemanticListener>>();
    }

    public void activate() {
        this.resourceSet.eAdapters().add((Object)this);
    }

    public void deactivate() {
        this.resourceSet.eAdapters().remove((Object)this);
    }

    public void addEditingSemanticListener(PropertiesEditingSemanticListener listener) {
        NotificationFilter[] notificationFilterArray = listener.getFilters();
        int n = notificationFilterArray.length;
        int n2 = 0;
        while (n2 < n) {
            NotificationFilter filter = notificationFilterArray[n2];
            if (filter instanceof EStructuralFeatureNotificationFilter) {
                for (EStructuralFeature feature : ((EStructuralFeatureNotificationFilter)filter).getFeatures()) {
                    this.addEditingSemanticListener(feature, listener);
                }
            } else if (filter instanceof EClassifierNotificationFilter) {
                for (EClassifier eClassifier : ((EClassifierNotificationFilter)filter).getEClassifiers()) {
                    this.addEditingSemanticListener(eClassifier, listener);
                }
            }
            ++n2;
        }
    }

    private void addEditingSemanticListener(EStructuralFeature feature, PropertiesEditingSemanticListener listener) {
        List<PropertiesEditingSemanticListener> listeners = this.eStructuralFeatureListeners.get(feature);
        if (listeners == null) {
            listeners = new ArrayList<PropertiesEditingSemanticListener>();
            this.eStructuralFeatureListeners.put(feature, listeners);
        }
        listeners.add(listener);
    }

    private void addEditingSemanticListener(EClassifier eClassifier, PropertiesEditingSemanticListener listener) {
        List<PropertiesEditingSemanticListener> listeners = this.eClassifierListeners.get(eClassifier);
        if (listeners == null) {
            listeners = new ArrayList<PropertiesEditingSemanticListener>();
            this.eClassifierListeners.put(eClassifier, listeners);
        }
        listeners.add(listener);
    }

    public void removeEditingSemanticListener(PropertiesEditingSemanticListener listener) {
        NotificationFilter[] notificationFilterArray = listener.getFilters();
        int n = notificationFilterArray.length;
        int n2 = 0;
        while (n2 < n) {
            NotificationFilter filter = notificationFilterArray[n2];
            if (filter instanceof EStructuralFeatureNotificationFilter) {
                for (EStructuralFeature feature : ((EStructuralFeatureNotificationFilter)filter).getFeatures()) {
                    this.removeEditingSemanticListener(feature, listener);
                }
            } else if (filter instanceof EClassifierNotificationFilter) {
                for (EClassifier eClassifier : ((EClassifierNotificationFilter)filter).getEClassifiers()) {
                    this.removeEditingSemanticListener(eClassifier, listener);
                }
            }
            ++n2;
        }
        if (this.eClassifierListeners.size() + this.eStructuralFeatureListeners.size() == 0) {
            this.deactivate();
        }
    }

    private void removeEditingSemanticListener(EStructuralFeature feature, PropertiesEditingSemanticListener listener) {
        List<PropertiesEditingSemanticListener> listeners = this.eStructuralFeatureListeners.get(feature);
        if (listeners != null) {
            listeners.remove(listener);
            if (listeners.isEmpty()) {
                this.eStructuralFeatureListeners.remove(feature);
            }
        }
    }

    private void removeEditingSemanticListener(EClassifier eClassifier, PropertiesEditingSemanticListener listener) {
        List<PropertiesEditingSemanticListener> listeners = this.eClassifierListeners.get(eClassifier);
        if (listeners != null) {
            listeners.remove(listener);
            if (listeners.isEmpty()) {
                this.eClassifierListeners.remove(eClassifier);
            }
        }
    }

    public void notifyChanged(Notification notification) {
        EStructuralFeature feature;
        EObject notifier;
        EClass eClass;
        super.notifyChanged(notification);
        if (notification.getNotifier() instanceof EObject && this.eClassifierListeners.get(eClass = (notifier = (EObject)notification.getNotifier()).eClass()) != null) {
            List<PropertiesEditingSemanticListener> listeners = this.eClassifierListeners.get(eClass);
            for (PropertiesEditingSemanticListener listener : listeners) {
                listener.notifyChanged(notification);
            }
        }
        if (notification.getFeature() instanceof EStructuralFeature && this.eStructuralFeatureListeners.get(feature = (EStructuralFeature)notification.getFeature()) != null) {
            List<PropertiesEditingSemanticListener> listeners = this.eStructuralFeatureListeners.get(feature);
            for (PropertiesEditingSemanticListener listener : listeners) {
                listener.notifyChanged(notification);
            }
        }
    }
}

