/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.validation.internal.service.impl.tests;

import java.util.Collection;
import junit.framework.TestCase;
import ordersystem.OrderSystemFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.validation.internal.service.ConstraintCache;
import org.eclipse.emf.validation.internal.service.IProviderDescriptor;
import org.eclipse.emf.validation.internal.service.IProviderOperation;
import org.eclipse.emf.validation.internal.service.impl.tests.AbstractGetConstraintsOperationTest;
import org.eclipse.emf.validation.model.IModelConstraint;
import org.eclipse.emf.validation.service.IModelConstraintProvider;
import org.eclipse.emf.validation.tests.TestNotification;

public class ConstraintCacheTest
extends TestCase {
    static int batchHits = 0;
    static int liveHits = 0;
    private ConstraintCache fixture;
    private IProviderDescriptor provider;

    public ConstraintCacheTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.provider = new TestDescriptor();
        this.fixture = new ConstraintCache();
        this.fixture.addProvider(this.provider);
    }

    private ConstraintCache getFixture() {
        return this.fixture;
    }

    public void test_getDescriptor() {
        IProviderDescriptor desc = this.getFixture().getDescriptor();
        ConstraintCacheTest.assertNotNull((String)"Descriptor is null", (Object)desc);
        ConstraintCacheTest.assertTrue((String)"Descriptor is not caching", (boolean)desc.isCache());
        ConstraintCacheTest.assertFalse((String)"Descriptor is cacheable", (boolean)desc.isCacheEnabled());
        ConstraintCacheTest.assertFalse((String)"Descriptor is XML", (boolean)desc.isXmlProvider());
    }

    public void test_getProviders() {
        Collection c = this.getFixture().getProviders();
        ConstraintCacheTest.assertNotNull((String)"Collection is null", (Object)c);
        ConstraintCacheTest.assertFalse((String)"Collection is empty", (boolean)c.isEmpty());
    }

    public void test_addProvider() {
        Collection c = this.getFixture().getProviders();
        ConstraintCacheTest.assertNotNull((String)"Collection is null", (Object)c);
        ConstraintCacheTest.assertTrue((String)"Provider not found", (boolean)c.contains(this.provider));
    }

    public void test_getBatchConstraints() {
        ConstraintCacheTest.assertTrue((String)"Hit count should be zero", (batchHits == 0 ? 1 : 0) != 0);
        Collection c = this.getFixture().getBatchConstraints((EObject)OrderSystemFactory.eINSTANCE.createProduct(), null);
        ConstraintCacheTest.assertNotNull((String)"Collection is null", (Object)c);
        ConstraintCacheTest.assertEquals((String)"Wrong number of constraints.", (int)1, (int)c.size());
        ConstraintCacheTest.assertEquals((String)"Source provider not hit.", (int)1, (int)batchHits);
        c = this.getFixture().getBatchConstraints((EObject)OrderSystemFactory.eINSTANCE.createProduct(), null);
        ConstraintCacheTest.assertNotNull((String)"Second collection is null", (Object)c);
        ConstraintCacheTest.assertEquals((String)"Wrong number of constraints on second pass.", (int)1, (int)c.size());
        ConstraintCacheTest.assertEquals((String)"Source provider hit again.", (int)1, (int)batchHits);
    }

    public void test_getLiveConstraints() {
        ConstraintCacheTest.assertTrue((String)"Hit count should be zero", (liveHits == 0 ? 1 : 0) != 0);
        Collection c = this.getFixture().getLiveConstraints((Notification)new TestNotification(OrderSystemFactory.eINSTANCE.createProduct(), 1), null);
        ConstraintCacheTest.assertNotNull((String)"Collection is null", (Object)c);
        ConstraintCacheTest.assertEquals((String)"Wrong number of constraints.", (int)1, (int)c.size());
        ConstraintCacheTest.assertEquals((String)"Source provider not hit.", (int)1, (int)liveHits);
        c = this.getFixture().getLiveConstraints((Notification)new TestNotification(OrderSystemFactory.eINSTANCE.createProduct(), 1), null);
        ConstraintCacheTest.assertNotNull((String)"Second collection is null", (Object)c);
        ConstraintCacheTest.assertEquals((String)"Wrong number of constraints on second pass.", (int)1, (int)c.size());
        ConstraintCacheTest.assertEquals((String)"Source provider hit again.", (int)1, (int)liveHits);
    }

    static class TestDescriptor
    implements IProviderDescriptor {
        private final IModelConstraintProvider testProvider = new TestProvider();

        TestDescriptor() {
        }

        public boolean provides(IProviderOperation<? extends Collection<? extends IModelConstraint>> operation) {
            return true;
        }

        public boolean isCacheEnabled() {
            return true;
        }

        public boolean isXmlProvider() {
            return false;
        }

        public boolean isCache() {
            return false;
        }

        public IModelConstraintProvider getProvider() {
            return this.testProvider;
        }
    }

    static class TestProvider
    extends AbstractGetConstraintsOperationTest.TestProvider {
        TestProvider() {
        }

        @Override
        public Collection<IModelConstraint> getBatchConstraints(EObject eObject, Collection<IModelConstraint> constraints) {
            ++batchHits;
            return super.getBatchConstraints(eObject, constraints);
        }

        @Override
        public Collection<IModelConstraint> getLiveConstraints(Notification notification, Collection<IModelConstraint> constraints) {
            ++liveHits;
            return super.getLiveConstraints(notification, constraints);
        }
    }
}

