/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.validation.tests;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import junit.framework.TestCase;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.validation.model.EvaluationMode;
import org.eclipse.emf.validation.model.IConstraintStatus;
import org.eclipse.emf.validation.model.IModelConstraint;
import org.eclipse.emf.validation.service.IBatchValidator;
import org.eclipse.emf.validation.service.ILiveValidator;
import org.eclipse.emf.validation.service.ITraversalStrategy;
import org.eclipse.emf.validation.service.ModelValidationService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestBase
extends TestCase {
    public static final String PLUGIN_ID = "org.eclipse.emf.validation.tests";
    public static final String ID_PREFIX = "org.eclipse.emf.validation.tests.";
    protected final IBatchValidator batchValidator = (IBatchValidator)ModelValidationService.getInstance().newValidator(EvaluationMode.BATCH);
    protected final IBatchValidator treeValidator;
    protected final ILiveValidator liveValidator;

    public TestBase(String name) {
        super(name);
        this.batchValidator.setTraversalStrategy((ITraversalStrategy)new ITraversalStrategy.Flat());
        this.batchValidator.setReportSuccesses(true);
        this.treeValidator = (IBatchValidator)ModelValidationService.getInstance().newValidator(EvaluationMode.BATCH);
        this.treeValidator.setTraversalStrategy((ITraversalStrategy)new ITraversalStrategy.Recursive());
        this.treeValidator.setReportSuccesses(true);
        this.liveValidator = (ILiveValidator)ModelValidationService.getInstance().newValidator(EvaluationMode.LIVE);
        this.liveValidator.setReportSuccesses(true);
    }

    protected void assertAllConstraintsNotPresent(String constraintType, IStatus[] statuses, String ... ids) {
        ArrayList<String> found = new ArrayList<String>();
        IStatus[] iStatusArray = statuses;
        int n = statuses.length;
        int n2 = 0;
        while (n2 < n) {
            IStatus element = iStatusArray[n2];
            IModelConstraint next = ((IConstraintStatus)element).getConstraint();
            String id = next.getDescriptor().getId();
            if (Arrays.asList(ids).contains(id)) {
                found.add(id);
            }
            ++n2;
        }
        if (!found.isEmpty()) {
            TestBase.fail((String)("Found unwanted " + constraintType + " constraints: " + found));
        }
    }

    protected void assertAllConstraintsNotPresent(String constraintType, Collection<IModelConstraint> constraints, String ... ids) {
        ArrayList<String> found = new ArrayList<String>();
        for (IModelConstraint next : constraints) {
            String id = next.getDescriptor().getId();
            if (!Arrays.asList(ids).contains(id)) continue;
            found.add(id);
        }
        if (!found.isEmpty()) {
            TestBase.fail((String)("Found unwanted " + constraintType + " constraints: " + found));
        }
    }

    protected void assertAllConstraintsPresent(String constraintType, IStatus[] statuses, String ... ids) {
        LinkedList<String> notFound = new LinkedList<String>(Arrays.asList(ids));
        IStatus[] iStatusArray = statuses;
        int n = statuses.length;
        int n2 = 0;
        while (n2 < n) {
            IStatus element = iStatusArray[n2];
            IModelConstraint next = ((IConstraintStatus)element).getConstraint();
            notFound.remove(next.getDescriptor().getId());
            ++n2;
        }
        if (!notFound.isEmpty()) {
            TestBase.fail((String)("Did not find " + constraintType + " constraints: " + notFound));
        }
    }

    protected void assertAllConstraintsPresent(String constraintType, Collection<IModelConstraint> constraints, String ... ids) {
        LinkedList<String> notFound = new LinkedList<String>(Arrays.asList(ids));
        for (IModelConstraint next : constraints) {
            notFound.remove(next.getDescriptor().getId());
        }
        if (!notFound.isEmpty()) {
            TestBase.fail((String)("Did not find " + constraintType + " constraints: " + notFound));
        }
    }

    protected void assertAllTargetsPresent(String constraintType, IStatus[] statuses, Collection<? extends EObject> targets) {
        LinkedList<? extends EObject> notFound = new LinkedList<EObject>(targets);
        IStatus[] iStatusArray = statuses;
        int n = statuses.length;
        int n2 = 0;
        while (n2 < n) {
            IStatus element = iStatusArray[n2];
            IConstraintStatus next = (IConstraintStatus)element;
            notFound.remove(next.getTarget());
            ++n2;
        }
        if (!notFound.isEmpty()) {
            TestBase.fail((String)("Did not find " + constraintType + " targets: " + notFound));
        }
    }

    protected void assertConstraintAndTargetNotPresent(String constraintType, IStatus[] statuses, String constraintId, EObject target) {
        IStatus[] iStatusArray = statuses;
        int n = statuses.length;
        int n2 = 0;
        while (n2 < n) {
            IStatus element = iStatusArray[n2];
            IConstraintStatus status = (IConstraintStatus)element;
            IModelConstraint constraint = ((IConstraintStatus)element).getConstraint();
            if (target.equals(status.getTarget()) && constraintId.equals(constraint.getDescriptor().getId())) {
                TestBase.fail((String)("Found unwanted " + constraintType + " constraint " + constraintId + " on " + target));
            }
            ++n2;
        }
    }

    protected void assertConstraintAndTargetPresent(String constraintType, IStatus[] statuses, String constraintId, EObject target) {
        IStatus[] iStatusArray = statuses;
        int n = statuses.length;
        int n2 = 0;
        while (n2 < n) {
            IStatus element = iStatusArray[n2];
            IConstraintStatus status = (IConstraintStatus)element;
            IModelConstraint constraint = ((IConstraintStatus)element).getConstraint();
            if (target.equals(status.getTarget()) && constraintId.equals(constraint.getDescriptor().getId())) {
                return;
            }
            ++n2;
        }
        TestBase.fail((String)("Did not find " + constraintType + " constraint " + constraintId + " on " + target));
    }

    protected IStatus getStatus(IStatus[] statuses, String id) {
        IConstraintStatus result = null;
        IStatus[] iStatusArray = statuses;
        int n = statuses.length;
        int n2 = 0;
        while (n2 < n) {
            IStatus element = iStatusArray[n2];
            IConstraintStatus next = (IConstraintStatus)element;
            if (next.getConstraint().getDescriptor().getId().equals(id)) {
                result = next;
                break;
            }
            ++n2;
        }
        return result;
    }

    protected IStatus[] getStatuses(IStatus[] statuses, String id) {
        ArrayList<IConstraintStatus> result = new ArrayList<IConstraintStatus>();
        IStatus[] iStatusArray = statuses;
        int n = statuses.length;
        int n2 = 0;
        while (n2 < n) {
            IStatus element = iStatusArray[n2];
            IConstraintStatus next = (IConstraintStatus)element;
            if (next.getConstraint().getDescriptor().getId().equals(id)) {
                result.add(next);
            }
            ++n2;
        }
        return result.toArray(new IStatus[result.size()]);
    }

    protected IStatus[] getStatuses(IStatus status) {
        if (status.getCode() == 10) {
            return new IStatus[0];
        }
        ArrayList<IStatus> result = new ArrayList<IStatus>();
        this.collectStatuses(status, result);
        return result.toArray(new IStatus[result.size()]);
    }

    private void collectStatuses(IStatus status, List<IStatus> statuses) {
        if (status.isMultiStatus()) {
            IStatus[] children;
            IStatus[] iStatusArray = children = status.getChildren();
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                IStatus element = iStatusArray[n2];
                this.collectStatuses(element, statuses);
                ++n2;
            }
        } else {
            statuses.add(status);
        }
    }

    protected void showRecursive(EObject o, int tabs) {
        int i = 0;
        while (i < tabs) {
            System.out.print("  ");
            ++i;
        }
        System.out.println(o);
        int childTabs = tabs + 1;
        for (EObject next : o.eContents()) {
            this.showRecursive(next, childTabs);
        }
    }
}

