/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xsd.impl.type;

import org.eclipse.xsd.impl.type.XSDAnySimpleType;

public class XSDFloatType
extends XSDAnySimpleType {
    protected static final Float NaN = new Float(Float.NaN);
    protected static final Float NEGATIVE_INFINITY = new Float(Float.NEGATIVE_INFINITY);
    protected static final Float POSITIVE_INFINITY = new Float(Float.POSITIVE_INFINITY);

    public Object getValue(String literal) {
        try {
            if ("Nan".equals(literal)) {
                return NaN;
            }
            if ("-INF".equals(literal)) {
                return NEGATIVE_INFINITY;
            }
            if ("INF".equals(literal)) {
                return POSITIVE_INFINITY;
            }
            return new Float(literal);
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    public int compareValues(Object value1, Object value2) {
        return ((Float)value1).compareTo((Float)value2);
    }
}

