/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.validation.service;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.validation.EMFEventType;
import org.eclipse.emf.validation.internal.EMFModelValidationPlugin;
import org.eclipse.emf.validation.internal.util.Log;
import org.eclipse.emf.validation.internal.util.Trace;
import org.eclipse.emf.validation.service.INotificationGenerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EventTypeService {
    private static EventTypeService instance = new EventTypeService();
    private static final String A_NAME = "name";
    private static final String A_FEATURE_SPECIFIC = "featureSpecific";
    private static final String A_NOTIFICATION_GENERATOR = "notificationGenerator";
    private final Map<String, INotificationGenerator> notificationGenerators = new HashMap<String, INotificationGenerator>();

    private EventTypeService() {
        this.configureEventTypes();
    }

    private void configureEventTypes() {
        IConfigurationElement[] configs;
        IConfigurationElement[] iConfigurationElementArray = configs = Platform.getExtensionRegistry().getConfigurationElementsFor(EMFModelValidationPlugin.getPluginId(), "eventTypes");
        int n = configs.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            if (element.getName().equals("eventType")) {
                try {
                    String name = element.getAttribute(A_NAME);
                    if (name != null && name.length() > 0) {
                        EMFEventType.addEventType(name, Boolean.valueOf(element.getAttribute(A_FEATURE_SPECIFIC)));
                        String notificationGenerator = element.getAttribute(A_NOTIFICATION_GENERATOR);
                        if (notificationGenerator != null && notificationGenerator.length() > 0) {
                            this.notificationGenerators.put(name, (INotificationGenerator)element.createExecutableExtension(A_NOTIFICATION_GENERATOR));
                        }
                    }
                }
                catch (CoreException e) {
                    Trace.catching(this.getClass(), "configureEventTypes()", e);
                    Log.log(e.getStatus());
                }
            }
            ++n2;
        }
    }

    public static EventTypeService getInstance() {
        return instance;
    }

    @Deprecated
    public void configureEventTypes(IConfigurationElement[] elements) {
    }

    public Collection<INotificationGenerator> getNotificationGenerators() {
        return Collections.unmodifiableCollection(this.notificationGenerators.values());
    }

    public INotificationGenerator getNotificationGenerator(String eventName) {
        return this.notificationGenerators.get(eventName);
    }
}

