/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.teneo.eclipse;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.teneo.eclipse.StoreEclipseException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class StoreEclipseUtil {
    public static void handleError(Throwable t, Log log) {
        t.printStackTrace(System.err);
        log.error((Object)t);
        MessageDialog.openError((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"Error Occured", (String)t.getMessage());
    }

    public static Properties readPropFile(IStructuredSelection selection) {
        IFile propFile = (IFile)selection.getFirstElement();
        String filePath = propFile.getFullPath().toOSString();
        try {
            InputStream is = propFile.getContents();
            Properties props = new Properties();
            props.load(is);
            is.close();
            StoreEclipseUtil.checkProperty("name", props);
            StoreEclipseUtil.checkProperty("editorextension", "editorid", props);
            return props;
        }
        catch (IOException e) {
            throw new StoreEclipseException("Exception when reading properties from: " + filePath, e);
        }
        catch (CoreException e) {
            throw new StoreEclipseException("Exception when reading properties from: " + filePath, e);
        }
    }

    private static void checkProperty(String propName, Properties props) {
        if (props.getProperty(propName) == null) {
            throw new StoreEclipseException("The ehb file does not contain the property: " + propName);
        }
    }

    private static void checkProperty(String propName1, String propName2, Properties props) {
        if (props.getProperty(propName1) == null && props.getProperty(propName2) == null) {
            throw new StoreEclipseException("The ehb file must contain one of these properties: " + propName1 + "," + propName2);
        }
    }
}

