/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.teneo.annotations.pamodel.impl;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.EObjectImpl;
import org.eclipse.emf.ecore.util.EObjectContainmentWithInverseEList;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.emf.ecore.xmi.impl.XMLResourceImpl;
import org.eclipse.emf.teneo.annotations.pamodel.PAnnotatedEAttribute;
import org.eclipse.emf.teneo.annotations.pamodel.PAnnotatedEClass;
import org.eclipse.emf.teneo.annotations.pamodel.PAnnotatedEDataType;
import org.eclipse.emf.teneo.annotations.pamodel.PAnnotatedEModelElement;
import org.eclipse.emf.teneo.annotations.pamodel.PAnnotatedEPackage;
import org.eclipse.emf.teneo.annotations.pamodel.PAnnotatedEReference;
import org.eclipse.emf.teneo.annotations.pamodel.PAnnotatedEStructuralFeature;
import org.eclipse.emf.teneo.annotations.pamodel.PAnnotatedModel;
import org.eclipse.emf.teneo.annotations.pamodel.PamodelPackage;
import org.eclipse.emf.teneo.annotations.pannotation.SequenceGenerator;
import org.eclipse.emf.teneo.annotations.pannotation.SequenceStyleGenerator;
import org.eclipse.emf.teneo.annotations.pannotation.TableGenerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PAnnotatedModelImpl
extends EObjectImpl
implements PAnnotatedModel {
    final MapTrackingAdapter itsMapTrackingAdapter;
    protected EList<PAnnotatedEPackage> paEPackages;
    protected final Map<EModelElement, PAnnotatedEModelElement> eElement_to_pElement;
    private boolean initialized = false;
    private ConcurrentHashMap<String, EClass> entityNameToEClass = new ConcurrentHashMap();

    protected PAnnotatedModelImpl() {
        this.eElement_to_pElement = new HashMap<EModelElement, PAnnotatedEModelElement>();
        this.itsMapTrackingAdapter = new MapTrackingAdapter();
        this.eAdapters().add((Object)this.itsMapTrackingAdapter);
    }

    @Override
    public Map<EModelElement, PAnnotatedEModelElement> getModelElementMapping() {
        return this.eElement_to_pElement;
    }

    @Override
    public void merge(PAnnotatedModel pModel) {
        this.eElement_to_pElement.putAll(pModel.getModelElementMapping());
    }

    protected void addMapping(PAnnotatedEModelElement target) {
        ENamedElement eModelElement = target.getModelElement();
        if (eModelElement != null) {
            PAnnotatedEModelElement prevAssoc = this.eElement_to_pElement.get(eModelElement);
            if (prevAssoc != null) {
                this.removeMapping((EModelElement)eModelElement);
                prevAssoc.setModelElement(null);
            }
            this.eElement_to_pElement.put((EModelElement)eModelElement, target);
        }
    }

    protected void removeMapping(EModelElement eModelElement) {
        PAnnotatedEModelElement prevAssoc = this.eElement_to_pElement.remove(eModelElement);
        assert (prevAssoc != null);
    }

    protected void attach(PAnnotatedEModelElement aElement) {
        aElement.eAdapters().add(0, (Object)this.itsMapTrackingAdapter);
        this.addMapping(aElement);
        this.attach((List<? extends Object>)aElement.eContents());
    }

    protected void attach(List<? extends Object> aElements) {
        for (Object object : aElements) {
            if (!(object instanceof PAnnotatedEModelElement)) continue;
            this.attach((PAnnotatedEModelElement)object);
        }
    }

    protected void detach(PAnnotatedEModelElement aElement) {
        aElement.eAdapters().remove((Object)this.itsMapTrackingAdapter);
        ENamedElement annotatedElement = aElement.getModelElement();
        if (annotatedElement != null) {
            this.removeMapping((EModelElement)annotatedElement);
        }
        this.detach((List<? extends Object>)aElement.eContents());
    }

    protected void detach(List<? extends Object> aElements) {
        for (Object object : aElements) {
            if (!(object instanceof PAnnotatedEModelElement)) continue;
            this.detach((PAnnotatedEModelElement)object);
        }
    }

    public void invMapIsWellFormed() {
        HashSet<EModelElement> definedUnused = new HashSet<EModelElement>(this.eElement_to_pElement.keySet());
        TreeIterator i = EcoreUtil.getAllContents((Collection)this.eContents());
        while (i.hasNext()) {
            Object x = i.next();
            if (x instanceof PAnnotatedEModelElement) {
                PAnnotatedEModelElement paElement = (PAnnotatedEModelElement)x;
                ENamedElement annotatedElement = paElement.getModelElement();
                if (annotatedElement == null) continue;
                assert (this.getPAnnotated((EModelElement)annotatedElement) == paElement);
                definedUnused.remove(annotatedElement);
                continue;
            }
            i.prune();
        }
        assert (definedUnused.isEmpty());
    }

    @Override
    public PAnnotatedEModelElement getPAnnotated(EModelElement e) {
        this.checkAnnotatedPresent(e, this.eElement_to_pElement);
        return this.eElement_to_pElement.get(e);
    }

    @Override
    public PAnnotatedEPackage getPAnnotated(EPackage e) {
        this.checkAnnotatedPresent((EModelElement)e, this.eElement_to_pElement);
        return (PAnnotatedEPackage)this.eElement_to_pElement.get(e);
    }

    @Override
    public PAnnotatedEClass getPAnnotated(EClass e) {
        if (e.getEPackage() instanceof EcorePackage) {
            return (PAnnotatedEClass)this.eElement_to_pElement.get(e);
        }
        this.checkAnnotatedPresent((EModelElement)e, this.eElement_to_pElement);
        return (PAnnotatedEClass)this.eElement_to_pElement.get(e);
    }

    @Override
    public PAnnotatedEStructuralFeature getPAnnotated(EStructuralFeature e) {
        this.checkAnnotatedPresent((EModelElement)e, this.eElement_to_pElement);
        return (PAnnotatedEStructuralFeature)this.eElement_to_pElement.get(e);
    }

    @Override
    public PAnnotatedEDataType getPAnnotated(EDataType e) {
        return (PAnnotatedEDataType)this.eElement_to_pElement.get(e);
    }

    @Override
    public PAnnotatedEAttribute getPAnnotated(EAttribute e) {
        this.checkAnnotatedPresent((EModelElement)e, this.eElement_to_pElement);
        return (PAnnotatedEAttribute)this.eElement_to_pElement.get(e);
    }

    @Override
    public PAnnotatedEReference getPAnnotated(EReference e) {
        this.checkAnnotatedPresent((EModelElement)e, this.eElement_to_pElement);
        return (PAnnotatedEReference)this.eElement_to_pElement.get(e);
    }

    private void checkAnnotatedPresent(EModelElement ee, Map<EModelElement, PAnnotatedEModelElement> map) {
        if (!this.isInitialized()) {
            return;
        }
        if (ee == null) {
            throw new IllegalArgumentException("Trying to retrieve Annotated Type using null. This can occur if not all epackages have been registered with Teneo.\nOr this can occur if epackages which refer to eachother are placed in different ecore/xsd files and they are not read using one resource set. The reference from one epackage to another must be resolvable by EMF.");
        }
        if (map.get(ee) == null) {
            String name = ee instanceof ENamedElement ? " for: " + ((ENamedElement)ee).getName() : "";
            throw new IllegalArgumentException("No annotated model element present " + name + " for type " + ee.eClass().getName() + " has its epackage been registered with Teneo?");
        }
    }

    protected EClass eStaticClass() {
        return PamodelPackage.Literals.PANNOTATED_MODEL;
    }

    @Override
    public EList<PAnnotatedEPackage> getPaEPackages() {
        if (this.paEPackages == null) {
            this.paEPackages = new EObjectContainmentWithInverseEList(PAnnotatedEPackage.class, (InternalEObject)this, 0, 2);
        }
        return this.paEPackages;
    }

    public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 0: {
                return ((InternalEList)this.getPaEPackages()).basicAdd((Object)otherEnd, msgs);
            }
        }
        return super.eInverseAdd(otherEnd, featureID, msgs);
    }

    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 0: {
                return ((InternalEList)this.getPaEPackages()).basicRemove((Object)otherEnd, msgs);
            }
        }
        return super.eInverseRemove(otherEnd, featureID, msgs);
    }

    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 0: {
                return this.getPaEPackages();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 0: {
                this.getPaEPackages().clear();
                this.getPaEPackages().addAll((Collection)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    public void eUnset(int featureID) {
        switch (featureID) {
            case 0: {
                this.getPaEPackages().clear();
                return;
            }
        }
        super.eUnset(featureID);
    }

    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 0: {
                return this.paEPackages != null && !this.paEPackages.isEmpty();
            }
        }
        return super.eIsSet(featureID);
    }

    @Override
    public SequenceGenerator getSequenceGenerator(EStructuralFeature efeature, String name) {
        for (PAnnotatedEPackage pae : this.getPaEPackages()) {
            for (SequenceGenerator sg : pae.getSequenceGenerators()) {
                if (sg.getName() == null || sg.getName().compareTo(name) != 0) continue;
                return sg;
            }
        }
        throw new IllegalStateException("No sequence generator found with the name: " + name + ", name is used in " + "annotation of element " + efeature.getEContainingClass().getName() + "/" + efeature.getName());
    }

    @Override
    public SequenceStyleGenerator getSequenceStyleGenerator(EStructuralFeature efeature, String name) {
        for (PAnnotatedEPackage pae : this.getPaEPackages()) {
            for (SequenceStyleGenerator sg : pae.getSequenceStyleGenerators()) {
                if (sg.getName() == null || sg.getName().compareTo(name) != 0) continue;
                return sg;
            }
        }
        throw new IllegalStateException("No sequence generator found with the name: " + name + ", name is used in " + "annotation of element " + efeature.getEContainingClass().getName() + "/" + efeature.getName());
    }

    @Override
    public TableGenerator getTableGenerator(EStructuralFeature efeature, String name) {
        for (PAnnotatedEPackage pae : this.getPaEPackages()) {
            for (TableGenerator tg : pae.getTableGenerators()) {
                if (tg.getName() == null || tg.getName().compareTo(name) != 0) continue;
                return tg;
            }
            for (PAnnotatedEClass pec : pae.getPaEClasses()) {
                if (pec.getTableGenerator() != null && pec.getTableGenerator().getName() != null && pec.getTableGenerator().getName().compareTo(name) == 0) {
                    return pec.getTableGenerator();
                }
                for (PAnnotatedEStructuralFeature pef : pec.getPaEStructuralFeatures()) {
                    for (TableGenerator tg : pef.getTableGenerators()) {
                        if (tg.getName() == null || tg.getName().compareTo(name) != 0) continue;
                        return tg;
                    }
                }
            }
        }
        return null;
    }

    @Override
    public boolean isInitialized() {
        return this.initialized;
    }

    @Override
    public void setInitialized(boolean initialized) {
        this.initialized = initialized;
    }

    @Override
    public EClass getEClass(String entityName) {
        EClass eClass = this.entityNameToEClass.get(entityName);
        if (eClass != null) {
            return eClass;
        }
        for (PAnnotatedEPackage aPackage : this.getPaEPackages()) {
            for (PAnnotatedEClass aClass : aPackage.getPaEClasses()) {
                if (aClass.getEntity() == null || aClass.getEntity().getName() == null || aClass.getEntity().getName().compareTo(entityName) != 0) continue;
                this.entityNameToEClass.put(entityName, aClass.getModelEClass());
                return aClass.getModelEClass();
            }
        }
        throw new IllegalArgumentException("No Annotated EClass for entityName " + entityName);
    }

    @Override
    public EClassifier getEClassifier(String name) {
        if (this.hasEClass(name)) {
            return this.getEClass(name);
        }
        for (PAnnotatedEPackage aPackage : this.getPaEPackages()) {
            EClassifier eClassifier = aPackage.getModelEPackage().getEClassifier(name);
            if (!(eClassifier instanceof EDataType)) continue;
            return eClassifier;
        }
        throw new IllegalArgumentException("No EClassifier for name " + name);
    }

    @Override
    public boolean hasEClassifier(String name) {
        if (this.hasEClass(name)) {
            return true;
        }
        for (PAnnotatedEPackage aPackage : this.getPaEPackages()) {
            EClassifier eClassifier = aPackage.getModelEPackage().getEClassifier(name);
            if (!(eClassifier instanceof EDataType)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean hasEClass(String entityName) {
        if (this.entityNameToEClass.get(entityName) != null) {
            return true;
        }
        for (PAnnotatedEPackage aPackage : this.getPaEPackages()) {
            for (PAnnotatedEClass aClass : aPackage.getPaEClasses()) {
                if (aClass.getEntity() == null || aClass.getEntity().getName() == null || aClass.getEntity().getName().compareTo(entityName) != 0) continue;
                this.entityNameToEClass.put(entityName, aClass.getModelEClass());
                return true;
            }
        }
        return false;
    }

    @Override
    public String toXML() {
        try {
            XMLResourceImpl xmlResource = new XMLResourceImpl();
            xmlResource.getContents().add((Object)this);
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            HashMap<String, String> options = new HashMap<String, String>();
            options.put("PROCESS_DANGLING_HREF", "RECORD");
            xmlResource.save((OutputStream)bos, options);
            String res = bos.toString();
            bos.close();
            return res;
        }
        catch (IOException e) {
            throw new IllegalStateException("Exception while converting pamodel to a xml string", e);
        }
    }

    class MapTrackingAdapter
    extends AdapterImpl {
        MapTrackingAdapter() {
        }

        public void notifyChanged(Notification msg) {
            Object msgFeature = msg.getFeature();
            if (!msg.isTouch() && msgFeature == PamodelPackage.eINSTANCE.getPAnnotatedEModelElement_ModelElement()) {
                switch (msg.getEventType()) {
                    case 1: 
                    case 2: {
                        PAnnotatedModelImpl.this.removeMapping((EModelElement)msg.getOldValue());
                        PAnnotatedModelImpl.this.addMapping((PAnnotatedEModelElement)msg.getNotifier());
                    }
                }
            } else if (msgFeature instanceof EReference && !msg.isTouch()) {
                EReference r = (EReference)msgFeature;
                if (PamodelPackage.eINSTANCE.getPAnnotatedEModelElement().isSuperTypeOf(r.getEReferenceType()) && r.isContainment()) {
                    switch (msg.getEventType()) {
                        case 1: 
                        case 2: {
                            if (msg.getOldValue() != null) {
                                PAnnotatedModelImpl.this.detach((PAnnotatedEModelElement)msg.getOldValue());
                            }
                            if (msg.getNewValue() == null) break;
                            PAnnotatedModelImpl.this.attach((PAnnotatedEModelElement)msg.getNewValue());
                            break;
                        }
                        case 3: {
                            if (msg.getNewValue() == null) break;
                            PAnnotatedModelImpl.this.attach((PAnnotatedEModelElement)msg.getNewValue());
                            break;
                        }
                        case 5: {
                            PAnnotatedModelImpl.this.attach((List)msg.getNewValue());
                            break;
                        }
                        case 4: {
                            if (msg.getOldValue() == null) break;
                            PAnnotatedModelImpl.this.detach((PAnnotatedEModelElement)msg.getOldValue());
                            break;
                        }
                        case 6: {
                            PAnnotatedModelImpl.this.detach((List)msg.getNewValue());
                        }
                    }
                }
            }
            super.notifyChanged(msg);
        }
    }
}

