/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.internal.cdo.util;

import java.text.MessageFormat;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EGenericType;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EParameter;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.ETypeParameter;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.internal.cdo.bundle.OM;
import org.eclipse.emf.internal.cdo.messages.Messages;
import org.eclipse.emf.internal.cdo.util.PackageClosure;
import org.eclipse.net4j.util.om.trace.ContextTracer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompletePackageClosure
extends PackageClosure {
    private static final ContextTracer TRACER = new ContextTracer(OM.DEBUG_MODEL, CompletePackageClosure.class);
    private boolean excludeEcore;
    private Set<EPackage> visitedPackages;

    public CompletePackageClosure() {
    }

    public CompletePackageClosure(boolean excludeEcore) {
        this.excludeEcore = excludeEcore;
    }

    @Override
    protected void handleEPackage(EPackage ePackage, Set<EPackage> visitedPackages) {
        if (ePackage != null && visitedPackages.add(ePackage)) {
            if (this.excludeEcore && (EcorePackage.eINSTANCE == ePackage || "http://www.eclipse.org/emf/2002/Ecore".equals(ePackage.getNsURI()))) {
                return;
            }
            this.visitedPackages = visitedPackages;
            HashSet<EClassifier> visitedClassifiers = new HashSet<EClassifier>();
            for (EClassifier classifier : ePackage.getEClassifiers()) {
                this.handleEClassifier(classifier, visitedClassifiers);
            }
            for (EClassifier classifier : visitedClassifiers) {
                EPackage p = classifier.getEPackage();
                if (p != null) {
                    if (!visitedPackages.add(p) || !TRACER.isEnabled()) continue;
                    TRACER.trace("Found package " + p.getNsURI());
                    continue;
                }
                OM.LOG.warn(MessageFormat.format(Messages.getString("CompletePackageClosure.0"), classifier.getName()));
            }
        }
    }

    protected void handleEClassifier(EClassifier classifier, Set<EClassifier> visited) {
        if (classifier != null && visited.add(classifier)) {
            this.handleEPackage(classifier.getEPackage(), this.visitedPackages);
            this.handleETypeParameters((EList<ETypeParameter>)classifier.getETypeParameters(), visited);
            if (classifier instanceof EClass) {
                EClass eClass = (EClass)classifier;
                this.handleEStructuralFeatures((List<EStructuralFeature>)eClass.getEStructuralFeatures(), visited);
                this.handleEOperations((List<EOperation>)eClass.getEOperations(), visited);
                this.handleEGenericTypes((EList<EGenericType>)eClass.getEGenericSuperTypes(), visited);
            }
        }
    }

    protected void handleEStructuralFeatures(List<EStructuralFeature> structuralFeatures, Set<EClassifier> visited) {
        if (structuralFeatures != null) {
            for (EStructuralFeature structuralFeature : structuralFeatures) {
                this.handleEGenericType(structuralFeature.getEGenericType(), visited);
            }
        }
    }

    protected void handleEOperations(List<EOperation> operations, Set<EClassifier> visited) {
        if (operations != null) {
            for (EOperation operation : operations) {
                this.handleEGenericType(operation.getEGenericType(), visited);
                this.handleETypeParameters((EList<ETypeParameter>)operation.getETypeParameters(), visited);
                this.handleEParameters((List<EParameter>)operation.getEParameters(), visited);
                this.handleEGenericTypes((EList<EGenericType>)operation.getEGenericExceptions(), visited);
            }
        }
    }

    protected void handleEParameters(List<EParameter> parameters, Set<EClassifier> visited) {
        if (parameters != null) {
            for (EParameter parameter : parameters) {
                this.handleEClassifier(parameter.getEType(), visited);
                this.handleEGenericType(parameter.getEGenericType(), visited);
            }
        }
    }

    protected void handleEGenericTypes(EList<EGenericType> genericTypes, Set<EClassifier> visited) {
        if (genericTypes != null) {
            for (EGenericType genericType : genericTypes) {
                this.handleEGenericType(genericType, visited);
            }
        }
    }

    protected void handleEGenericType(EGenericType genericType, Set<EClassifier> visited) {
        if (genericType != null) {
            this.handleEClassifier(genericType.getEClassifier(), visited);
            this.handleEClassifier(genericType.getERawType(), visited);
            this.handleEGenericType(genericType.getELowerBound(), visited);
            this.handleEGenericType(genericType.getEUpperBound(), visited);
            this.handleEGenericTypes((EList<EGenericType>)genericType.getETypeArguments(), visited);
            this.handleETypeParameter(genericType.getETypeParameter(), visited);
        }
    }

    protected void handleETypeParameters(EList<ETypeParameter> typeParameters, Set<EClassifier> visited) {
        if (typeParameters != null) {
            for (ETypeParameter typeParameter : typeParameters) {
                this.handleETypeParameter(typeParameter, visited);
            }
        }
    }

    protected void handleETypeParameter(ETypeParameter typeParameter, Set<EClassifier> visited) {
        if (typeParameter != null) {
            this.handleEGenericTypes((EList<EGenericType>)typeParameter.getEBounds(), visited);
        }
    }
}

