/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.internal.cdo.session;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.cdo.CDOObject;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.id.CDOIDAndVersion;
import org.eclipse.emf.cdo.common.id.CDOIDLibraryDescriptor;
import org.eclipse.emf.cdo.common.id.CDOIDObject;
import org.eclipse.emf.cdo.common.id.CDOIDObjectFactory;
import org.eclipse.emf.cdo.common.id.CDOIDUtil;
import org.eclipse.emf.cdo.common.io.CDODataInput;
import org.eclipse.emf.cdo.common.model.CDOPackageUnit;
import org.eclipse.emf.cdo.common.model.EMFUtil;
import org.eclipse.emf.cdo.common.protocol.CDOAuthenticator;
import org.eclipse.emf.cdo.common.revision.CDORevision;
import org.eclipse.emf.cdo.common.revision.CDORevisionFactory;
import org.eclipse.emf.cdo.common.revision.CDORevisionUtil;
import org.eclipse.emf.cdo.common.revision.delta.CDORevisionDelta;
import org.eclipse.emf.cdo.common.util.CDOException;
import org.eclipse.emf.cdo.eresource.EresourcePackage;
import org.eclipse.emf.cdo.internal.common.model.CDOPackageRegistryImpl;
import org.eclipse.emf.cdo.session.CDOCollectionLoadingPolicy;
import org.eclipse.emf.cdo.session.CDOSession;
import org.eclipse.emf.cdo.session.CDOSessionInvalidationEvent;
import org.eclipse.emf.cdo.session.remote.CDORemoteSession;
import org.eclipse.emf.cdo.spi.common.model.InternalCDOPackageRegistry;
import org.eclipse.emf.cdo.spi.common.model.InternalCDOPackageUnit;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevision;
import org.eclipse.emf.cdo.transaction.CDOTimeStampContext;
import org.eclipse.emf.cdo.util.CDOUtil;
import org.eclipse.emf.cdo.view.CDOView;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.internal.cdo.CDOFactoryImpl;
import org.eclipse.emf.internal.cdo.bundle.OM;
import org.eclipse.emf.internal.cdo.messages.Messages;
import org.eclipse.emf.internal.cdo.session.CDORevisionManagerImpl;
import org.eclipse.emf.internal.cdo.session.SessionUtil;
import org.eclipse.emf.internal.cdo.session.remote.CDORemoteSessionManagerImpl;
import org.eclipse.emf.internal.cdo.transaction.CDOTransactionImpl;
import org.eclipse.emf.internal.cdo.view.CDOAuditImpl;
import org.eclipse.emf.internal.cdo.view.CDOViewImpl;
import org.eclipse.emf.spi.cdo.AbstractQueryIterator;
import org.eclipse.emf.spi.cdo.CDOSessionProtocol;
import org.eclipse.emf.spi.cdo.InternalCDOObject;
import org.eclipse.emf.spi.cdo.InternalCDORemoteSessionManager;
import org.eclipse.emf.spi.cdo.InternalCDOSession;
import org.eclipse.emf.spi.cdo.InternalCDOTransaction;
import org.eclipse.emf.spi.cdo.InternalCDOView;
import org.eclipse.emf.spi.cdo.InternalCDOViewSet;
import org.eclipse.emf.spi.cdo.InternalCDOXATransaction;
import org.eclipse.net4j.util.ReflectUtil;
import org.eclipse.net4j.util.WrappedException;
import org.eclipse.net4j.util.concurrent.QueueRunner;
import org.eclipse.net4j.util.concurrent.RWLockManager;
import org.eclipse.net4j.util.container.Container;
import org.eclipse.net4j.util.event.Event;
import org.eclipse.net4j.util.event.EventUtil;
import org.eclipse.net4j.util.event.IListener;
import org.eclipse.net4j.util.event.INotifier;
import org.eclipse.net4j.util.io.ExtendedDataInput;
import org.eclipse.net4j.util.io.IOUtil;
import org.eclipse.net4j.util.lifecycle.ILifecycle;
import org.eclipse.net4j.util.lifecycle.Lifecycle;
import org.eclipse.net4j.util.lifecycle.LifecycleEventAdapter;
import org.eclipse.net4j.util.lifecycle.LifecycleUtil;
import org.eclipse.net4j.util.om.log.OMLogger;
import org.eclipse.net4j.util.om.monitor.OMMonitor;
import org.eclipse.net4j.util.om.trace.ContextTracer;
import org.eclipse.net4j.util.options.IOptions;
import org.eclipse.net4j.util.options.IOptionsContainer;
import org.eclipse.net4j.util.options.OptionsEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CDOSessionImpl
extends Container<CDOView>
implements InternalCDOSession {
    private static final ContextTracer TRACER = new ContextTracer(OM.DEBUG_SESSION, CDOSessionImpl.class);
    private CDOSession.ExceptionHandler exceptionHandler;
    private CDOSessionProtocol sessionProtocol;
    @ReflectUtil.ExcludeFromDump
    private IListener sessionProtocolListener = new LifecycleEventAdapter(){

        protected void onDeactivated(ILifecycle lifecycle) {
            CDOSessionImpl.this.deactivate();
        }
    };
    private int sessionID;
    private String userID;
    private CDOSession.Options options;
    private CDOSession.Repository repository;
    private InternalCDOPackageRegistry packageRegistry;
    private CDORevisionManagerImpl revisionManager;
    private CDOAuthenticator authenticator;
    private InternalCDORemoteSessionManager remoteSessionManager;
    private Set<InternalCDOView> views = new HashSet<InternalCDOView>();
    @ReflectUtil.ExcludeFromDump
    private CDOIDObjectFactory cdoidObjectFactory;
    @ReflectUtil.ExcludeFromDump
    private transient QueueRunner invalidationRunner;
    @ReflectUtil.ExcludeFromDump
    private transient Object invalidationRunnerLock = new Object();
    @ReflectUtil.ExcludeFromDump
    private transient int lastViewID;

    public CDOSessionImpl() {
        this.options = this.createOptions();
        this.revisionManager = this.createRevisionManager();
        this.remoteSessionManager = this.createRemoteSessionManager();
    }

    public int getSessionID() {
        return this.sessionID;
    }

    public String getUserID() {
        return this.userID;
    }

    @Override
    public void setUserID(String userID) {
        this.userID = userID;
    }

    @Override
    public CDOSession.ExceptionHandler getExceptionHandler() {
        return this.exceptionHandler;
    }

    @Override
    public void setExceptionHandler(CDOSession.ExceptionHandler exceptionHandler) {
        this.checkInactive();
        this.exceptionHandler = exceptionHandler;
    }

    @Override
    public CDOSession.Options options() {
        return this.options;
    }

    protected CDOSession.Options createOptions() {
        return new OptionsImpl();
    }

    @Override
    public CDOSession.Repository repository() {
        return this.repository;
    }

    protected CDOSession.Repository createRepository(CDOSessionProtocol.OpenSessionResult result) {
        return new RepositoryImpl(this.repository.getName(), result);
    }

    @Override
    public CDOSessionProtocol getSessionProtocol() {
        return this.sessionProtocol;
    }

    public CDOIDObject createCDOIDObject(ExtendedDataInput in) {
        return this.cdoidObjectFactory.createCDOIDObject(in);
    }

    public CDOIDObject createCDOIDObject(String in) {
        return this.cdoidObjectFactory.createCDOIDObject(in);
    }

    public void close() {
        LifecycleUtil.deactivate((Object)this, (OMLogger.Level)OMLogger.Level.DEBUG);
    }

    public boolean isClosed() {
        return !this.isActive();
    }

    @Override
    public void setRepositoryName(String repositoryName) {
        this.repository = new TemporaryRepositoryName(repositoryName);
    }

    @Override
    public void setPackageRegistry(InternalCDOPackageRegistry packageRegistry) {
        this.packageRegistry = packageRegistry;
    }

    @Override
    public InternalCDOPackageRegistry getPackageRegistry() {
        return this.packageRegistry;
    }

    public Object processPackage(Object value) {
        CDOFactoryImpl.prepareDynamicEPackage(value);
        return value;
    }

    public EPackage[] loadPackages(CDOPackageUnit packageUnit) {
        if (packageUnit.getOriginalType().isGenerated() && !this.options().isGeneratedPackageEmulationEnabled()) {
            throw new CDOException(MessageFormat.format(Messages.getString("CDOSessionImpl.0"), packageUnit));
        }
        return this.getSessionProtocol().loadPackages(packageUnit);
    }

    @Override
    public CDORevisionManagerImpl getRevisionManager() {
        return this.revisionManager;
    }

    @Override
    public CDOAuthenticator getAuthenticator() {
        return this.authenticator;
    }

    @Override
    public void setAuthenticator(CDOAuthenticator authenticator) {
        this.authenticator = authenticator;
    }

    @Override
    public InternalCDORemoteSessionManager getRemoteSessionManager() {
        return this.remoteSessionManager;
    }

    @Override
    public InternalCDOTransaction openTransaction(ResourceSet resourceSet) {
        this.checkActive();
        InternalCDOTransaction transaction = this.createTransaction();
        this.initView(transaction, resourceSet);
        return transaction;
    }

    @Override
    public InternalCDOTransaction openTransaction() {
        return this.openTransaction(this.createResourceSet());
    }

    protected InternalCDOTransaction createTransaction() {
        return new CDOTransactionImpl();
    }

    @Override
    public InternalCDOView openView(ResourceSet resourceSet) {
        this.checkActive();
        InternalCDOView view = this.createView();
        this.initView(view, resourceSet);
        return view;
    }

    @Override
    public InternalCDOView openView() {
        return this.openView(this.createResourceSet());
    }

    protected InternalCDOView createView() {
        return new CDOViewImpl();
    }

    @Override
    public CDOAuditImpl openAudit(ResourceSet resourceSet, long timeStamp) {
        this.checkActive();
        CDOAuditImpl audit = this.createAudit(timeStamp);
        this.initView(audit, resourceSet);
        return audit;
    }

    @Override
    public CDOAuditImpl openAudit(long timeStamp) {
        return this.openAudit(this.createResourceSet(), timeStamp);
    }

    protected CDOAuditImpl createAudit(long timeStamp) {
        return new CDOAuditImpl(timeStamp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void viewDetached(InternalCDOView view) {
        view.getViewSet().remove(view);
        Set<InternalCDOView> set = this.views;
        synchronized (set) {
            if (!this.views.remove(view)) {
                return;
            }
        }
        if (this.isActive()) {
            try {
                LifecycleUtil.deactivate((Object)view);
            }
            catch (Exception ex) {
                throw WrappedException.wrap((Exception)ex);
            }
        }
        this.fireElementRemovedEvent(view);
    }

    public CDOView getView(int viewID) {
        this.checkActive();
        InternalCDOView[] internalCDOViewArray = this.getViews();
        int n = internalCDOViewArray.length;
        int n2 = 0;
        while (n2 < n) {
            InternalCDOView view = internalCDOViewArray[n2];
            if (view.getViewID() == viewID) {
                return view;
            }
            ++n2;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InternalCDOView[] getViews() {
        this.checkActive();
        Set<InternalCDOView> set = this.views;
        synchronized (set) {
            return this.views.toArray(new InternalCDOView[this.views.size()]);
        }
    }

    public CDOView[] getElements() {
        return this.getViews();
    }

    public boolean isEmpty() {
        this.checkActive();
        return this.views.isEmpty();
    }

    @Override
    public void handleSyncResponse(long timestamp, Collection<CDOPackageUnit> newPackageUnits, Set<CDOIDAndVersion> dirtyOIDs, Collection<CDOID> detachedObjects) {
        this.handleCommitNotification(timestamp, newPackageUnits, dirtyOIDs, detachedObjects, null, null, true, false);
    }

    @Override
    public void handleCommitNotification(long timeStamp, Collection<CDOPackageUnit> newPackageUnits, Set<CDOIDAndVersion> dirtyOIDs, Collection<CDOID> detachedObjects, Collection<CDORevisionDelta> deltas, InternalCDOView excludedView) {
        this.handleCommitNotification(timeStamp, newPackageUnits, dirtyOIDs, detachedObjects, deltas, excludedView, this.options().isPassiveUpdateEnabled(), true);
    }

    private void handleCommitNotification(final long timeStamp, Collection<CDOPackageUnit> newPackageUnits, Set<CDOIDAndVersion> dirtyOIDs, final Collection<CDOID> detachedObjects, final Collection<CDORevisionDelta> deltas, InternalCDOView excludedView, final boolean passiveUpdate, final boolean async) {
        try {
            if (passiveUpdate) {
                this.updateRevisionForRemoteChanges(timeStamp, dirtyOIDs, detachedObjects, excludedView);
            }
            final Set<CDOIDAndVersion> finalDirtyOIDs = Collections.unmodifiableSet(dirtyOIDs);
            final Collection<CDOID> finalDetachedObjects = Collections.unmodifiableCollection(detachedObjects);
            final boolean skipChangeSubscription = !(deltas != null && deltas.size() > 0 || detachedObjects != null && detachedObjects.size() > 0);
            InternalCDOView[] internalCDOViewArray = this.getViews();
            int n = internalCDOViewArray.length;
            int n2 = 0;
            while (n2 < n) {
                final InternalCDOView view = internalCDOViewArray[n2];
                if (view != excludedView) {
                    Runnable runnable = new Runnable(){

                        public void run() {
                            try {
                                Set<CDOObject> conflicts = null;
                                if (passiveUpdate) {
                                    conflicts = view.handleInvalidation(timeStamp, finalDirtyOIDs, finalDetachedObjects);
                                }
                                if (!skipChangeSubscription) {
                                    view.handleChangeSubscription(deltas, detachedObjects);
                                }
                                if (conflicts != null) {
                                    ((InternalCDOTransaction)view).handleConflicts(conflicts);
                                }
                            }
                            catch (RuntimeException ex) {
                                if (!async) {
                                    throw ex;
                                }
                                if (CDOSessionImpl.this.isActive()) {
                                    OM.LOG.error((Throwable)ex);
                                }
                                OM.LOG.info(Messages.getString("CDOSessionImpl.1"));
                            }
                        }
                    };
                    if (async) {
                        QueueRunner runner = this.getInvalidationRunner();
                        runner.addWork((Object)runnable);
                    } else {
                        runnable.run();
                    }
                }
                ++n2;
            }
        }
        catch (RuntimeException ex) {
            if (!async) {
                throw ex;
            }
            if (this.isActive()) {
                OM.LOG.error((Throwable)ex);
            }
            OM.LOG.info(Messages.getString("CDOSessionImpl.2"));
        }
        this.fireInvalidationEvent(timeStamp, newPackageUnits, dirtyOIDs, detachedObjects, excludedView);
    }

    @Override
    public void handleUpdateRevision(long timeStamp, Set<CDOIDAndVersion> dirtyOIDs, Collection<CDOID> detachedObjects) {
        this.updateRevisionForRemoteChanges(timeStamp, dirtyOIDs, detachedObjects, null);
    }

    private void updateRevisionForRemoteChanges(long timeStamp, Set<CDOIDAndVersion> dirtyOIDs, Collection<CDOID> detachedObjects, InternalCDOView excludedView) {
        if (excludedView == null || timeStamp == 0L) {
            for (CDOIDAndVersion dirtyOID : dirtyOIDs) {
                CDOID id = dirtyOID.getID();
                int version = dirtyOID.getVersion();
                this.revisionManager.revisedRevisionByVersion(id, version, timeStamp);
            }
        }
        for (CDOID id : detachedObjects) {
            this.revisionManager.revisedRevision(id, timeStamp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private QueueRunner getInvalidationRunner() {
        Object object = this.invalidationRunnerLock;
        synchronized (object) {
            if (this.invalidationRunner == null) {
                this.invalidationRunner = new QueueRunner();
                this.invalidationRunner.activate();
            }
        }
        return this.invalidationRunner;
    }

    public void fireInvalidationEvent(long timeStamp, Collection<CDOPackageUnit> packageUnits, Set<CDOIDAndVersion> dirtyOIDs, Collection<CDOID> detachedObjects, InternalCDOView excludedView) {
        this.fireEvent(new InvalidationEvent(excludedView, timeStamp, packageUnits, dirtyOIDs, detachedObjects));
    }

    public String toString() {
        return MessageFormat.format("CDOSession[{0}, {1}]", this.repository().getName(), this.sessionID);
    }

    protected InternalCDOPackageRegistry createPackageRegistry() {
        return new CDOPackageRegistryImpl();
    }

    protected CDORevisionManagerImpl createRevisionManager() {
        return new CDORevisionManagerImpl(this);
    }

    protected InternalCDORemoteSessionManager createRemoteSessionManager() {
        return new CDORemoteSessionManagerImpl(this);
    }

    protected ResourceSet createResourceSet() {
        return new ResourceSetImpl();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initView(InternalCDOView view, ResourceSet resourceSet) {
        InternalCDOViewSet viewSet = SessionUtil.prepareResourceSet(resourceSet);
        Set<InternalCDOView> set = this.views;
        synchronized (set) {
            view.setSession(this);
            view.setViewID(++this.lastViewID);
            this.views.add(view);
        }
        view.setViewSet(viewSet);
        viewSet.add(view);
        try {
            view.activate();
            this.fireElementAddedEvent(view);
        }
        catch (RuntimeException ex) {
            Set<InternalCDOView> set2 = this.views;
            synchronized (set2) {
                this.views.remove(view);
            }
            viewSet.remove(view);
            throw ex;
        }
    }

    protected void doBeforeActivate() throws Exception {
        super.doBeforeActivate();
        this.checkState(this.repository().getName(), "repository().getName()");
    }

    protected void doActivate() throws Exception {
        super.doActivate();
        this.sessionProtocol = this.createSessionProtocol();
        if (this.exceptionHandler != null) {
            this.sessionProtocol = new DelegatingSessionProtocol(this.sessionProtocol);
        }
        EventUtil.addListener((Object)this.sessionProtocol, (IListener)this.sessionProtocolListener);
        this.revisionManager.activate();
        this.remoteSessionManager.activate();
        if (this.packageRegistry == null) {
            this.packageRegistry = this.createPackageRegistry();
        }
        this.packageRegistry.setPackageProcessor((InternalCDOPackageRegistry.PackageProcessor)this);
        this.packageRegistry.setPackageLoader((InternalCDOPackageRegistry.PackageLoader)this);
        this.packageRegistry.activate();
        String name = this.repository().getName();
        boolean passiveUpdateEnabled = this.options().isPassiveUpdateEnabled();
        CDOSessionProtocol.OpenSessionResult result = this.getSessionProtocol().openSession(name, passiveUpdateEnabled);
        this.sessionID = result.getSessionID();
        this.repository = this.createRepository(result);
        this.handleLibraryDescriptor(result.getLibraryDescriptor());
        for (InternalCDOPackageUnit packageUnit : result.getPackageUnits()) {
            if (EcorePackage.eINSTANCE.getNsURI().equals(packageUnit.getID())) {
                EMFUtil.addAdapter((Notifier)EcorePackage.eINSTANCE, (Adapter)packageUnit.getTopLevelPackageInfo());
                packageUnit.setState(CDOPackageUnit.State.LOADED);
            } else if (EresourcePackage.eINSTANCE.getNsURI().equals(packageUnit.getID())) {
                EMFUtil.addAdapter((Notifier)EresourcePackage.eINSTANCE, (Adapter)packageUnit.getTopLevelPackageInfo());
                packageUnit.setState(CDOPackageUnit.State.LOADED);
            }
            this.packageRegistry.putPackageUnit(packageUnit);
        }
    }

    protected abstract CDOSessionProtocol createSessionProtocol();

    protected void doDeactivate() throws Exception {
        InternalCDOView[] internalCDOViewArray = this.views.toArray(new InternalCDOView[this.views.size()]);
        int n = internalCDOViewArray.length;
        int n2 = 0;
        while (n2 < n) {
            InternalCDOView view = internalCDOViewArray[n2];
            try {
                view.close();
            }
            catch (RuntimeException runtimeException) {}
            ++n2;
        }
        this.views.clear();
        this.views = null;
        if (this.invalidationRunner != null) {
            LifecycleUtil.deactivate((Object)this.invalidationRunner, (OMLogger.Level)OMLogger.Level.WARN);
            this.invalidationRunner = null;
        }
        this.revisionManager.deactivate();
        this.revisionManager = null;
        this.packageRegistry.deactivate();
        this.packageRegistry = null;
        EventUtil.removeListener((Object)this.sessionProtocol, (IListener)this.sessionProtocolListener);
        LifecycleUtil.deactivate((Object)this.sessionProtocol);
        this.sessionProtocol = null;
        super.doDeactivate();
    }

    private void handleLibraryDescriptor(CDOIDLibraryDescriptor libraryDescriptor) throws Exception {
        String factoryName = libraryDescriptor.getFactoryName();
        if (TRACER.isEnabled()) {
            TRACER.format("Using CDOID factory: {0}", new Object[]{factoryName});
        }
        File cacheFolder = this.getCacheFolder();
        ClassLoader classLoader = OM.class.getClassLoader();
        Set<String> neededLibraries = this.createSet(libraryDescriptor.getLibraryNames());
        if (!neededLibraries.isEmpty()) {
            IOUtil.mkdirs((File)cacheFolder);
            Set<String> existingLibraries = this.createSet(cacheFolder.list());
            HashSet<String> missingLibraries = new HashSet<String>(neededLibraries);
            missingLibraries.removeAll(existingLibraries);
            if (!missingLibraries.isEmpty()) {
                this.getSessionProtocol().loadLibraries(missingLibraries, cacheFolder);
            }
        }
        int i = 0;
        URL[] urls = new URL[neededLibraries.size()];
        for (String neededLibrary : neededLibraries) {
            File lib = new File(cacheFolder, neededLibrary);
            if (TRACER.isEnabled()) {
                TRACER.format("Using CDOID library: {0}", new Object[]{lib.getAbsolutePath()});
            }
            urls[i++] = new URL("file:///" + lib.getAbsolutePath());
        }
        classLoader = new URLClassLoader(urls, classLoader);
        Class<?> factoryClass = classLoader.loadClass(factoryName);
        this.cdoidObjectFactory = (CDOIDObjectFactory)factoryClass.newInstance();
    }

    private File getCacheFolder() {
        String stateLocation = OM.BUNDLE.getStateLocation();
        File repos = new File(stateLocation, "repos");
        return new File(repos, this.repository().getUUID());
    }

    private Set<String> createSet(String[] fileNames) {
        HashSet<String> set = new HashSet<String>();
        String[] stringArray = fileNames;
        int n = fileNames.length;
        int n2 = 0;
        while (n2 < n) {
            String fileName = stringArray[n2];
            if (fileName.endsWith(".jar")) {
                set.add(fileName);
            }
            ++n2;
        }
        return set;
    }

    private Map<CDOID, CDOIDAndVersion> getAllCDOIDAndVersion() {
        HashMap<CDOID, CDOIDAndVersion> uniqueObjects = new HashMap<CDOID, CDOIDAndVersion>();
        InternalCDOView[] internalCDOViewArray = this.getViews();
        int n = internalCDOViewArray.length;
        int n2 = 0;
        while (n2 < n) {
            InternalCDOView view = internalCDOViewArray[n2];
            view.getCDOIDAndVersion(uniqueObjects, Arrays.asList(view.getObjectsArray()));
            ++n2;
        }
        for (CDORevision revision : this.getRevisionManager().getCachedRevisions()) {
            if (uniqueObjects.containsKey(revision.getID())) continue;
            uniqueObjects.put(revision.getID(), CDOIDUtil.createIDAndVersion((CDOID)revision.getID(), (int)revision.getVersion()));
        }
        return uniqueObjects;
    }

    @Override
    public Collection<CDOTimeStampContext> refresh() {
        this.checkActive();
        if (!this.options().isPassiveUpdateEnabled()) {
            Map<CDOID, CDOIDAndVersion> allRevisions = this.getAllCDOIDAndVersion();
            try {
                if (!allRevisions.isEmpty()) {
                    int initialChunkSize = this.options().getCollectionLoadingPolicy().getInitialChunkSize();
                    return this.getSessionProtocol().syncRevisions(allRevisions, initialChunkSize);
                }
            }
            catch (Exception ex) {
                throw WrappedException.wrap((Exception)ex);
            }
        }
        return Collections.emptyList();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class DelegatingSessionProtocol
    extends Lifecycle
    implements CDOSessionProtocol {
        private CDOSessionProtocol delegate;
        @ReflectUtil.ExcludeFromDump
        private IListener delegateListener = new LifecycleEventAdapter(){

            protected void onDeactivated(ILifecycle lifecycle) {
                DelegatingSessionProtocol.this.deactivate();
            }
        };

        public DelegatingSessionProtocol(CDOSessionProtocol delegate) {
            this.delegate = delegate;
            this.activate();
        }

        public CDOSessionProtocol getDelegate() {
            return this.delegate;
        }

        @Override
        public boolean cancelQuery(int queryId) {
            int attempt = 0;
            while (true) {
                try {
                    return this.delegate.cancelQuery(queryId);
                }
                catch (Exception ex) {
                    this.handleException(++attempt, ex);
                    continue;
                }
                break;
            }
        }

        @Override
        public void changeSubscription(int viewId, List<CDOID> cdoIDs, boolean subscribeMode, boolean clear) {
            int attempt = 0;
            while (true) {
                try {
                    this.delegate.changeSubscription(viewId, cdoIDs, subscribeMode, clear);
                    return;
                }
                catch (Exception ex) {
                    this.handleException(++attempt, ex);
                    continue;
                }
                break;
            }
        }

        @Override
        public void closeView(int viewId) {
            int attempt = 0;
            while (true) {
                try {
                    this.delegate.closeView(viewId);
                    return;
                }
                catch (Exception ex) {
                    this.handleException(++attempt, ex);
                    continue;
                }
                break;
            }
        }

        @Override
        public CDOSessionProtocol.CommitTransactionResult commitTransaction(InternalCDOTransaction.InternalCDOCommitContext commitContext, OMMonitor monitor) {
            int attempt = 0;
            while (true) {
                try {
                    return this.delegate.commitTransaction(commitContext, monitor);
                }
                catch (Exception ex) {
                    this.handleException(++attempt, ex);
                    continue;
                }
                break;
            }
        }

        @Override
        public CDOSessionProtocol.CommitTransactionResult commitTransactionCancel(InternalCDOXATransaction.InternalCDOXACommitContext xaContext, OMMonitor monitor) {
            int attempt = 0;
            while (true) {
                try {
                    return this.delegate.commitTransactionCancel(xaContext, monitor);
                }
                catch (Exception ex) {
                    this.handleException(++attempt, ex);
                    continue;
                }
                break;
            }
        }

        @Override
        public CDOSessionProtocol.CommitTransactionResult commitTransactionPhase1(InternalCDOXATransaction.InternalCDOXACommitContext xaContext, OMMonitor monitor) {
            int attempt = 0;
            while (true) {
                try {
                    return this.delegate.commitTransactionPhase1(xaContext, monitor);
                }
                catch (Exception ex) {
                    this.handleException(++attempt, ex);
                    continue;
                }
                break;
            }
        }

        @Override
        public CDOSessionProtocol.CommitTransactionResult commitTransactionPhase2(InternalCDOXATransaction.InternalCDOXACommitContext xaContext, OMMonitor monitor) {
            int attempt = 0;
            while (true) {
                try {
                    return this.delegate.commitTransactionPhase2(xaContext, monitor);
                }
                catch (Exception ex) {
                    this.handleException(++attempt, ex);
                    continue;
                }
                break;
            }
        }

        @Override
        public CDOSessionProtocol.CommitTransactionResult commitTransactionPhase3(InternalCDOXATransaction.InternalCDOXACommitContext xaContext, OMMonitor monitor) {
            int attempt = 0;
            while (true) {
                try {
                    return this.delegate.commitTransactionPhase3(xaContext, monitor);
                }
                catch (Exception ex) {
                    this.handleException(++attempt, ex);
                    continue;
                }
                break;
            }
        }

        @Override
        public List<CDORemoteSession> getRemoteSessions(InternalCDORemoteSessionManager manager, boolean subscribe) {
            int attempt = 0;
            while (true) {
                try {
                    return this.delegate.getRemoteSessions(manager, subscribe);
                }
                catch (Exception ex) {
                    this.handleException(++attempt, ex);
                    continue;
                }
                break;
            }
        }

        @Override
        public CDOSessionProtocol.RepositoryTimeResult getRepositoryTime() {
            int attempt = 0;
            while (true) {
                try {
                    return this.delegate.getRepositoryTime();
                }
                catch (Exception ex) {
                    this.handleException(++attempt, ex);
                    continue;
                }
                break;
            }
        }

        @Override
        public boolean isObjectLocked(CDOView view, CDOObject object, RWLockManager.LockType lockType, boolean byOthers) {
            int attempt = 0;
            while (true) {
                try {
                    return this.delegate.isObjectLocked(view, object, lockType, byOthers);
                }
                catch (Exception ex) {
                    this.handleException(++attempt, ex);
                    continue;
                }
                break;
            }
        }

        @Override
        public Object loadChunk(InternalCDORevision revision, EStructuralFeature feature, int accessIndex, int fetchIndex, int fromIndex, int toIndex) {
            int attempt = 0;
            while (true) {
                try {
                    return this.delegate.loadChunk(revision, feature, accessIndex, fetchIndex, fromIndex, toIndex);
                }
                catch (Exception ex) {
                    this.handleException(++attempt, ex);
                    continue;
                }
                break;
            }
        }

        @Override
        public void loadLibraries(Set<String> missingLibraries, File cacheFolder) {
            int attempt = 0;
            while (true) {
                try {
                    this.delegate.loadLibraries(missingLibraries, cacheFolder);
                    return;
                }
                catch (Exception ex) {
                    this.handleException(++attempt, ex);
                    continue;
                }
                break;
            }
        }

        public EPackage[] loadPackages(CDOPackageUnit packageUnit) {
            int attempt = 0;
            while (true) {
                try {
                    return this.delegate.loadPackages(packageUnit);
                }
                catch (Exception ex) {
                    this.handleException(++attempt, ex);
                    continue;
                }
                break;
            }
        }

        @Override
        public InternalCDORevision loadRevisionByVersion(CDOID id, int referenceChunk, int version) {
            int attempt = 0;
            while (true) {
                try {
                    return this.delegate.loadRevisionByVersion(id, referenceChunk, version);
                }
                catch (Exception ex) {
                    this.handleException(++attempt, ex);
                    continue;
                }
                break;
            }
        }

        @Override
        public List<InternalCDORevision> loadRevisions(Collection<CDOID> ids, int referenceChunk) {
            int attempt = 0;
            while (true) {
                try {
                    return this.delegate.loadRevisions(ids, referenceChunk);
                }
                catch (Exception ex) {
                    this.handleException(++attempt, ex);
                    continue;
                }
                break;
            }
        }

        @Override
        public List<InternalCDORevision> loadRevisionsByTime(Collection<CDOID> ids, int referenceChunk, long timeStamp) {
            int attempt = 0;
            while (true) {
                try {
                    return this.delegate.loadRevisionsByTime(ids, referenceChunk, timeStamp);
                }
                catch (Exception ex) {
                    this.handleException(++attempt, ex);
                    continue;
                }
                break;
            }
        }

        @Override
        public void lockObjects(CDOView view, Map<CDOID, CDOIDAndVersion> objects, long timeout, RWLockManager.LockType lockType) throws InterruptedException {
            int attempt = 0;
            while (true) {
                try {
                    this.delegate.lockObjects(view, objects, timeout, lockType);
                    return;
                }
                catch (Exception ex) {
                    this.handleException(++attempt, ex);
                    continue;
                }
                break;
            }
        }

        @Override
        public CDOSessionProtocol.OpenSessionResult openSession(String repositoryName, boolean passiveUpdateEnabled) {
            int attempt = 0;
            while (true) {
                try {
                    return this.delegate.openSession(repositoryName, passiveUpdateEnabled);
                }
                catch (Exception ex) {
                    this.handleException(++attempt, ex);
                    continue;
                }
                break;
            }
        }

        @Override
        public void openView(int viewId, byte protocolViewType, long timeStamp) {
            int attempt = 0;
            while (true) {
                try {
                    this.delegate.openView(viewId, protocolViewType, timeStamp);
                    return;
                }
                catch (Exception ex) {
                    this.handleException(++attempt, ex);
                    continue;
                }
                break;
            }
        }

        @Override
        public List<Object> query(int viewID, AbstractQueryIterator<?> queryResult) {
            int attempt = 0;
            while (true) {
                try {
                    return this.delegate.query(viewID, queryResult);
                }
                catch (Exception ex) {
                    this.handleException(++attempt, ex);
                    continue;
                }
                break;
            }
        }

        @Override
        public boolean[] setAudit(int viewId, long timeStamp, List<InternalCDOObject> invalidObjects) {
            int attempt = 0;
            while (true) {
                try {
                    return this.delegate.setAudit(viewId, timeStamp, invalidObjects);
                }
                catch (Exception ex) {
                    this.handleException(++attempt, ex);
                    continue;
                }
                break;
            }
        }

        @Override
        public void setPassiveUpdate(Map<CDOID, CDOIDAndVersion> idAndVersions, int initialChunkSize, boolean passiveUpdateEnabled) {
            int attempt = 0;
            while (true) {
                try {
                    this.delegate.setPassiveUpdate(idAndVersions, initialChunkSize, passiveUpdateEnabled);
                    return;
                }
                catch (Exception ex) {
                    this.handleException(++attempt, ex);
                    continue;
                }
                break;
            }
        }

        @Override
        public Collection<CDOTimeStampContext> syncRevisions(Map<CDOID, CDOIDAndVersion> allRevisions, int initialChunkSize) {
            int attempt = 0;
            while (true) {
                try {
                    return this.delegate.syncRevisions(allRevisions, initialChunkSize);
                }
                catch (Exception ex) {
                    this.handleException(++attempt, ex);
                    continue;
                }
                break;
            }
        }

        @Override
        public void unlockObjects(CDOView view, Collection<? extends CDOObject> objects, RWLockManager.LockType lockType) {
            int attempt = 0;
            while (true) {
                try {
                    this.delegate.unlockObjects(view, objects, lockType);
                    return;
                }
                catch (Exception ex) {
                    this.handleException(++attempt, ex);
                    continue;
                }
                break;
            }
        }

        @Override
        public void unsubscribeRemoteSessions() {
            int attempt = 0;
            while (true) {
                try {
                    this.delegate.unsubscribeRemoteSessions();
                    return;
                }
                catch (Exception ex) {
                    this.handleException(++attempt, ex);
                    continue;
                }
                break;
            }
        }

        @Override
        public List<InternalCDORevision> verifyRevision(List<InternalCDORevision> revisions) {
            int attempt = 0;
            while (true) {
                try {
                    return this.delegate.verifyRevision(revisions);
                }
                catch (Exception ex) {
                    this.handleException(++attempt, ex);
                    continue;
                }
                break;
            }
        }

        protected void doActivate() throws Exception {
            super.doActivate();
            EventUtil.addListener((Object)this.delegate, (IListener)this.delegateListener);
        }

        protected void doDeactivate() throws Exception {
            EventUtil.removeListener((Object)this.delegate, (IListener)this.delegateListener);
            LifecycleUtil.deactivate((Object)this.delegate);
            this.delegate = null;
            super.doDeactivate();
        }

        private void handleException(int attempt, Exception exception) {
            try {
                CDOSessionImpl.this.getExceptionHandler().handleException(CDOSessionImpl.this, attempt, exception);
            }
            catch (Exception ex) {
                throw WrappedException.wrap((Exception)ex);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class InvalidationEvent
    extends Event
    implements CDOSessionInvalidationEvent {
        private static final long serialVersionUID = 1L;
        private InternalCDOView view;
        private long timeStamp;
        private Set<CDOIDAndVersion> dirtyOIDs;
        private Collection<CDOID> detachedObjects;
        private Collection<CDOPackageUnit> newPackageUnits;

        public InvalidationEvent(InternalCDOView view, long timeStamp, Collection<CDOPackageUnit> packageUnits, Set<CDOIDAndVersion> dirtyOIDs, Collection<CDOID> detachedObjects) {
            super((INotifier)CDOSessionImpl.this);
            this.view = view;
            this.timeStamp = timeStamp;
            this.newPackageUnits = packageUnits;
            this.dirtyOIDs = dirtyOIDs;
            this.detachedObjects = detachedObjects;
        }

        @Override
        public CDOSession getSession() {
            return (CDOSession)this.getSource();
        }

        @Override
        public InternalCDOView getView() {
            return this.view;
        }

        @Override
        public long getTimeStamp() {
            return this.timeStamp;
        }

        @Override
        public Set<CDOIDAndVersion> getDirtyOIDs() {
            return this.dirtyOIDs;
        }

        @Override
        public Collection<CDOID> getDetachedObjects() {
            return this.detachedObjects;
        }

        @Override
        public Collection<CDOPackageUnit> getNewPackageUnits() {
            return this.newPackageUnits;
        }

        public String toString() {
            return "CDOSessionInvalidationEvent: " + this.dirtyOIDs;
        }
    }

    protected class OptionsImpl
    extends org.eclipse.net4j.util.event.Notifier
    implements CDOSession.Options {
        private boolean generatedPackageEmulationEnabled = false;
        private boolean passiveUpdateEnabled = true;
        private CDOCollectionLoadingPolicy collectionLoadingPolicy;
        private CDORevisionFactory revisionFactory;

        public OptionsImpl() {
            int value = (Integer)OM.PREF_COLLECTION_LOADING_CHUNK_SIZE.getValue();
            this.collectionLoadingPolicy = CDOUtil.createCollectionLoadingPolicy(value, value);
        }

        public IOptionsContainer getContainer() {
            return CDOSessionImpl.this;
        }

        public boolean isGeneratedPackageEmulationEnabled() {
            return this.generatedPackageEmulationEnabled;
        }

        public synchronized void setGeneratedPackageEmulationEnabled(boolean generatedPackageEmulationEnabled) {
            this.generatedPackageEmulationEnabled = generatedPackageEmulationEnabled;
            if (this.generatedPackageEmulationEnabled != generatedPackageEmulationEnabled) {
                this.generatedPackageEmulationEnabled = generatedPackageEmulationEnabled;
                this.fireEvent(new GeneratedPackageEmulationEventImpl());
            }
        }

        public boolean isPassiveUpdateEnabled() {
            return this.passiveUpdateEnabled;
        }

        public synchronized void setPassiveUpdateEnabled(boolean passiveUpdateEnabled) {
            if (this.passiveUpdateEnabled != passiveUpdateEnabled) {
                this.passiveUpdateEnabled = passiveUpdateEnabled;
                Map allRevisions = CDOSessionImpl.this.getAllCDOIDAndVersion();
                if (!allRevisions.isEmpty()) {
                    int initialChunkSize = this.collectionLoadingPolicy.getInitialChunkSize();
                    CDOSessionImpl.this.getSessionProtocol().setPassiveUpdate(allRevisions, initialChunkSize, passiveUpdateEnabled);
                }
                this.fireEvent(new PassiveUpdateEventImpl());
            }
        }

        public CDOCollectionLoadingPolicy getCollectionLoadingPolicy() {
            return this.collectionLoadingPolicy;
        }

        public synchronized void setCollectionLoadingPolicy(CDOCollectionLoadingPolicy policy) {
            if (policy == null) {
                policy = CDOCollectionLoadingPolicy.DEFAULT;
            }
            if (this.collectionLoadingPolicy != policy) {
                this.collectionLoadingPolicy = policy;
                this.fireEvent(new CollectionLoadingPolicyEventImpl());
            }
        }

        public synchronized CDORevisionFactory getRevisionFactory() {
            if (this.revisionFactory == null) {
                this.revisionFactory = new CDORevisionFactory(){

                    public CDORevision createRevision(EClass eClass, CDOID id) {
                        return CDORevisionUtil.createRevision((EClass)eClass, (CDOID)id);
                    }

                    public CDORevision createRevision(CDODataInput in) throws IOException {
                        return in.readCDORevision();
                    }

                    public String toString() {
                        return "DefaultRevisionFactory";
                    }
                };
            }
            return this.revisionFactory;
        }

        public synchronized void setRevisionFactory(CDORevisionFactory revisionFactory) {
            if (this.revisionFactory != revisionFactory) {
                this.revisionFactory = revisionFactory;
                this.fireEvent(new RevisionFactoryEventImpl());
            }
        }

        private final class CollectionLoadingPolicyEventImpl
        extends OptionsEvent
        implements CDOSession.Options.CollectionLoadingPolicyEvent {
            private static final long serialVersionUID = 1L;

            public CollectionLoadingPolicyEventImpl() {
                super((IOptions)OptionsImpl.this);
            }
        }

        private final class GeneratedPackageEmulationEventImpl
        extends OptionsEvent
        implements CDOSession.Options.GeneratedPackageEmulationEvent {
            private static final long serialVersionUID = 1L;

            public GeneratedPackageEmulationEventImpl() {
                super((IOptions)OptionsImpl.this);
            }
        }

        private final class PassiveUpdateEventImpl
        extends OptionsEvent
        implements CDOSession.Options.PassiveUpdateEvent {
            private static final long serialVersionUID = 1L;

            public PassiveUpdateEventImpl() {
                super((IOptions)OptionsImpl.this);
            }
        }

        private final class RevisionFactoryEventImpl
        extends OptionsEvent
        implements CDOSession.Options.RevisionFactoryEvent {
            private static final long serialVersionUID = 1L;

            public RevisionFactoryEventImpl() {
                super((IOptions)OptionsImpl.this);
            }
        }
    }

    protected class RepositoryImpl
    implements CDOSession.Repository {
        private String name;
        private String uuid;
        private long creationTime;
        private CDOSessionProtocol.RepositoryTimeResult timeResult;
        private boolean supportingAudits;

        public RepositoryImpl(String name, CDOSessionProtocol.OpenSessionResult result) {
            this.name = name;
            this.uuid = result.getRepositoryUUID();
            this.creationTime = result.getRepositoryCreationTime();
            this.timeResult = result.getRepositoryTimeResult();
            this.supportingAudits = result.isRepositorySupportingAudits();
        }

        public String getName() {
            return this.name;
        }

        public String getUUID() {
            return this.uuid;
        }

        public long getCreationTime() {
            CDOSessionImpl.this.checkActive();
            return this.creationTime;
        }

        public long getCurrentTime() {
            return this.getCurrentTime(false);
        }

        public long getCurrentTime(boolean forceRefresh) {
            CDOSessionImpl.this.checkActive();
            if (this.timeResult == null || forceRefresh) {
                this.timeResult = this.refreshTime();
            }
            return this.timeResult.getAproximateRepositoryTime();
        }

        public boolean isSupportingAudits() {
            return this.supportingAudits;
        }

        private CDOSessionProtocol.RepositoryTimeResult refreshTime() {
            return CDOSessionImpl.this.getSessionProtocol().getRepositoryTime();
        }
    }

    private static final class TemporaryRepositoryName
    implements CDOSession.Repository {
        private String name;

        public TemporaryRepositoryName(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public long getCreationTime() {
            throw new UnsupportedOperationException();
        }

        public long getCurrentTime() {
            throw new UnsupportedOperationException();
        }

        public long getCurrentTime(boolean forceRefresh) {
            throw new UnsupportedOperationException();
        }

        public String getUUID() {
            throw new UnsupportedOperationException();
        }

        public boolean isSupportingAudits() {
            throw new UnsupportedOperationException();
        }
    }
}

