/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.internal.cdo;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import org.eclipse.emf.cdo.CDOState;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.model.CDOModelUtil;
import org.eclipse.emf.cdo.common.model.CDOPackageRegistry;
import org.eclipse.emf.cdo.common.revision.CDORevision;
import org.eclipse.emf.cdo.eresource.CDOResource;
import org.eclipse.emf.cdo.spi.common.model.InternalCDOPackageRegistry;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevision;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.impl.NotifyingListImpl;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.emf.internal.cdo.CDOObjectImpl;
import org.eclipse.emf.internal.cdo.CDOObjectWrapper;
import org.eclipse.emf.internal.cdo.CDOStateMachine;
import org.eclipse.emf.internal.cdo.bundle.OM;
import org.eclipse.emf.internal.cdo.util.FSMUtil;
import org.eclipse.emf.spi.cdo.InternalCDOObject;
import org.eclipse.emf.spi.cdo.InternalCDOView;
import org.eclipse.net4j.util.ImplementationError;
import org.eclipse.net4j.util.ReflectUtil;
import org.eclipse.net4j.util.om.trace.ContextTracer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CDOLegacyWrapper
extends CDOObjectWrapper {
    private static final ContextTracer TRACER = new ContextTracer(OM.DEBUG_OBJECT, CDOLegacyWrapper.class);
    protected CDOState state;
    protected InternalCDORevision revision;

    public CDOLegacyWrapper(InternalEObject instance) {
        this.instance = instance;
        this.state = CDOState.TRANSIENT;
    }

    @Override
    public CDOState cdoState() {
        return this.state;
    }

    @Override
    public InternalCDORevision cdoRevision() {
        return this.revision;
    }

    @Override
    public void cdoReload() {
        CDOStateMachine.INSTANCE.reload(this);
    }

    @Override
    public CDOState cdoInternalSetState(CDOState state) {
        if (this.state != state) {
            if (TRACER.isEnabled()) {
                TRACER.format("Setting state {0} for {1}", new Object[]{state, this});
            }
            CDOState tmp = this.state;
            this.state = state;
            this.adjustEProxy();
            return tmp;
        }
        return null;
    }

    @Override
    public void cdoInternalSetRevision(CDORevision revision) {
        if (TRACER.isEnabled()) {
            TRACER.format("Setting revision: {0}", new Object[]{revision});
        }
        this.revision = (InternalCDORevision)revision;
    }

    @Override
    public void cdoInternalPostAttach() {
        this.instanceToRevision();
        for (Adapter adapter : this.eAdapters()) {
            this.view.subscribe(this, adapter);
        }
    }

    @Override
    public void cdoInternalPostDetach(boolean remote) {
    }

    @Override
    public void cdoInternalPreCommit() {
    }

    @Override
    public void cdoInternalPreLoad() {
    }

    @Override
    public void cdoInternalPostLoad() {
        this.revisionToInstance();
    }

    @Override
    public void cdoInternalPostInvalidate() {
    }

    @Override
    public void cdoInternalCleanup() {
    }

    public boolean equals(Object obj) {
        return obj == this || obj == this.instance;
    }

    public int hashCode() {
        if (this.instance != null) {
            return this.instance.hashCode();
        }
        return super.hashCode();
    }

    public String toString() {
        return "CDOLegacyWrapper[" + this.id + "]";
    }

    protected void instanceToRevision() {
        if (TRACER.isEnabled()) {
            TRACER.format("Transfering instance to revision: {0} --> {1}", new Object[]{this.instance, this.revision});
        }
        this.instanceToRevisionContainment();
        InternalCDOPackageRegistry packageRegistry = this.cdoView().getSession().getPackageRegistry();
        EClass eClass = this.revision.getEClass();
        EStructuralFeature[] eStructuralFeatureArray = CDOModelUtil.getAllPersistentFeatures((EClass)eClass);
        int n = eStructuralFeatureArray.length;
        int n2 = 0;
        while (n2 < n) {
            EStructuralFeature feature = eStructuralFeatureArray[n2];
            this.instanceToRevisionFeature(feature, (CDOPackageRegistry)packageRegistry);
            ++n2;
        }
    }

    protected void instanceToRevisionContainment() {
        CDOResource resource = (CDOResource)this.getInstanceResource(this.instance);
        this.revision.setResourceID(resource == null ? CDOID.NULL : resource.cdoID());
        InternalEObject eContainer = this.getInstanceContainer(this.instance);
        if (eContainer == null) {
            this.revision.setContainerID((Object)CDOID.NULL);
            this.revision.setContainingFeatureID(0);
        } else {
            InternalCDOObject cdoContainer = FSMUtil.adapt(eContainer, this.view);
            this.revision.setContainerID((Object)cdoContainer.cdoID());
            this.revision.setContainingFeatureID(this.getInstanceContainerFeatureID(this.instance));
        }
    }

    protected void instanceToRevisionFeature(EStructuralFeature feature, CDOPackageRegistry packageRegistry) {
        Object instanceValue = this.getInstanceValue(this.instance, feature, packageRegistry);
        CDOObjectImpl.instanceToRevisionFeature(this.view, this.revision, feature, instanceValue);
    }

    protected void revisionToInstance() {
        boolean deliver;
        if (TRACER.isEnabled()) {
            TRACER.format("Transfering revision to instance: {0} --> {1}", new Object[]{this.revision, this.instance});
        }
        if (deliver = this.instance.eDeliver()) {
            this.instance.eSetDeliver(false);
        }
        try {
            this.revisionToInstanceContainment();
            InternalCDOPackageRegistry packageRegistry = this.cdoView().getSession().getPackageRegistry();
            EClass eClass = this.revision.getEClass();
            EStructuralFeature[] eStructuralFeatureArray = CDOModelUtil.getAllPersistentFeatures((EClass)eClass);
            int n = eStructuralFeatureArray.length;
            int n2 = 0;
            while (n2 < n) {
                EStructuralFeature feature = eStructuralFeatureArray[n2];
                this.revisionToInstanceFeature(feature, (CDOPackageRegistry)packageRegistry);
                ++n2;
            }
        }
        finally {
            if (deliver) {
                this.instance.eSetDeliver(true);
            }
        }
    }

    protected void revisionToInstanceContainment() {
        CDOID resourceID = this.revision.getResourceID();
        InternalEObject resource = this.getEObjectFromPotentialID(this.view, null, resourceID);
        this.setInstanceResource((Resource.Internal)resource);
        Object containerID = this.revision.getContainerID();
        InternalEObject container = this.getEObjectFromPotentialID(this.view, null, containerID);
        this.setInstanceContainer(container, this.revision.getContainingFeatureID());
    }

    protected void revisionToInstanceFeature(EStructuralFeature feature, CDOPackageRegistry packageRegistry) {
        Object value = this.revision.getValue(feature);
        this.view.getStore().set(this.instance, feature, -1, value);
    }

    protected Resource.Internal getInstanceResource(InternalEObject instance) {
        return instance.eDirectResource();
    }

    protected InternalEObject getInstanceContainer(InternalEObject instance) {
        return instance.eInternalContainer();
    }

    protected int getInstanceContainerFeatureID(InternalEObject instance) {
        return instance.eContainerFeatureID();
    }

    protected Object getInstanceValue(InternalEObject instance, EStructuralFeature feature, CDOPackageRegistry packageRegistry) {
        return instance.eGet(feature);
    }

    protected void setInstanceResource(Resource.Internal resource) {
        Method method = ReflectUtil.getMethod(this.instance.getClass(), (String)"eSetDirectResource", (Class[])new Class[]{Resource.Internal.class});
        ReflectUtil.invokeMethod((Method)method, (Object)this.instance, (Object[])new Object[]{resource});
    }

    protected void setInstanceContainer(InternalEObject container, int containerFeatureID) {
        Method method = ReflectUtil.getMethod(this.instance.getClass(), (String)"eBasicSetContainer", (Class[])new Class[]{InternalEObject.class, Integer.TYPE});
        ReflectUtil.invokeMethod((Method)method, (Object)this.instance, (Object[])new Object[]{container, containerFeatureID});
    }

    protected void setInstanceValue(InternalEObject instance, EStructuralFeature feature, Object value) {
        instance.eSet(feature, value);
    }

    protected InternalEObject getEObjectFromPotentialID(InternalCDOView view, EStructuralFeature feature, Object potentialID) {
        if (potentialID instanceof CDOID) {
            CDOID id = (CDOID)potentialID;
            if (id.isNull()) {
                return null;
            }
            boolean loadOnDemand = feature == null;
            potentialID = view.getObject(id, loadOnDemand);
            if (potentialID == null && !loadOnDemand) {
                return this.createProxy(view, feature, id);
            }
        }
        if (potentialID instanceof InternalCDOObject) {
            return ((InternalCDOObject)potentialID).cdoInternalInstance();
        }
        return (InternalEObject)potentialID;
    }

    protected InternalEObject createProxy(InternalCDOView view, EStructuralFeature feature, CDOID id) {
        EClassifier eType = feature.getEType();
        Class instanceClass = eType.getInstanceClass();
        Class[] interfaces = new Class[]{instanceClass, InternalEObject.class, LegacyProxy.class};
        ClassLoader classLoader = CDOLegacyWrapper.class.getClassLoader();
        LegacyProxyInvocationHandler handler = new LegacyProxyInvocationHandler(this, id);
        return (InternalEObject)Proxy.newProxyInstance(classLoader, interfaces, (InvocationHandler)handler);
    }

    protected void clearEList(InternalEList<Object> list) {
        while (!list.isEmpty()) {
            Object toBeRemoved = list.basicGet(0);
            list.basicRemove(toBeRemoved, null);
        }
    }

    protected void resolveAllProxies() {
        InternalCDOPackageRegistry packageRegistry = this.cdoView().getSession().getPackageRegistry();
        EClass eClass = this.revision.getEClass();
        EStructuralFeature[] eStructuralFeatureArray = CDOModelUtil.getAllPersistentFeatures((EClass)eClass);
        int n = eStructuralFeatureArray.length;
        int n2 = 0;
        while (n2 < n) {
            EStructuralFeature feature = eStructuralFeatureArray[n2];
            if (feature instanceof EReference) {
                this.resolveProxies(feature, (CDOPackageRegistry)packageRegistry);
            }
            ++n2;
        }
    }

    protected void resolveProxies(EStructuralFeature feature, CDOPackageRegistry packageRegistry) {
        Object value = this.getInstanceValue(this.instance, feature, packageRegistry);
        if (value != null) {
            if (feature.isMany()) {
                InternalEList list = (InternalEList)value;
                int size = list.size();
                int i = 0;
                while (i < size) {
                    Object element = list.get(i);
                    if (element instanceof LegacyProxy) {
                        CDOID id = ((LegacyProxy)element).getID();
                        InternalCDOObject resolved = (InternalCDOObject)this.view.getObject(id);
                        InternalEObject instance = resolved.cdoInternalInstance();
                        if (list instanceof NotifyingListImpl) {
                            ((NotifyingListImpl)list).basicSet(i, (Object)instance, null);
                        } else {
                            list.set(i, (Object)instance);
                        }
                    }
                    ++i;
                }
            } else if (value instanceof LegacyProxy) {
                CDOID id = ((LegacyProxy)value).getID();
                InternalCDOObject resolved = (InternalCDOObject)this.view.getObject(id);
                InternalEObject instance = resolved.cdoInternalInstance();
                this.setInstanceValue(instance, feature, instance);
            }
        }
    }

    protected void adjustEProxy() {
        if (this.state == CDOState.PROXY) {
            if (!this.instance.eIsProxy()) {
                URI uri = URI.createURI((String)("cdo:proxy#" + this.id));
                if (TRACER.isEnabled()) {
                    TRACER.format("Setting proxyURI {0} for {1}", new Object[]{uri, this.instance});
                }
                this.instance.eSetProxyURI(uri);
            }
        } else if (this.instance.eIsProxy()) {
            if (TRACER.isEnabled()) {
                TRACER.format("Unsetting proxyURI for {0}", new Object[]{this.instance});
            }
            this.instance.eSetProxyURI(null);
        }
    }

    protected static int getEFlagMask(Class<?> instanceClass, String flagName) {
        Field field = ReflectUtil.getField(instanceClass, (String)flagName);
        if (!field.isAccessible()) {
            field.setAccessible(true);
        }
        try {
            return (Integer)field.get(null);
        }
        catch (IllegalAccessException ex) {
            throw new ImplementationError((Throwable)ex);
        }
    }

    public static boolean isLegacyProxy(Object object) {
        return object instanceof LegacyProxy;
    }

    private static interface LegacyProxy {
        public CDOID getID();
    }

    private static final class LegacyProxyInvocationHandler
    implements InvocationHandler,
    LegacyProxy {
        private static final Method getIDMethod = ReflectUtil.getMethod(LegacyProxy.class, (String)"getID", (Class[])new Class[0]);
        private static final Method eIsProxyMethod = ReflectUtil.getMethod(EObject.class, (String)"eIsProxy", (Class[])new Class[0]);
        private static final Method eProxyURIMethod = ReflectUtil.getMethod(InternalEObject.class, (String)"eProxyURI", (Class[])new Class[0]);
        private CDOLegacyWrapper wrapper;
        private CDOID id;

        public LegacyProxyInvocationHandler(CDOLegacyWrapper wrapper, CDOID id) {
            this.wrapper = wrapper;
            this.id = id;
        }

        public CDOID getID() {
            return this.id;
        }

        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if (method.equals(getIDMethod)) {
                return this.id;
            }
            if (method.equals(eIsProxyMethod)) {
                return true;
            }
            if (method.equals(eProxyURIMethod)) {
                Resource resource = this.wrapper.eResource();
                return resource.getURI().appendFragment(this.id.toURIFragment());
            }
            throw new UnsupportedOperationException(method.getName());
        }
    }
}

