/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.internal.cdo.net4j.protocol;

import java.io.IOException;
import java.util.List;
import org.eclipse.emf.cdo.common.io.CDODataInput;
import org.eclipse.emf.cdo.common.io.CDODataOutput;
import org.eclipse.emf.internal.cdo.bundle.OM;
import org.eclipse.emf.internal.cdo.net4j.protocol.CDOClientProtocol;
import org.eclipse.emf.internal.cdo.net4j.protocol.CDOClientRequest;
import org.eclipse.emf.spi.cdo.InternalCDOObject;
import org.eclipse.net4j.util.om.trace.ContextTracer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SetAuditRequest
extends CDOClientRequest<boolean[]> {
    private static final ContextTracer TRACER = new ContextTracer(OM.DEBUG_PROTOCOL, SetAuditRequest.class);
    private int viewID;
    private long timeStamp;
    private List<InternalCDOObject> invalidObjects;

    public SetAuditRequest(CDOClientProtocol protocol, int viewID, long timeStamp, List<InternalCDOObject> invalidObjects) {
        super(protocol, (short)23);
        this.viewID = viewID;
        this.timeStamp = timeStamp;
        this.invalidObjects = invalidObjects;
    }

    @Override
    protected void requesting(CDODataOutput out) throws IOException {
        if (TRACER.isEnabled()) {
            TRACER.format("Writing viewID: {0}", new Object[]{this.viewID});
        }
        out.writeInt(this.viewID);
        if (TRACER.isEnabled()) {
            TRACER.format("Writing timeStamp: {0,date} {0,time}", new Object[]{this.timeStamp});
        }
        out.writeLong(this.timeStamp);
        int size = this.invalidObjects.size();
        if (TRACER.isEnabled()) {
            TRACER.format("Writing {0} IDs", new Object[]{size});
        }
        out.writeInt(size);
        for (InternalCDOObject object : this.invalidObjects) {
            if (TRACER.isEnabled()) {
                TRACER.format("Writing ID: {0}", new Object[]{object.cdoID()});
            }
            out.writeCDOID(object.cdoID());
        }
    }

    @Override
    protected boolean[] confirming(CDODataInput in) throws IOException {
        int size = in.readInt();
        if (TRACER.isEnabled()) {
            TRACER.format("Reading {0} existanceFlags", new Object[]{size});
        }
        boolean[] existanceFlags = new boolean[size];
        int i = 0;
        while (i < size) {
            boolean existanceFlag;
            existanceFlags[i] = existanceFlag = in.readBoolean();
            if (TRACER.isEnabled()) {
                TRACER.format("Read existanceFlag: {0}", new Object[]{existanceFlag});
            }
            ++i;
        }
        return existanceFlags;
    }
}

