/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.internal.cdo.util;

import java.util.List;
import org.eclipse.emf.cdo.common.id.CDOIDProvider;
import org.eclipse.emf.cdo.common.model.CDOFeature;
import org.eclipse.emf.cdo.common.revision.CDOReferenceProxy;
import org.eclipse.emf.cdo.common.revision.delta.CDOAddFeatureDelta;
import org.eclipse.emf.cdo.common.revision.delta.CDOFeatureDeltaVisitor;
import org.eclipse.emf.cdo.common.revision.delta.CDOListFeatureDelta;
import org.eclipse.emf.cdo.common.revision.delta.CDORevisionDelta;
import org.eclipse.emf.cdo.common.revision.delta.CDOSetFeatureDelta;
import org.eclipse.emf.cdo.internal.common.revision.delta.CDOFeatureDeltaVisitorImpl;
import org.eclipse.emf.cdo.internal.common.revision.delta.CDOListFeatureDeltaImpl;
import org.eclipse.emf.cdo.spi.common.InternalCDORevision;

public class RevisionAdjuster
extends CDOFeatureDeltaVisitorImpl {
    private CDOIDProvider idProvider;
    private InternalCDORevision revision;

    public RevisionAdjuster(CDOIDProvider idProvider) {
        this.idProvider = idProvider;
    }

    public void adjustRevision(InternalCDORevision revision, CDORevisionDelta revisionDelta) {
        this.revision = revision;
        revisionDelta.accept((CDOFeatureDeltaVisitor)this);
    }

    public void visit(CDOAddFeatureDelta delta) {
        this.revision.setValue(delta.getFeature(), delta.getValue());
    }

    public void visit(CDOSetFeatureDelta delta) {
        CDOFeature feature = delta.getFeature();
        Object value = delta.getValue();
        if (value != null && feature.isReference() && !(value instanceof CDOReferenceProxy)) {
            this.revision.setValue(feature, (Object)this.idProvider.provideCDOID(value));
        }
    }

    public void visit(CDOListFeatureDelta deltas) {
        CDOFeature feature = deltas.getFeature();
        List list = (List)this.revision.getValue(feature);
        int[] indices = ((CDOListFeatureDeltaImpl)deltas).reconstructAddedIndices();
        int i = 1;
        while (i <= indices[0]) {
            int index = indices[i];
            Object value = list.get(index);
            if (value != null && feature.isReference() && !(value instanceof CDOReferenceProxy)) {
                value = this.idProvider.provideCDOID(value);
                list.set(index, value);
            }
            ++i;
        }
    }
}

