/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.internal.cdo.util;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.cdo.CDOObject;
import org.eclipse.emf.cdo.CDOSession;
import org.eclipse.emf.cdo.CDOTransaction;
import org.eclipse.emf.cdo.CDOTransactionHandler;
import org.eclipse.emf.cdo.CDOView;
import org.eclipse.emf.cdo.common.id.CDOIDMetaRange;
import org.eclipse.emf.cdo.common.model.CDOPackage;
import org.eclipse.emf.cdo.common.revision.delta.CDOFeatureDelta;
import org.eclipse.emf.cdo.spi.common.InternalCDOPackage;
import org.eclipse.emf.cdo.util.CDOPackageRegistry;
import org.eclipse.emf.cdo.util.CDOPackageType;
import org.eclipse.emf.cdo.util.CDOPackageTypeRegistry;
import org.eclipse.emf.cdo.util.EMFUtil;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EFactory;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.impl.EPackageImpl;
import org.eclipse.emf.ecore.impl.EPackageRegistryImpl;
import org.eclipse.emf.internal.cdo.CDOSessionImpl;
import org.eclipse.emf.internal.cdo.bundle.OM;
import org.eclipse.emf.internal.cdo.util.ModelUtil;
import org.eclipse.net4j.util.container.ContainerEventAdapter;
import org.eclipse.net4j.util.container.IContainer;
import org.eclipse.net4j.util.event.IListener;
import org.eclipse.net4j.util.lifecycle.ILifecycle;
import org.eclipse.net4j.util.lifecycle.LifecycleEventAdapter;
import org.eclipse.net4j.util.om.trace.ContextTracer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CDOPackageRegistryImpl
extends EPackageRegistryImpl
implements CDOPackageRegistry {
    private final ContextTracer TRACER = new ContextTracer(OM.DEBUG_MODEL, CDOPackageRegistryImpl.class);
    private static final long serialVersionUID = 1L;
    private CDOSessionImpl session;

    public CDOSessionImpl getSession() {
        return this.session;
    }

    @Override
    public void setSession(CDOSession session) {
        this.session = (CDOSessionImpl)session;
    }

    @Override
    public void putPackageDescriptor(CDOPackage cdoPackage) {
        this.checkSession();
        RemotePackageDescriptor descriptor = new RemotePackageDescriptor(cdoPackage);
        String uri = cdoPackage.getPackageURI();
        if (this.TRACER.isEnabled()) {
            this.TRACER.format("Registering package descriptor for {0}", new Object[]{uri});
        }
        this.put(uri, (Object)descriptor);
    }

    @Override
    public EPackage putEPackage(EPackage ePackage) {
        this.checkSession();
        String uri = ePackage.getNsURI();
        if (ePackage.getESuperPackage() != null) {
            throw new IllegalArgumentException("Not a top level package: " + uri);
        }
        this.putEPackage(uri, ePackage);
        return this.getEPackage(uri);
    }

    private void putEPackage(String uri, EPackage ePackage) {
        if (uri != null) {
            this.put(uri, (Object)ePackage);
        }
        for (EPackage subPackage : ePackage.getESubpackages()) {
            this.putEPackage(subPackage.getNsURI(), subPackage);
        }
    }

    public Object put(String key, Object value) {
        this.checkSession();
        if (value instanceof EPackage) {
            EPackageImpl ePackage;
            if (this.TRACER.isEnabled()) {
                this.TRACER.format("Registering package for {0}", new Object[]{key});
            }
            if (value instanceof EPackageImpl && EMFUtil.isDynamicEPackage(ePackage = (EPackageImpl)value)) {
                ModelUtil.prepareEPackage(ePackage);
            }
            ePackage = (EPackage)value;
            CDOPackage cdoPackage = ModelUtil.getCDOPackage((EPackage)ePackage, this.session.getPackageManager());
            CDOIDMetaRange metaIDRange = cdoPackage.getTopLevelPackage().getMetaIDRange();
            ((InternalCDOPackage)cdoPackage).setPersistent(metaIDRange != null && !metaIDRange.isTemporary());
        }
        return super.put((Object)key, value);
    }

    public void putAll(Map<? extends String, ? extends Object> m) {
        throw new UnsupportedOperationException();
    }

    private void checkSession() {
        if (this.session == null) {
            throw new IllegalStateException("session == null");
        }
    }

    public static class DemandPopulating
    extends TransactionBound {
        private static final long serialVersionUID = 1L;
        private Set<EClass> usedClasses = new HashSet<EClass>();

        public void addingObject(CDOTransaction transaction, CDOObject object) {
            EClass usedClass = object.eClass();
            this.addAllEPackages(usedClass);
        }

        private void addAllEPackages(EClass eClass) {
            if (this.usedClasses.add(eClass)) {
                this.addPackage(eClass.getEPackage());
                for (EClass superType : eClass.getEAllSuperTypes()) {
                    this.addAllEPackages(superType);
                }
                for (EReference eReference : eClass.getEAllReferences()) {
                    this.addAllEPackages(eReference.getEReferenceType());
                }
            }
        }

        protected void sessionAboutToDeactivate() {
            this.usedClasses.clear();
            super.sessionAboutToDeactivate();
        }

        private void addPackage(EPackage ePackage) {
            if (!this.containsKey(ePackage.getNsURI())) {
                EPackage topLevelPackage = ModelUtil.getTopLevelPackage(ePackage);
                this.putEPackage(topLevelPackage);
            }
        }
    }

    private final class RemotePackageDescriptor
    implements EPackage.Descriptor {
        private CDOPackage cdoPackage;

        private RemotePackageDescriptor(CDOPackage cdoPackage) {
            this.cdoPackage = cdoPackage;
        }

        public CDOPackage getCDOPackage() {
            return this.cdoPackage;
        }

        public EFactory getEFactory() {
            throw new UnsupportedOperationException("Not yet implemented");
        }

        public EPackage getEPackage() {
            EPackage ePackage = ModelUtil.createEPackage(this.cdoPackage);
            CDOIDMetaRange idRange = this.cdoPackage.getMetaIDRange();
            if (idRange != null) {
                CDOPackageRegistryImpl.this.session.registerEPackage(ePackage, idRange);
            }
            return ePackage;
        }

        public String toString() {
            return MessageFormat.format("LocalPackageDescriptor[{0}]", this.cdoPackage.getPackageURI());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SelfPopulating
    extends SessionBound {
        private static final long serialVersionUID = 1L;
        private IListener typeListener = new ContainerEventAdapter<Map.Entry<String, CDOPackageType>>(){

            protected void onAdded(IContainer<Map.Entry<String, CDOPackageType>> container, Map.Entry<String, CDOPackageType> entry) {
                SelfPopulating.this.addEntry(entry);
            }
        };

        @Override
        protected void sessionActivated() {
            for (Map.Entry entry : CDOPackageTypeRegistry.INSTANCE.entrySet()) {
                this.addEntry(entry);
            }
            CDOPackageTypeRegistry.INSTANCE.addListener(this.typeListener);
        }

        @Override
        protected void sessionAboutToDeactivate() {
            CDOPackageTypeRegistry.INSTANCE.removeListener(this.typeListener);
        }

        protected void addEntry(Map.Entry<String, CDOPackageType> entry) {
            String uri;
            CDOPackageType packageType = entry.getValue();
            if (packageType != CDOPackageType.LEGACY && !this.containsKey(uri = entry.getKey())) {
                try {
                    EPackage ePackage = EPackage.Registry.INSTANCE.getEPackage(uri);
                    this.putEPackage(ePackage);
                }
                catch (RuntimeException ex) {
                    OM.LOG.error((Throwable)ex);
                }
            }
        }
    }

    public static abstract class SessionBound
    extends CDOPackageRegistryImpl {
        private static final long serialVersionUID = 1L;
        private IListener sessionLifecycleListener = new LifecycleEventAdapter(){

            protected void onActivated(ILifecycle lifecycle) {
                SessionBound.this.sessionActivated();
            }

            protected void onAboutToDeactivate(ILifecycle lifecycle) {
                SessionBound.this.getSession().removeListener((IListener)this);
                SessionBound.this.sessionAboutToDeactivate();
            }
        };

        public void setSession(CDOSession session) {
            super.setSession(session);
            session.addListener(this.sessionLifecycleListener);
        }

        protected abstract void sessionActivated();

        protected abstract void sessionAboutToDeactivate();
    }

    public static class TransactionBound
    extends SessionBound
    implements CDOTransactionHandler {
        private static final long serialVersionUID = 1L;
        private List<CDOTransaction> transactions = new ArrayList<CDOTransaction>();
        private IListener sessionContainerListener = new ContainerEventAdapter<CDOView>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void onAdded(IContainer<CDOView> session, CDOView view) {
                if (view instanceof CDOTransaction) {
                    CDOTransaction transaction = (CDOTransaction)view;
                    transaction.addHandler(TransactionBound.this);
                    List list = TransactionBound.this.transactions;
                    synchronized (list) {
                        TransactionBound.this.transactions.add(transaction);
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void onRemoved(IContainer<CDOView> session, CDOView view) {
                if (view instanceof CDOTransaction) {
                    CDOTransaction transaction = (CDOTransaction)view;
                    transaction.removeHandler(TransactionBound.this);
                    List list = TransactionBound.this.transactions;
                    synchronized (list) {
                        TransactionBound.this.transactions.remove(transaction);
                    }
                }
            }
        };

        protected void sessionActivated() {
            this.getSession().addListener(this.sessionContainerListener);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void sessionAboutToDeactivate() {
            this.getSession().removeListener(this.sessionContainerListener);
            List<CDOTransaction> list = this.transactions;
            synchronized (list) {
                for (CDOTransaction transaction : this.transactions) {
                    transaction.removeHandler(this);
                }
                this.transactions.clear();
            }
        }

        public void addingObject(CDOTransaction transaction, CDOObject object) {
        }

        public void modifyingObject(CDOTransaction transaction, CDOObject object, CDOFeatureDelta featureDelta) {
        }

        public void committingTransaction(CDOTransaction transaction) {
        }
    }
}

