/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.internal.cdo.protocol;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.id.CDOIDUtil;
import org.eclipse.emf.cdo.spi.common.InternalCDORevision;
import org.eclipse.emf.internal.cdo.bundle.OM;
import org.eclipse.emf.internal.cdo.protocol.CDOClientRequest;
import org.eclipse.net4j.channel.IChannel;
import org.eclipse.net4j.util.io.ExtendedDataInputStream;
import org.eclipse.net4j.util.io.ExtendedDataOutput;
import org.eclipse.net4j.util.io.ExtendedDataOutputStream;
import org.eclipse.net4j.util.om.trace.ContextTracer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VerifyRevisionRequest
extends CDOClientRequest<List<InternalCDORevision>> {
    private static final ContextTracer PROTOCOL = new ContextTracer(OM.DEBUG_PROTOCOL, VerifyRevisionRequest.class);
    private Collection<InternalCDORevision> revisions;

    public VerifyRevisionRequest(IChannel channel, Collection<InternalCDORevision> revisions) {
        super(channel);
        this.revisions = revisions;
    }

    public VerifyRevisionRequest(IChannel channel, InternalCDORevision revision) {
        this(channel, (Collection<InternalCDORevision>)Collections.singleton(revision));
    }

    protected short getSignalID() {
        return 11;
    }

    protected void requesting(ExtendedDataOutputStream out) throws IOException {
        if (PROTOCOL.isEnabled()) {
            PROTOCOL.format("Writing {0} IDs and versions", new Object[]{this.revisions.size()});
        }
        out.writeInt(this.revisions.size());
        for (InternalCDORevision revision : this.revisions) {
            CDOID id = revision.getID();
            int version = revision.getVersion();
            if (PROTOCOL.isEnabled()) {
                PROTOCOL.format("Writing ID and version: {0}v{1}", new Object[]{id, version});
            }
            CDOIDUtil.write((ExtendedDataOutput)out, (CDOID)id);
            out.writeInt(version);
        }
    }

    protected List<InternalCDORevision> confirming(ExtendedDataInputStream in) throws IOException {
        ArrayList<InternalCDORevision> result = new ArrayList<InternalCDORevision>();
        if (PROTOCOL.isEnabled()) {
            PROTOCOL.format("Reading {0} timeStamps", new Object[]{this.revisions.size()});
        }
        for (InternalCDORevision revision : this.revisions) {
            long revised = in.readLong();
            if (PROTOCOL.isEnabled()) {
                PROTOCOL.format("Reading timeStamp: {0}", new Object[]{revised});
            }
            if (revised == 0L) continue;
            revision.setRevised(revised);
            result.add(revision);
        }
        return result;
    }
}

