/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.ui;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.cdo.CDOAudit;
import org.eclipse.emf.cdo.CDOSession;
import org.eclipse.emf.cdo.CDOTransaction;
import org.eclipse.emf.cdo.CDOTransactionFinishedEvent;
import org.eclipse.emf.cdo.CDOTransactionStartedEvent;
import org.eclipse.emf.cdo.CDOView;
import org.eclipse.emf.cdo.CDOViewEvent;
import org.eclipse.emf.cdo.common.CDOProtocolView;
import org.eclipse.emf.cdo.internal.ui.SharedIcons;
import org.eclipse.emf.cdo.internal.ui.actions.CloseSessionAction;
import org.eclipse.emf.cdo.internal.ui.actions.CloseViewAction;
import org.eclipse.emf.cdo.internal.ui.actions.CommitTransactionAction;
import org.eclipse.emf.cdo.internal.ui.actions.CreateResourceAction;
import org.eclipse.emf.cdo.internal.ui.actions.ImportResourceAction;
import org.eclipse.emf.cdo.internal.ui.actions.LoadResourceAction;
import org.eclipse.emf.cdo.internal.ui.actions.ManagePackagesAction;
import org.eclipse.emf.cdo.internal.ui.actions.OpenAuditAction;
import org.eclipse.emf.cdo.internal.ui.actions.OpenTransactionAction;
import org.eclipse.emf.cdo.internal.ui.actions.OpenViewAction;
import org.eclipse.emf.cdo.internal.ui.actions.OpenViewEditorAction;
import org.eclipse.emf.cdo.internal.ui.actions.RegisterFilesystemPackagesAction;
import org.eclipse.emf.cdo.internal.ui.actions.RegisterSinglePackageAction;
import org.eclipse.emf.cdo.internal.ui.actions.RegisterWorkspacePackagesAction;
import org.eclipse.emf.cdo.internal.ui.actions.ReloadViewAction;
import org.eclipse.emf.cdo.internal.ui.actions.RollbackTransactionAction;
import org.eclipse.emf.cdo.internal.ui.views.CDOViewHistory;
import org.eclipse.emf.cdo.ui.CDOViewHistoryEvent;
import org.eclipse.emf.cdo.util.CDOPackageType;
import org.eclipse.emf.cdo.util.CDOPackageTypeRegistry;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.net4j.connector.IConnector;
import org.eclipse.net4j.util.container.IContainer;
import org.eclipse.net4j.util.event.IEvent;
import org.eclipse.net4j.util.event.IListener;
import org.eclipse.net4j.util.ui.views.ContainerItemProvider;
import org.eclipse.net4j.util.ui.views.IElementFilter;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IWorkbenchPage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CDOItemProvider
extends ContainerItemProvider<IContainer<Object>> {
    private IWorkbenchPage page;
    private Map<CDOView, CDOViewHistory> viewHistories = new HashMap<CDOView, CDOViewHistory>();
    private IListener viewListener = new IListener(){

        public void notifyEvent(IEvent event) {
            if (event instanceof CDOTransactionStartedEvent || event instanceof CDOTransactionFinishedEvent) {
                try {
                    final CDOView view = ((CDOViewEvent)event).getView();
                    CDOItemProvider.this.getViewer().getControl().getDisplay().syncExec(new Runnable(){

                        public void run() {
                            try {
                                Object[] entries;
                                CDOItemProvider.this.fireLabelProviderChanged(view);
                                CDOViewHistory history = (CDOViewHistory)((Object)CDOItemProvider.this.viewHistories.get(view));
                                if (history != null && (entries = history.getEntries()) != null && entries.length != 0) {
                                    CDOItemProvider.this.fireLabelProviderChanged(entries);
                                }
                            }
                            catch (Exception exception) {}
                        }
                    });
                }
                catch (Exception exception) {}
            }
        }
    };
    private IListener historyListener = new IListener(){

        public void notifyEvent(IEvent event) {
            if (event instanceof CDOViewHistoryEvent) {
                CDOViewHistoryEvent e = (CDOViewHistoryEvent)event;
                CDOView view = e.getViewHistory().getView();
                CDOItemProvider.this.refreshElement(view, false);
                CDOViewHistory.Entry addedEntry = e.getAddedEntry();
                if (addedEntry != null) {
                    CDOItemProvider.this.revealElement(addedEntry);
                }
            }
        }
    };

    public CDOItemProvider(IWorkbenchPage page, IElementFilter rootElementFilter) {
        super(rootElementFilter);
        this.page = page;
    }

    public CDOItemProvider(IWorkbenchPage page) {
        this(page, null);
    }

    public Object[] getChildren(Object element) {
        if (element instanceof CDOView) {
            CDOView view = (CDOView)element;
            CDOViewHistory history = this.viewHistories.get(view);
            if (history != null) {
                return history.getEntries();
            }
            return NO_ELEMENTS;
        }
        return super.getChildren(element);
    }

    public boolean hasChildren(Object element) {
        if (element instanceof CDOView) {
            CDOView view = (CDOView)element;
            CDOViewHistory history = this.viewHistories.get(view);
            if (history != null) {
                return history.hasEntries();
            }
            return false;
        }
        return super.hasChildren(element);
    }

    public Object getParent(Object element) {
        if (element instanceof CDOViewHistory.Entry) {
            return ((CDOViewHistory.Entry)element).getView();
        }
        return super.getParent(element);
    }

    public String getText(Object obj) {
        if (obj instanceof CDOSession) {
            return CDOItemProvider.getSessionLabel((CDOSession)obj);
        }
        if (obj instanceof CDOView) {
            return CDOItemProvider.getViewLabel((CDOView)obj);
        }
        if (obj instanceof CDOViewHistory.Entry) {
            return CDOItemProvider.getHistroyEntryLabel((CDOViewHistory.Entry)obj);
        }
        return super.getText(obj);
    }

    public Image getImage(Object obj) {
        if (obj instanceof CDOSession) {
            return SharedIcons.getImage("obj16/cdo_session");
        }
        if (obj instanceof CDOView) {
            CDOView view = (CDOView)obj;
            switch (view.getViewType()) {
                case TRANSACTION: {
                    return SharedIcons.getImage("obj16/cdo_editor");
                }
                case READONLY: {
                    return SharedIcons.getImage("obj16/cdo_editor_readonly");
                }
                case AUDIT: {
                    return SharedIcons.getImage("obj16/cdo_editor_historical");
                }
            }
        }
        return super.getImage(obj);
    }

    public static String getSessionLabel(CDOSession session) {
        IConnector connector = session.getConnector();
        String repositoryName = session.getRepositoryName();
        return "Session " + connector.getURL() + "/" + repositoryName + " [" + session.getSessionID() + "]";
    }

    public static String getViewLabel(CDOView view) {
        if (view instanceof CDOTransaction) {
            CDOTransaction transaction = (CDOTransaction)view;
            return MessageFormat.format("{0}Transaction [{1}]", transaction.isDirty() ? "*" : "", transaction.getViewID());
        }
        if (view instanceof CDOAudit) {
            CDOAudit audit = (CDOAudit)view;
            return MessageFormat.format("Audit [{0,date} {0,time}]", audit.getTimeStamp());
        }
        return MessageFormat.format("View [{0}]", view.getViewID());
    }

    public static String getHistroyEntryLabel(CDOViewHistory.Entry entry) {
        return String.valueOf(entry.getView().isDirty() ? "*" : "") + entry.getResourcePath();
    }

    protected void fillContextMenu(IMenuManager manager, ITreeSelection selection) {
        super.fillContextMenu(manager, selection);
        if (selection.size() == 1) {
            Object object = selection.getFirstElement();
            if (object instanceof CDOSession) {
                this.fillSession(manager, (CDOSession)object);
            } else if (object instanceof CDOView) {
                this.fillView(manager, (CDOView)object);
            } else if (object instanceof CDOViewHistory.Entry) {
                this.fillHistoryEntry(manager, (CDOViewHistory.Entry)object);
            }
        }
    }

    protected void fillSession(IMenuManager manager, CDOSession session) {
        manager.add((IAction)new OpenTransactionAction(this.page, session));
        manager.add((IAction)new OpenViewAction(this.page, session));
        manager.add((IAction)new OpenAuditAction(this.page, session));
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)new ManagePackagesAction(this.page, session));
        MenuManager generatedManager = new MenuManager("Register Generated Package");
        if (this.fillGenerated(generatedManager, session)) {
            manager.add((IContributionItem)generatedManager);
        }
        RegisterWorkspacePackagesAction a1 = new RegisterWorkspacePackagesAction(this.page, session);
        a1.setText(String.valueOf(a1.getText()) + "...");
        manager.add((IAction)a1);
        RegisterFilesystemPackagesAction a2 = new RegisterFilesystemPackagesAction(this.page, session);
        a2.setText(String.valueOf(a2.getText()) + "...");
        manager.add((IAction)a2);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)new CloseSessionAction(this.page, session));
    }

    protected boolean fillGenerated(MenuManager manager, CDOSession session) {
        Set entrySet = CDOPackageTypeRegistry.INSTANCE.entrySet();
        ArrayList entryList = new ArrayList(entrySet);
        Collections.sort(entryList, new Comparator<Map.Entry<String, CDOPackageType>>(){

            @Override
            public int compare(Map.Entry<String, CDOPackageType> e1, Map.Entry<String, CDOPackageType> e2) {
                return e1.getKey().compareTo(e2.getKey());
            }
        });
        HashSet registeredURIs = new HashSet(session.getPackageRegistry().keySet());
        boolean added = false;
        for (Map.Entry entry : entryList) {
            String packageURI = (String)entry.getKey();
            if (registeredURIs.contains(packageURI)) continue;
            manager.add((IAction)new RegisterSinglePackageAction(this.page, session, packageURI, (CDOPackageType)entry.getValue()));
            added = true;
        }
        return added;
    }

    protected void fillView(IMenuManager manager, CDOView view) {
        manager.add((IAction)new OpenViewEditorAction(this.page, view));
        manager.add((IAction)new LoadResourceAction(this.page, view));
        manager.add((IContributionItem)new Separator());
        if (view.getViewType() == CDOProtocolView.Type.TRANSACTION) {
            manager.add((IAction)new CreateResourceAction(this.page, view));
            manager.add((IAction)new ImportResourceAction(this.page, view));
            manager.add((IAction)new CommitTransactionAction(this.page, view));
            manager.add((IAction)new RollbackTransactionAction(this.page, view));
        }
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)new ReloadViewAction(this.page, view));
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)new CloseViewAction(this.page, view));
    }

    protected void fillHistoryEntry(IMenuManager manager, CDOViewHistory.Entry entry) {
    }

    protected void elementAdded(Object element, Object parent) {
        super.elementAdded(element, parent);
        if (element instanceof CDOView) {
            CDOView view = (CDOView)element;
            view.addListener(this.viewListener);
            CDOViewHistory history = new CDOViewHistory(view);
            history.addListener(this.historyListener);
            this.viewHistories.put(view, history);
        }
    }

    protected void elementRemoved(Object element, Object parent) {
        super.elementRemoved(element, parent);
        if (element instanceof CDOView) {
            CDOView view = (CDOView)element;
            view.removeListener(this.viewListener);
            CDOViewHistory history = this.viewHistories.remove(view);
            history.removeListener(this.historyListener);
            history.dispose();
        }
    }
}

