/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.server;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.model.CDOClassRef;
import org.eclipse.emf.cdo.common.model.CDOFeature;
import org.eclipse.emf.cdo.common.model.CDOPackage;
import org.eclipse.emf.cdo.common.model.CDOPackageInfo;
import org.eclipse.emf.cdo.common.revision.CDORevision;
import org.eclipse.emf.cdo.common.revision.CDORevisionUtil;
import org.eclipse.emf.cdo.common.revision.delta.CDORevisionDelta;
import org.eclipse.emf.cdo.internal.server.MEMStore;
import org.eclipse.emf.cdo.internal.server.MEMStoreChunkReader;
import org.eclipse.emf.cdo.internal.server.Store;
import org.eclipse.emf.cdo.internal.server.StoreAccessor;
import org.eclipse.emf.cdo.server.ISession;
import org.eclipse.emf.cdo.server.IStoreChunkReader;
import org.eclipse.emf.cdo.server.IStoreReader;
import org.eclipse.emf.cdo.server.IStoreWriter;
import org.eclipse.emf.cdo.server.IView;
import org.eclipse.emf.cdo.spi.common.InternalCDORevision;
import org.eclipse.net4j.util.collection.CloseableIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MEMStoreAccessor
extends StoreAccessor
implements IStoreReader,
IStoreWriter {
    List<CDORevision> newRevisions = new ArrayList<CDORevision>();

    public MEMStoreAccessor(MEMStore store, ISession session) {
        super((Store)store, session);
    }

    public MEMStoreAccessor(MEMStore store, IView view) {
        super((Store)store, view);
    }

    @Override
    public MEMStore getStore() {
        return (MEMStore)super.getStore();
    }

    @Override
    public IStoreChunkReader createChunkReader(CDORevision revision, CDOFeature feature) {
        return new MEMStoreChunkReader(this, revision, feature);
    }

    @Override
    public Collection<CDOPackageInfo> readPackageInfos() {
        return Collections.emptySet();
    }

    @Override
    public void readPackage(CDOPackage cdoPackage) {
        throw new UnsupportedOperationException();
    }

    @Override
    public CloseableIterator<CDOID> readObjectIDs(boolean withTypes) {
        throw new UnsupportedOperationException();
    }

    @Override
    public CDOClassRef readObjectType(CDOID id) {
        throw new UnsupportedOperationException();
    }

    @Override
    public CDORevision readRevision(CDOID id, int referenceChunk) {
        InternalCDORevision storeRevision = (InternalCDORevision)this.getStore().getRevision(id);
        return storeRevision;
    }

    @Override
    public CDORevision readRevisionByTime(CDOID id, int referenceChunk, long timeStamp) {
        throw new UnsupportedOperationException();
    }

    @Override
    public CDORevision readRevisionByVersion(CDOID id, int referenceChunk, int version) {
        return this.getStore().getRevisionByVersion(id, version);
    }

    @Override
    public CDOID readResourceID(String path) {
        CDORevision revision = this.getStore().getResource(path);
        return revision == null ? null : revision.getID();
    }

    @Override
    public String readResourcePath(CDOID id) {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void commit(IStoreWriter.CommitContext context) {
        MEMStore store;
        MEMStore mEMStore = store = this.getStore();
        synchronized (mEMStore) {
            super.commit(context);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rollback(IStoreWriter.CommitContext context) {
        MEMStore store;
        MEMStore mEMStore = store = this.getStore();
        synchronized (mEMStore) {
            super.rollback(context);
            for (CDORevision revision : this.newRevisions) {
                store.removeRevision(revision);
            }
        }
    }

    @Override
    protected void writePackages(CDOPackage ... cdoPackages) {
    }

    @Override
    protected void writeRevision(CDORevision revision) {
        this.newRevisions.add(revision);
        this.getStore().addRevision(revision);
    }

    @Override
    protected void writeRevisionDelta(CDORevisionDelta revisionDelta) {
        CDORevision revision = this.getStore().getRevision(revisionDelta.getID());
        CDORevision newRevision = CDORevisionUtil.copy((CDORevision)revision);
        revisionDelta.apply(newRevision);
        this.writeRevision(newRevision);
    }

    @Override
    protected void doRelease() {
        this.newRevisions.clear();
    }
}

