/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.spi.common.revision;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.Map;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.id.CDOIDTemp;
import org.eclipse.emf.cdo.common.id.CDOIDUtil;
import org.eclipse.emf.cdo.common.io.CDODataInput;
import org.eclipse.emf.cdo.common.io.CDODataOutput;
import org.eclipse.emf.cdo.common.model.CDOClassInfo;
import org.eclipse.emf.cdo.common.model.CDOClassifierRef;
import org.eclipse.emf.cdo.common.model.CDOModelUtil;
import org.eclipse.emf.cdo.common.model.CDOType;
import org.eclipse.emf.cdo.common.revision.CDOList;
import org.eclipse.emf.cdo.common.revision.CDOListFactory;
import org.eclipse.emf.cdo.common.revision.CDOReferenceAdjuster;
import org.eclipse.emf.cdo.common.revision.CDORevision;
import org.eclipse.emf.cdo.common.revision.CDORevisionData;
import org.eclipse.emf.cdo.common.revision.delta.CDORevisionDelta;
import org.eclipse.emf.cdo.common.revision.delta.CDORevisionDeltaUtil;
import org.eclipse.emf.cdo.internal.common.bundle.OM;
import org.eclipse.emf.cdo.internal.common.messages.Messages;
import org.eclipse.emf.cdo.spi.common.revision.CDORevisionMerger;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDOList;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevision;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevisionDelta;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.FeatureMapUtil;
import org.eclipse.net4j.util.ImplementationError;
import org.eclipse.net4j.util.om.trace.ContextTracer;
import org.eclipse.net4j.util.om.trace.PerfTracer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractCDORevision
implements InternalCDORevision {
    private static final ContextTracer TRACER = new ContextTracer(OM.DEBUG_REVISION, AbstractCDORevision.class);
    private static final PerfTracer READING = new PerfTracer(OM.PERF_REVISION_READING, AbstractCDORevision.class);
    private static final PerfTracer WRITING = new PerfTracer(OM.PERF_REVISION_WRITING, AbstractCDORevision.class);
    private CDOClassInfo classInfo;
    private CDOID id;
    private int version;
    private long created;
    private long revised;
    private CDOID resourceID;
    private Object containerID;
    private int containingFeatureID;

    public AbstractCDORevision(EClass eClass, CDOID id) {
        if (eClass.isAbstract()) {
            throw new IllegalArgumentException(MessageFormat.format(Messages.getString("AbstractCDORevision.0"), eClass));
        }
        if (CDOIDUtil.isNull(id)) {
            throw new IllegalArgumentException(Messages.getString("AbstractCDORevision.1"));
        }
        this.classInfo = CDOModelUtil.getClassInfo(eClass);
        this.id = id;
        this.version = 0;
        this.created = 0L;
        this.revised = 0L;
        this.resourceID = CDOID.NULL;
        this.containerID = CDOID.NULL;
        this.containingFeatureID = 0;
        this.initValues(this.classInfo.getAllPersistentFeatures());
    }

    public AbstractCDORevision(AbstractCDORevision source) {
        this.classInfo = source.classInfo;
        this.id = source.id;
        this.version = source.version;
        this.created = source.created;
        this.revised = source.revised;
        this.resourceID = source.resourceID;
        this.containerID = source.containerID;
        this.containingFeatureID = source.containingFeatureID;
    }

    public AbstractCDORevision(CDODataInput in) throws IOException {
        READING.start((Object)this);
        EClassifier classifier = in.readCDOClassifierRefAndResolve();
        this.classInfo = CDOModelUtil.getClassInfo((EClass)classifier);
        this.id = in.readCDOID();
        this.version = in.readInt();
        if (!this.id.isTemporary()) {
            this.created = in.readLong();
            this.revised = in.readLong();
        }
        this.resourceID = in.readCDOID();
        this.containerID = in.readCDOID();
        this.containingFeatureID = in.readInt();
        if (TRACER.isEnabled()) {
            TRACER.format("Reading revision: ID={0}, className={1}, version={2}, created={3}, revised={4}, resource={5}, container={6}, featureID={7}", new Object[]{this.id, this.getEClass().getName(), this.version, this.created, this.revised, this.resourceID, this.containerID, this.containingFeatureID});
        }
        this.readValues(in);
        READING.stop((Object)this);
    }

    @Override
    public void write(CDODataOutput out, int referenceChunk) throws IOException {
        EClass eClass = this.getEClass();
        CDOClassifierRef classRef = new CDOClassifierRef((EClassifier)eClass);
        if (TRACER.isEnabled()) {
            TRACER.format("Writing revision: ID={0}, className={1}, version={2}, created={3}, revised={4}, resource={5}, container={6}, featureID={7}", new Object[]{this.id, eClass.getName(), this.getVersion(), this.created, this.revised, this.resourceID, this.containerID, this.containingFeatureID});
        }
        WRITING.start((Object)this);
        out.writeCDOClassifierRef(classRef);
        out.writeCDOID(this.id);
        out.writeInt(this.getVersion());
        if (!this.id.isTemporary()) {
            out.writeLong(this.created);
            out.writeLong(this.revised);
        }
        out.writeCDOID(this.resourceID);
        CDOID newContainerID = out.getIDProvider().provideCDOID(this.containerID);
        out.writeCDOID(newContainerID);
        out.writeInt(this.containingFeatureID);
        this.writeValues(out, referenceChunk);
        WRITING.stop((Object)this);
    }

    @Override
    public EClass getEClass() {
        return this.classInfo.getEClass();
    }

    @Override
    public CDOID getID() {
        return this.id;
    }

    @Override
    public void setID(CDOID id) {
        if (TRACER.isEnabled()) {
            TRACER.format("Setting ID: {0}", new Object[]{id});
        }
        this.id = id;
    }

    @Override
    public int getVersion() {
        return this.version < 0 ? -this.version : this.version;
    }

    @Override
    public void setVersion(int version) {
        if (TRACER.isEnabled()) {
            TRACER.format("Setting version for {0}: v{1}", new Object[]{this, version});
        }
        this.version = version;
    }

    @Override
    public boolean isTransactional() {
        return this.version < 0;
    }

    @Override
    public int setTransactional() {
        if (TRACER.isEnabled()) {
            TRACER.format("Setting transactional {0}: v{1}", new Object[]{this, -(this.version + 1)});
        }
        this.version = -(this.version + 1);
        return this.version;
    }

    @Override
    public void setUntransactional() {
        if (TRACER.isEnabled()) {
            TRACER.format("Setting untransactional {0}: v{1}", new Object[]{this, Math.abs(this.version)});
        }
        this.version = Math.abs(this.version);
    }

    @Override
    public long getCreated() {
        return this.created;
    }

    @Override
    public void setCreated(long created) {
        if (TRACER.isEnabled()) {
            TRACER.format("Setting created {0}: {1,date} {1,time}", new Object[]{this, created});
        }
        this.created = created;
    }

    @Override
    public long getRevised() {
        return this.revised;
    }

    @Override
    public void setRevised(long revised) {
        if (revised != 0L && revised < Math.max(0L, this.created)) {
            throw new IllegalArgumentException("created=" + this.created + ", revised=" + revised);
        }
        if (TRACER.isEnabled()) {
            TRACER.format("Setting revised {0}: {1,date} {1,time}", new Object[]{this, revised});
        }
        this.revised = revised;
    }

    @Override
    public boolean isCurrent() {
        return this.revised == 0L;
    }

    @Override
    public boolean isValid(long timeStamp) {
        return (this.revised == 0L || this.revised >= timeStamp) && timeStamp >= this.created;
    }

    @Override
    public boolean isResourceNode() {
        return this.classInfo.isResourceNode();
    }

    @Override
    public boolean isResourceFolder() {
        return this.classInfo.isResourceFolder();
    }

    @Override
    public boolean isResource() {
        return this.classInfo.isResource();
    }

    @Override
    public CDORevisionData data() {
        return this;
    }

    @Override
    public CDORevision revision() {
        return this;
    }

    @Override
    public InternalCDORevisionDelta compare(CDORevision origin) {
        return (InternalCDORevisionDelta)CDORevisionDeltaUtil.create(origin, this);
    }

    @Override
    public void merge(CDORevisionDelta delta) {
        CDORevisionMerger applier = new CDORevisionMerger();
        applier.merge(this, delta);
    }

    @Override
    public CDOID getResourceID() {
        return this.resourceID;
    }

    @Override
    public void setResourceID(CDOID resourceID) {
        if (TRACER.isEnabled()) {
            TRACER.format("Setting resourceID {0}: {1}", new Object[]{this, resourceID});
        }
        this.resourceID = resourceID;
    }

    @Override
    public Object getContainerID() {
        return this.containerID;
    }

    @Override
    public void setContainerID(Object containerID) {
        if (TRACER.isEnabled()) {
            TRACER.format("Setting containerID {0}: {1}", new Object[]{this, containerID});
        }
        this.containerID = containerID;
    }

    @Override
    public int getContainingFeatureID() {
        return this.containingFeatureID;
    }

    @Override
    public void setContainingFeatureID(int containingFeatureID) {
        if (TRACER.isEnabled()) {
            TRACER.format("Setting containingFeatureID {0}: {1}", new Object[]{this, containingFeatureID});
        }
        this.containingFeatureID = containingFeatureID;
    }

    @Override
    public int hashCode(EStructuralFeature feature) {
        return this.getValue(feature).hashCode();
    }

    @Override
    public Object get(EStructuralFeature feature, int index) {
        if (feature.isMany()) {
            return this.getList(feature).get(index);
        }
        return this.getValue(feature);
    }

    @Override
    public Object basicGet(EStructuralFeature feature, int index) {
        if (feature.isMany()) {
            return this.getList(feature).get(index);
        }
        return this.basicGet(feature);
    }

    @Override
    public boolean contains(EStructuralFeature feature, Object value) {
        return this.getList(feature).contains(value);
    }

    @Override
    public int indexOf(EStructuralFeature feature, Object value) {
        return this.getList(feature).indexOf(value);
    }

    @Override
    public boolean isEmpty(EStructuralFeature feature) {
        return this.getList(feature).isEmpty();
    }

    @Override
    public int lastIndexOf(EStructuralFeature feature, Object value) {
        return this.getList(feature).lastIndexOf(value);
    }

    @Override
    public int size(EStructuralFeature feature) {
        return this.getList(feature).size();
    }

    @Override
    public Object[] toArray(EStructuralFeature feature) {
        if (!feature.isMany()) {
            throw new IllegalStateException("!feature.isMany()");
        }
        return this.getList(feature).toArray();
    }

    @Override
    public <T> T[] toArray(EStructuralFeature feature, T[] array) {
        if (!feature.isMany()) {
            throw new IllegalStateException("!feature.isMany()");
        }
        return this.getList(feature).toArray(array);
    }

    @Override
    public void add(EStructuralFeature feature, int index, Object value) {
        this.getList(feature).add(index, value);
    }

    @Override
    public void clear(EStructuralFeature feature) {
        this.setValue(feature, null);
    }

    @Override
    public Object move(EStructuralFeature feature, int targetIndex, int sourceIndex) {
        return this.getList(feature).move(targetIndex, sourceIndex);
    }

    @Override
    public Object remove(EStructuralFeature feature, int index) {
        return this.getList(feature).remove(index);
    }

    @Override
    public Object set(EStructuralFeature feature, int index, Object value) {
        if (feature.isMany()) {
            return this.getList(feature).set(index, value);
        }
        return this.setValue(feature, value);
    }

    @Override
    public Object basicSet(EStructuralFeature feature, int index, Object value) {
        if (feature.isMany()) {
            return this.getList(feature).set(index, value);
        }
        return this.basicSet(feature, value);
    }

    @Override
    public void unset(EStructuralFeature feature) {
        this.setValue(feature, null);
    }

    @Override
    public void adjustReferences(CDOReferenceAdjuster revisionAdjuster) {
        if (TRACER.isEnabled()) {
            TRACER.format("Adjusting references for revision {0}", new Object[]{this});
        }
        this.resourceID = (CDOID)revisionAdjuster.adjustReference(this.resourceID);
        this.containerID = revisionAdjuster.adjustReference(this.containerID);
        EStructuralFeature[] features = this.classInfo.getAllPersistentFeatures();
        int i = 0;
        while (i < features.length) {
            EStructuralFeature feature = features[i];
            if (feature instanceof EReference || FeatureMapUtil.isFeatureMap((EStructuralFeature)feature)) {
                if (feature.isMany()) {
                    InternalCDOList list = (InternalCDOList)this.getValueAsList(i);
                    if (list != null) {
                        list.adjustReferences(revisionAdjuster, feature);
                    }
                } else {
                    CDOType type = CDOModelUtil.getType(feature);
                    this.setValue(i, type.adjustReferences(revisionAdjuster, this.getValue(i)));
                }
            }
            ++i;
        }
    }

    public String toString() {
        return String.valueOf(this.getEClass().getName()) + "@" + this.id + "v" + this.version;
    }

    @Override
    public Object getValue(EStructuralFeature feature) {
        return this.convertValue(feature, this.basicGet(feature));
    }

    @Override
    public Object setValue(EStructuralFeature feature, Object value) {
        return this.convertValue(feature, this.basicSet(feature, value));
    }

    protected Object convertValue(EStructuralFeature feature, Object value) {
        if (value == null) {
            value = feature.getDefaultValue();
            if (value != null) {
                CDOType type = CDOModelUtil.getType(feature);
                value = type.convertToCDO(feature.getEType(), value);
            }
        } else if (value == InternalCDORevision.NIL) {
            value = null;
        }
        return value;
    }

    protected Object basicGet(EStructuralFeature feature) {
        int featureIndex = this.classInfo.getFeatureIndex(feature);
        return this.getValue(featureIndex);
    }

    protected Object basicSet(EStructuralFeature feature, Object value) {
        int featureIndex = this.classInfo.getFeatureIndex(feature);
        try {
            Object old = this.getValue(featureIndex);
            this.setValue(featureIndex, value);
            return old;
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            throw new IllegalArgumentException(MessageFormat.format(Messages.getString("AbstractCDORevision.20"), feature, this.classInfo), ex);
        }
    }

    @Override
    public CDOList getList(EStructuralFeature feature) {
        return this.getList(feature, 0);
    }

    @Override
    public CDOList getList(EStructuralFeature feature, int size) {
        int featureIndex = this.classInfo.getFeatureIndex(feature);
        CDOList list = (CDOList)this.getValue(featureIndex);
        if (list == null && size != -1) {
            list = CDOListFactory.DEFAULT.createList(size, 0, 0);
            this.setValue(featureIndex, (Object)list);
        }
        return list;
    }

    @Override
    public void setList(EStructuralFeature feature, InternalCDOList list) {
        int featureIndex = this.classInfo.getFeatureIndex(feature);
        this.setValue(featureIndex, (Object)list);
    }

    @Override
    public void setListSize(EStructuralFeature feature, int size) {
        CDOList list = this.getList(feature, size);
        int j = list.size();
        while (j < size) {
            list.add(InternalCDOList.UNINITIALIZED);
            ++j;
        }
    }

    protected abstract void initValues(EStructuralFeature[] var1);

    protected abstract Object getValue(int var1);

    protected abstract void setValue(int var1, Object var2);

    private CDOList getValueAsList(int i) {
        return (CDOList)this.getValue(i);
    }

    private void readValues(CDODataInput in) throws IOException {
        EClass owner = this.getEClass();
        EStructuralFeature[] features = this.classInfo.getAllPersistentFeatures();
        this.initValues(features);
        int i = 0;
        while (i < features.length) {
            Object value;
            EStructuralFeature feature = features[i];
            if (feature.isMany()) {
                value = in.readCDOList(owner, feature);
            } else {
                value = in.readCDOFeatureValue(feature);
                if (TRACER.isEnabled()) {
                    TRACER.format("Read feature {0}: {1}", new Object[]{feature.getName(), value});
                }
            }
            this.setValue(i, value);
            ++i;
        }
    }

    private void writeValues(CDODataOutput out, int referenceChunk) throws IOException {
        EClass owner = this.getEClass();
        EStructuralFeature[] features = this.classInfo.getAllPersistentFeatures();
        int i = 0;
        while (i < features.length) {
            EStructuralFeature feature = features[i];
            if (feature.isMany()) {
                CDOList list = this.getValueAsList(i);
                out.writeCDOList(owner, feature, list, referenceChunk);
            } else {
                AbstractCDORevision.checkNoFeatureMap(feature);
                Object value = this.getValue(i);
                if (value != null && feature instanceof EReference) {
                    value = out.getIDProvider().provideCDOID(value);
                }
                if (TRACER.isEnabled()) {
                    TRACER.format("Writing feature {0}: {1}", new Object[]{feature.getName(), value});
                }
                out.writeCDOFeatureValue(feature, value);
            }
            ++i;
        }
    }

    public static void checkNoFeatureMap(EStructuralFeature feature) {
        if (FeatureMapUtil.isFeatureMap((EStructuralFeature)feature)) {
            throw new ImplementationError("Single-valued feature maps not handled, yet.");
        }
    }

    public static Object remapID(Object value, Map<CDOIDTemp, CDOID> idMappings) {
        CDOIDTemp oldID;
        if (value instanceof CDOIDTemp && !(oldID = (CDOIDTemp)value).isNull()) {
            CDOID newID = idMappings.get(oldID);
            if (newID == null) {
                throw new IllegalStateException(MessageFormat.format(Messages.getString("AbstractCDORevision.2"), oldID));
            }
            if (TRACER.isEnabled()) {
                TRACER.format("Adjusting ID: {0} --> {1}", new Object[]{oldID, newID});
            }
            return newID;
        }
        return value;
    }
}

