/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.common.model;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.impl.EPackageImpl;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.xmi.impl.EcoreResourceFactoryImpl;
import org.eclipse.net4j.util.WrappedException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class EMFUtil {
    private EMFUtil() {
    }

    public static EPackage getGeneratedEPackage(EPackage ePackage) {
        String packageURI = ePackage.getNsURI();
        if (packageURI.equals(EcorePackage.eINSTANCE.getNsURI())) {
            return EcorePackage.eINSTANCE;
        }
        EPackage.Registry registry = EPackage.Registry.INSTANCE;
        return registry.getEPackage(packageURI);
    }

    public static Map.Entry<String, Object>[] getSortedRegistryEntries(EPackage.Registry packageRegistry) {
        Set entries = packageRegistry.entrySet();
        Map.Entry[] array = entries.toArray(new Map.Entry[entries.size()]);
        Arrays.sort(array, new Comparator<Map.Entry<String, Object>>(){

            @Override
            public int compare(Map.Entry<String, Object> o1, Map.Entry<String, Object> o2) {
                return o1.getKey().compareTo(o2.getKey());
            }
        });
        return array;
    }

    public static EPackage getTopLevelPackage(EPackage ePackage) {
        EPackage superPackage = ePackage.getESuperPackage();
        return superPackage == null ? ePackage : EMFUtil.getTopLevelPackage(superPackage);
    }

    public static EPackage createEPackage(String name, String nsPrefix, String nsURI) {
        EPackage ePackage = EcoreFactory.eINSTANCE.createEPackage();
        ePackage.setName(name);
        ePackage.setNsPrefix(nsPrefix);
        ePackage.setNsURI(nsURI);
        return ePackage;
    }

    public static EClass createEClass(EPackage ePackage, String name, boolean isAbstract, boolean isInterface) {
        EClass eClass = EcoreFactory.eINSTANCE.createEClass();
        eClass.setName(name);
        eClass.setAbstract(isAbstract);
        eClass.setInterface(isInterface);
        ePackage.getEClassifiers().add((Object)eClass);
        return eClass;
    }

    public static EAttribute createEAttribute(EClass eClass, String name, EClassifier type) {
        EAttribute eAttribute = EcoreFactory.eINSTANCE.createEAttribute();
        eAttribute.setName(name);
        eAttribute.setEType(type);
        eClass.getEStructuralFeatures().add((Object)eAttribute);
        return eAttribute;
    }

    public static EReference createEReference(EClass eClass, String name, EClassifier type, boolean isRequired, boolean isMany) {
        EReference eReference = EcoreFactory.eINSTANCE.createEReference();
        eReference.setName(name);
        eReference.setEType(type);
        eReference.setLowerBound(isRequired ? 1 : 0);
        eReference.setUpperBound(isMany ? -1 : 0);
        eClass.getEStructuralFeatures().add((Object)eReference);
        return eReference;
    }

    public static EClass[] getPersistentClasses(EPackage ePackage) {
        ArrayList<EClass> result = new ArrayList<EClass>();
        for (EClassifier classifier : ePackage.getEClassifiers()) {
            if (!(classifier instanceof EClass)) continue;
            result.add((EClass)classifier);
        }
        return result.toArray(new EClass[result.size()]);
    }

    public static List<EStructuralFeature> getPersistentFeatures(EList<EStructuralFeature> eFeatures) {
        ArrayList<EStructuralFeature> result = new ArrayList<EStructuralFeature>();
        for (EStructuralFeature feature : eFeatures) {
            if (feature.isTransient() || feature == EcorePackage.eINSTANCE.getEClass_ESuperTypes() || feature == EcorePackage.eINSTANCE.getETypedElement_EType() || feature == EcorePackage.eINSTANCE.getEOperation_EExceptions()) continue;
            result.add(feature);
        }
        return result;
    }

    public static boolean isDynamicEPackage(Object value) {
        return value.getClass() == EPackageImpl.class;
    }

    public static String getParentURI(EPackage ePackage) {
        EPackage superPackage = ePackage.getESuperPackage();
        String parentURI = superPackage == null ? null : superPackage.getNsURI();
        return parentURI;
    }

    public static void registerPackage(EPackage ePackage, EPackage.Registry ... packageRegistries) {
        ePackage.getClass();
        if (packageRegistries == null || packageRegistries.length == 0) {
            EPackage.Registry[] globalRegistry = new EPackage.Registry[]{EPackage.Registry.INSTANCE};
            packageRegistries = globalRegistry;
        }
        EPackage.Registry[] registryArray = packageRegistries;
        int n = packageRegistries.length;
        int n2 = 0;
        while (n2 < n) {
            EPackage.Registry packageRegistry = registryArray[n2];
            packageRegistry.put((Object)ePackage.getNsURI(), (Object)ePackage);
            ++n2;
        }
    }

    public static byte[] getEPackageBytes(EPackage ePackage, boolean zipped, EPackage.Registry packageRegistry) {
        try {
            Resource resource = ePackage.eResource();
            if (resource == null) {
                resource = EMFUtil.createEcoreResource(ePackage.getNsURI(), packageRegistry);
                resource.getContents().add((Object)ePackage);
            }
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            resource.save((OutputStream)baos, EMFUtil.createResourceOptions(zipped));
            return baos.toByteArray();
        }
        catch (Exception ex) {
            throw WrappedException.wrap((Exception)ex);
        }
    }

    public static EPackage createEPackage(String uri, byte[] bytes, boolean zipped, EPackage.Registry packageRegistry) {
        try {
            ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
            Resource resource = EMFUtil.createEcoreResource(uri, packageRegistry);
            resource.load((InputStream)bais, EMFUtil.createResourceOptions(zipped));
            EList contents = resource.getContents();
            return (EPackage)contents.get(0);
        }
        catch (Exception ex) {
            throw WrappedException.wrap((Exception)ex);
        }
    }

    private static Resource createEcoreResource(String uri, EPackage.Registry packageRegistry) {
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        resourceSet.setPackageRegistry(packageRegistry);
        EcoreResourceFactoryImpl resourceFactory = new EcoreResourceFactoryImpl();
        resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put("*", resourceFactory);
        resourceSet.getResourceFactoryRegistry().getProtocolToFactoryMap().put("*", resourceFactory);
        return resourceSet.createResource(URI.createURI((String)uri));
    }

    private static Map<String, Object> createResourceOptions(boolean zipped) {
        HashMap<String, Object> options = new HashMap<String, Object>();
        if (zipped) {
            options.put("ZIP", true);
        }
        return options;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addAdapter(Notifier notifier, Adapter adapter) {
        Notifier notifier2 = notifier;
        synchronized (notifier2) {
            EList adapters = notifier.eAdapters();
            if (!adapters.contains((Object)adapter)) {
                adapters.add((Object)adapter);
            }
        }
    }

    public static EPackage[] getAllPackages(EPackage ePackage) {
        ArrayList<EPackage> result = new ArrayList<EPackage>();
        EMFUtil.getAllPackages(ePackage, result);
        return result.toArray(new EPackage[result.size()]);
    }

    private static void getAllPackages(EPackage ePackage, List<EPackage> result) {
        result.add(ePackage);
        for (EPackage subPackage : ePackage.getESubpackages()) {
            EMFUtil.getAllPackages(subPackage, result);
        }
    }

    public static String getQualifiedName(EPackage ePackage, String separator) {
        StringBuilder builder = new StringBuilder();
        EPackage eSuperPackage = ePackage.getESuperPackage();
        if (eSuperPackage != null) {
            builder.append(EMFUtil.getQualifiedName(eSuperPackage, separator));
            builder.append(separator);
        }
        builder.append(ePackage.getName());
        return builder.toString();
    }

    public static String getQualifiedName(EClassifier classifier, String separator) {
        StringBuilder builder = new StringBuilder();
        EPackage ePackage = classifier.getEPackage();
        if (ePackage != null) {
            builder.append(EMFUtil.getQualifiedName(ePackage, separator));
            builder.append(separator);
        }
        builder.append(classifier.getName());
        return builder.toString();
    }

    public static ResourceSet newResourceSet(Resource.Factory resourceFactory) {
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put("*", resourceFactory);
        return resourceSet;
    }

    public static ResourceSet newEcoreResourceSet(EPackage.Registry packageRegistry) {
        ResourceSet resourceSet = EMFUtil.newResourceSet((Resource.Factory)new EcoreResourceFactoryImpl());
        resourceSet.setPackageRegistry(packageRegistry);
        return resourceSet;
    }

    public static ResourceSet newEcoreResourceSet() {
        return EMFUtil.newEcoreResourceSet(EPackage.Registry.INSTANCE);
    }
}

