/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.common.model;

import java.io.IOException;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.id.CDOIDObjectFactory;
import org.eclipse.emf.cdo.common.id.CDOIDUtil;
import org.eclipse.emf.cdo.common.model.CDOType;
import org.eclipse.net4j.util.io.ExtendedDataInput;
import org.eclipse.net4j.util.io.ExtendedDataOutput;

public abstract class CDOTypeImpl
implements CDOType {
    public static Map<Integer, CDOTypeImpl> ids = new HashMap<Integer, CDOTypeImpl>();
    private static final byte BOOLEAN_DEFAULT_PRIMITIVE = 0;
    private static final char CHARACTER_DEFAULT_PRIMITIVE = '\u0000';
    private static final short SHORT_DEFAULT_PRIMITIVE = 0;
    public static final Boolean BOOLEAN_DEFAULT = new Boolean(false);
    public static final Byte BYTE_DEFAULT = new Byte(0);
    public static final Character CHARACTER_DEFAULT = new Character('\u0000');
    public static final Double DOUBLE_DEFAULT = new Double(0.0);
    public static final Float FLOAT_DEFAULT = new Float(0.0);
    public static final Integer INTEGER_DEFAULT = new Integer(0);
    public static final Long LONG_DEFAULT = new Long(0L);
    public static final Short SHORT_DEFAULT = new Short(0);
    public static final CDOType BOOLEAN = new CDOTypeImpl("BOOLEAN", 22, false, BOOLEAN_DEFAULT){

        public void writeValue(ExtendedDataOutput out, Object value) throws IOException {
            boolean v = (Boolean)(value == null ? this.getDefaultValue() : value);
            out.writeBoolean(v);
        }

        public Object readValue(ExtendedDataInput in, CDOIDObjectFactory factory) throws IOException {
            boolean v = in.readBoolean();
            return new Boolean(v);
        }
    };
    public static final CDOType BYTE = new CDOTypeImpl("BYTE", 24, false, BYTE_DEFAULT){

        public void writeValue(ExtendedDataOutput out, Object value) throws IOException {
            out.writeByte((int)((Byte)(value == null ? this.getDefaultValue() : value)).byteValue());
        }

        public Object readValue(ExtendedDataInput in, CDOIDObjectFactory factory) throws IOException {
            return new Byte(in.readByte());
        }
    };
    public static final CDOType CHAR = new CDOTypeImpl("CHAR", 27, false, CHARACTER_DEFAULT){

        public void writeValue(ExtendedDataOutput out, Object value) throws IOException {
            out.writeChar((int)((Character)(value == null ? this.getDefaultValue() : value)).charValue());
        }

        public Object readValue(ExtendedDataInput in, CDOIDObjectFactory factory) throws IOException {
            return new Character(in.readChar());
        }
    };
    public static final CDOType DOUBLE = new CDOTypeImpl("DOUBLE", 31, false, DOUBLE_DEFAULT){

        public void writeValue(ExtendedDataOutput out, Object value) throws IOException {
            out.writeDouble(((Double)(value == null ? this.getDefaultValue() : value)).doubleValue());
        }

        public Object readValue(ExtendedDataInput in, CDOIDObjectFactory factory) throws IOException {
            return new Double(in.readDouble());
        }
    };
    public static final CDOType FLOAT = new CDOTypeImpl("FLOAT", 37, false, FLOAT_DEFAULT){

        public void writeValue(ExtendedDataOutput out, Object value) throws IOException {
            out.writeFloat(((Float)(value == null ? this.getDefaultValue() : value)).floatValue());
        }

        public Object readValue(ExtendedDataInput in, CDOIDObjectFactory factory) throws IOException {
            return new Float(in.readFloat());
        }
    };
    public static final CDOType INT = new CDOTypeImpl("INT", 39, false, INTEGER_DEFAULT){

        public void writeValue(ExtendedDataOutput out, Object value) throws IOException {
            out.writeInt(((Integer)(value == null ? this.getDefaultValue() : value)).intValue());
        }

        public Object readValue(ExtendedDataInput in, CDOIDObjectFactory factory) throws IOException {
            return new Integer(in.readInt());
        }
    };
    public static final CDOType LONG = new CDOTypeImpl("LONG", 43, false, LONG_DEFAULT){

        public void writeValue(ExtendedDataOutput out, Object value) throws IOException {
            out.writeLong(((Long)(value == null ? this.getDefaultValue() : value)).longValue());
        }

        public Object readValue(ExtendedDataInput in, CDOIDObjectFactory factory) throws IOException {
            return new Long(in.readLong());
        }
    };
    public static final CDOType SHORT = new CDOTypeImpl("SHORT", 48, false, SHORT_DEFAULT){

        public void writeValue(ExtendedDataOutput out, Object value) throws IOException {
            out.writeShort((int)((Short)(value == null ? this.getDefaultValue() : value)).shortValue());
        }

        public Object readValue(ExtendedDataInput in, CDOIDObjectFactory factory) throws IOException {
            return new Short(in.readShort());
        }
    };
    public static final CDOType OBJECT = new CDOTypeImpl("OBJECT", 10, true, CDOID.NULL){

        public void writeValue(ExtendedDataOutput out, Object value) throws IOException {
            CDOIDUtil.write(out, (CDOID)value);
        }

        public Object readValue(ExtendedDataInput in, CDOIDObjectFactory factory) throws IOException {
            return CDOIDUtil.read(in, factory);
        }
    };
    public static final CDOType BOOLEAN_OBJECT = new ObjectType("BOOLEAN_OBJECT", 23){

        protected void doWriteValue(ExtendedDataOutput out, Object value) throws IOException {
            out.writeBoolean(((Boolean)value).booleanValue());
        }

        protected Object doReadValue(ExtendedDataInput in) throws IOException {
            return in.readBoolean();
        }
    };
    public static final CDOType BYTE_OBJECT = new ObjectType("BYTE_OBJECT", 26){

        protected void doWriteValue(ExtendedDataOutput out, Object value) throws IOException {
            out.writeByte((int)((Byte)value).byteValue());
        }

        protected Object doReadValue(ExtendedDataInput in) throws IOException {
            return in.readByte();
        }
    };
    public static final CDOType CHARACTER_OBJECT = new ObjectType("CHARACTER_OBJECT", 28){

        protected void doWriteValue(ExtendedDataOutput out, Object value) throws IOException {
            out.writeChar((int)((Character)value).charValue());
        }

        protected Object doReadValue(ExtendedDataInput in) throws IOException {
            return Character.valueOf(in.readChar());
        }
    };
    public static final CDOType DATE = new ObjectType("DATE", 29){

        protected void doWriteValue(ExtendedDataOutput out, Object value) throws IOException {
            out.writeLong(((Date)value).getTime());
        }

        protected Object doReadValue(ExtendedDataInput in) throws IOException {
            return new Date(in.readLong());
        }
    };
    public static final CDOType DOUBLE_OBJECT = new ObjectType("DOUBLE_OBJECT", 32){

        protected void doWriteValue(ExtendedDataOutput out, Object value) throws IOException {
            out.writeDouble(((Double)value).doubleValue());
        }

        protected Object doReadValue(ExtendedDataInput in) throws IOException {
            return in.readDouble();
        }
    };
    public static final CDOType FLOAT_OBJECT = new ObjectType("FLOAT_OBJECT", 38){

        protected void doWriteValue(ExtendedDataOutput out, Object value) throws IOException {
            out.writeFloat(((Float)value).floatValue());
        }

        protected Object doReadValue(ExtendedDataInput in) throws IOException {
            return Float.valueOf(in.readFloat());
        }
    };
    public static final CDOType INTEGER_OBJECT = new ObjectType("INTEGER_OBJECT", 40){

        protected void doWriteValue(ExtendedDataOutput out, Object value) throws IOException {
            out.writeInt(((Integer)value).intValue());
        }

        protected Object doReadValue(ExtendedDataInput in) throws IOException {
            return in.readInt();
        }
    };
    public static final CDOType LONG_OBJECT = new ObjectType("LONG_OBJECT", 44){

        protected void doWriteValue(ExtendedDataOutput out, Object value) throws IOException {
            out.writeLong(((Long)value).longValue());
        }

        protected Object doReadValue(ExtendedDataInput in) throws IOException {
            return in.readLong();
        }
    };
    public static final CDOType SHORT_OBJECT = new ObjectType("SHORT_OBJECT", 49){

        protected void doWriteValue(ExtendedDataOutput out, Object value) throws IOException {
            out.writeShort((int)((Short)value).shortValue());
        }

        protected Object doReadValue(ExtendedDataInput in) throws IOException {
            return in.readShort();
        }
    };
    public static final CDOType STRING = new CDOTypeImpl("STRING", 50, true){

        public Object copyValue(Object value) {
            return (String)value;
        }

        public void writeValue(ExtendedDataOutput out, Object value) throws IOException {
            out.writeString((String)value);
        }

        public Object readValue(ExtendedDataInput in, CDOIDObjectFactory factory) throws IOException {
            return in.readString();
        }
    };
    public static final CDOType BYTE_ARRAY = new CDOTypeImpl("BYTE_ARRAY", 25, true){

        public Object copyValue(Object value) {
            if (value == null) {
                return null;
            }
            byte[] array = (byte[])value;
            byte[] result = new byte[array.length];
            System.arraycopy(value, 0, result, 0, array.length);
            return result;
        }

        public void writeValue(ExtendedDataOutput out, Object value) throws IOException {
            out.writeByteArray((byte[])value);
        }

        public Object readValue(ExtendedDataInput in, CDOIDObjectFactory factory) throws IOException {
            return in.readByteArray();
        }
    };
    public static final CDOType CUSTOM = new CDOTypeImpl("CUSTOM", 999, true){

        public Object copyValue(Object value) {
            return (String)value;
        }

        public void writeValue(ExtendedDataOutput out, Object value) throws IOException {
            out.writeString((String)value);
        }

        public Object readValue(ExtendedDataInput in, CDOIDObjectFactory factory) throws IOException {
            return in.readString();
        }
    };
    private String name;
    private int typeID;
    private boolean canBeNull;
    private Object defaultValue;

    private CDOTypeImpl(String name, int typeID, boolean canBeNull, Object defaultValue) {
        this.name = name;
        this.typeID = typeID;
        this.canBeNull = canBeNull;
        this.defaultValue = defaultValue;
        ids.put(typeID, this);
    }

    private CDOTypeImpl(String name, int typeID, boolean canBeNull) {
        this(name, typeID, canBeNull, (Object)null);
    }

    public String getName() {
        return this.name;
    }

    public int getTypeID() {
        return this.typeID;
    }

    public boolean canBeNull() {
        return this.canBeNull;
    }

    public Object getDefaultValue() {
        return this.defaultValue;
    }

    public String toString() {
        return this.name;
    }

    public Object copyValue(Object value) {
        return value == null ? this.getDefaultValue() : value;
    }

    public void write(ExtendedDataOutput out) throws IOException {
        out.writeInt(this.typeID);
    }

    /* synthetic */ CDOTypeImpl(String string, int n, boolean bl, Object object, CDOTypeImpl cDOTypeImpl) {
        this(string, n, bl, object);
    }

    /* synthetic */ CDOTypeImpl(String string, int n, boolean bl, CDOTypeImpl cDOTypeImpl) {
        this(string, n, bl);
    }

    private static abstract class ObjectType
    extends CDOTypeImpl {
        public ObjectType(String name, int typeID) {
            super(name, typeID, true, null);
        }

        public final void writeValue(ExtendedDataOutput out, Object value) throws IOException {
            if (value == null) {
                out.writeBoolean(false);
            } else {
                out.writeBoolean(true);
                this.doWriteValue(out, value);
            }
        }

        protected abstract void doWriteValue(ExtendedDataOutput var1, Object var2) throws IOException;

        public final Object readValue(ExtendedDataInput in, CDOIDObjectFactory factory) throws IOException {
            boolean notNull = in.readBoolean();
            if (notNull) {
                return this.doReadValue(in);
            }
            return null;
        }

        protected abstract Object doReadValue(ExtendedDataInput var1) throws IOException;
    }
}

