/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.common.model;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.cdo.common.id.CDOIDMetaRange;
import org.eclipse.emf.cdo.common.id.CDOIDUtil;
import org.eclipse.emf.cdo.common.model.CDOClass;
import org.eclipse.emf.cdo.common.model.CDOModelUtil;
import org.eclipse.emf.cdo.common.model.CDOPackage;
import org.eclipse.emf.cdo.common.model.CDOPackageManager;
import org.eclipse.emf.cdo.internal.common.bundle.OM;
import org.eclipse.emf.cdo.internal.common.model.CDOModelElementImpl;
import org.eclipse.emf.cdo.internal.common.model.CDOPackageManagerImpl;
import org.eclipse.emf.cdo.spi.common.InternalCDOClass;
import org.eclipse.emf.cdo.spi.common.InternalCDOPackage;
import org.eclipse.net4j.util.ObjectUtil;
import org.eclipse.net4j.util.io.ExtendedDataInput;
import org.eclipse.net4j.util.io.ExtendedDataOutput;
import org.eclipse.net4j.util.om.trace.ContextTracer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CDOPackageImpl
extends CDOModelElementImpl
implements InternalCDOPackage {
    private static final ContextTracer MODEL = new ContextTracer(OM.DEBUG_MODEL, CDOPackageImpl.class);
    private static final ContextTracer PROTOCOL = new ContextTracer(OM.DEBUG_PROTOCOL, CDOPackageImpl.class);
    private CDOPackageManager packageManager;
    private String packageURI;
    private List<CDOClass> classes;
    private List<CDOClass> index;
    private String ecore;
    private boolean dynamic;
    private CDOIDMetaRange metaIDRange;
    private String parentURI;
    private transient boolean persistent = true;

    public CDOPackageImpl() {
    }

    public CDOPackageImpl(CDOPackageManager packageManager, String packageURI, String name, String ecore, boolean dynamic, CDOIDMetaRange metaIDRange, String parentURI) {
        super(name);
        this.packageManager = packageManager;
        this.packageURI = packageURI;
        this.ecore = ecore;
        this.dynamic = dynamic;
        this.metaIDRange = metaIDRange;
        this.parentURI = parentURI;
        if (MODEL.isEnabled()) {
            MODEL.format("Created {0}", new Object[]{this});
        }
        this.createLists();
    }

    public CDOPackageImpl(CDOPackageManager packageManager, ExtendedDataInput in) throws IOException {
        this.packageManager = packageManager;
        this.createLists();
        this.read(in);
    }

    public CDOPackageImpl(CDOPackageManager packageManager, String packageURI, boolean dynamic, CDOIDMetaRange metaIDRange, String parentURI) {
        this.packageManager = packageManager;
        this.packageURI = packageURI;
        this.dynamic = dynamic;
        this.metaIDRange = metaIDRange;
        this.parentURI = parentURI;
        if (MODEL.isEnabled()) {
            MODEL.format("Created proxy package {0}, dynamic={1}, metaIDRange={2}, parentURI={3}", new Object[]{packageURI, dynamic, metaIDRange, packageURI});
        }
    }

    @Override
    public void read(ExtendedDataInput in) throws IOException {
        super.read(in);
        this.packageURI = in.readString();
        this.dynamic = in.readBoolean();
        this.ecore = in.readString();
        this.metaIDRange = CDOIDUtil.readMetaRange(in);
        this.parentURI = in.readString();
        if (PROTOCOL.isEnabled()) {
            PROTOCOL.format("Read package: URI={0}, name={1}, dynamic={2}, metaIDRange={3}, parentURI={4}", new Object[]{this.packageURI, this.getName(), this.dynamic, this.metaIDRange, this.parentURI});
        }
        int size = in.readInt();
        if (PROTOCOL.isEnabled()) {
            PROTOCOL.format("Reading {0} classes", new Object[]{size});
        }
        int i = 0;
        while (i < size) {
            CDOClass cdoClass = CDOModelUtil.readClass(this, in);
            this.addClass(cdoClass);
            ++i;
        }
    }

    @Override
    public void write(ExtendedDataOutput out) throws IOException {
        this.resolve();
        if (PROTOCOL.isEnabled()) {
            PROTOCOL.format("Writing package: URI={0}, name={1}, dynamic={2}, metaIDRange={3}, parentURI={4}", new Object[]{this.packageURI, this.getName(), this.dynamic, this.metaIDRange, this.parentURI});
        }
        super.write(out);
        out.writeString(this.packageURI);
        out.writeBoolean(this.dynamic);
        out.writeString(this.ecore);
        CDOIDUtil.writeMetaRange(out, this.metaIDRange);
        out.writeString(this.parentURI);
        int size = this.classes.size();
        if (PROTOCOL.isEnabled()) {
            PROTOCOL.format("Writing {0} classes", new Object[]{size});
        }
        out.writeInt(size);
        for (CDOClass cdoClass : this.classes) {
            CDOModelUtil.writeClass(out, cdoClass);
        }
    }

    @Override
    public void setPackageManager(CDOPackageManager packageManager) {
        this.packageManager = packageManager;
    }

    @Override
    public CDOPackageManager getPackageManager() {
        return this.packageManager;
    }

    @Override
    public String getParentURI() {
        return this.parentURI;
    }

    public void setParentURI(String parentURI) {
        this.parentURI = parentURI;
    }

    @Override
    public CDOPackage getTopLevelPackage() {
        CDOPackage parentPackage = this.getParentPackage();
        return parentPackage == null ? this : parentPackage.getTopLevelPackage();
    }

    @Override
    public CDOPackage getParentPackage() {
        return this.packageManager.lookupPackage(this.parentURI);
    }

    @Override
    public CDOPackage[] getSubPackages(boolean recursive) {
        ArrayList<CDOPackage> result = new ArrayList<CDOPackage>();
        CDOPackage[] allPackages = this.packageManager.getPackages();
        this.getSubPackages(this, allPackages, result, recursive);
        return result.toArray(new CDOPackage[result.size()]);
    }

    private void getSubPackages(CDOPackage parentPackage, CDOPackage[] allPackages, List<CDOPackage> result, boolean recursive) {
        CDOPackage[] cDOPackageArray = allPackages;
        int n = allPackages.length;
        int n2 = 0;
        while (n2 < n) {
            CDOPackage cdoPackage = cDOPackageArray[n2];
            if (ObjectUtil.equals((Object)cdoPackage.getParentURI(), (Object)parentPackage.getPackageURI())) {
                result.add(cdoPackage);
                if (recursive) {
                    this.getSubPackages(cdoPackage, allPackages, result, true);
                }
            }
            ++n2;
        }
    }

    @Override
    public String getPackageURI() {
        return this.packageURI;
    }

    public void setPackageURI(String packageURI) {
        this.packageURI = packageURI;
    }

    @Override
    public int getClassCount() {
        this.resolve();
        return this.classes.size();
    }

    @Override
    public CDOClass[] getClasses() {
        this.resolve();
        return this.classes.toArray(new CDOClass[this.classes.size()]);
    }

    @Override
    public void setClasses(List<CDOClass> classes) {
        this.classes = classes;
        for (CDOClass cdoClass : classes) {
            ((InternalCDOClass)cdoClass).setContainingPackage(this);
            this.setIndex(cdoClass.getClassifierID(), cdoClass);
        }
    }

    @Override
    public CDOClass[] getConcreteClasses() {
        this.resolve();
        ArrayList<CDOClass> result = new ArrayList<CDOClass>(0);
        for (CDOClass cdoClass : this.classes) {
            if (cdoClass.isAbstract()) continue;
            result.add(cdoClass);
        }
        return result.toArray(new CDOClass[result.size()]);
    }

    @Override
    public CDOClass lookupClass(int classifierID) {
        this.resolve();
        return this.index.get(classifierID);
    }

    @Override
    public String getEcore() {
        if (this.ecore == null && this.packageManager instanceof CDOPackageManagerImpl && this.parentURI == null) {
            this.ecore = ((CDOPackageManagerImpl)this.packageManager).provideEcore(this);
        }
        return this.ecore;
    }

    @Override
    public void setEcore(String ecore) {
        this.ecore = ecore;
    }

    @Override
    public CDOIDMetaRange getMetaIDRange() {
        return this.metaIDRange;
    }

    @Override
    public void setMetaIDRange(CDOIDMetaRange metaIDRange) {
        this.metaIDRange = metaIDRange;
    }

    @Override
    public boolean isDynamic() {
        return this.dynamic;
    }

    public void setDynamic(boolean dynamic) {
        this.dynamic = dynamic;
    }

    @Override
    public boolean isSystem() {
        return false;
    }

    @Override
    public boolean isProxy() {
        return this.classes == null;
    }

    @Override
    public boolean isPersistent() {
        return this.persistent;
    }

    @Override
    public void setPersistent(boolean persistent) {
        this.persistent = persistent;
    }

    @Override
    public void addClass(CDOClass cdoClass) {
        int classifierID = cdoClass.getClassifierID();
        if (MODEL.isEnabled()) {
            MODEL.format("Adding class: {0}", new Object[]{cdoClass});
        }
        this.setIndex(classifierID, cdoClass);
        this.classes.add(cdoClass);
    }

    @Override
    public int compareTo(CDOPackage that) {
        return this.getPackageURI().compareTo(that.getPackageURI());
    }

    public String toString() {
        return MessageFormat.format("CDOPackage(URI={0}, name={1}, dynamic={2}, metaIDRange={3}, parentURI={4})", this.packageURI, this.getName(), this.dynamic, this.metaIDRange, this.parentURI);
    }

    @Override
    protected void onInitialize() {
        for (CDOClass cdoClass : this.classes) {
            ((InternalCDOClass)cdoClass).initialize();
        }
    }

    private void setIndex(int classifierID, CDOClass cdoClass) {
        while (classifierID >= this.index.size()) {
            this.index.add(null);
        }
        this.index.set(classifierID, cdoClass);
    }

    private void resolve() {
        if (this.classes == null && this.packageManager instanceof CDOPackageManagerImpl) {
            this.createLists();
            ((CDOPackageManagerImpl)this.packageManager).resolve(this);
        }
    }

    private void createLists() {
        this.classes = new ArrayList<CDOClass>(0);
        this.index = new ArrayList<CDOClass>(0);
    }
}

