/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.common.model;

import java.io.IOException;
import org.eclipse.emf.cdo.internal.common.bundle.OM;
import org.eclipse.emf.cdo.spi.common.InternalCDOModelElement;
import org.eclipse.net4j.util.ImplementationError;
import org.eclipse.net4j.util.io.ExtendedDataInput;
import org.eclipse.net4j.util.io.ExtendedDataOutput;
import org.eclipse.net4j.util.om.trace.ContextTracer;

public abstract class CDOModelElementImpl
implements InternalCDOModelElement {
    private static final ContextTracer MODEL = new ContextTracer(OM.DEBUG_MODEL, CDOModelElementImpl.class);
    private String name;
    private Object clientInfo;
    private Object serverInfo;
    private boolean initialized;

    protected CDOModelElementImpl(String name) {
        this.name = name;
    }

    protected CDOModelElementImpl() {
    }

    public void read(ExtendedDataInput in) throws IOException {
        this.name = in.readString();
    }

    public void write(ExtendedDataOutput out) throws IOException {
        out.writeString(this.name);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Object getClientInfo() {
        return this.clientInfo;
    }

    public void setClientInfo(Object clientInfo) {
        if (MODEL.isEnabled()) {
            MODEL.format("Setting client info: {0} --> {1}", new Object[]{this, clientInfo});
        }
        this.clientInfo = clientInfo;
    }

    public Object getServerInfo() {
        return this.serverInfo;
    }

    public void setServerInfo(Object serverInfo) {
        if (MODEL.isEnabled()) {
            MODEL.format("Setting server info: {0} --> {1}", new Object[]{this, serverInfo});
        }
        this.serverInfo = serverInfo;
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public final void initialize() {
        if (this.initialized) {
            throw new ImplementationError("Duplicate initialization");
        }
        this.initialized = true;
        this.onInitialize();
    }

    protected abstract void onInitialize();
}

