/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xsd.impl;

import java.math.BigDecimal;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.xsd.XSDAnnotation;
import org.eclipse.xsd.XSDConcreteComponent;
import org.eclipse.xsd.XSDDiagnostic;
import org.eclipse.xsd.XSDFactory;
import org.eclipse.xsd.XSDFixedFacet;
import org.eclipse.xsd.XSDFractionDigitsFacet;
import org.eclipse.xsd.XSDPackage;
import org.eclipse.xsd.XSDSimpleTypeDefinition;
import org.eclipse.xsd.XSDTotalDigitsFacet;
import org.eclipse.xsd.impl.XSDFixedFacetImpl;
import org.eclipse.xsd.util.XSDConstants;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class XSDFractionDigitsFacetImpl
extends XSDFixedFacetImpl
implements XSDFractionDigitsFacet {
    protected static final int VALUE_EDEFAULT = 0;
    protected int value = 0;

    public static XSDFractionDigitsFacet createFractionDigitsFacet(Node node) {
        if (XSDConstants.nodeType(node) == 15) {
            XSDFractionDigitsFacet xsdFractionDigitsFacet = XSDFactory.eINSTANCE.createXSDFractionDigitsFacet();
            xsdFractionDigitsFacet.setElement((Element)node);
            return xsdFractionDigitsFacet;
        }
        return null;
    }

    protected XSDFractionDigitsFacetImpl() {
    }

    protected EClass eStaticClass() {
        return XSDPackage.Literals.XSD_FRACTION_DIGITS_FACET;
    }

    public int getValue() {
        return this.value;
    }

    public void setValue(int newValue) {
        int oldValue = this.value;
        this.value = newValue;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 11, oldValue, this.value));
        }
    }

    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 11: {
                return this.getValue();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 11: {
                this.setValue((Integer)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    public void eUnset(int featureID) {
        switch (featureID) {
            case 11: {
                this.setValue(0);
                return;
            }
        }
        super.eUnset(featureID);
    }

    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 11: {
                return this.value != 0;
            }
        }
        return super.eIsSet(featureID);
    }

    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (value: ");
        result.append(this.value);
        result.append(')');
        return result.toString();
    }

    public Element createElement() {
        Element newElement = this.createElement(15);
        this.setElement(newElement);
        return newElement;
    }

    public void validate() {
        super.validate();
        XSDSimpleTypeDefinition xsdSimpleTypeDefinition = this.getSimpleTypeDefinition();
        XSDTotalDigitsFacet xsdTotalDigitsFacet = xsdSimpleTypeDefinition.getTotalDigitsFacet();
        if (xsdTotalDigitsFacet != null && this.getValue() > xsdTotalDigitsFacet.getValue()) {
            XSDDiagnostic xsdDiagnostic = this.reportConstraintViolation("http://www.w3.org/TR/xmlschema-2/", "fractionDigits-less-than-equal-to-totalDigits", this.getElement(), "value", new Object[]{this.getValue(), xsdTotalDigitsFacet.getValue()});
            xsdDiagnostic.getComponents().add((Object)xsdTotalDigitsFacet);
        }
    }

    protected void validateValue() {
        this.checkBuiltInTypeConstraint("nonNegativeInteger", this.getLexicalValue(), "http://www.w3.org/TR/xmlschema-2/", "element-totalDigits", this.getElement(), "value", true);
    }

    protected void validateRestriction(XSDFixedFacet xsdFixedFacet) {
        if (this.getValue() > ((XSDFractionDigitsFacet)xsdFixedFacet).getValue()) {
            XSDDiagnostic xsdDiagnostic = this.reportConstraintViolation("http://www.w3.org/TR/xmlschema-2/", "fractionDigits-valid-restriction", this.getElement(), "value", new Object[]{this.getValue(), xsdFixedFacet.getEffectiveValue(), xsdFixedFacet.getSimpleTypeDefinition().getURI()});
            xsdDiagnostic.getComponents().add((Object)xsdFixedFacet);
        }
    }

    protected void changeAttribute(EAttribute eAttribute) {
        super.changeAttribute(eAttribute);
        if (eAttribute == XSDPackage.Literals.XSD_FACET__LEXICAL_VALUE) {
            if (this.getLexicalValue() == null) {
                this.setValue(0);
            } else {
                try {
                    int newValue = Integer.parseInt(this.getLexicalValue());
                    if (newValue != this.getValue()) {
                        this.setValue(newValue);
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    this.setValue(0);
                }
            }
            this.traverseToRootForAnalysis();
        }
    }

    public boolean isConstraintSatisfied(Object value) {
        return value instanceof BigDecimal && ((BigDecimal)value).scale() <= this.getValue();
    }

    public Object getEffectiveValue() {
        return this.getValue();
    }

    public XSDConcreteComponent cloneConcreteComponent(boolean deep, boolean shareDOM) {
        XSDFractionDigitsFacetImpl clonedFractionDigitsFacet = (XSDFractionDigitsFacetImpl)this.getXSDFactory().createXSDFractionDigitsFacet();
        clonedFractionDigitsFacet.isReconciling = true;
        if (this.getLexicalValue() != null) {
            clonedFractionDigitsFacet.setLexicalValue(this.getLexicalValue());
        }
        if (this.isSetFixed()) {
            clonedFractionDigitsFacet.setFixed(this.isFixed());
        }
        if (deep && this.getAnnotation() != null) {
            clonedFractionDigitsFacet.setAnnotation((XSDAnnotation)this.getAnnotation().cloneConcreteComponent(deep, shareDOM));
        }
        if (shareDOM && this.getElement() != null) {
            clonedFractionDigitsFacet.setElement(this.getElement());
        }
        clonedFractionDigitsFacet.isReconciling = shareDOM;
        return clonedFractionDigitsFacet;
    }
}

