/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xsd.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.UniqueEList;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EDataTypeUniqueEList;
import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.EObjectEList;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.xsd.XSDAnnotation;
import org.eclipse.xsd.XSDAttributeDeclaration;
import org.eclipse.xsd.XSDAttributeGroupDefinition;
import org.eclipse.xsd.XSDComplexTypeDefinition;
import org.eclipse.xsd.XSDComponent;
import org.eclipse.xsd.XSDConcreteComponent;
import org.eclipse.xsd.XSDDiagnostic;
import org.eclipse.xsd.XSDDiagnosticSeverity;
import org.eclipse.xsd.XSDDisallowedSubstitutions;
import org.eclipse.xsd.XSDElementDeclaration;
import org.eclipse.xsd.XSDFactory;
import org.eclipse.xsd.XSDForm;
import org.eclipse.xsd.XSDIdentityConstraintDefinition;
import org.eclipse.xsd.XSDImport;
import org.eclipse.xsd.XSDInclude;
import org.eclipse.xsd.XSDModelGroupDefinition;
import org.eclipse.xsd.XSDNamedComponent;
import org.eclipse.xsd.XSDNotationDeclaration;
import org.eclipse.xsd.XSDPackage;
import org.eclipse.xsd.XSDPlugin;
import org.eclipse.xsd.XSDProhibitedSubstitutions;
import org.eclipse.xsd.XSDRedefine;
import org.eclipse.xsd.XSDRedefineContent;
import org.eclipse.xsd.XSDSchema;
import org.eclipse.xsd.XSDSchemaCompositor;
import org.eclipse.xsd.XSDSchemaContent;
import org.eclipse.xsd.XSDSchemaDirective;
import org.eclipse.xsd.XSDSimpleTypeDefinition;
import org.eclipse.xsd.XSDTypeDefinition;
import org.eclipse.xsd.impl.XSDConcreteComponentImpl;
import org.eclipse.xsd.impl.XSDImportImpl;
import org.eclipse.xsd.impl.XSDNamedComponentImpl;
import org.eclipse.xsd.impl.XSDSchemaContentImpl;
import org.eclipse.xsd.impl.XSDScopeImpl;
import org.eclipse.xsd.util.XSDConstants;
import org.eclipse.xsd.util.XSDParser;
import org.eclipse.xsd.util.XSDResourceFactoryImpl;
import org.eclipse.xsd.util.XSDResourceImpl;
import org.eclipse.xsd.util.XSDSwitch;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.events.Event;
import org.w3c.dom.events.EventListener;
import org.w3c.dom.events.EventTarget;
import org.w3c.dom.events.MutationEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XSDSchemaImpl
extends XSDScopeImpl
implements XSDSchema {
    protected static final Document DOCUMENT_EDEFAULT = null;
    protected Document document = DOCUMENT_EDEFAULT;
    protected static final String SCHEMA_LOCATION_EDEFAULT = null;
    protected String schemaLocation = SCHEMA_LOCATION_EDEFAULT;
    protected static final String TARGET_NAMESPACE_EDEFAULT = null;
    protected String targetNamespace = TARGET_NAMESPACE_EDEFAULT;
    protected static final XSDForm ATTRIBUTE_FORM_DEFAULT_EDEFAULT = XSDForm.UNQUALIFIED_LITERAL;
    protected XSDForm attributeFormDefault = ATTRIBUTE_FORM_DEFAULT_EDEFAULT;
    protected static final int ATTRIBUTE_FORM_DEFAULT_ESETFLAG = 256;
    protected static final XSDForm ELEMENT_FORM_DEFAULT_EDEFAULT = XSDForm.UNQUALIFIED_LITERAL;
    protected XSDForm elementFormDefault = ELEMENT_FORM_DEFAULT_EDEFAULT;
    protected static final int ELEMENT_FORM_DEFAULT_ESETFLAG = 512;
    protected EList<XSDProhibitedSubstitutions> finalDefault;
    protected EList<XSDDisallowedSubstitutions> blockDefault;
    protected static final String VERSION_EDEFAULT = null;
    protected String version = VERSION_EDEFAULT;
    protected EList<XSDSchemaContent> contents;
    protected EList<XSDElementDeclaration> elementDeclarations;
    protected EList<XSDAttributeDeclaration> attributeDeclarations;
    protected EList<XSDAttributeGroupDefinition> attributeGroupDefinitions;
    protected EList<XSDTypeDefinition> typeDefinitions;
    protected EList<XSDModelGroupDefinition> modelGroupDefinitions;
    protected EList<XSDIdentityConstraintDefinition> identityConstraintDefinitions;
    protected EList<XSDNotationDeclaration> notationDeclarations;
    protected EList<XSDAnnotation> annotations;
    protected EList<XSDDiagnostic> allDiagnostics;
    protected EList<XSDSchemaDirective> referencingDirectives;
    protected EList<XSDSchema> incorporatedVersions;
    protected static ResourceSet globalResourceSet;
    protected static XSDSchema xsdMagicSchemaForSchema2001;
    protected static XSDSchema xsdSchemaForSchema2001;
    protected static XSDSchema xsdSchemaInstance2001;
    protected static XSDSchema xsdMagicSchemaForSchema2000_10;
    protected static XSDSchema xsdSchemaForSchema2000_10;
    protected static XSDSchema xsdMagicSchemaForSchema1999;
    protected static XSDSchema xsdSchemaForSchema1999;
    protected Map<String, String> qNamePrefixToNamespaceMap = new HashMap<String, String>(){
        private static final long serialVersionUID = 1L;

        @Override
        public String put(String key, String value) {
            Element theElement;
            if ("".equals(key)) {
                throw new IllegalArgumentException("The default prefix should represented as null rather than as a zero length String");
            }
            if (value == null) {
                value = "";
            }
            String result = super.put(key, value);
            if (!XSDSchemaImpl.this.isReconciling && (theElement = XSDSchemaImpl.this.getElement()) != null) {
                String xmlnsAttribute = "xmlns";
                if (key != null) {
                    xmlnsAttribute = String.valueOf(xmlnsAttribute) + ":" + key;
                }
                theElement.setAttributeNS("http://www.w3.org/2000/xmlns/", xmlnsAttribute, value);
            }
            return result;
        }

        @Override
        public String get(Object key) {
            String result = (String)super.get(key);
            return "".equals(result) ? null : result;
        }

        @Override
        public String remove(Object key) {
            String result = (String)super.remove(key);
            if (!XSDSchemaImpl.this.isReconciling && result != null) {
                Element theElement;
                if (key == null) {
                    key = "xmlns";
                }
                if ((theElement = XSDSchemaImpl.this.getElement()) != null && theElement.hasAttributeNS("http://www.w3.org/2000/xmlns/", (String)key)) {
                    theElement.removeAttributeNS("http://www.w3.org/2000/xmlns/", (String)key);
                }
            }
            return result;
        }
    };
    protected String schemaForSchemaQNamePrefix;
    protected boolean hasRetargetedNamespace = false;
    protected Collection<XSDSchemaImpl> circularResolveDependencies;
    protected Map<String, XSDSimpleTypeDefinition> simpleTypeIdMap;
    protected List<XSDSchema> incorporatingSchemas;
    protected EventListener eventListener;
    protected Node deletionNode;
    protected boolean isIncrementalUpdate = true;
    protected String pendingSchemaLocation;
    protected List<XSDSchemaImpl> schemasToRedefine;
    protected Map<XSDComponent, XSDComponent> redefinitionMap = new HashMap<XSDComponent, XSDComponent>();

    public static XSDSchema createSchema(Node node) {
        XSDSchema xsdSchema = XSDFactory.eINSTANCE.createXSDSchema();
        String schemaForSchemaNamespace = node.getNamespaceURI();
        XSDSchemaImpl.getSchemaForSchema(schemaForSchemaNamespace);
        xsdSchema.setElement((Element)node);
        return xsdSchema;
    }

    public static synchronized XSDSchema createMetaSchema(Node node) {
        if (XSDConstants.nodeType(node) == 33) {
            XSDSchema xsdSchema = XSDFactory.eINSTANCE.createXSDSchema();
            String schemaForSchemaNamespace = node.getNamespaceURI();
            if ("http://www.w3.org/2001/XMLSchema".equals(schemaForSchemaNamespace)) {
                if (xsdMagicSchemaForSchema2001 == null) {
                    xsdMagicSchemaForSchema2001 = xsdSchema;
                } else if (xsdSchemaForSchema2001 == null) {
                    xsdSchemaForSchema2001 = xsdSchema;
                }
            } else if ("http://www.w3.org/2000/10/XMLSchema".equals(schemaForSchemaNamespace)) {
                if (xsdMagicSchemaForSchema2000_10 == null) {
                    xsdMagicSchemaForSchema2000_10 = xsdSchema;
                } else if (xsdSchemaForSchema2000_10 == null) {
                    xsdSchemaForSchema2000_10 = xsdSchema;
                }
            } else if ("http://www.w3.org/1999/XMLSchema".equals(schemaForSchemaNamespace)) {
                if (xsdMagicSchemaForSchema1999 == null) {
                    xsdMagicSchemaForSchema1999 = xsdSchema;
                } else if (xsdSchemaForSchema1999 == null) {
                    xsdSchemaForSchema1999 = xsdSchema;
                }
            }
            xsdSchema.setElement((Element)node);
            return xsdSchema;
        }
        return null;
    }

    public static synchronized ResourceSet getGlobalResourceSet() {
        if (globalResourceSet == null) {
            globalResourceSet = XSDSchemaImpl.createResourceSet();
            String baseURL = XSDPlugin.INSTANCE.getBaseURL().toString();
            globalResourceSet.getURIConverter().getURIMap().put(URI.createURI((String)"http://www.w3.org/2001/xml.xsd"), URI.createURI((String)(String.valueOf(baseURL) + "cache/www.w3.org/2001/xml.xsd")));
        }
        return globalResourceSet;
    }

    public static ResourceSet createResourceSet() {
        ResourceSetImpl result = new ResourceSetImpl();
        result.getResourceFactoryRegistry().getExtensionToFactoryMap().put("xsd", new XSDResourceFactoryImpl());
        return result;
    }

    public static synchronized XSDSchema getMagicSchemaForSchema(String namespace) {
        if ("http://www.w3.org/2001/XMLSchema".equals(namespace)) {
            if (xsdMagicSchemaForSchema2001 == null) {
                try {
                    try {
                        String baseURL = XSDPlugin.INSTANCE.getBaseURL().toString();
                        XSDSchemaImpl.getGlobalResourceSet().getLoadOptions().put("XSD_MAGIC_XML_SCHEMA", "http://www.w3.org/2001/XMLSchema");
                        XSDSchemaImpl.getGlobalResourceSet().getResource(URI.createURI((String)(String.valueOf(baseURL) + "cache/www.w3.org/2001/MagicXMLSchema.xsd")), true);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                        XSDSchemaImpl.getGlobalResourceSet().getLoadOptions().remove("XSD_MAGIC_XML_SCHEMA");
                    }
                }
                finally {
                    XSDSchemaImpl.getGlobalResourceSet().getLoadOptions().remove("XSD_MAGIC_XML_SCHEMA");
                }
            }
            return xsdMagicSchemaForSchema2001;
        }
        if ("http://www.w3.org/2000/10/XMLSchema".equals(namespace)) {
            if (xsdMagicSchemaForSchema2000_10 == null) {
                try {
                    try {
                        String baseURL = XSDPlugin.INSTANCE.getBaseURL().toString();
                        XSDSchemaImpl.getGlobalResourceSet().getLoadOptions().put("XSD_MAGIC_XML_SCHEMA", "http://www.w3.org/2000/10/XMLSchema");
                        XSDSchemaImpl.getGlobalResourceSet().getResource(URI.createURI((String)(String.valueOf(baseURL) + "cache/www.w3.org/2000/10/MagicXMLSchema.xsd")), true);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                        XSDSchemaImpl.getGlobalResourceSet().getLoadOptions().remove("XSD_MAGIC_XML_SCHEMA");
                    }
                }
                finally {
                    XSDSchemaImpl.getGlobalResourceSet().getLoadOptions().remove("XSD_MAGIC_XML_SCHEMA");
                }
            }
            return xsdMagicSchemaForSchema2000_10;
        }
        if ("http://www.w3.org/1999/XMLSchema".equals(namespace)) {
            if (xsdMagicSchemaForSchema1999 == null) {
                try {
                    try {
                        String baseURL = XSDPlugin.INSTANCE.getBaseURL().toString();
                        XSDSchemaImpl.getGlobalResourceSet().getLoadOptions().put("XSD_MAGIC_XML_SCHEMA", "http://www.w3.org/1999/XMLSchema");
                        XSDSchemaImpl.getGlobalResourceSet().getResource(URI.createURI((String)(String.valueOf(baseURL) + "cache/www.w3.org/1999/MagicXMLSchema.xsd")), true);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                        XSDSchemaImpl.getGlobalResourceSet().getLoadOptions().remove("XSD_MAGIC_XML_SCHEMA");
                    }
                }
                finally {
                    XSDSchemaImpl.getGlobalResourceSet().getLoadOptions().remove("XSD_MAGIC_XML_SCHEMA");
                }
            }
            return xsdMagicSchemaForSchema1999;
        }
        return null;
    }

    public static synchronized XSDSchema getSchemaForSchema(String namespace) {
        if ("http://www.w3.org/2001/XMLSchema".equals(namespace)) {
            if (xsdSchemaForSchema2001 == null) {
                try {
                    try {
                        String baseURL = XSDPlugin.INSTANCE.getBaseURL().toString();
                        XSDSchemaImpl.getMagicSchemaForSchema(namespace);
                        XSDSchemaImpl.getGlobalResourceSet().getLoadOptions().put("XSD_XML_SCHEMA", "http://www.w3.org/2001/XMLSchema");
                        XSDSchemaImpl.getGlobalResourceSet().getResource(URI.createURI((String)(String.valueOf(baseURL) + "cache/www.w3.org/2001/XMLSchema.xsd")), true);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                        XSDSchemaImpl.getGlobalResourceSet().getLoadOptions().remove("XSD_XML_SCHEMA");
                    }
                }
                finally {
                    XSDSchemaImpl.getGlobalResourceSet().getLoadOptions().remove("XSD_XML_SCHEMA");
                }
            }
            return xsdSchemaForSchema2001;
        }
        if ("http://www.w3.org/2000/10/XMLSchema".equals(namespace)) {
            if (xsdSchemaForSchema2000_10 == null) {
                try {
                    try {
                        String baseURL = XSDPlugin.INSTANCE.getBaseURL().toString();
                        XSDSchemaImpl.getMagicSchemaForSchema(namespace);
                        XSDSchemaImpl.getGlobalResourceSet().getLoadOptions().put("XSD_XML_SCHEMA", "http://www.w3.org/2000/10/XMLSchema");
                        XSDSchemaImpl.getGlobalResourceSet().getResource(URI.createURI((String)(String.valueOf(baseURL) + "cache/www.w3.org/2000/10/XMLSchema.xsd")), true);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                        XSDSchemaImpl.getGlobalResourceSet().getLoadOptions().remove("XSD_XML_SCHEMA");
                    }
                }
                finally {
                    XSDSchemaImpl.getGlobalResourceSet().getLoadOptions().remove("XSD_XML_SCHEMA");
                }
            }
            return xsdSchemaForSchema2000_10;
        }
        if ("http://www.w3.org/1999/XMLSchema".equals(namespace)) {
            if (xsdSchemaForSchema1999 == null) {
                try {
                    try {
                        String baseURL = XSDPlugin.INSTANCE.getBaseURL().toString();
                        XSDSchemaImpl.getMagicSchemaForSchema(namespace);
                        XSDSchemaImpl.getGlobalResourceSet().getLoadOptions().put("XSD_XML_SCHEMA", "http://www.w3.org/1999/XMLSchema");
                        XSDSchemaImpl.getGlobalResourceSet().getResource(URI.createURI((String)(String.valueOf(baseURL) + "cache/www.w3.org/1999/XMLSchema.xsd")), true);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                        XSDSchemaImpl.getGlobalResourceSet().getLoadOptions().remove("XSD_XML_SCHEMA");
                    }
                }
                finally {
                    XSDSchemaImpl.getGlobalResourceSet().getLoadOptions().remove("XSD_XML_SCHEMA");
                }
            }
            return xsdSchemaForSchema1999;
        }
        return null;
    }

    public static synchronized XSDSchema getSchemaInstance(String namespace) {
        if ("http://www.w3.org/2001/XMLSchema-instance".equals(namespace)) {
            if (xsdSchemaInstance2001 == null) {
                try {
                    try {
                        String baseURL = XSDPlugin.INSTANCE.getBaseURL().toString();
                        XSDSchemaImpl.getSchemaForSchema("http://www.w3.org/2001/XMLSchema");
                        XSDSchemaImpl.getGlobalResourceSet().getLoadOptions().put("XSD_SCHEMA_INSTANCE", "http://www.w3.org/2001/XMLSchema-instance");
                        Resource schemaInstance2001Resource = XSDSchemaImpl.getGlobalResourceSet().getResource(URI.createURI((String)(String.valueOf(baseURL) + "cache/www.w3.org/2001/XMLSchema-instance.xsd")), true);
                        xsdSchemaInstance2001 = ((XSDResourceImpl)schemaInstance2001Resource).getSchema();
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                        XSDSchemaImpl.getGlobalResourceSet().getLoadOptions().remove("XSD_SCHEMA_INSTANCE");
                    }
                }
                finally {
                    XSDSchemaImpl.getGlobalResourceSet().getLoadOptions().remove("XSD_SCHEMA_INSTANCE");
                }
            }
            return xsdSchemaInstance2001;
        }
        return null;
    }

    protected XSDSchemaImpl() {
    }

    @Override
    protected EClass eStaticClass() {
        return XSDPackage.Literals.XSD_SCHEMA;
    }

    @Override
    public Document getDocument() {
        return this.document;
    }

    @Override
    public void setDocument(Document newDocument) {
        Document oldDocument = this.document;
        this.document = newDocument;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 5, (Object)oldDocument, (Object)this.document));
        }
    }

    @Override
    public String getSchemaLocation() {
        return this.schemaLocation;
    }

    @Override
    public void setSchemaLocation(String newSchemaLocation) {
        String oldSchemaLocation = this.schemaLocation;
        this.schemaLocation = newSchemaLocation;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 6, (Object)oldSchemaLocation, (Object)this.schemaLocation));
        }
    }

    @Override
    public String getTargetNamespace() {
        return this.targetNamespace;
    }

    @Override
    public void setTargetNamespace(String newTargetNamespace) {
        String oldTargetNamespace = this.targetNamespace;
        this.targetNamespace = newTargetNamespace;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 7, (Object)oldTargetNamespace, (Object)this.targetNamespace));
        }
    }

    @Override
    public XSDForm getAttributeFormDefault() {
        return this.attributeFormDefault;
    }

    @Override
    public void setAttributeFormDefault(XSDForm newAttributeFormDefault) {
        XSDForm oldAttributeFormDefault = this.attributeFormDefault;
        this.attributeFormDefault = newAttributeFormDefault == null ? ATTRIBUTE_FORM_DEFAULT_EDEFAULT : newAttributeFormDefault;
        boolean oldAttributeFormDefaultESet = (this.eFlags & 0x100) != 0;
        this.eFlags |= 0x100;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 8, (Object)oldAttributeFormDefault, (Object)this.attributeFormDefault, !oldAttributeFormDefaultESet));
        }
    }

    @Override
    public void unsetAttributeFormDefault() {
        XSDForm oldAttributeFormDefault = this.attributeFormDefault;
        boolean oldAttributeFormDefaultESet = (this.eFlags & 0x100) != 0;
        this.attributeFormDefault = ATTRIBUTE_FORM_DEFAULT_EDEFAULT;
        this.eFlags &= 0xFFFFFEFF;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 2, 8, (Object)oldAttributeFormDefault, (Object)ATTRIBUTE_FORM_DEFAULT_EDEFAULT, oldAttributeFormDefaultESet));
        }
    }

    @Override
    public boolean isSetAttributeFormDefault() {
        return (this.eFlags & 0x100) != 0;
    }

    @Override
    public XSDForm getElementFormDefault() {
        return this.elementFormDefault;
    }

    @Override
    public void setElementFormDefault(XSDForm newElementFormDefault) {
        XSDForm oldElementFormDefault = this.elementFormDefault;
        this.elementFormDefault = newElementFormDefault == null ? ELEMENT_FORM_DEFAULT_EDEFAULT : newElementFormDefault;
        boolean oldElementFormDefaultESet = (this.eFlags & 0x200) != 0;
        this.eFlags |= 0x200;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 9, (Object)oldElementFormDefault, (Object)this.elementFormDefault, !oldElementFormDefaultESet));
        }
    }

    @Override
    public void unsetElementFormDefault() {
        XSDForm oldElementFormDefault = this.elementFormDefault;
        boolean oldElementFormDefaultESet = (this.eFlags & 0x200) != 0;
        this.elementFormDefault = ELEMENT_FORM_DEFAULT_EDEFAULT;
        this.eFlags &= 0xFFFFFDFF;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 2, 9, (Object)oldElementFormDefault, (Object)ELEMENT_FORM_DEFAULT_EDEFAULT, oldElementFormDefaultESet));
        }
    }

    @Override
    public boolean isSetElementFormDefault() {
        return (this.eFlags & 0x200) != 0;
    }

    @Override
    public EList<XSDProhibitedSubstitutions> getFinalDefault() {
        if (this.finalDefault == null) {
            this.finalDefault = new EDataTypeUniqueEList.Unsettable(XSDProhibitedSubstitutions.class, (InternalEObject)this, 10);
        }
        return this.finalDefault;
    }

    @Override
    public void unsetFinalDefault() {
        if (this.finalDefault != null) {
            ((InternalEList.Unsettable)this.finalDefault).unset();
        }
    }

    @Override
    public boolean isSetFinalDefault() {
        return this.finalDefault != null && ((InternalEList.Unsettable)this.finalDefault).isSet();
    }

    @Override
    public EList<XSDDisallowedSubstitutions> getBlockDefault() {
        if (this.blockDefault == null) {
            this.blockDefault = new EDataTypeUniqueEList.Unsettable(XSDDisallowedSubstitutions.class, (InternalEObject)this, 11);
        }
        return this.blockDefault;
    }

    @Override
    public void unsetBlockDefault() {
        if (this.blockDefault != null) {
            ((InternalEList.Unsettable)this.blockDefault).unset();
        }
    }

    @Override
    public boolean isSetBlockDefault() {
        return this.blockDefault != null && ((InternalEList.Unsettable)this.blockDefault).isSet();
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    @Override
    public void setVersion(String newVersion) {
        String oldVersion = this.version;
        this.version = newVersion;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 12, (Object)oldVersion, (Object)this.version));
        }
    }

    @Override
    public EList<XSDSchemaContent> getContents() {
        if (this.contents == null) {
            this.contents = new EObjectContainmentEList(XSDSchemaContent.class, (InternalEObject)this, 13);
        }
        return this.contents;
    }

    @Override
    public EList<XSDElementDeclaration> getElementDeclarations() {
        if (this.elementDeclarations == null) {
            this.elementDeclarations = new XSDNamedComponentImpl.XSDNamedComponentList(XSDElementDeclaration.class, this, 14);
        }
        return this.elementDeclarations;
    }

    @Override
    public EList<XSDAttributeDeclaration> getAttributeDeclarations() {
        if (this.attributeDeclarations == null) {
            this.attributeDeclarations = new XSDNamedComponentImpl.XSDNamedComponentList(XSDAttributeDeclaration.class, this, 15);
        }
        return this.attributeDeclarations;
    }

    @Override
    public EList<XSDAttributeGroupDefinition> getAttributeGroupDefinitions() {
        if (this.attributeGroupDefinitions == null) {
            this.attributeGroupDefinitions = new XSDNamedComponentImpl.XSDNamedComponentList(XSDAttributeGroupDefinition.class, this, 16);
        }
        return this.attributeGroupDefinitions;
    }

    @Override
    public EList<XSDTypeDefinition> getTypeDefinitions() {
        if (this.typeDefinitions == null) {
            this.typeDefinitions = new XSDNamedComponentImpl.XSDNamedComponentList(XSDTypeDefinition.class, this, 17);
        }
        return this.typeDefinitions;
    }

    @Override
    public EList<XSDModelGroupDefinition> getModelGroupDefinitions() {
        if (this.modelGroupDefinitions == null) {
            this.modelGroupDefinitions = new XSDNamedComponentImpl.XSDNamedComponentList(XSDModelGroupDefinition.class, this, 18);
        }
        return this.modelGroupDefinitions;
    }

    @Override
    public EList<XSDIdentityConstraintDefinition> getIdentityConstraintDefinitions() {
        if (this.identityConstraintDefinitions == null) {
            this.identityConstraintDefinitions = new XSDNamedComponentImpl.XSDNamedComponentList(XSDIdentityConstraintDefinition.class, this, 19);
        }
        return this.identityConstraintDefinitions;
    }

    @Override
    public EList<XSDNotationDeclaration> getNotationDeclarations() {
        if (this.notationDeclarations == null) {
            this.notationDeclarations = new XSDNamedComponentImpl.XSDNamedComponentList(XSDNotationDeclaration.class, this, 20);
        }
        return this.notationDeclarations;
    }

    @Override
    public EList<XSDAnnotation> getAnnotations() {
        if (this.annotations == null) {
            this.annotations = new EObjectEList(XSDAnnotation.class, (InternalEObject)this, 21);
        }
        return this.annotations;
    }

    @Override
    public EList<XSDDiagnostic> getAllDiagnostics() {
        if (this.allDiagnostics == null) {
            this.allDiagnostics = new EObjectEList(XSDDiagnostic.class, (InternalEObject)this, 22);
        }
        return this.allDiagnostics;
    }

    @Override
    public EList<XSDSchemaDirective> getReferencingDirectives() {
        if (this.referencingDirectives == null) {
            this.referencingDirectives = new EObjectEList(XSDSchemaDirective.class, (InternalEObject)this, 23);
        }
        return this.referencingDirectives;
    }

    public boolean hasRetargetedNamespace() {
        return this.hasRetargetedNamespace;
    }

    @Override
    public XSDSchema getOriginalVersion() {
        for (XSDSchemaDirective xsdSchemaDirective : this.getReferencingDirectives()) {
            XSDSchemaCompositor xsdSchemaCompositor;
            if (!(xsdSchemaDirective instanceof XSDSchemaCompositor) || (xsdSchemaCompositor = (XSDSchemaCompositor)xsdSchemaDirective).getResolvedSchema() == xsdSchemaCompositor.getIncorporatedSchema()) continue;
            return xsdSchemaCompositor.getResolvedSchema();
        }
        return this;
    }

    @Override
    public EList<XSDSchema> getIncorporatedVersions() {
        if (this.incorporatedVersions == null) {
            this.incorporatedVersions = new EObjectContainmentEList(XSDSchema.class, (InternalEObject)this, 26);
        }
        return this.incorporatedVersions;
    }

    @Override
    public XSDSchema getRootVersion() {
        XSDSchema result = this;
        XSDSchema originalVersion = result.getOriginalVersion();
        while (result != originalVersion) {
            result = originalVersion;
            originalVersion = result.getOriginalVersion();
        }
        return result;
    }

    @Override
    public Map<String, String> getQNamePrefixToNamespaceMap() {
        return this.qNamePrefixToNamespaceMap;
    }

    @Override
    public String getSchemaForSchemaQNamePrefix() {
        return this.schemaForSchemaQNamePrefix;
    }

    @Override
    public void setSchemaForSchemaQNamePrefix(String qNamePrefix) {
        String oldSchemaForSchemaQNamePrefix = this.schemaForSchemaQNamePrefix;
        String oldSchemaForSchemaNamespace = this.getSchemaForSchemaNamespace();
        this.schemaForSchemaQNamePrefix = qNamePrefix;
        String newSchemaForSchemaNamespace = this.getSchemaForSchemaNamespace();
        if (XSDConstants.isSchemaForSchemaNamespace(oldSchemaForSchemaNamespace) && !XSDConstants.isSchemaForSchemaNamespace(newSchemaForSchemaNamespace)) {
            this.getQNamePrefixToNamespaceMap().remove(oldSchemaForSchemaQNamePrefix);
            this.getQNamePrefixToNamespaceMap().put(qNamePrefix, oldSchemaForSchemaNamespace);
            if (this.getElement() != null && XSDConstants.isSchemaForSchemaNamespace(this.getSchemaForSchemaNamespace())) {
                this.updatePrefix(this.getElement(), this.getSchemaForSchemaNamespace(), oldSchemaForSchemaQNamePrefix, qNamePrefix);
                this.updateElement();
            }
        }
    }

    @Override
    public String getSchemaForSchemaNamespace() {
        return this.getQNamePrefixToNamespaceMap().get(this.getSchemaForSchemaQNamePrefix());
    }

    @Override
    public String getStringBlockDefault() {
        if (this.isSetBlockDefault()) {
            StringBuffer result = new StringBuffer();
            for (Object literal : this.getBlockDefault()) {
                if (result.length() != 0) {
                    result.append(' ');
                }
                if (literal.toString().equals("all")) {
                    result.append("#all");
                    continue;
                }
                result.append(literal);
            }
            return result.toString();
        }
        return null;
    }

    @Override
    public void setStringBlockDefault(String blockDefault) {
        if (blockDefault == null) {
            this.unsetBlockDefault();
        } else {
            ArrayList<XSDDisallowedSubstitutions> newBlockDefault = new ArrayList<XSDDisallowedSubstitutions>();
            StringTokenizer stringTokenizer = new StringTokenizer(blockDefault);
            while (stringTokenizer.hasMoreTokens()) {
                XSDDisallowedSubstitutions literal;
                String token = stringTokenizer.nextToken();
                if (token.equals("#all")) {
                    token = "all";
                }
                if ((literal = XSDDisallowedSubstitutions.get(token)) == null) continue;
                newBlockDefault.add(literal);
            }
            if (!newBlockDefault.equals(this.getBlockDefault())) {
                ArrayList<XSDDisallowedSubstitutions> oldContents = new ArrayList<XSDDisallowedSubstitutions>((Collection<XSDDisallowedSubstitutions>)this.getBlockDefault());
                oldContents.removeAll(newBlockDefault);
                this.getBlockDefault().removeAll(oldContents);
                XSDSchemaImpl.setListContentAndOrder(this.getBlockDefault(), newBlockDefault);
            } else if (newBlockDefault.isEmpty() && !this.isSetBlockDefault()) {
                this.getBlockDefault().clear();
            }
        }
    }

    @Override
    public String getStringFinalDefault() {
        if (this.isSetFinalDefault()) {
            StringBuffer result = new StringBuffer();
            for (Object literal : this.getFinalDefault()) {
                if (result.length() != 0) {
                    result.append(' ');
                }
                if (literal.toString().equals("all")) {
                    result.append("#all");
                    continue;
                }
                result.append(literal);
            }
            return result.toString();
        }
        return null;
    }

    @Override
    public void setStringFinalDefault(String finalDefault) {
        if (finalDefault == null) {
            this.unsetFinalDefault();
        } else {
            ArrayList<XSDProhibitedSubstitutions> newFinalDefault = new ArrayList<XSDProhibitedSubstitutions>();
            StringTokenizer stringTokenizer = new StringTokenizer(finalDefault);
            while (stringTokenizer.hasMoreTokens()) {
                XSDProhibitedSubstitutions literal;
                String token = stringTokenizer.nextToken();
                if (token.equals("#all")) {
                    token = "all";
                }
                if ((literal = XSDProhibitedSubstitutions.get(token)) == null) continue;
                newFinalDefault.add(literal);
            }
            if (!newFinalDefault.equals(this.getFinalDefault())) {
                ArrayList<XSDProhibitedSubstitutions> oldContents = new ArrayList<XSDProhibitedSubstitutions>((Collection<XSDProhibitedSubstitutions>)this.getFinalDefault());
                oldContents.removeAll(newFinalDefault);
                this.getFinalDefault().removeAll(oldContents);
                XSDSchemaImpl.setListContentAndOrder(this.getFinalDefault(), newFinalDefault);
            } else if (newFinalDefault.isEmpty() && !this.isSetFinalDefault()) {
                this.getFinalDefault().clear();
            }
        }
    }

    @Override
    public Element createElement() {
        Element newElement = this.createElement(33);
        this.setElement(newElement);
        return newElement;
    }

    @Override
    protected void traverseToRootForPatching() {
        if (!this.isReconciling && this.isIncrementalUpdate) {
            this.isReconciling = true;
            this.patch();
            this.isReconciling = false;
        }
    }

    protected void computeSchemasToPatch(XSDSchema root, List<XSDSchema> schemasToPatch) {
        schemasToPatch.add(root);
        int i = 0;
        while (i < schemasToPatch.size()) {
            XSDSchema xsdSchema = schemasToPatch.get(i);
            for (XSDSchemaContent content : xsdSchema.getContents()) {
                if (content instanceof XSDSchemaDirective) {
                    XSDSchemaCompositor xsdSchemaCompositor;
                    XSDSchemaImpl xsdIncorporatedSchema;
                    if (!(content instanceof XSDSchemaCompositor) || (xsdIncorporatedSchema = (XSDSchemaImpl)(xsdSchemaCompositor = (XSDSchemaCompositor)content).getIncorporatedSchema()) == null || schemasToPatch.contains(xsdIncorporatedSchema)) continue;
                    xsdIncorporatedSchema.patchContents();
                    this.computeSchemasToPatch(xsdIncorporatedSchema, schemasToPatch);
                    continue;
                }
                if (!(content instanceof XSDAnnotation)) break;
            }
            ++i;
        }
    }

    @Override
    protected void patch() {
        this.circularResolveDependencies = new HashSet<XSDSchemaImpl>();
        if (XSDConstants.isSchemaForSchemaNamespace(this.getTargetNamespace())) {
            XSDSchema magicSchemaForSchema = XSDSchemaImpl.getMagicSchemaForSchema(this.getTargetNamespace());
            if (magicSchemaForSchema != this) {
                XSDNamedComponentImpl.addToSortedList(this.getTypeDefinitions(), (XSDTypeDefinition)magicSchemaForSchema.getTypeDefinitions().get(0));
            }
        } else {
            Collection<XSDSchema> xsiSchemas = this.resolveSchema("http://www.w3.org/2001/XMLSchema-instance");
            if (xsiSchemas.size() == 1) {
                XSDNamedComponentImpl.mergeToSortedList(this.getAttributeDeclarations(), xsiSchemas.iterator().next().getAttributeDeclarations());
            }
        }
        Iterator i = this.getReferencingDirectives().iterator();
        while (i.hasNext()) {
            XSDSchemaDirective xsdSchemaDirective = (XSDSchemaDirective)i.next();
            if (xsdSchemaDirective.getContainer() != null && (xsdSchemaDirective.getResolvedSchema() == this || xsdSchemaDirective instanceof XSDSchemaCompositor && ((XSDSchemaCompositor)xsdSchemaDirective).getIncorporatedSchema() == this)) continue;
            i.remove();
        }
        super.patch();
        ArrayList<XSDSchema> schemasToPatch = new ArrayList<XSDSchema>();
        this.computeSchemasToPatch(this, schemasToPatch);
        if (this.circularResolveDependencies != null) {
            Collection<XSDSchemaImpl> localCircularResolveDependencies = this.circularResolveDependencies;
            this.circularResolveDependencies = null;
            for (XSDSchemaImpl circularSchema : localCircularResolveDependencies) {
                circularSchema.patch();
            }
        }
        if (this.schemaLocation != null) {
            int i2 = 0;
            int size = schemasToPatch.size();
            while (i2 < size) {
                XSDSchemaImpl xsdSchema = (XSDSchemaImpl)schemasToPatch.get(i2);
                xsdSchema.analyze();
                ++i2;
            }
        }
    }

    protected void patchContents() {
        this.incorporatingSchemas = null;
        super.patch();
    }

    @Override
    protected void traverseToRootForAnalysis() {
        if (!this.isReconciling && this.isIncrementalUpdate) {
            this.isReconciling = true;
            this.analyze();
            this.isReconciling = false;
        }
    }

    @Override
    protected boolean analyze() {
        return super.analyze();
    }

    @Override
    public void validate() {
        super.validate();
        Element theElement = this.getElement();
        if (theElement != null) {
            if (XSDConstants.nodeType(this.element) != 33) {
                this.createDiagnostic(XSDDiagnosticSeverity.ERROR_LITERAL, "content-valid.1", String.valueOf(this.element.getNamespaceURI() == null ? "" : this.element.getNamespaceURI()) + "#" + this.element.getLocalName(), XSDPlugin.INSTANCE.getString("_UI_XML_SCHEMA_name"), "schema");
            } else if (this.getContainer() == null || !this.eContainmentFeature().isTransient()) {
                this.checkAttributes("http://www.w3.org/TR/xmlschema-1/", "element-complexType", theElement, new String[]{"attributeFormDefault", "blockDefault", "elementFormDefault", "finalDefault", "id", "targetNamespace", "version"});
                XSDComplexTypeDefinition xsdComplexTypeDefinition = (XSDComplexTypeDefinition)this.getSchemaForSchema().resolveElementDeclaration("schema").getTypeDefinition();
                this.checkComplexContent(xsdComplexTypeDefinition, "http://www.w3.org/TR/xmlschema-1/", "element-schema", theElement);
                this.checkAttributeTypeConstraint(xsdComplexTypeDefinition, "attributeFormDefault", null, "http://www.w3.org/TR/xmlschema-1/", "element-schema", theElement, "attributeFormDefault", false);
                this.checkAttributeTypeConstraint(xsdComplexTypeDefinition, "blockDefault", null, "http://www.w3.org/TR/xmlschema-1/", "element-schema", theElement, "blockDefault", false);
                this.checkAttributeTypeConstraint(xsdComplexTypeDefinition, "elementFormDefault", null, "http://www.w3.org/TR/xmlschema-1/", "element-schema", theElement, "elementFormDefault", false);
                this.checkAttributeTypeConstraint(xsdComplexTypeDefinition, "finalDefault", null, "http://www.w3.org/TR/xmlschema-1/", "element-schema", theElement, "finalDefault", false);
                this.checkBuiltInTypeConstraint("ID", null, "http://www.w3.org/TR/xmlschema-1/", "element-schema", theElement, "id", false);
            }
        }
        if (this.getSchemaForSchema() != null) {
            this.checkBuiltInTypeConstraint("anyURI", this.getTargetNamespace(), "http://www.w3.org/TR/xmlschema-1/", "element-schema", theElement, "targetNamespace", false);
            this.checkBuiltInTypeConstraint("token", this.getVersion(), "http://www.w3.org/TR/xmlschema-1/", "element-schema", theElement, "version", false);
            this.validateNoDuplicates("attribute_noun", this.getAttributeDeclarations());
            this.validateNoDuplicates("attributeGroup_noun", this.getAttributeGroupDefinitions());
            this.validateNoDuplicates("modelGroup_noun", this.getModelGroupDefinitions());
            this.validateNoDuplicates("element_noun", this.getElementDeclarations());
            this.validateNoDuplicates("type_noun", this.getTypeDefinitions());
            this.validateNoDuplicates("identityConstraint_noun", this.getIdentityConstraintDefinitions());
            this.validateNoDuplicates("notation_noun", this.getNotationDeclarations());
        }
    }

    public void validateNoDuplicates(String componentNoun, EList<? extends XSDNamedComponent> xsdNamedComponents) {
        String name = null;
        String targetNamespace = null;
        for (XSDNamedComponent xsdNamedComponent : xsdNamedComponents) {
            if (xsdNamedComponent.hasNameAndTargetNamespace(name, targetNamespace)) {
                this.getDiagnosticTarget(xsdNamedComponent).createDiagnostic(XSDDiagnosticSeverity.ERROR_LITERAL, "coss-schema.2", XSDPlugin.INSTANCE.getString(componentNoun), xsdNamedComponent.getURI());
            }
            name = xsdNamedComponent.getName();
            targetNamespace = xsdNamedComponent.getTargetNamespace();
        }
    }

    protected void updateSortedList(XSDNamedComponent xsdNamedComponent) {
        new XSDSwitch<Object>(){

            @Override
            public Object caseXSDElementDeclaration(XSDElementDeclaration xsdElementDeclaration) {
                if (XSDSchemaImpl.this.getElementDeclarations().remove((Object)xsdElementDeclaration)) {
                    XSDNamedComponentImpl.addToSortedList(XSDSchemaImpl.this.getElementDeclarations(), xsdElementDeclaration);
                }
                return this;
            }

            @Override
            public Object caseXSDAttributeDeclaration(XSDAttributeDeclaration xsdAttributeDeclaration) {
                if (XSDSchemaImpl.this.getAttributeDeclarations().remove((Object)xsdAttributeDeclaration)) {
                    XSDNamedComponentImpl.addToSortedList(XSDSchemaImpl.this.getAttributeDeclarations(), xsdAttributeDeclaration);
                }
                return this;
            }

            @Override
            public Object caseXSDAttributeGroupDefinition(XSDAttributeGroupDefinition xsdAttributeGroupDefinition) {
                if (XSDSchemaImpl.this.getAttributeGroupDefinitions().remove((Object)xsdAttributeGroupDefinition)) {
                    XSDNamedComponentImpl.addToSortedList(XSDSchemaImpl.this.getAttributeGroupDefinitions(), xsdAttributeGroupDefinition);
                }
                return this;
            }

            @Override
            public Object caseXSDTypeDefinition(XSDTypeDefinition xsdTypeDefinition) {
                if (XSDSchemaImpl.this.getTypeDefinitions().remove((Object)xsdTypeDefinition)) {
                    XSDNamedComponentImpl.addToSortedList(XSDSchemaImpl.this.getTypeDefinitions(), xsdTypeDefinition);
                }
                return this;
            }

            @Override
            public Object caseXSDModelGroupDefinition(XSDModelGroupDefinition xsdModelGroupDefinition) {
                if (XSDSchemaImpl.this.getModelGroupDefinitions().remove((Object)xsdModelGroupDefinition)) {
                    XSDNamedComponentImpl.addToSortedList(XSDSchemaImpl.this.getModelGroupDefinitions(), xsdModelGroupDefinition);
                }
                return this;
            }

            @Override
            public Object caseXSDNotationDeclaration(XSDNotationDeclaration xsdNotationDeclaration) {
                if (XSDSchemaImpl.this.getNotationDeclarations().remove((Object)xsdNotationDeclaration)) {
                    XSDNamedComponentImpl.addToSortedList(XSDSchemaImpl.this.getNotationDeclarations(), xsdNotationDeclaration);
                }
                return this;
            }

            @Override
            public Object caseXSDIdentityConstraintDefinition(XSDIdentityConstraintDefinition xsdIdentityConstraintDefinition) {
                if (XSDSchemaImpl.this.getIdentityConstraintDefinitions().remove((Object)xsdIdentityConstraintDefinition)) {
                    XSDNamedComponentImpl.addToSortedList(XSDSchemaImpl.this.getIdentityConstraintDefinitions(), xsdIdentityConstraintDefinition);
                }
                return this;
            }
        }.doSwitch(xsdNamedComponent);
    }

    @Override
    protected void adoptContent(EReference eReference, XSDConcreteComponent xsdConcreteComponent) {
        super.adoptContent(eReference, xsdConcreteComponent);
        if (eReference == XSDPackage.Literals.XSD_SCHEMA__CONTENTS) {
            new XSDSwitch<Object>(){

                @Override
                public Object caseXSDElementDeclaration(XSDElementDeclaration xsdElementDeclaration) {
                    XSDNamedComponentImpl.addToSortedList(XSDSchemaImpl.this.getElementDeclarations(), xsdElementDeclaration);
                    return this;
                }

                @Override
                public Object caseXSDAttributeDeclaration(XSDAttributeDeclaration xsdAttributeDeclaration) {
                    XSDNamedComponentImpl.addToSortedList(XSDSchemaImpl.this.getAttributeDeclarations(), xsdAttributeDeclaration);
                    return this;
                }

                @Override
                public Object caseXSDAttributeGroupDefinition(XSDAttributeGroupDefinition xsdAttributeGroupDefinition) {
                    XSDNamedComponentImpl.addToSortedList(XSDSchemaImpl.this.getAttributeGroupDefinitions(), xsdAttributeGroupDefinition);
                    return this;
                }

                @Override
                public Object caseXSDTypeDefinition(XSDTypeDefinition xsdTypeDefinition) {
                    XSDNamedComponentImpl.addToSortedList(XSDSchemaImpl.this.getTypeDefinitions(), xsdTypeDefinition);
                    return this;
                }

                @Override
                public Object caseXSDModelGroupDefinition(XSDModelGroupDefinition xsdModelGroupDefinition) {
                    XSDNamedComponentImpl.addToSortedList(XSDSchemaImpl.this.getModelGroupDefinitions(), xsdModelGroupDefinition);
                    return this;
                }

                @Override
                public Object caseXSDNotationDeclaration(XSDNotationDeclaration xsdNotationDeclaration) {
                    XSDNamedComponentImpl.addToSortedList(XSDSchemaImpl.this.getNotationDeclarations(), xsdNotationDeclaration);
                    return this;
                }

                @Override
                public Object caseXSDAnnotation(XSDAnnotation xsdAnnotation) {
                    XSDSchemaImpl.this.getAnnotations().add((Object)xsdAnnotation);
                    return this;
                }
            }.doSwitch(xsdConcreteComponent);
            this.traverseToRootForPatching();
        }
    }

    @Override
    protected void orphanContent(EReference eReference, XSDConcreteComponent xsdConcreteComponent) {
        super.orphanContent(eReference, xsdConcreteComponent);
        if (eReference == XSDPackage.Literals.XSD_SCHEMA__CONTENTS) {
            new XSDSwitch<Object>(){

                @Override
                public Object caseXSDElementDeclaration(XSDElementDeclaration xsdElementDeclaration) {
                    XSDSchemaImpl.this.getElementDeclarations().remove((Object)xsdElementDeclaration);
                    return this;
                }

                @Override
                public Object caseXSDAttributeDeclaration(XSDAttributeDeclaration xsdAttributeDeclaration) {
                    XSDSchemaImpl.this.getAttributeDeclarations().remove((Object)xsdAttributeDeclaration);
                    return this;
                }

                @Override
                public Object caseXSDAttributeGroupDefinition(XSDAttributeGroupDefinition xsdAttributeGroupDefinition) {
                    XSDSchemaImpl.this.getAttributeGroupDefinitions().remove((Object)xsdAttributeGroupDefinition);
                    return this;
                }

                @Override
                public Object caseXSDTypeDefinition(XSDTypeDefinition xsdTypeDefinition) {
                    XSDSchemaImpl.this.getTypeDefinitions().remove((Object)xsdTypeDefinition);
                    return this;
                }

                @Override
                public Object caseXSDModelGroupDefinition(XSDModelGroupDefinition xsdModelGroupDefinition) {
                    XSDSchemaImpl.this.getModelGroupDefinitions().remove((Object)xsdModelGroupDefinition);
                    return this;
                }

                @Override
                public Object caseXSDNotationDeclaration(XSDNotationDeclaration xsdNotationDeclaration) {
                    XSDSchemaImpl.this.getNotationDeclarations().remove((Object)xsdNotationDeclaration);
                    return this;
                }

                @Override
                public Object caseXSDAnnotation(XSDAnnotation xsdAnnotation) {
                    XSDSchemaImpl.this.getAnnotations().remove((Object)xsdAnnotation);
                    return this;
                }
            }.doSwitch(xsdConcreteComponent);
            this.traverseToRootForPatching();
        }
    }

    @Override
    protected void reconcileAttributes(Element changedElement) {
        super.reconcileAttributes(changedElement);
        if (changedElement == this.getElement()) {
            if (changedElement.hasAttributeNS(null, "version")) {
                String newVersion = changedElement.getAttributeNS(null, "version");
                if (!newVersion.equals(this.getVersion())) {
                    this.setVersion(newVersion);
                }
            } else if (this.getVersion() != null) {
                this.setVersion(null);
            }
            if (changedElement.hasAttributeNS(null, "targetNamespace")) {
                String newTargetNamespace = changedElement.getAttributeNS(null, "targetNamespace");
                if (!newTargetNamespace.equals(this.getTargetNamespace())) {
                    this.setTargetNamespace(newTargetNamespace);
                }
            } else if (this.getTargetNamespace() != null) {
                this.setTargetNamespace(null);
            }
            if (changedElement.hasAttributeNS(null, "attributeFormDefault")) {
                XSDForm newAttributeFormDefault = XSDForm.get(changedElement.getAttributeNS(null, "attributeFormDefault"));
                if (!this.isSetAttributeFormDefault() || newAttributeFormDefault != this.getAttributeFormDefault()) {
                    this.setAttributeFormDefault(newAttributeFormDefault);
                }
            } else if (this.isSetAttributeFormDefault()) {
                this.unsetAttributeFormDefault();
            }
            if (changedElement.hasAttributeNS(null, "elementFormDefault")) {
                XSDForm newElementFormDefault = XSDForm.get(changedElement.getAttributeNS(null, "elementFormDefault"));
                if (!this.isSetElementFormDefault() || newElementFormDefault != this.getElementFormDefault()) {
                    this.setElementFormDefault(newElementFormDefault);
                }
            } else if (this.isSetElementFormDefault()) {
                this.unsetElementFormDefault();
            }
            if (changedElement.hasAttributeNS(null, "blockDefault")) {
                this.setStringBlockDefault(changedElement.getAttributeNS(null, "blockDefault"));
            } else if (this.isSetBlockDefault()) {
                this.unsetBlockDefault();
            }
            if (changedElement.hasAttributeNS(null, "finalDefault")) {
                this.setStringFinalDefault(changedElement.getAttributeNS(null, "finalDefault"));
            } else if (this.isSetFinalDefault()) {
                this.unsetFinalDefault();
            }
            Map<String, String> theQNamePrefixToNamespaceMap = this.getQNamePrefixToNamespaceMap();
            theQNamePrefixToNamespaceMap.clear();
            Element currentElement = changedElement;
            while (true) {
                NamedNodeMap attributes = currentElement.getAttributes();
                int i = 0;
                int size = attributes.getLength();
                while (i < size) {
                    Attr attr = (Attr)attributes.item(i);
                    String name = attr.getNodeName();
                    if (name.startsWith("xmlns")) {
                        String key;
                        String value = attr.getNodeValue();
                        int index = name.indexOf(":");
                        String string = key = index == -1 || index == name.length() - 1 ? null : name.substring(index + 1);
                        if (!theQNamePrefixToNamespaceMap.containsKey(key)) {
                            theQNamePrefixToNamespaceMap.put(key, value);
                        }
                    }
                    ++i;
                }
                Node parent = currentElement.getParentNode();
                if (!(parent instanceof Element)) break;
                currentElement = (Element)parent;
            }
            String nodeName = changedElement.getNodeName();
            int index = nodeName.indexOf(":");
            this.setSchemaForSchemaQNamePrefix(index == -1 ? null : nodeName.substring(0, index));
        }
    }

    @Override
    protected void handleUnreconciledElement(Element child, List<XSDConcreteComponent> newContents, List<XSDConcreteComponent> remainingContents) {
        XSDSchemaContent xsdSchemaContent = XSDSchemaContentImpl.createSchemaContent(child);
        if (xsdSchemaContent != null) {
            newContents.add(xsdSchemaContent);
        }
    }

    @Override
    protected void handleReconciliation(List<XSDConcreteComponent> newContents, List<XSDConcreteComponent> remainingContents) {
        if (!remainingContents.isEmpty()) {
            this.getContents().removeAll(remainingContents);
        }
        List<XSDConcreteComponent> list = newContents;
        XSDSchemaImpl.setListContentAndOrder(this.getContents(), list);
    }

    @Override
    public XSDConcreteComponent getCorrespondingComponent(Node node) {
        ArrayList<Element> parents = new ArrayList<Element>();
        if (node.getNodeType() == 2) {
            node = ((Attr)node).getOwnerElement();
        } else {
            Node scanNode = node;
            while (scanNode != null) {
                if (scanNode.getNodeType() == 1) {
                    node = scanNode;
                    break;
                }
                scanNode = scanNode.getNextSibling();
            }
            scanNode = node;
            while (scanNode != null) {
                if (scanNode.getNodeType() == 1) {
                    node = scanNode;
                    break;
                }
                scanNode = scanNode.getPreviousSibling();
            }
        }
        Node parent = node;
        while (parent != null) {
            if (parent.getNodeType() == 1) {
                parents.add((Element)parent);
            }
            parent = parent.getParentNode();
        }
        XSDConcreteComponent bestXSDConcreteComponent = this.getBestConcreteComponent(parents);
        return bestXSDConcreteComponent;
    }

    @Override
    public Map<String, XSDSimpleTypeDefinition> getSimpleTypeIdMap() {
        if (this.simpleTypeIdMap == null) {
            this.simpleTypeIdMap = new HashMap<String, XSDSimpleTypeDefinition>();
            for (XSDTypeDefinition xsdTypeDefinition : this.getTypeDefinitions()) {
                Element theElement;
                if (!(xsdTypeDefinition instanceof XSDSimpleTypeDefinition) || (theElement = xsdTypeDefinition.getElement()) == null || !theElement.hasAttributeNS(null, "id") || !(xsdTypeDefinition instanceof XSDSimpleTypeDefinition)) continue;
                this.simpleTypeIdMap.put(theElement.getAttributeNS(null, "id"), (XSDSimpleTypeDefinition)xsdTypeDefinition);
            }
        }
        return this.simpleTypeIdMap;
    }

    protected List<XSDSchema> getIncorporatingSchemas() {
        if (this.incorporatingSchemas == null) {
            UniqueEList.FastCompare visited = new UniqueEList.FastCompare();
            visited.add(this);
            this.incorporatingSchemas = new ArrayList<XSDSchema>();
            int i = 0;
            while (i < visited.size()) {
                XSDSchemaImpl xsdSchema = (XSDSchemaImpl)visited.get(i);
                this.incorporatingSchemas.add(xsdSchema);
                for (XSDSchemaDirective xsdSchemaDirective : xsdSchema.getReferencingDirectives()) {
                    XSDSchemaImpl incorporatingSchema;
                    if (!(xsdSchemaDirective instanceof XSDSchemaCompositor) || ((XSDSchemaCompositor)xsdSchemaDirective).getIncorporatedSchema() != xsdSchema || (incorporatingSchema = (XSDSchemaImpl)xsdSchemaDirective.getSchema()) == null || !visited.add(incorporatingSchema)) continue;
                    this.incorporatingSchemas.add(incorporatingSchema);
                    visited.addAll(incorporatingSchema.getIncorporatingSchemas());
                }
                ++i;
            }
        }
        return this.incorporatingSchemas;
    }

    public Collection<XSDSchema> resolveSchema(String namespace) {
        if ("".equals(namespace)) {
            namespace = null;
        }
        if (namespace == null ? this.getTargetNamespace() == null || "".equals(this.getTargetNamespace()) || this.hasRetargetedNamespace() : namespace.equals(this.getTargetNamespace())) {
            return this.getIncorporatingSchemas();
        }
        if (XSDConstants.isSchemaInstanceNamespace(namespace)) {
            return Collections.singleton(XSDSchemaImpl.getSchemaInstance(namespace));
        }
        ArrayList<XSDSchema> result = new ArrayList<XSDSchema>();
        for (XSDSchemaContent xsdSchemaContent : this.getContents()) {
            if (xsdSchemaContent instanceof XSDSchemaDirective) {
                XSDSchema importedSchema;
                if (!(xsdSchemaContent instanceof XSDImport)) continue;
                XSDImport xsdImport = (XSDImport)xsdSchemaContent;
                String importNamespace = xsdImport.getNamespace();
                if (!(namespace == null ? importNamespace == null || "".equals(importNamespace) : namespace.equals(importNamespace)) || (importedSchema = ((XSDImportImpl)xsdImport).importSchema()) == null) continue;
                result.add(importedSchema);
                Collection<XSDSchemaImpl> circular = ((XSDSchemaImpl)importedSchema).circularResolveDependencies;
                if (circular == null) continue;
                circular.add(this);
                continue;
            }
            if (!(xsdSchemaContent instanceof XSDAnnotation)) break;
        }
        return result;
    }

    protected XSDNamedComponent resolveNamedComponent(EReference namedComponentsRefReference, String namespace, String localName) {
        if ("".equals(namespace)) {
            namespace = null;
        }
        Collection<XSDSchema> resolvedSchemas = this.resolveSchema(namespace);
        for (XSDSchema resolvedSchema : resolvedSchemas) {
            List list = (List)resolvedSchema.eGet((EStructuralFeature)namedComponentsRefReference);
            XSDNamedComponent xsdNamedComponent = XSDNamedComponentImpl.findInSortedList(list, namespace, localName);
            if (xsdNamedComponent == null && namespace == null && resolvedSchemas.contains(this) && resolvedSchema.getTargetNamespace() != null) {
                xsdNamedComponent = XSDNamedComponentImpl.findInSortedList(list, this.getTargetNamespace(), localName);
            }
            if (xsdNamedComponent == null) continue;
            return xsdNamedComponent;
        }
        return null;
    }

    @Override
    public XSDAttributeDeclaration resolveAttributeDeclaration(String namespace, String localName) {
        XSDAttributeDeclaration result = (XSDAttributeDeclaration)this.resolveNamedComponent(XSDPackage.Literals.XSD_SCHEMA__ATTRIBUTE_DECLARATIONS, namespace, localName);
        if (result == null) {
            result = this.createUnresolvedAttributeDeclaration(namespace, localName);
        }
        return result;
    }

    @Override
    public XSDAttributeGroupDefinition resolveAttributeGroupDefinition(String namespace, String localName) {
        XSDAttributeGroupDefinition result = (XSDAttributeGroupDefinition)this.resolveNamedComponent(XSDPackage.Literals.XSD_SCHEMA__ATTRIBUTE_GROUP_DEFINITIONS, namespace, localName);
        if (result == null) {
            result = this.createUnresolvedAttributeGroupDefinition(namespace, localName);
        }
        return result;
    }

    @Override
    public XSDElementDeclaration resolveElementDeclaration(String namespace, String localName) {
        XSDElementDeclaration result = (XSDElementDeclaration)this.resolveNamedComponent(XSDPackage.Literals.XSD_SCHEMA__ELEMENT_DECLARATIONS, namespace, localName);
        if (result == null) {
            result = this.createUnresolvedElementDeclaration(namespace, localName);
        }
        return result;
    }

    @Override
    public XSDTypeDefinition resolveTypeDefinition(String namespace, String localName) {
        XSDTypeDefinition result = (XSDTypeDefinition)this.resolveNamedComponent(XSDPackage.Literals.XSD_SCHEMA__TYPE_DEFINITIONS, namespace, localName);
        if (result == null && XSDConstants.isSchemaForSchemaNamespace(namespace) && !XSDConstants.isSchemaForSchemaNamespace(this.getTargetNamespace())) {
            result = XSDSchemaImpl.getSchemaForSchema(namespace).resolveTypeDefinition(namespace, localName);
        }
        if (result == null) {
            result = this.createUnresolvedTypeDefinition(namespace, localName);
        }
        return result;
    }

    @Override
    public XSDSimpleTypeDefinition resolveSimpleTypeDefinition(String namespace, String localName) {
        XSDSimpleTypeDefinition result;
        XSDTypeDefinition xsdTypeDefinition = (XSDTypeDefinition)this.resolveNamedComponent(XSDPackage.Literals.XSD_SCHEMA__TYPE_DEFINITIONS, namespace, localName);
        XSDSimpleTypeDefinition xSDSimpleTypeDefinition = result = xsdTypeDefinition instanceof XSDSimpleTypeDefinition ? (XSDSimpleTypeDefinition)xsdTypeDefinition : null;
        if (result == null && XSDConstants.isSchemaForSchemaNamespace(namespace)) {
            if ("anyType".equals(localName) || "anySimpleType".equals(localName)) {
                XSDSchema magicSchemaForSchema = XSDSchemaImpl.getMagicSchemaForSchema(namespace);
                if (magicSchemaForSchema == this) {
                    EList<XSDTypeDefinition> typeDefinitions = magicSchemaForSchema.getTypeDefinitions();
                    if (typeDefinitions.size() > 0) {
                        result = (XSDSimpleTypeDefinition)typeDefinitions.get(0);
                    }
                } else {
                    result = magicSchemaForSchema.resolveSimpleTypeDefinition(namespace, localName);
                }
            } else if (!XSDConstants.isSchemaForSchemaNamespace(this.getTargetNamespace())) {
                XSDSchema schemaForSchema = XSDSchemaImpl.getSchemaForSchema(namespace);
                result = schemaForSchema.resolveSimpleTypeDefinition(namespace, localName);
            }
        }
        if (result == null) {
            result = this.createUnresolvedSimpleTypeDefinition(namespace, localName);
        }
        return result;
    }

    @Override
    public XSDComplexTypeDefinition resolveComplexTypeDefinition(String namespace, String localName) {
        XSDComplexTypeDefinition result;
        XSDTypeDefinition xsdTypeDefinition = (XSDTypeDefinition)this.resolveNamedComponent(XSDPackage.Literals.XSD_SCHEMA__TYPE_DEFINITIONS, namespace, localName);
        XSDComplexTypeDefinition xSDComplexTypeDefinition = result = xsdTypeDefinition instanceof XSDComplexTypeDefinition ? (XSDComplexTypeDefinition)xsdTypeDefinition : null;
        if (result == null && XSDConstants.isSchemaForSchemaNamespace(namespace) && !XSDConstants.isSchemaForSchemaNamespace(this.getTargetNamespace())) {
            result = XSDSchemaImpl.getSchemaForSchema(namespace).resolveComplexTypeDefinition(namespace, localName);
        }
        if (result == null) {
            result = this.createUnresolvedComplexTypeDefinition(namespace, localName);
        }
        return result;
    }

    @Override
    public XSDModelGroupDefinition resolveModelGroupDefinition(String namespace, String localName) {
        XSDModelGroupDefinition result = (XSDModelGroupDefinition)this.resolveNamedComponent(XSDPackage.Literals.XSD_SCHEMA__MODEL_GROUP_DEFINITIONS, namespace, localName);
        if (result == null) {
            result = this.createUnresolvedModelGroupDefinition(namespace, localName);
        }
        return result;
    }

    @Override
    public XSDIdentityConstraintDefinition resolveIdentityConstraintDefinition(String namespace, String localName) {
        XSDIdentityConstraintDefinition result = (XSDIdentityConstraintDefinition)this.resolveNamedComponent(XSDPackage.Literals.XSD_SCHEMA__IDENTITY_CONSTRAINT_DEFINITIONS, namespace, localName);
        if (result == null) {
            result = this.createUnresolvedIdentityConstraintDefinition(namespace, localName);
        }
        return result;
    }

    @Override
    public XSDNotationDeclaration resolveNotationDeclaration(String namespace, String localName) {
        XSDNotationDeclaration result = (XSDNotationDeclaration)this.resolveNamedComponent(XSDPackage.Literals.XSD_SCHEMA__NOTATION_DECLARATIONS, namespace, localName);
        if (result == null) {
            result = this.createUnresolvedNotationDeclaration(namespace, localName);
        }
        return result;
    }

    @Override
    protected void changeAttribute(EAttribute eAttribute) {
        if (eAttribute == XSDPackage.Literals.XSD_SCHEMA__SCHEMA_LOCATION) {
            this.patch();
        } else {
            super.changeAttribute(eAttribute);
            Element theElement = this.getElement();
            if (theElement != null) {
                if (eAttribute == null || eAttribute == XSDPackage.Literals.XSD_SCHEMA__VERSION) {
                    this.niceSetAttribute(theElement, "version", this.getVersion());
                    if (eAttribute != null) {
                        this.traverseToRootForPatching();
                    }
                }
                if (eAttribute == null || eAttribute == XSDPackage.Literals.XSD_SCHEMA__TARGET_NAMESPACE) {
                    this.niceSetAttribute(theElement, "targetNamespace", this.getTargetNamespace());
                    if (eAttribute != null && !this.isReconciling && this.isIncrementalUpdate) {
                        for (Object content : this.getContents()) {
                            if (!(content instanceof XSDNamedComponentImpl)) continue;
                            ((XSDNamedComponentImpl)content).patchTargetNamespaceAttribute();
                        }
                        this.reset();
                    }
                }
                if (eAttribute == null || eAttribute == XSDPackage.Literals.XSD_SCHEMA__ATTRIBUTE_FORM_DEFAULT) {
                    this.niceSetAttribute(theElement, "attributeFormDefault", this.isSetAttributeFormDefault() ? this.getAttributeFormDefault().getName() : null);
                    if (eAttribute != null) {
                        this.traverseToRootForPatching();
                    }
                }
                if (eAttribute == null || eAttribute == XSDPackage.Literals.XSD_SCHEMA__ELEMENT_FORM_DEFAULT) {
                    this.niceSetAttribute(theElement, "elementFormDefault", this.isSetElementFormDefault() ? this.getElementFormDefault().getName() : null);
                    if (eAttribute != null) {
                        this.traverseToRootForPatching();
                    }
                }
                if (eAttribute == null || eAttribute == XSDPackage.Literals.XSD_SCHEMA__BLOCK_DEFAULT) {
                    this.niceSetAttribute(theElement, "blockDefault", this.getStringBlockDefault());
                    if (eAttribute != null) {
                        this.traverseToRootForPatching();
                    }
                }
                if (eAttribute == null || eAttribute == XSDPackage.Literals.XSD_SCHEMA__FINAL_DEFAULT) {
                    this.niceSetAttribute(theElement, "finalDefault", this.getStringFinalDefault());
                    if (eAttribute != null) {
                        this.traverseToRootForPatching();
                    }
                }
            }
        }
    }

    @Override
    protected void changeReference(EReference eReference) {
        super.changeReference(eReference);
        if (eReference == XSDPackage.Literals.XSD_SCHEMA__REFERENCING_DIRECTIVES) {
            boolean newHasRetargetedNamespace = false;
            for (XSDSchemaDirective xsdSchemaDirective : this.getReferencingDirectives()) {
                XSDSchemaCompositor xsdSchemaCompositor;
                if (!(xsdSchemaDirective instanceof XSDSchemaCompositor) || (xsdSchemaCompositor = (XSDSchemaCompositor)xsdSchemaDirective).getResolvedSchema() == xsdSchemaCompositor.getIncorporatedSchema() || xsdSchemaCompositor.getResolvedSchema().getTargetNamespace() != null) continue;
                newHasRetargetedNamespace = true;
                break;
            }
            this.hasRetargetedNamespace = newHasRetargetedNamespace;
        }
    }

    @Override
    public void setElement(Element element) {
        Element oldElement = this.getElement();
        if (oldElement instanceof EventTarget) {
            EventTarget oldEventTarget = (EventTarget)((Object)oldElement);
            oldEventTarget.removeEventListener("DOMNodeInserted", this.getEventListener(), true);
            oldEventTarget.removeEventListener("DOMNodeRemoved", this.getEventListener(), true);
            oldEventTarget.removeEventListener("DOMAttrModified", this.getEventListener(), true);
        }
        super.setElement(element);
        if (element instanceof EventTarget) {
            EventTarget eventTarget = (EventTarget)((Object)element);
            eventTarget.addEventListener("DOMNodeInserted", this.getEventListener(), true);
            eventTarget.addEventListener("DOMNodeRemoved", this.getEventListener(), true);
            eventTarget.addEventListener("DOMAttrModified", this.getEventListener(), true);
        }
        if (element != null) {
            this.document = element.getOwnerDocument();
        }
    }

    @Override
    public XSDSchema getSchemaForSchema() {
        return XSDSchemaImpl.getSchemaForSchema(this.getSchemaForSchemaNamespace());
    }

    @Override
    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 13: {
                return ((InternalEList)this.getContents()).basicRemove((Object)otherEnd, msgs);
            }
            case 26: {
                return ((InternalEList)this.getIncorporatedVersions()).basicRemove((Object)otherEnd, msgs);
            }
        }
        return super.eInverseRemove(otherEnd, featureID, msgs);
    }

    @Override
    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 5: {
                return this.getDocument();
            }
            case 6: {
                return this.getSchemaLocation();
            }
            case 7: {
                return this.getTargetNamespace();
            }
            case 8: {
                return this.getAttributeFormDefault();
            }
            case 9: {
                return this.getElementFormDefault();
            }
            case 10: {
                return this.getFinalDefault();
            }
            case 11: {
                return this.getBlockDefault();
            }
            case 12: {
                return this.getVersion();
            }
            case 13: {
                return this.getContents();
            }
            case 14: {
                return this.getElementDeclarations();
            }
            case 15: {
                return this.getAttributeDeclarations();
            }
            case 16: {
                return this.getAttributeGroupDefinitions();
            }
            case 17: {
                return this.getTypeDefinitions();
            }
            case 18: {
                return this.getModelGroupDefinitions();
            }
            case 19: {
                return this.getIdentityConstraintDefinitions();
            }
            case 20: {
                return this.getNotationDeclarations();
            }
            case 21: {
                return this.getAnnotations();
            }
            case 22: {
                return this.getAllDiagnostics();
            }
            case 23: {
                return this.getReferencingDirectives();
            }
            case 24: {
                return this.getRootVersion();
            }
            case 25: {
                return this.getOriginalVersion();
            }
            case 26: {
                return this.getIncorporatedVersions();
            }
            case 27: {
                return this.getSchemaForSchema();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    @Override
    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 5: {
                this.setDocument((Document)newValue);
                return;
            }
            case 6: {
                this.setSchemaLocation((String)newValue);
                return;
            }
            case 7: {
                this.setTargetNamespace((String)newValue);
                return;
            }
            case 8: {
                this.setAttributeFormDefault((XSDForm)((Object)newValue));
                return;
            }
            case 9: {
                this.setElementFormDefault((XSDForm)((Object)newValue));
                return;
            }
            case 10: {
                this.getFinalDefault().clear();
                this.getFinalDefault().addAll((Collection)newValue);
                return;
            }
            case 11: {
                this.getBlockDefault().clear();
                this.getBlockDefault().addAll((Collection)newValue);
                return;
            }
            case 12: {
                this.setVersion((String)newValue);
                return;
            }
            case 13: {
                this.getContents().clear();
                this.getContents().addAll((Collection)newValue);
                return;
            }
            case 14: {
                this.getElementDeclarations().clear();
                this.getElementDeclarations().addAll((Collection)newValue);
                return;
            }
            case 15: {
                this.getAttributeDeclarations().clear();
                this.getAttributeDeclarations().addAll((Collection)newValue);
                return;
            }
            case 16: {
                this.getAttributeGroupDefinitions().clear();
                this.getAttributeGroupDefinitions().addAll((Collection)newValue);
                return;
            }
            case 17: {
                this.getTypeDefinitions().clear();
                this.getTypeDefinitions().addAll((Collection)newValue);
                return;
            }
            case 18: {
                this.getModelGroupDefinitions().clear();
                this.getModelGroupDefinitions().addAll((Collection)newValue);
                return;
            }
            case 19: {
                this.getIdentityConstraintDefinitions().clear();
                this.getIdentityConstraintDefinitions().addAll((Collection)newValue);
                return;
            }
            case 20: {
                this.getNotationDeclarations().clear();
                this.getNotationDeclarations().addAll((Collection)newValue);
                return;
            }
            case 21: {
                this.getAnnotations().clear();
                this.getAnnotations().addAll((Collection)newValue);
                return;
            }
            case 22: {
                this.getAllDiagnostics().clear();
                this.getAllDiagnostics().addAll((Collection)newValue);
                return;
            }
            case 23: {
                this.getReferencingDirectives().clear();
                this.getReferencingDirectives().addAll((Collection)newValue);
                return;
            }
            case 26: {
                this.getIncorporatedVersions().clear();
                this.getIncorporatedVersions().addAll((Collection)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    @Override
    public void eUnset(int featureID) {
        switch (featureID) {
            case 5: {
                this.setDocument(DOCUMENT_EDEFAULT);
                return;
            }
            case 6: {
                this.setSchemaLocation(SCHEMA_LOCATION_EDEFAULT);
                return;
            }
            case 7: {
                this.setTargetNamespace(TARGET_NAMESPACE_EDEFAULT);
                return;
            }
            case 8: {
                this.unsetAttributeFormDefault();
                return;
            }
            case 9: {
                this.unsetElementFormDefault();
                return;
            }
            case 10: {
                this.unsetFinalDefault();
                return;
            }
            case 11: {
                this.unsetBlockDefault();
                return;
            }
            case 12: {
                this.setVersion(VERSION_EDEFAULT);
                return;
            }
            case 13: {
                this.getContents().clear();
                return;
            }
            case 14: {
                this.getElementDeclarations().clear();
                return;
            }
            case 15: {
                this.getAttributeDeclarations().clear();
                return;
            }
            case 16: {
                this.getAttributeGroupDefinitions().clear();
                return;
            }
            case 17: {
                this.getTypeDefinitions().clear();
                return;
            }
            case 18: {
                this.getModelGroupDefinitions().clear();
                return;
            }
            case 19: {
                this.getIdentityConstraintDefinitions().clear();
                return;
            }
            case 20: {
                this.getNotationDeclarations().clear();
                return;
            }
            case 21: {
                this.getAnnotations().clear();
                return;
            }
            case 22: {
                this.getAllDiagnostics().clear();
                return;
            }
            case 23: {
                this.getReferencingDirectives().clear();
                return;
            }
            case 26: {
                this.getIncorporatedVersions().clear();
                return;
            }
        }
        super.eUnset(featureID);
    }

    @Override
    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 5: {
                return DOCUMENT_EDEFAULT == null ? this.document != null : !DOCUMENT_EDEFAULT.equals(this.document);
            }
            case 6: {
                return SCHEMA_LOCATION_EDEFAULT == null ? this.schemaLocation != null : !SCHEMA_LOCATION_EDEFAULT.equals(this.schemaLocation);
            }
            case 7: {
                return TARGET_NAMESPACE_EDEFAULT == null ? this.targetNamespace != null : !TARGET_NAMESPACE_EDEFAULT.equals(this.targetNamespace);
            }
            case 8: {
                return this.isSetAttributeFormDefault();
            }
            case 9: {
                return this.isSetElementFormDefault();
            }
            case 10: {
                return this.isSetFinalDefault();
            }
            case 11: {
                return this.isSetBlockDefault();
            }
            case 12: {
                return VERSION_EDEFAULT == null ? this.version != null : !VERSION_EDEFAULT.equals(this.version);
            }
            case 13: {
                return this.contents != null && !this.contents.isEmpty();
            }
            case 14: {
                return this.elementDeclarations != null && !this.elementDeclarations.isEmpty();
            }
            case 15: {
                return this.attributeDeclarations != null && !this.attributeDeclarations.isEmpty();
            }
            case 16: {
                return this.attributeGroupDefinitions != null && !this.attributeGroupDefinitions.isEmpty();
            }
            case 17: {
                return this.typeDefinitions != null && !this.typeDefinitions.isEmpty();
            }
            case 18: {
                return this.modelGroupDefinitions != null && !this.modelGroupDefinitions.isEmpty();
            }
            case 19: {
                return this.identityConstraintDefinitions != null && !this.identityConstraintDefinitions.isEmpty();
            }
            case 20: {
                return this.notationDeclarations != null && !this.notationDeclarations.isEmpty();
            }
            case 21: {
                return this.annotations != null && !this.annotations.isEmpty();
            }
            case 22: {
                return this.allDiagnostics != null && !this.allDiagnostics.isEmpty();
            }
            case 23: {
                return this.referencingDirectives != null && !this.referencingDirectives.isEmpty();
            }
            case 24: {
                return this.getRootVersion() != null;
            }
            case 25: {
                return this.getOriginalVersion() != null;
            }
            case 26: {
                return this.incorporatedVersions != null && !this.incorporatedVersions.isEmpty();
            }
            case 27: {
                return this.getSchemaForSchema() != null;
            }
        }
        return super.eIsSet(featureID);
    }

    @Override
    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (document: ");
        result.append(this.document);
        result.append(", schemaLocation: ");
        result.append(this.schemaLocation);
        result.append(", targetNamespace: ");
        result.append(this.targetNamespace);
        result.append(", attributeFormDefault: ");
        if ((this.eFlags & 0x100) != 0) {
            result.append((Object)this.attributeFormDefault);
        } else {
            result.append("<unset>");
        }
        result.append(", elementFormDefault: ");
        if ((this.eFlags & 0x200) != 0) {
            result.append((Object)this.elementFormDefault);
        } else {
            result.append("<unset>");
        }
        result.append(", finalDefault: ");
        result.append(this.finalDefault);
        result.append(", blockDefault: ");
        result.append(this.blockDefault);
        result.append(", version: ");
        result.append(this.version);
        result.append(')');
        return result.toString();
    }

    public XSDSchema getMagicSchemaForSchema() {
        return XSDSchemaImpl.getMagicSchemaForSchema(this.getSchemaForSchemaNamespace());
    }

    public Node getDeletionNode() {
        return this.deletionNode;
    }

    protected EventListener getEventListener() {
        if (this.eventListener == null) {
            class XSDSchemaEventListener
            implements EventListener,
            Serializable {
                private static final long serialVersionUID = 1L;

                XSDSchemaEventListener() {
                }

                public void handleEvent(Event event) {
                    MutationEvent mutationEvent;
                    if (event instanceof MutationEvent && (mutationEvent = (MutationEvent)event).getTarget() instanceof Node) {
                        Node node = (Node)((Object)mutationEvent.getTarget());
                        while (node.getNodeType() != 1) {
                            node = node.getParentNode();
                        }
                        if (mutationEvent.getAttrChange() == 0) {
                            XSDConcreteComponent listener = XSDSchemaImpl.this.getCorrespondingComponent(node.getParentNode());
                            if (listener != null) {
                                Node parent;
                                if (event.getType().equals("DOMNodeRemoved")) {
                                    XSDSchemaImpl.this.deletionNode = (Node)((Object)event.getTarget());
                                }
                                if ((parent = node.getParentNode()).getNodeType() == 1) {
                                    listener.elementContentsChanged((Element)parent);
                                }
                                XSDSchemaImpl.this.deletionNode = null;
                            }
                        } else {
                            XSDConcreteComponent listener = XSDSchemaImpl.this.getCorrespondingComponent(node);
                            if (listener != null) {
                                listener.elementAttributesChanged((Element)node);
                            }
                        }
                    }
                }

                public Object writeReplace() {
                    return new DummyEventListener();
                }
            }
            this.eventListener = new XSDSchemaEventListener();
        }
        return this.eventListener;
    }

    @Override
    public Document updateDocument() {
        this.document = XSDParser.createDocument();
        return this.document;
    }

    @Override
    public void setIncrementalUpdate(boolean isIncrementalUpdate) {
        this.isIncrementalUpdate = isIncrementalUpdate;
        this.traverseToRootForPatching();
    }

    @Override
    public boolean isIncrementalUpdate() {
        return this.isIncrementalUpdate;
    }

    @Override
    public void update() {
        boolean oldIsIncrementalUpdate = this.isIncrementalUpdate;
        this.isIncrementalUpdate = true;
        this.traverseToRootForPatching();
        this.isIncrementalUpdate = oldIsIncrementalUpdate;
    }

    @Override
    public void update(boolean force) {
        this.forceResolve = force;
        this.update();
        this.forceResolve = false;
    }

    @Override
    public void reset() {
        super.reset();
        this.redefinitionMap.clear();
        this.reset((List<? extends XSDConcreteComponent>)this.getAttributeDeclarations());
        this.reset((List<? extends XSDConcreteComponent>)this.getAttributeGroupDefinitions());
        this.reset((List<? extends XSDConcreteComponent>)this.getElementDeclarations());
        this.reset((List<? extends XSDConcreteComponent>)this.getModelGroupDefinitions());
        this.reset((List<? extends XSDConcreteComponent>)this.getTypeDefinitions());
        this.reset((List<? extends XSDConcreteComponent>)this.getNotationDeclarations());
        this.reset((List<? extends XSDConcreteComponent>)this.getIdentityConstraintDefinitions());
        this.forceResolve = true;
        this.update();
        this.forceResolve = false;
    }

    protected void reset(List<? extends XSDConcreteComponent> components) {
        Iterator<? extends XSDConcreteComponent> i = components.iterator();
        while (i.hasNext()) {
            XSDConcreteComponent xsdConcreteComponent = i.next();
            if (xsdConcreteComponent.getSchema() == this) continue;
            i.remove();
        }
    }

    public String getPendingSchemaLocation() {
        return this.pendingSchemaLocation;
    }

    public List<XSDSchemaImpl> getSchemasToRedefine() {
        if (this.schemasToRedefine == null) {
            this.schemasToRedefine = new UniqueEList();
            this.schemasToRedefine.add(this);
        }
        return this.schemasToRedefine;
    }

    public Map<XSDComponent, XSDComponent> getRedefinitionMap() {
        return this.redefinitionMap;
    }

    public XSDSchema imported(XSDImport xsdImport) {
        xsdImport.setResolvedSchema(this);
        this.getReferencingDirectives().add((Object)xsdImport);
        this.propogateComponents(xsdImport.getSchema());
        return this;
    }

    public void propogateComponents(XSDSchema otherXSDSchema) {
        otherXSDSchema.getAnnotations().addAll(this.getAnnotations());
        XSDNamedComponentImpl.mergeToSortedList(otherXSDSchema.getAttributeDeclarations(), this.getAttributeDeclarations());
        XSDNamedComponentImpl.mergeToSortedList(otherXSDSchema.getAttributeGroupDefinitions(), this.getAttributeGroupDefinitions());
        XSDNamedComponentImpl.mergeToSortedList(otherXSDSchema.getElementDeclarations(), this.getElementDeclarations());
        XSDNamedComponentImpl.mergeToSortedList(otherXSDSchema.getModelGroupDefinitions(), this.getModelGroupDefinitions());
        XSDNamedComponentImpl.mergeToSortedList(otherXSDSchema.getTypeDefinitions(), this.getTypeDefinitions());
        XSDNamedComponentImpl.mergeToSortedList(otherXSDSchema.getNotationDeclarations(), this.getNotationDeclarations());
        XSDNamedComponentImpl.mergeToSortedList(otherXSDSchema.getIdentityConstraintDefinitions(), this.getIdentityConstraintDefinitions());
    }

    public XSDSchema redefined(XSDRedefine xsdRedefine) {
        XSDSchema redefiningSchema = xsdRedefine.getSchema();
        xsdRedefine.setResolvedSchema(this);
        this.getReferencingDirectives().add((Object)xsdRedefine);
        if (redefiningSchema != this && (this.getTargetNamespace() == null || this.getTargetNamespace().equals(redefiningSchema.getTargetNamespace()))) {
            for (XSDSchema incorporatedVersion : this.getIncorporatedVersions()) {
                Iterator i;
                if (!(incorporatedVersion.getTargetNamespace() == null ? redefiningSchema.getTargetNamespace() == null : incorporatedVersion.getTargetNamespace().equals(redefiningSchema.getTargetNamespace())) || !(i = incorporatedVersion.getReferencingDirectives().iterator()).hasNext()) continue;
                i.next();
                ((XSDSchemaImpl)incorporatedVersion).incorporate(xsdRedefine);
                return incorporatedVersion;
            }
            XSDSchemaImpl redefinedSchema = (XSDSchemaImpl)this.cloneConcreteComponent(true, true);
            if (redefinedSchema.getTargetNamespace() == null && redefiningSchema.getTargetNamespace() != null) {
                redefinedSchema.patch();
                redefinedSchema.setTargetNamespace(redefiningSchema.getTargetNamespace());
                redefinedSchema.patch();
            }
            ListIterator i = redefinedSchema.getContents().listIterator();
            while (i.hasNext()) {
                Object component = i.next();
                if (!(component instanceof XSDInclude)) continue;
                redefinedSchema.isReconciling = true;
                i.remove();
                XSDRedefine xsdRedefineReplaced = XSDFactory.eINSTANCE.createXSDRedefine();
                xsdRedefineReplaced.setSchemaLocation(((XSDInclude)component).getSchemaLocation());
                i.add(xsdRedefineReplaced);
                redefinedSchema.isReconciling = false;
            }
            redefinedSchema.pendingSchemaLocation = this.getSchemaLocation();
            this.getIncorporatedVersions().add((Object)redefinedSchema);
            redefinedSchema.incorporate(xsdRedefine);
            return redefinedSchema;
        }
        return this;
    }

    public XSDSchema included(XSDInclude xsdInclude) {
        XSDSchema includingSchema = xsdInclude.getSchema();
        xsdInclude.setResolvedSchema(this);
        this.getReferencingDirectives().add((Object)xsdInclude);
        if (this.getTargetNamespace() == null || this.getTargetNamespace().equals(includingSchema.getTargetNamespace())) {
            if (includingSchema.getTargetNamespace() != null && this.getTargetNamespace() == null) {
                for (XSDSchema xsdSchema : this.getIncorporatedVersions()) {
                    XSDSchemaImpl incorporatedVersion = (XSDSchemaImpl)xsdSchema;
                    if (!includingSchema.getTargetNamespace().equals(incorporatedVersion.getTargetNamespace())) continue;
                    if (incorporatedVersion.getReferencingDirectives().isEmpty()) {
                        incorporatedVersion.incorporate(xsdInclude);
                        return incorporatedVersion;
                    }
                    for (XSDSchemaDirective xsdSchemaDirective : incorporatedVersion.getReferencingDirectives()) {
                        if (!(xsdSchemaDirective instanceof XSDInclude)) continue;
                        incorporatedVersion.incorporate(xsdInclude);
                        return incorporatedVersion;
                    }
                }
                XSDSchemaImpl includedSchema = (XSDSchemaImpl)this.cloneConcreteComponent(true, true);
                includedSchema.patch();
                includedSchema.setTargetNamespace(includingSchema.getTargetNamespace());
                includedSchema.patch();
                this.getIncorporatedVersions().add((Object)includedSchema);
                includedSchema.incorporate(xsdInclude);
                return includedSchema;
            }
            this.incorporate(xsdInclude);
        }
        return this;
    }

    protected void incorporate(XSDSchemaCompositor xsdSchemaCompositor) {
        xsdSchemaCompositor.setIncorporatedSchema(this);
        XSDSchema redefiningSchema = xsdSchemaCompositor.getSchema();
        this.getReferencingDirectives().add((Object)xsdSchemaCompositor);
        if (this.getTargetNamespace() == null && redefiningSchema.getTargetNamespace() != null) {
            this.setTargetNamespace(redefiningSchema.getTargetNamespace());
        }
        if (this.getPendingSchemaLocation() != null) {
            for (Object component : this.getContents()) {
                if (!(component instanceof XSDSchemaDirective)) continue;
                ((XSDConcreteComponentImpl)component).patch();
            }
        }
        if (xsdSchemaCompositor instanceof XSDRedefine) {
            XSDSwitch<Object> xsdSwitch = new XSDSwitch<Object>(){

                @Override
                public Object caseXSDAttributeGroupDefinition(XSDAttributeGroupDefinition xsdAttributeGroupDefinition) {
                    XSDAttributeGroupDefinition redefinedAttributeGroupDefinition = XSDSchemaImpl.this.resolveAttributeGroupDefinition(xsdAttributeGroupDefinition.getName());
                    for (XSDSchemaImpl schemaToRedefine : XSDSchemaImpl.this.getSchemasToRedefine()) {
                        int index = schemaToRedefine.getAttributeGroupDefinitions().indexOf((Object)redefinedAttributeGroupDefinition);
                        if (index == -1) continue;
                        schemaToRedefine.getAttributeGroupDefinitions().set(index, (Object)xsdAttributeGroupDefinition);
                        schemaToRedefine.redefinitionMap.put(xsdAttributeGroupDefinition, redefinedAttributeGroupDefinition);
                    }
                    return this;
                }

                @Override
                public Object caseXSDSimpleTypeDefinition(XSDSimpleTypeDefinition xsdSimpleTypeDefinition) {
                    XSDSimpleTypeDefinition redefinedSimpleTypeDefinition = XSDSchemaImpl.this.resolveSimpleTypeDefinition(xsdSimpleTypeDefinition.getName());
                    for (XSDSchemaImpl schemaToRedefine : XSDSchemaImpl.this.getSchemasToRedefine()) {
                        int index = schemaToRedefine.getTypeDefinitions().indexOf((Object)redefinedSimpleTypeDefinition);
                        if (index == -1) continue;
                        schemaToRedefine.getTypeDefinitions().set(index, (Object)xsdSimpleTypeDefinition);
                        schemaToRedefine.redefinitionMap.put(xsdSimpleTypeDefinition, redefinedSimpleTypeDefinition);
                    }
                    return this;
                }

                @Override
                public Object caseXSDComplexTypeDefinition(XSDComplexTypeDefinition xsdComplexTypeDefinition) {
                    XSDComplexTypeDefinition redefinedComplexTypeDefinition = XSDSchemaImpl.this.resolveComplexTypeDefinition(xsdComplexTypeDefinition.getName());
                    if (xsdComplexTypeDefinition != redefinedComplexTypeDefinition) {
                        for (XSDSchemaImpl schemaToRedefine : XSDSchemaImpl.this.getSchemasToRedefine()) {
                            int index = schemaToRedefine.getTypeDefinitions().indexOf((Object)redefinedComplexTypeDefinition);
                            if (index == -1) continue;
                            schemaToRedefine.getTypeDefinitions().set(index, (Object)xsdComplexTypeDefinition);
                            schemaToRedefine.redefinitionMap.put(xsdComplexTypeDefinition, redefinedComplexTypeDefinition);
                        }
                    }
                    return this;
                }

                @Override
                public Object caseXSDModelGroupDefinition(XSDModelGroupDefinition xsdModelGroupDefinition) {
                    XSDModelGroupDefinition redefinedModelGroupDefinition = XSDSchemaImpl.this.resolveModelGroupDefinition(xsdModelGroupDefinition.getName());
                    for (XSDSchemaImpl schemaToRedefine : XSDSchemaImpl.this.getSchemasToRedefine()) {
                        int index = schemaToRedefine.getModelGroupDefinitions().indexOf((Object)redefinedModelGroupDefinition);
                        if (index == -1) continue;
                        schemaToRedefine.getModelGroupDefinitions().set(index, (Object)xsdModelGroupDefinition);
                        schemaToRedefine.redefinitionMap.put(xsdModelGroupDefinition, redefinedModelGroupDefinition);
                    }
                    return this;
                }
            };
            for (XSDRedefineContent xsdRedefineContent : ((XSDRedefine)xsdSchemaCompositor).getContents()) {
                xsdSwitch.doSwitch(xsdRedefineContent);
            }
        }
        if (((XSDSchemaImpl)redefiningSchema).getPendingSchemaLocation() != null) {
            ((XSDSchemaImpl)redefiningSchema).getSchemasToRedefine().addAll(this.getSchemasToRedefine());
        }
        this.propogateComponents(redefiningSchema);
        if (this.getPendingSchemaLocation() == null) {
            this.patch();
        }
        ((XSDSchemaImpl)redefiningSchema).getRedefinitionMap().putAll(this.getRedefinitionMap());
    }

    @Override
    public XSDConcreteComponent cloneConcreteComponent(boolean deep, boolean shareDOM) {
        XSDSchemaImpl clonedSchema = (XSDSchemaImpl)this.getXSDFactory().createXSDSchema();
        clonedSchema.isReconciling = true;
        clonedSchema.setTargetNamespace(this.getTargetNamespace());
        if (this.isSetAttributeFormDefault()) {
            clonedSchema.setAttributeFormDefault(this.getAttributeFormDefault());
        }
        if (this.isSetElementFormDefault()) {
            clonedSchema.setElementFormDefault(this.getElementFormDefault());
        }
        if (this.isSetFinalDefault()) {
            if (!this.getFinalDefault().isEmpty()) {
                clonedSchema.getFinalDefault().addAll(this.getFinalDefault());
            } else {
                clonedSchema.getFinalDefault().clear();
            }
        }
        if (this.isSetBlockDefault()) {
            if (!this.getBlockDefault().isEmpty()) {
                clonedSchema.getBlockDefault().addAll(this.getBlockDefault());
            } else {
                clonedSchema.getBlockDefault().clear();
            }
        }
        clonedSchema.setSchemaForSchemaQNamePrefix(this.getSchemaForSchemaQNamePrefix());
        clonedSchema.getQNamePrefixToNamespaceMap().putAll(this.getQNamePrefixToNamespaceMap());
        if (deep && !this.getContents().isEmpty()) {
            clonedSchema.getContents().addAll((Collection)XSDSchemaImpl.cloneConcreteComponents(this.getContents(), true, shareDOM));
        }
        if (shareDOM && this.getElement() != null) {
            clonedSchema.setElement(this.getElement());
        }
        clonedSchema.isReconciling = shareDOM;
        return clonedSchema;
    }

    private static class DummyEventListener
    implements EventListener,
    Serializable {
        private static final long serialVersionUID = 1L;

        private DummyEventListener() {
        }

        public void handleEvent(Event arg0) {
        }
    }
}

