/**
 * <copyright>
 * </copyright>
 *
 * $Id: EntityMappingsTypeValidator.java,v 1.1 2009/07/23 11:16:28 mtaal Exp $
 */
package org.eclipse.emf.teneo.jpa.orm.validation;

import org.eclipse.emf.common.util.EList;

import org.eclipse.emf.teneo.jpa.orm.AccessType;
import org.eclipse.emf.teneo.jpa.orm.Embeddable;
import org.eclipse.emf.teneo.jpa.orm.Entity;
import org.eclipse.emf.teneo.jpa.orm.MappedSuperclass;
import org.eclipse.emf.teneo.jpa.orm.NamedNativeQuery;
import org.eclipse.emf.teneo.jpa.orm.NamedQuery;
import org.eclipse.emf.teneo.jpa.orm.PersistenceUnitMetadata;
import org.eclipse.emf.teneo.jpa.orm.SequenceGenerator;
import org.eclipse.emf.teneo.jpa.orm.SqlResultSetMapping;
import org.eclipse.emf.teneo.jpa.orm.TableGenerator;

/**
 * A sample validator interface for {@link org.eclipse.emf.teneo.jpa.orm.EntityMappingsType}.
 * This doesn't really do anything, and it's not a real EMF artifact.
 * It was generated by the org.eclipse.emf.examples.generator.validator plug-in to illustrate how EMF's code generator can be extended.
 * This can be disabled with -vmargs -Dorg.eclipse.emf.examples.generator.validator=false.
 */
public interface EntityMappingsTypeValidator {
	boolean validate();

	boolean validateDescription(String value);
	boolean validatePersistenceUnitMetadata(PersistenceUnitMetadata value);
	boolean validatePackage(String value);
	boolean validateSchema(String value);
	boolean validateCatalog(String value);
	boolean validateAccess(AccessType value);
	boolean validateSequenceGenerator(EList<SequenceGenerator> value);
	boolean validateTableGenerator(EList<TableGenerator> value);
	boolean validateNamedQuery(EList<NamedQuery> value);
	boolean validateNamedNativeQuery(EList<NamedNativeQuery> value);
	boolean validateSqlResultSetMapping(EList<SqlResultSetMapping> value);
	boolean validateMappedSuperclass(EList<MappedSuperclass> value);
	boolean validateEntity(EList<Entity> value);
	boolean validateEmbeddable(EList<Embeddable> value);
	boolean validateVersion(String value);
}
