#!/bin/sh
# create site.xml and/or site-ganymede.xml from a build type label, a target dir, and a set of directories to merge

# REQUIREMENTS 
# buildTypeLabel (interim, milestones, releases)
# sitexml (category.xml) && coordsitexml    (category-ganymede.xml)
# sitexmlOut (site.xml)  && coordsitexmlOut (site-ganymede.xml)
# coordsiteSuffix (ganymede)
# header (/path/to/header.${buildTypeLabel}) -- actual file will be header.interim.site.xml or header.releases.site-ganymede.xml
# targetDir (/path/to/output/the/site.xml file)
# sourceDirs (one or more dirs whose contents to merge

norm="\033[0;39m";
grey="\033[1;30m";
green="\033[1;32m";
brown="\033[0;33m";
yellow="\033[1;33m";
blue="\033[1;34m";
cyan="\033[1;36m";
red="\033[1;31m";

##########################################################################################
if [ $# -lt 7 ]; then
	echo " "
	echo "usage: ${0##*/}"
	echo "-debug [1|2]                         (optional)"
	echo "-coordsite ganymede                  (optional)"
	echo "-label [interim|milestones|releases] (required)"
	echo "-header /path/to/site/header.\$label  (required)"
	echo "-targetDir /path/to/\$label/          (required: path to dir containing site.xml)"
	echo " <sourceDir1> <sourceDir2> ...       (required)"
	echo " "
	echo "examples:"
	echo "	${0##*/} -label \$buildTypeLabel -header \$buildDir/site/header.\$buildTypeLabel -targetDir \$localUpdatesWebDir/\${siteLabel}_rN \$localUpdatesWebDir/\${siteLabel}_rN";
	echo "	${0##*/} -label \$buildTypeLabel -header \$buildDir/site/header.\$buildTypeLabel -targetDir \$localUpdatesWebDir $componentSiteDirs"
	exit 1
fi

sourceDirs="";
debug=0;
coordsiteSuffix="";

while [ "$#" -gt 0 ]; do
	case $1 in
		'-debug')		debug=$2;				shift 1;;
		'-coordsite') 	coordsiteSuffix="-"$2; 	shift 1;;
		'-label') 		buildTypeLabel=$2; 		shift 1;;
		'-header')		header=$2;				shift 1;;
		'-targetDir')	targetDir=$2;			shift 1;;
		*)				sourceDirs=$sourceDirs" "$1; 
	esac
	shift 1
done

##########################################################################################

sitexml=category.xml
sitexmlOut=site.xml

coordsitexml="";
coordsitexmlOut="";
if [[ $coordsiteSuffix ]]; then
	coordsitexml=category${coordsiteSuffix}.xml
	coordsitexmlOut=site${coordsiteSuffix}.xml
fi

numd=0;
for d in $sourceDirs; do
	(( numd += 1 ));
done
if [[ $debug -gt 0 ]]; then echo ""; fi
echo -e "[compose] [`date +%H:%M:%S`] Merge $blue$numd$norm components' category*.xml into single $sitexmlOut"
#start file
if [[ $debug -gt 0 ]]; then echo -e "          Copy ${header}.$grey${sitexmlOut}$norm to $grey$sitexmlOut$norm ..."; fi
cp ${header}.${sitexmlOut} $targetDir/$sitexmlOut

if [[ $coordsiteSuffix ]] && [[ $coordsitexmlOut ]]; then
	if [[ -f ${header}.${coordsitexmlOut} ]]; then 
		if [[ $debug -gt 0 ]]; then echo -e "               ${header}${coordsitexmlOut} to $grey$coordsitexmlOut$norm ..."; fi
		cp ${header}.${coordsitexmlOut} $targetDir/$coordsitexmlOut
	else
		if [[ $debug -gt 0 ]]; then echo -e "               ${header}.$grey${sitexmlOut}$norm to $grey$coordsitexmlOut$norm ..."; fi
		cp ${header}.${sitexmlOut} $targetDir/$coordsitexmlOut
	fi
fi

#insert contents
cnt=0;
for d in $sourceDirs; do
	(( cnt += 1 ));
	dd=${d%/}; dd=${dd##*/};
	if [[ -f $d/$sitexml ]]; then
		if [[ $debug -gt 0 ]]; then echo -e "    [$cnt/$numd] Append $brown$dd$norm/$sitexml into $sitexmlOut ..."; fi
		cat $d/$sitexml >> $targetDir/$sitexmlOut;
	else
		if [[ $debug -gt 0 ]]; then echo -e "${red}*!*$norm [$cnt/$numd] Append $brown$dd$norm/$sitexml into $sitexmlOut ... ${red}NO SUCH FILE! *!*$norm"; fi
	fi
	if [[ $coordsiteSuffix ]] && [[ $coordsitexml ]] && [[ $coordsitexmlOut ]]; then
		if [[ -f $d/$coordsitexml ]]; then
			if [[ $debug -gt 0 ]]; then echo -e "    [$cnt/$numd]        $brown$dd$norm/$coordsitexml into $coordsitexmlOut ..."; fi
			cat $d/$coordsitexml >> $targetDir/$coordsitexmlOut;
		else
			if [[ $debug -gt 0 ]]; then echo -e "${red}*!*$norm [$cnt/$numd]        $brown$dd$norm/$coordsitexml into $coordsitexmlOut ... ${red}NO SUCH FILE! *!*$norm"; fi
		fi
	fi
done

# clean out extraneous </site> tags caused by people running two promotes at the same time. 
# I mean seriously, wtf, people? It's a shared xml file. You can't write into it from two processes and NOT expect things to break.
sed -i "s#</site>##g" $targetDir/$sitexmlOut

#end file
echo "" >> $targetDir/$sitexmlOut
echo "</site>" >> $targetDir/$sitexmlOut
if [[ $coordsiteSuffix ]] && [[ $coordsitexmlOut ]]; then
	sed -i "s#</site>##g" $targetDir/$coordsitexmlOut
	echo "" >> $targetDir/$coordsitexmlOut
	echo "</site>" >> $targetDir/$coordsitexmlOut
fi
