/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.transaction.multithread.tests;

import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.emf.transaction.multithread.tests.AbstractMultithreadTest;
import org.eclipse.emf.transaction.multithread.tests.Constants;
import org.eclipse.emf.transaction.multithread.tests.LongRunningReadThread;
import org.eclipse.emf.transaction.multithread.tests.NestedReadInWriteThread;
import org.eclipse.emf.transaction.multithread.tests.ReadThread;
import org.eclipse.emf.transaction.multithread.tests.WriteThread;

public class ReadWriteOperationTest
extends AbstractMultithreadTest {
    public static Test suite() {
        return new TestSuite(ReadWriteOperationTest.class, "Concurrent Reader and Writer Thread Tests");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testComplexSimultaneousReadsWrites() {
        Object notifier = new Object();
        NestedReadInWriteThread readInWriteThread1 = new NestedReadInWriteThread(this.getDomain(), null, notifier);
        NestedReadInWriteThread readInWriteThread2 = new NestedReadInWriteThread(this.getDomain(), null, notifier);
        Object object = notifier;
        synchronized (object) {
            try {
                readInWriteThread1.start();
                notifier.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        object = notifier;
        synchronized (object) {
            try {
                readInWriteThread2.start();
                notifier.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        boolean done = false;
        while (!done) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (readInWriteThread1.isAlive() || readInWriteThread2.isAlive()) continue;
            done = true;
        }
        ReadWriteOperationTest.assertFalse((boolean)readInWriteThread1.isFailed());
        ReadWriteOperationTest.assertFalse((boolean)readInWriteThread2.isFailed());
        ReadWriteOperationTest.assertTrue((boolean)readInWriteThread1.isExecuted());
        ReadWriteOperationTest.assertTrue((boolean)readInWriteThread2.isExecuted());
        ReadWriteOperationTest.assertFalse((boolean)readInWriteThread1.isInnerFailed());
        ReadWriteOperationTest.assertFalse((boolean)readInWriteThread2.isInnerFailed());
        ReadWriteOperationTest.assertTrue((boolean)readInWriteThread1.isInnerExecuted());
        ReadWriteOperationTest.assertTrue((boolean)readInWriteThread2.isInnerExecuted());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSimultaneousReadsWrites() {
        Object notifier = new Object();
        WriteThread writeThread1 = new WriteThread(this.getDomain(), null, notifier);
        WriteThread writeThread2 = new WriteThread(this.getDomain(), null, notifier);
        ReadThread readThread1 = new ReadThread(this.getDomain(), null, notifier);
        ReadThread readThread2 = new ReadThread(this.getDomain(), null, notifier);
        Object object = notifier;
        synchronized (object) {
            try {
                readThread1.start();
                notifier.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        object = notifier;
        synchronized (object) {
            try {
                writeThread1.start();
                notifier.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        object = notifier;
        synchronized (object) {
            try {
                readThread2.start();
                notifier.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        object = notifier;
        synchronized (object) {
            try {
                writeThread2.start();
                notifier.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        boolean done = false;
        while (!done) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (writeThread1.isAlive() || writeThread2.isAlive() || readThread1.isAlive() || readThread2.isAlive()) continue;
            done = true;
        }
        ReadWriteOperationTest.assertFalse((boolean)readThread1.isFailed());
        ReadWriteOperationTest.assertFalse((boolean)readThread2.isFailed());
        ReadWriteOperationTest.assertFalse((boolean)writeThread1.isFailed());
        ReadWriteOperationTest.assertFalse((boolean)writeThread2.isFailed());
        ReadWriteOperationTest.assertTrue((boolean)readThread1.isExecuted());
        ReadWriteOperationTest.assertTrue((boolean)readThread2.isExecuted());
        ReadWriteOperationTest.assertTrue((boolean)writeThread1.isExecuted());
        ReadWriteOperationTest.assertTrue((boolean)writeThread2.isExecuted());
        ReadWriteOperationTest.assertTrue((Constants.occurredBefore(writeThread2, writeThread1) || Constants.occurredAfter(writeThread2, writeThread1) ? 1 : 0) != 0);
        ReadWriteOperationTest.assertTrue((Constants.occurredBefore(writeThread2, readThread2) || Constants.occurredAfter(writeThread2, readThread2) ? 1 : 0) != 0);
        ReadWriteOperationTest.assertTrue((Constants.occurredBefore(writeThread2, readThread1) || Constants.occurredAfter(writeThread2, readThread1) ? 1 : 0) != 0);
        ReadWriteOperationTest.assertTrue((Constants.occurredBefore(readThread2, readThread1) || Constants.occurredAfter(readThread2, readThread1) ? 1 : 0) != 0);
        ReadWriteOperationTest.assertTrue((Constants.occurredBefore(readThread2, writeThread1) || Constants.occurredAfter(readThread2, writeThread1) ? 1 : 0) != 0);
        ReadWriteOperationTest.assertTrue((Constants.occurredBefore(readThread1, writeThread1) || Constants.occurredAfter(readThread1, writeThread1) ? 1 : 0) != 0);
    }

    public void testNestedReadInWrite() {
        NestedReadInWriteThread readInWriteThd = new NestedReadInWriteThread(this.getDomain());
        readInWriteThd.start();
        boolean done = false;
        while (!done) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (readInWriteThd.isAlive()) continue;
            done = true;
        }
        ReadWriteOperationTest.assertFalse((boolean)readInWriteThd.isInnerFailed());
        ReadWriteOperationTest.assertFalse((boolean)readInWriteThd.isFailed());
        ReadWriteOperationTest.assertTrue((boolean)readInWriteThd.isInnerExecuted());
        ReadWriteOperationTest.assertTrue((boolean)readInWriteThd.isExecuted());
        ReadWriteOperationTest.assertTrue((readInWriteThd.getEndTime() - readInWriteThd.getInnerEndTime() > 0L ? 1 : 0) != 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testLongRunningReadWithWrites() {
        Object notifier = new Object();
        LongRunningReadThread longReadThread = new LongRunningReadThread(this.getDomain(), null, notifier);
        ReadThread readThd1 = new ReadThread(this.getDomain(), null, notifier);
        ReadThread readThd2 = new ReadThread(this.getDomain(), null, notifier);
        WriteThread writeThd1 = new WriteThread(this.getDomain(), null, notifier);
        ReadThread readThd3 = new ReadThread(this.getDomain(), null, notifier);
        Object object = notifier;
        synchronized (object) {
            try {
                longReadThread.start();
                notifier.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        object = notifier;
        synchronized (object) {
            try {
                readThd1.start();
                notifier.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        object = notifier;
        synchronized (object) {
            try {
                readThd2.start();
                notifier.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        object = notifier;
        synchronized (object) {
            try {
                writeThd1.start();
                notifier.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        object = notifier;
        synchronized (object) {
            try {
                readThd3.start();
                notifier.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        boolean done = false;
        while (!done) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (longReadThread.isAlive() || readThd1.isAlive() || readThd2.isAlive() || readThd3.isAlive() || writeThd1.isAlive()) continue;
            done = true;
        }
        ReadWriteOperationTest.assertFalse((boolean)longReadThread.isFailed());
        ReadWriteOperationTest.assertFalse((boolean)readThd1.isFailed());
        ReadWriteOperationTest.assertFalse((boolean)readThd2.isFailed());
        ReadWriteOperationTest.assertFalse((boolean)readThd3.isFailed());
        ReadWriteOperationTest.assertFalse((boolean)writeThd1.isFailed());
        ReadWriteOperationTest.assertTrue((boolean)longReadThread.isExecuted());
        ReadWriteOperationTest.assertTrue((boolean)readThd1.isExecuted());
        ReadWriteOperationTest.assertTrue((boolean)readThd2.isExecuted());
        ReadWriteOperationTest.assertTrue((boolean)readThd3.isExecuted());
        ReadWriteOperationTest.assertTrue((boolean)writeThd1.isExecuted());
        ReadWriteOperationTest.assertTrue((!Constants.occurIntersect(longReadThread, readThd1) ? 1 : 0) != 0);
        ReadWriteOperationTest.assertTrue((!Constants.occurIntersect(longReadThread, readThd2) ? 1 : 0) != 0);
        ReadWriteOperationTest.assertTrue((Constants.occurredAfter(readThd1, readThd2) || Constants.occurredBefore(readThd1, readThd2) ? 1 : 0) != 0);
        ReadWriteOperationTest.assertTrue((String)"Read yielded to a write", ((Constants.occurredBefore(longReadThread, writeThd1) || Constants.occurredAfter(longReadThread, writeThd1)) && !Constants.occurredDuring(longReadThread, writeThd1) ? 1 : 0) != 0);
        ReadWriteOperationTest.assertTrue((!Constants.occurIntersect(longReadThread, readThd3) ? 1 : 0) != 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test_interruptionOfUIThread_149982() {
        Object notifier = new Object();
        LongRunningReadThread longReadThread = new LongRunningReadThread(this.getDomain(), null, notifier);
        WriteThread writeThd1 = new WriteThread(this.getDomain());
        Object object = notifier;
        synchronized (object) {
            try {
                longReadThread.start();
                notifier.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        Thread uiThread = Thread.currentThread();
        class Interrupter
        implements Runnable {
            private volatile boolean dead;
            private final /* synthetic */ Thread val$uiThread;

            Interrupter(Thread thread) {
                this.val$uiThread = thread;
            }

            public void run() {
                while (!this.dead) {
                    this.val$uiThread.interrupt();
                    try {
                        Thread.sleep(50L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }

            void die() {
                this.dead = true;
            }
        }
        Interrupter interrupter = new Interrupter(uiThread);
        Thread interrupterThread = new Thread(interrupter);
        interrupterThread.setDaemon(true);
        interrupterThread.start();
        try {
            uiThread.interrupt();
            writeThd1.run();
            if (writeThd1.isFailed()) {
                ReadWriteOperationTest.assertTrue((boolean)writeThd1.failedIn("org.eclipse.core.internal.jobs.JobManager"));
            } else {
                ReadWriteOperationTest.assertTrue((boolean)writeThd1.isExecuted());
            }
        }
        finally {
            interrupter.die();
            Thread.interrupted();
        }
    }
}

