/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.transaction.tests;

import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.examples.extlibrary.Book;
import org.eclipse.emf.examples.extlibrary.EXTLibraryPackage;
import org.eclipse.emf.examples.extlibrary.Writer;
import org.eclipse.emf.transaction.NotificationFilter;
import org.eclipse.emf.transaction.ResourceSetListener;
import org.eclipse.emf.transaction.tests.AbstractTest;
import org.eclipse.emf.transaction.tests.fixtures.TestListener;

public class NotificationFilterTest
extends AbstractTest {
    public NotificationFilterTest(String name) {
        super(name);
    }

    public static Test suite() {
        return new TestSuite(NotificationFilterTest.class, "Notification Filter Tests");
    }

    public void test_filteringOnDispatch() {
        try {
            TestListener bookListener = new TestListener(NotificationFilter.createFeatureFilter((EStructuralFeature)EXTLibraryPackage.eINSTANCE.getBook_Title()));
            this.domain.addResourceSetListener((ResourceSetListener)bookListener);
            TestListener authorListener = new TestListener(NotificationFilter.createNotifierTypeFilter((EClassifier)EXTLibraryPackage.eINSTANCE.getWriter()));
            this.domain.addResourceSetListener((ResourceSetListener)authorListener);
            this.startWriting();
            Book book = (Book)this.find("root/Root Book");
            NotificationFilterTest.assertNotNull((Object)book);
            String oldTitle = book.getTitle();
            String newTitle = "New Title";
            Writer newAuthor = (Writer)this.find("root/level1/Level1 Writer");
            NotificationFilterTest.assertNotNull((Object)newAuthor);
            book.setTitle(newTitle);
            book.setAuthor(newAuthor);
            this.commit();
            NotificationFilterTest.assertNotNull((Object)bookListener.postcommit);
            NotificationFilterTest.assertEquals((int)1, (int)bookListener.postcommitNotifications.size());
            Notification notification = bookListener.postcommitNotifications.get(0);
            NotificationFilterTest.assertSame((Object)book, (Object)notification.getNotifier());
            NotificationFilterTest.assertSame((Object)EXTLibraryPackage.eINSTANCE.getBook_Title(), (Object)notification.getFeature());
            NotificationFilterTest.assertSame((Object)oldTitle, (Object)notification.getOldValue());
            NotificationFilterTest.assertSame((Object)newTitle, (Object)notification.getNewValue());
            NotificationFilterTest.assertNotNull((Object)authorListener.postcommit);
            NotificationFilterTest.assertEquals((int)1, (int)authorListener.postcommitNotifications.size());
            notification = authorListener.postcommitNotifications.get(0);
            NotificationFilterTest.assertSame((Object)newAuthor, (Object)notification.getNotifier());
            NotificationFilterTest.assertSame((Object)EXTLibraryPackage.eINSTANCE.getWriter_Books(), (Object)notification.getFeature());
            NotificationFilterTest.assertSame((Object)book, (Object)notification.getNewValue());
        }
        catch (Exception e) {
            this.fail(e);
        }
    }

    public void test_contentTypeFilter_specific() {
        TestListener listener = new TestListener(NotificationFilter.createResourceContentTypeFilter((String)"org.eclipse.emf.examples.library.extendedLibrary"));
        this.domain.addResourceSetListener((ResourceSetListener)listener);
        this.startWriting();
        this.testResource.setModified(this.testResource.isModified());
        this.commit();
        NotificationFilterTest.assertNotNull((Object)listener.postcommit);
        NotificationFilterTest.assertNotNull(listener.postcommitNotifications);
        NotificationFilterTest.assertEquals((int)1, (int)listener.postcommitNotifications.size());
        listener.reset();
        this.startWriting();
        this.root.setName(this.root.getName());
        this.commit();
        NotificationFilterTest.assertNotNull((Object)listener.postcommit);
        NotificationFilterTest.assertNotNull(listener.postcommitNotifications);
        NotificationFilterTest.assertEquals((int)1, (int)listener.postcommitNotifications.size());
        listener.reset();
        this.domain.removeResourceSetListener((ResourceSetListener)listener);
    }

    public void test_contentTypeFilter_general() {
        TestListener listener = new TestListener(NotificationFilter.createResourceContentTypeFilter((String)"org.eclipse.core.runtime.xml"));
        this.domain.addResourceSetListener((ResourceSetListener)listener);
        this.startWriting();
        this.testResource.setModified(this.testResource.isModified());
        this.commit();
        NotificationFilterTest.assertNotNull((Object)listener.postcommit);
        NotificationFilterTest.assertNotNull(listener.postcommitNotifications);
        NotificationFilterTest.assertEquals((int)1, (int)listener.postcommitNotifications.size());
        listener.reset();
        this.startWriting();
        this.root.setName(this.root.getName());
        this.commit();
        NotificationFilterTest.assertNotNull((Object)listener.postcommit);
        NotificationFilterTest.assertNotNull(listener.postcommitNotifications);
        NotificationFilterTest.assertEquals((int)1, (int)listener.postcommitNotifications.size());
        listener.reset();
        this.domain.removeResourceSetListener((ResourceSetListener)listener);
    }

    public void test_contentTypeFilter_miss() {
        TestListener listener = new TestListener(NotificationFilter.createResourceContentTypeFilter((String)"org.eclipse.emf.examples.library.extendedLibrary"));
        this.startWriting();
        this.testResource.setURI(this.testResource.getURI().trimFileExtension().appendFileExtension("xml"));
        this.domain.addResourceSetListener((ResourceSetListener)listener);
        this.commit();
        this.startWriting();
        this.testResource.setModified(this.testResource.isModified());
        this.commit();
        NotificationFilterTest.assertNull((Object)listener.postcommit);
        listener.reset();
        this.startWriting();
        this.root.setName(this.root.getName());
        this.commit();
        NotificationFilterTest.assertNull((Object)listener.postcommit);
        listener.reset();
        this.domain.removeResourceSetListener((ResourceSetListener)listener);
    }

    public void test_contentTypeFilter_noContent() {
        TestListener listener = new TestListener(NotificationFilter.createResourceContentTypeFilter((String)"org.eclipse.emf.examples.library.extendedLibrary"));
        this.startWriting();
        this.testResource.setURI(this.testResource.getURI().trimSegments(1).appendSegment("newname.extlibrary"));
        this.domain.addResourceSetListener((ResourceSetListener)listener);
        this.commit();
        this.domain.addResourceSetListener((ResourceSetListener)listener);
        this.startWriting();
        this.testResource.setModified(this.testResource.isModified());
        this.commit();
        NotificationFilterTest.assertNotNull((Object)listener.postcommit);
        NotificationFilterTest.assertNotNull(listener.postcommitNotifications);
        NotificationFilterTest.assertEquals((int)1, (int)listener.postcommitNotifications.size());
        listener.reset();
        this.startWriting();
        this.root.setName(this.root.getName());
        this.commit();
        NotificationFilterTest.assertNotNull((Object)listener.postcommit);
        NotificationFilterTest.assertNotNull(listener.postcommitNotifications);
        NotificationFilterTest.assertEquals((int)1, (int)listener.postcommitNotifications.size());
        listener.reset();
        this.domain.removeResourceSetListener((ResourceSetListener)listener);
    }
}

