/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.workspace;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.core.commands.operations.IUndoContext;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.workspace.internal.l10n.Messages;

public final class ResourceUndoContext
implements IUndoContext {
    private final TransactionalEditingDomain editingDomain;
    private final Resource resource;

    public ResourceUndoContext(TransactionalEditingDomain domain, Resource resource) {
        this.editingDomain = domain;
        this.resource = resource;
    }

    public String getLabel() {
        return Messages.resCtxLabel;
    }

    public boolean matches(IUndoContext context) {
        return this.equals(context);
    }

    public boolean equals(Object o) {
        boolean result = false;
        if (o instanceof ResourceUndoContext) {
            result = this.getResource() == ((ResourceUndoContext)o).getResource();
        }
        return result;
    }

    public int hashCode() {
        return this.resource == null ? 0 : this.resource.hashCode();
    }

    public Resource getResource() {
        return this.resource;
    }

    public final TransactionalEditingDomain getEditingDomain() {
        return this.editingDomain;
    }

    public static Set getAffectedResources(List notifications) {
        HashSet<Object> result;
        if (notifications.isEmpty()) {
            result = Collections.EMPTY_SET;
        } else {
            result = new HashSet<Object>();
            Iterator iter = notifications.iterator();
            while (iter.hasNext()) {
                Object feature;
                Notification next = (Notification)iter.next();
                Object notifier = next.getNotifier();
                if (notifier instanceof Resource) {
                    result.add(notifier);
                    continue;
                }
                if (!(notifier instanceof EObject)) continue;
                EObject eobj = (EObject)notifier;
                Resource resource = eobj.eResource();
                if (resource != null) {
                    result.add(resource);
                }
                if (!((feature = next.getFeature()) instanceof EReference) || ((EReference)feature).getEOpposite() != null) continue;
                ResourceUndoContext.handleCrossResourceReference(result, next);
            }
        }
        return result;
    }

    public static Set getAffectedResources(IUndoableOperation operation) {
        HashSet<Resource> result;
        IUndoContext[] contexts = operation.getContexts();
        if (contexts.length == 0) {
            result = Collections.EMPTY_SET;
        } else {
            result = new HashSet<Resource>();
            int i = 0;
            while (i < contexts.length) {
                if (contexts[i] instanceof ResourceUndoContext) {
                    result.add(((ResourceUndoContext)contexts[i]).getResource());
                }
                ++i;
            }
        }
        return result;
    }

    private static void handleCrossResourceReference(Set resources, Notification notification) {
        Object oldValue = notification.getOldValue();
        Object newValue = notification.getNewValue();
        switch (notification.getEventType()) {
            case 1: 
            case 2: {
                Resource resource;
                if (oldValue != null && (resource = ((EObject)oldValue).eResource()) != null) {
                    resources.add(resource);
                }
                if (newValue == null || (resource = ((EObject)newValue).eResource()) == null) break;
                resources.add(resource);
                break;
            }
            case 3: {
                Resource resource = ((EObject)newValue).eResource();
                if (resource == null) break;
                resources.add(resource);
                break;
            }
            case 5: {
                Iterator iter = ((Collection)newValue).iterator();
                while (iter.hasNext()) {
                    Resource resource = ((EObject)iter.next()).eResource();
                    if (resource == null) continue;
                    resources.add(resource);
                }
                break;
            }
            case 4: {
                Resource resource = ((EObject)oldValue).eResource();
                if (resource == null) break;
                resources.add(resource);
                break;
            }
            case 6: {
                Iterator iter = ((Collection)oldValue).iterator();
                while (iter.hasNext()) {
                    Resource resource = ((EObject)iter.next()).eResource();
                    if (resource == null) continue;
                    resources.add(resource);
                }
                break;
            }
        }
    }
}

