/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.transaction.impl;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.transaction.ResourceSetListener;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.internal.EMFTransactionPlugin;
import org.eclipse.emf.transaction.internal.Tracing;
import org.eclipse.emf.transaction.internal.l10n.Messages;
import org.eclipse.osgi.util.NLS;

public class EditingDomainManager {
    private static final String EXT_POINT_DOMAINS = "editingDomains";
    private static final String E_DOMAIN = "editingDomain";
    private static final String A_ID = "id";
    private static final String A_FACTORY = "factory";
    private static final String EXT_POINT_LISTENERS = "listeners";
    private static final String E_LISTENER = "listener";
    private static final String A_CLASS = "class";
    private static final EditingDomainManager INSTANCE = new EditingDomainManager();
    private Collection universalListeners;
    private final Map listeners = new HashMap();
    static /* synthetic */ Class class$0;

    private EditingDomainManager() {
    }

    public static EditingDomainManager getInstance() {
        return INSTANCE;
    }

    public TransactionalEditingDomain createEditingDomain(String id) {
        TransactionalEditingDomain result = null;
        IConfigurationElement config = this.getDomainConfig(id);
        if (config != null) {
            String factoryClass = config.getAttribute(A_FACTORY);
            if (factoryClass == null || factoryClass.trim().length() == 0) {
                result = TransactionalEditingDomain.Factory.INSTANCE.createEditingDomain();
            } else {
                try {
                    Object factory = config.createExecutableExtension(A_FACTORY);
                    if (factory instanceof TransactionalEditingDomain.Factory) {
                        result = ((TransactionalEditingDomain.Factory)factory).createEditingDomain();
                    } else {
                        EMFTransactionPlugin.getPlugin().log(new Status(4, EMFTransactionPlugin.getPluginId(), 20, NLS.bind((String)Messages.factoryInterface, (Object)factory.getClass().getName(), (Object)id), null));
                    }
                }
                catch (CoreException e) {
                    Class<?> clazz = class$0;
                    if (clazz == null) {
                        try {
                            clazz = class$0 = Class.forName("org.eclipse.emf.transaction.impl.EditingDomainManager");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    Tracing.catching(clazz, "createEditingDomain", e);
                    EMFTransactionPlugin.INSTANCE.log(new MultiStatus(EMFTransactionPlugin.getPluginId(), 21, new IStatus[]{e.getStatus()}, NLS.bind((String)Messages.factoryInitialization, (Object)id), null));
                }
            }
        }
        return result;
    }

    public boolean isStaticallyRegistered(String id) {
        return this.getDomainConfig(id) != null;
    }

    public void configureListeners(String id, TransactionalEditingDomain domain) {
        Collection configs = this.getListenerConfigs(id);
        Iterator iter = configs.iterator();
        while (iter.hasNext()) {
            ResourceSetListener listener = this.getListener((IConfigurationElement)iter.next(), true);
            if (listener == null) continue;
            domain.addResourceSetListener(listener);
        }
    }

    public void deconfigureListeners(String id, TransactionalEditingDomain domain) {
        Collection configs = this.getListenerConfigs(id);
        Iterator iter = configs.iterator();
        while (iter.hasNext()) {
            ResourceSetListener listener = this.getListener((IConfigurationElement)iter.next(), false);
            if (listener == null) continue;
            domain.removeResourceSetListener(listener);
        }
    }

    private IConfigurationElement getDomainConfig(String id) {
        IConfigurationElement result = null;
        IConfigurationElement[] configs = Platform.getExtensionRegistry().getConfigurationElementsFor(EMFTransactionPlugin.getPluginId(), EXT_POINT_DOMAINS);
        int i = 0;
        while (result == null && i < configs.length) {
            if (E_DOMAIN.equals(configs[i].getName()) && id.equals(configs[i].getAttribute(A_ID))) {
                result = configs[i];
            }
            ++i;
        }
        return result;
    }

    private Collection getListenerConfigs(String id) {
        ArrayList<IConfigurationElement> result = new ArrayList<IConfigurationElement>();
        IConfigurationElement[] configs = Platform.getExtensionRegistry().getConfigurationElementsFor(EMFTransactionPlugin.getPluginId(), EXT_POINT_LISTENERS);
        int i = 0;
        while (i < configs.length) {
            if (E_LISTENER.equals(configs[i].getName())) {
                IConfigurationElement[] domains = configs[i].getChildren(E_DOMAIN);
                int j = 0;
                while (j < domains.length) {
                    if (id.equals(domains[j].getAttribute(A_ID))) {
                        result.add(configs[i]);
                        break;
                    }
                    ++j;
                }
            }
            ++i;
        }
        result.addAll(this.getUniversalListenerConfigs());
        return result;
    }

    private Collection getUniversalListenerConfigs() {
        if (this.universalListeners == null) {
            this.universalListeners = new ArrayList();
            IConfigurationElement[] configs = Platform.getExtensionRegistry().getConfigurationElementsFor(EMFTransactionPlugin.getPluginId(), EXT_POINT_LISTENERS);
            int i = 0;
            while (i < configs.length) {
                IConfigurationElement[] domains;
                if (E_LISTENER.equals(configs[i].getName()) && (domains = configs[i].getChildren(E_DOMAIN)).length == 0) {
                    this.universalListeners.add(configs[i]);
                }
                ++i;
            }
        }
        return this.universalListeners;
    }

    private ResourceSetListener getListener(IConfigurationElement config, boolean create) {
        ResourceSetListener result = null;
        WeakReference<ResourceSetListener> ref = (WeakReference<ResourceSetListener>)this.listeners.get(config.getAttribute(A_CLASS));
        if (ref != null) {
            result = (ResourceSetListener)ref.get();
        }
        if (result == null && create) {
            try {
                Object listener = config.createExecutableExtension(A_CLASS);
                if (listener instanceof ResourceSetListener) {
                    result = (ResourceSetListener)listener;
                    ref = new WeakReference<ResourceSetListener>(result);
                    this.listeners.put(result.getClass().getName(), ref);
                } else {
                    EMFTransactionPlugin.getPlugin().log(new Status(4, EMFTransactionPlugin.getPluginId(), 22, NLS.bind((String)Messages.listenerInterface, (Object)listener.getClass().getName()), null));
                }
            }
            catch (CoreException e) {
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("org.eclipse.emf.transaction.impl.EditingDomainManager");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                Tracing.catching(clazz, "getListener", e);
                EMFTransactionPlugin.INSTANCE.log(new MultiStatus(EMFTransactionPlugin.getPluginId(), 23, new IStatus[]{e.getStatus()}, NLS.bind((String)Messages.listenerInitialization, (Object)config.getAttribute(A_CLASS)), null));
            }
        }
        return result;
    }
}

